/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.mixin;

import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.item.CopperDivingLeggingsItem;
import com.adonis.createfisheryindustry.item.NetheriteDivingLeggingsItem;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class}, priority=1000)
public class JumpCooldownMixin {
    @Unique
    private int cfi_jumpCooldown = 0;

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void updateJumpCooldown(CallbackInfo ci) {
        if (this.cfi_jumpCooldown > 0) {
            --this.cfi_jumpCooldown;
        }
    }

    @Inject(method={"jumpFromGround"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkJumpCooldown(CallbackInfo ci) {
        LivingEntity entity = (LivingEntity)this;
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.isInWater() || player.isInLava()) {
            boolean hasLeggings;
            boolean hasDivingBoots = player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof DivingBootsItem;
            boolean bl = hasLeggings = player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof CopperDivingLeggingsItem || player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof NetheriteDivingLeggingsItem;
            if (hasDivingBoots && hasLeggings) {
                if (this.cfi_jumpCooldown > 0) {
                    ci.cancel();
                    if (!player.level().isClientSide && player.tickCount % 20 == 0) {
                        player.displayClientMessage((Component)Component.literal((String)("\u00a7c[CFI] \u8df3\u8dc3\u51b7\u5374\u4e2d... (" + this.cfi_jumpCooldown / 20 + "s)")), true);
                    }
                } else {
                    this.cfi_jumpCooldown = CreateFisheryCommonConfig.getDivingJumpCooldown();
                }
            }
        }
    }
}

