/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.item;

import com.adonis.createfisheryindustry.registry.CreateFisheryItems;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.apache.commons.lang3.math.Fraction;

public final class HarpoonPouchContents
implements TooltipComponent {
    public static final HarpoonPouchContents EMPTY = new HarpoonPouchContents(List.of());
    public static final Codec<HarpoonPouchContents> CODEC = ItemStack.CODEC.listOf().xmap(HarpoonPouchContents::new, contents -> contents.items);
    public static final StreamCodec<RegistryFriendlyByteBuf, HarpoonPouchContents> STREAM_CODEC = ItemStack.STREAM_CODEC.apply(ByteBufCodecs.list()).map(HarpoonPouchContents::new, contents -> contents.items);
    private static final Fraction HARPOON_WEIGHT = Fraction.getFraction((int)1, (int)4);
    private static final int MAX_SLOTS = 4;
    private final List<ItemStack> items;
    private final Fraction weight;

    public HarpoonPouchContents(List<ItemStack> items) {
        this(items, HarpoonPouchContents.computeContentWeight(items));
    }

    private HarpoonPouchContents(List<ItemStack> items, Fraction weight) {
        this.items = items;
        this.weight = weight;
    }

    private static Fraction computeContentWeight(List<ItemStack> content) {
        Fraction fraction = Fraction.ZERO;
        for (ItemStack stack : content) {
            if (!Mutable.isValidItem(stack)) continue;
            fraction = fraction.add(HARPOON_WEIGHT.multiplyBy(Fraction.getFraction((int)stack.getCount(), (int)1)));
        }
        return fraction;
    }

    public static Fraction getWeight(ItemStack stack) {
        if (stack.getItem() == CreateFisheryItems.HARPOON.get()) {
            return HARPOON_WEIGHT;
        }
        return Fraction.ZERO;
    }

    public ItemStack getItemUnsafe(int index) {
        return this.items.get(index);
    }

    public Stream<ItemStack> itemCopyStream() {
        return this.items.stream().map(ItemStack::copy);
    }

    public Iterable<ItemStack> items() {
        return this.items;
    }

    public Iterable<ItemStack> itemsCopy() {
        return Lists.transform(this.items, ItemStack::copy);
    }

    public int size() {
        return this.items.size();
    }

    public Fraction weight() {
        return this.weight;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HarpoonPouchContents)) {
            return false;
        }
        HarpoonPouchContents contents = (HarpoonPouchContents)other;
        return this.weight.equals((Object)contents.weight) && ItemStack.listMatches(this.items, contents.items);
    }

    public int hashCode() {
        return ItemStack.hashStackList(this.items);
    }

    public String toString() {
        return "HarpoonPouchContents" + String.valueOf(this.items);
    }

    public static class Mutable {
        private final List<ItemStack> items;
        private Fraction weight;

        public Mutable(HarpoonPouchContents contents) {
            this.items = new ArrayList<ItemStack>(contents.items);
            this.weight = contents.weight;
        }

        public Mutable clearItems() {
            this.items.clear();
            this.weight = Fraction.ZERO;
            return this;
        }

        private int findStackIndex(ItemStack stack) {
            if (!stack.isStackable()) {
                return -1;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)this.items.get(i), (ItemStack)stack)) continue;
                return i;
            }
            return -1;
        }

        private int getMaxAmountToAdd(ItemStack stack) {
            if (!Mutable.isValidItem(stack)) {
                return 0;
            }
            int remainingSlots = 4 - this.items.size();
            return Math.min(remainingSlots, stack.getCount());
        }

        private static boolean isValidItem(ItemStack stack) {
            return stack.getItem() == CreateFisheryItems.HARPOON.get() || stack.getItem() == Items.TRIDENT;
        }

        public int tryInsert(ItemStack stack) {
            if (stack.isEmpty() || !Mutable.isValidItem(stack)) {
                return 0;
            }
            int maxAdd = Math.min(stack.getCount(), this.getMaxAmountToAdd(stack));
            if (maxAdd == 0) {
                return 0;
            }
            this.weight = this.weight.add(HARPOON_WEIGHT.multiplyBy(Fraction.getFraction((int)maxAdd, (int)1)));
            int stackIndex = this.findStackIndex(stack);
            if (stackIndex != -1) {
                ItemStack existing = this.items.remove(stackIndex);
                ItemStack newStack = existing.copyWithCount(existing.getCount() + maxAdd);
                stack.shrink(maxAdd);
                this.items.add(0, newStack);
            } else {
                this.items.add(0, stack.split(maxAdd));
            }
            return maxAdd;
        }

        public int tryTransfer(Slot slot, Player player) {
            ItemStack stack = slot.getItem();
            int maxAdd = this.getMaxAmountToAdd(stack);
            return this.tryInsert(slot.safeTake(stack.getCount(), maxAdd, player));
        }

        @Nullable
        public ItemStack removeOne() {
            if (this.items.isEmpty()) {
                return null;
            }
            ItemStack stack = this.items.remove(0).copy();
            this.weight = this.weight.subtract(HARPOON_WEIGHT);
            return stack;
        }

        public Fraction weight() {
            return this.weight;
        }

        public HarpoonPouchContents toImmutable() {
            return new HarpoonPouchContents(List.copyOf(this.items), this.weight);
        }
    }
}

