/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.event;

import com.adonis.createfisheryindustry.item.HarpoonItem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.item.ItemTossEvent;

@EventBusSubscriber(modid="createfisheryindustry")
public class HarpoonDropHandler {
    @SubscribeEvent
    public static void onItemToss(ItemTossEvent event) {
        Player player;
        ItemEntity itemEntity = event.getEntity();
        ItemStack stack = itemEntity.getItem();
        if (stack.getItem() instanceof HarpoonItem && (player = event.getPlayer()) != null) {
            Vec3 lookVec = player.getLookAngle();
            float spread = 1.0f;
            double motionX = lookVec.x * 0.3 + ((double)player.getRandom().nextFloat() - 0.5) * (double)spread;
            double motionY = lookVec.y * 0.3 + 0.2;
            double motionZ = lookVec.z * 0.3 + ((double)player.getRandom().nextFloat() - 0.5) * (double)spread;
            itemEntity.setDeltaMovement(motionX, motionY, motionZ);
            itemEntity.setPickUpDelay(40);
            itemEntity.setNoGravity(false);
        }
    }
}

