/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.event;

import com.adonis.createfisheryindustry.entity.TetheredHarpoonEntity;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventBusSubscriber(modid="createfisheryindustry")
public class HarpoonDeathEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(HarpoonDeathEventHandler.class);

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity.level().isClientSide) {
            return;
        }
        LivingEntity killCredit = entity.getKillCredit();
        if (killCredit instanceof Player) {
            Player player = (Player)killCredit;
            boolean foundHarpoon = false;
            for (TetheredHarpoonEntity harpoon : entity.level().getEntitiesOfClass(TetheredHarpoonEntity.class, entity.getBoundingBox().inflate(10.0))) {
                if (harpoon.getOwner() != player || harpoon.currentState != TetheredHarpoonEntity.HarpoonState.HOOKED_IN_ENTITY && harpoon.getLastHitEntity() != entity || harpoon.getHitEntity() != entity && harpoon.getLastHitEntity() != entity || harpoon.getHitTick() < harpoon.tickCount - 10) continue;
                foundHarpoon = true;
                event.setCanceled(true);
                entity.skipDropExperience();
                harpoon.pullLootToPlayer((Entity)entity);
                harpoon.startRetrieving();
                break;
            }
            if (!foundHarpoon) {
                // empty if block
            }
        }
    }
}

