/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.client.renderer;

import com.adonis.createfisheryindustry.registry.CreateFisheryItems;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import net.createmod.catnip.outliner.Outliner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.common.NeoForge;

@OnlyIn(value=Dist.CLIENT)
public class PneumaticHarpoonTargetHandler {
    private static final double MAX_RANGE = 50.0;
    private static Entity currentTargetEntity = null;
    private static final int HIGHLIGHT_COLOR = -1;
    private static final int OUTLINE_COLOR = 0xFFFFFF;

    public static void init() {
        NeoForge.EVENT_BUS.register(PneumaticHarpoonTargetHandler.class);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        EntityHitResult entityHit;
        Entity entity;
        boolean holdingHarpoonGun;
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null || mc.level == null) {
            currentTargetEntity = null;
            return;
        }
        ItemStack mainHand = player.getMainHandItem();
        ItemStack offHand = player.getOffhandItem();
        boolean bl = holdingHarpoonGun = mainHand.getItem() == CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get() || offHand.getItem() == CreateFisheryItems.PNEUMATIC_HARPOON_GUN.get();
        if (!holdingHarpoonGun) {
            currentTargetEntity = null;
            return;
        }
        HitResult hit = PneumaticHarpoonTargetHandler.getPlayerTarget((Player)player, 50.0);
        currentTargetEntity = hit instanceof EntityHitResult ? ((entity = (entityHit = (EntityHitResult)hit).getEntity()) != null && PneumaticHarpoonTargetHandler.isValidTarget(entity) ? entity : null) : null;
        if (currentTargetEntity != null && !player.isUnderWater()) {
            AABB bb = currentTargetEntity.getBoundingBox();
            Outliner.getInstance().showAABB((Object)currentTargetEntity, bb).colored(-1).lineWidth(0.0625f);
        }
    }

    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (currentTargetEntity == null || player == null) {
            return;
        }
        if (!player.isUnderWater() && Outliner.getInstance() != null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        Vec3 camPos = mc.gameRenderer.getMainCamera().getPosition();
        poseStack.pushPose();
        poseStack.translate(-camPos.x, -camPos.y, -camPos.z);
        AABB bb = currentTargetEntity.getBoundingBox();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (double)bb.minX, (double)bb.minY, (double)bb.minZ, (double)bb.maxX, (double)bb.maxY, (double)bb.maxZ, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
        bufferSource.endBatch();
    }

    private static boolean isValidTarget(Entity entity) {
        if (entity.isSpectator()) {
            return false;
        }
        if (entity instanceof LivingEntity) {
            return true;
        }
        if (entity instanceof ItemEntity) {
            return true;
        }
        if (entity instanceof ExperienceOrb) {
            return true;
        }
        return entity.isPickable();
    }

    private static HitResult getPlayerTarget(Player player, double range) {
        double blockDist;
        Vec3 eyePos = player.getEyePosition(1.0f);
        Vec3 lookVec = player.getViewVector(1.0f);
        Vec3 endPos = eyePos.add(lookVec.scale(range));
        AABB searchBox = new AABB(eyePos, endPos).inflate(1.5);
        Entity closestEntity = null;
        double closestDistance = range * range;
        for (Entity entity : player.level().getEntities((Entity)player, searchBox)) {
            double distance;
            AABB entityBox;
            Optional hitPos;
            if (!PneumaticHarpoonTargetHandler.isValidTarget(entity) || !(hitPos = (entityBox = entity.getBoundingBox().inflate((double)entity.getPickRadius())).clip(eyePos, endPos)).isPresent() || !((distance = eyePos.distanceToSqr((Vec3)hitPos.get())) < closestDistance)) continue;
            closestDistance = distance;
            closestEntity = entity;
        }
        ClipContext clipContext = new ClipContext(eyePos, endPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult blockHit = player.level().clip(clipContext);
        if (closestEntity != null && closestDistance < (blockDist = eyePos.distanceToSqr(blockHit.getLocation()))) {
            return new EntityHitResult(closestEntity);
        }
        return blockHit;
    }

    public static Entity getTargetEntity() {
        return currentTargetEntity;
    }

    public static boolean hasValidTarget() {
        return currentTargetEntity != null;
    }
}

