/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.client.renderer;

import com.adonis.createfisheryindustry.block.MechanicalPeeler.MechanicalPeelerBlock;
import com.adonis.createfisheryindustry.block.MechanicalPeeler.MechanicalPeelerBlockEntity;
import com.adonis.createfisheryindustry.client.CreateFisheryPartialModels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.blockEntity.renderer.SafeBlockEntityRenderer;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MechanicalPeelerRenderer
extends SafeBlockEntityRenderer<MechanicalPeelerBlockEntity> {
    private static final Vec3 PIVOT = new Vec3(0.0, 8.0, 8.0);

    public MechanicalPeelerRenderer(BlockEntityRendererProvider.Context context) {
    }

    protected void renderSafe(MechanicalPeelerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        try {
            this.renderRotatingPart(be, partialTicks, ms, buffer, light, overlay);
            this.renderItems(be, partialTicks, ms, buffer, light, overlay);
            this.renderShaft(be, partialTicks, ms, buffer, light, overlay);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void renderRotatingPart(MechanicalPeelerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        Direction facing = (Direction)blockState.getValue((Property)MechanicalPeelerBlock.FACING);
        boolean axisAlongFirst = (Boolean)blockState.getValue((Property)MechanicalPeelerBlock.AXIS_ALONG_FIRST_COORDINATE);
        boolean flipped = (Boolean)blockState.getValue((Property)MechanicalPeelerBlock.FLIPPED);
        float speed = be.getSpeed();
        Direction.Axis kineticShaftAxis = ((MechanicalPeelerBlock)blockState.getBlock()).getRotationAxis(blockState);
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float rawAngle = time * speed * 6.0f / 10.0f;
        float prevTickTimeApproximation = time - 1.0f + partialTicks;
        float prevRawAngle = prevTickTimeApproximation * speed * 6.0f / 10.0f;
        float angle = AngleHelper.angleLerp((double)partialTicks, (double)prevRawAngle, (double)rawAngle) % 360.0f;
        float originOffset = 0.0625f;
        Vec3 rotOffset = facing.getAxis().isVertical() && kineticShaftAxis == Direction.Axis.Z ? new Vec3(MechanicalPeelerRenderer.PIVOT.x * (double)originOffset, MechanicalPeelerRenderer.PIVOT.y * (double)originOffset, 0.0) : new Vec3(0.0, MechanicalPeelerRenderer.PIVOT.y * (double)originOffset, MechanicalPeelerRenderer.PIVOT.z * (double)originOffset);
        try {
            SuperByteBuffer superBuffer;
            if (facing.getAxis().isHorizontal()) {
                superBuffer = CachedBuffers.partial((PartialModel)CreateFisheryPartialModels.THRESHER_BLADE, (BlockState)blockState);
                if (superBuffer == null) {
                    return;
                }
            } else {
                Direction horizontalFacing = kineticShaftAxis == Direction.Axis.X ? (flipped ? Direction.SOUTH : Direction.NORTH) : (flipped ? Direction.WEST : Direction.EAST);
                SuperByteBuffer superBuffer2 = CachedBuffers.partialFacingVertical((PartialModel)CreateFisheryPartialModels.THRESHER_BLADE, (BlockState)blockState, (Direction)horizontalFacing);
                if (superBuffer2 == null) {
                    return;
                }
                if (facing == Direction.DOWN) {
                    superBuffer2.rotateCentered(AngleHelper.rad((double)180.0), Direction.EAST);
                }
                KineticBlockEntityRenderer.standardKineticRotationTransform((SuperByteBuffer)superBuffer2, (KineticBlockEntity)be, (int)light).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
                return;
            }
            superBuffer.rotateCentered(AngleHelper.rad((double)AngleHelper.horizontalAngle((Direction)facing)), Direction.UP);
            superBuffer.translate(rotOffset.x, rotOffset.y, rotOffset.z);
            superBuffer.rotate(AngleHelper.rad((double)angle), Direction.WEST);
            superBuffer.translate(-rotOffset.x, -rotOffset.y, -rotOffset.z);
            superBuffer.light(light).overlay(overlay).renderInto(ms, buffer.getBuffer(RenderType.cutoutMipped()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void renderShaft(MechanicalPeelerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        BlockState blockState = be.getBlockState();
        try {
            SuperByteBuffer shaftBuffer;
            if (((Direction)blockState.getValue((Property)MechanicalPeelerBlock.FACING)).getAxis().isHorizontal()) {
                Direction oppositeFacing = ((Direction)blockState.getValue((Property)MechanicalPeelerBlock.FACING)).getOpposite();
                shaftBuffer = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)blockState, (Direction)oppositeFacing);
            } else {
                Direction.Axis axis = ((MechanicalPeelerBlock)blockState.getBlock()).getRotationAxis(blockState);
                shaftBuffer = CachedBuffers.block((SuperByteBufferCache.Compartment)KineticBlockEntityRenderer.KINETIC_BLOCK, (BlockState)KineticBlockEntityRenderer.shaft((Direction.Axis)axis));
            }
            if (shaftBuffer != null) {
                KineticBlockEntityRenderer.standardKineticRotationTransform((SuperByteBuffer)shaftBuffer, (KineticBlockEntity)be, (int)light).renderInto(ms, buffer.getBuffer(RenderType.solid()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void renderItems(MechanicalPeelerBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        if (be.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING) != Direction.UP) {
            return;
        }
        ItemStack itemToRender = this.getItemToRender(be);
        if (itemToRender.isEmpty()) {
            return;
        }
        if (be.getLevel().getGameTime() % 20L == 0L) {
            // empty if block
        }
        Vec3 itemMovement = be.getItemMovementVec();
        float animationProgress = this.calculateAnimationProgress(be, partialTicks);
        if (be.getLevel().getGameTime() % 10L != 0L || be.inputInventory.remainingTime > 0.0f) {
            // empty if block
        }
        this.renderSingleItem(ms, buffer, light, overlay, itemToRender, animationProgress, itemMovement, be);
    }

    private ItemStack getItemToRender(MechanicalPeelerBlockEntity be) {
        if (be.inputInventory.remainingTime > 0.0f) {
            if (!be.inputInventory.appliedRecipe) {
                return be.inputInventory.getStackInSlot(0);
            }
            ItemStack primaryOutput = be.outputInventory.getStackInSlot(0);
            if (!primaryOutput.isEmpty()) {
                return primaryOutput;
            }
            return be.inputInventory.getStackInSlot(0);
        }
        ItemStack primaryOutput = be.outputInventory.getStackInSlot(0);
        if (!primaryOutput.isEmpty()) {
            return primaryOutput;
        }
        return be.inputInventory.getStackInSlot(0);
    }

    private float calculateAnimationProgress(MechanicalPeelerBlockEntity be, float partialTicks) {
        float duration = be.inputInventory.recipeDuration;
        if (duration == 0.0f || be.getSpeed() == 0.0f) {
            return 0.5f;
        }
        float remainingTime = be.inputInventory.remainingTime;
        float baseProgress = 1.0f - remainingTime / duration;
        float processingSpeed = Mth.clamp((float)(Math.abs(be.getSpeed()) / 32.0f), (float)1.0f, (float)128.0f);
        float interpolatedProgress = baseProgress + partialTicks * processingSpeed / duration;
        interpolatedProgress = Mth.clamp((float)interpolatedProgress, (float)0.0f, (float)1.0f);
        float visualProgress = !be.inputInventory.appliedRecipe ? 1.0f - interpolatedProgress * 0.5f : 0.5f - interpolatedProgress * 0.5f;
        return Mth.clamp((float)visualProgress, (float)0.0f, (float)1.0f);
    }

    private void renderSingleItem(PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack, float progress, Vec3 itemMovement, MechanicalPeelerBlockEntity be) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        BakedModel modelWithOverrides = itemRenderer.getModel(stack, be.getLevel(), null, 0);
        boolean blockItem = modelWithOverrides.isGui3d();
        ms.pushPose();
        float positionOffset = progress - 0.5f;
        ms.translate(0.5 + itemMovement.x * (double)positionOffset, 0.0, 0.5 + itemMovement.z * (double)positionOffset);
        if (Math.abs(itemMovement.x) > 0.0) {
            ms.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
        ms.translate(0.0f, blockItem ? 0.925f : 0.8125f, 0.0f);
        ms.scale(0.5f, 0.5f, 0.5f);
        if (!blockItem) {
            ms.mulPose(Axis.XP.rotationDegrees(90.0f));
        }
        itemRenderer.render(stack, ItemDisplayContext.FIXED, false, ms, buffer, light, overlay, modelWithOverrides);
        ms.popPose();
    }

    public static void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer) {
        BlockState state = context.state;
        Direction facing = (Direction)state.getValue((Property)MechanicalPeelerBlock.FACING);
        boolean axisAlongFirst = (Boolean)state.getValue((Property)MechanicalPeelerBlock.AXIS_ALONG_FIRST_COORDINATE);
        boolean flipped = (Boolean)state.getValue((Property)MechanicalPeelerBlock.FLIPPED);
        MechanicalPeelerRenderer.renderBladeInContraption(context, renderWorld, matrices, buffer, state, facing, axisAlongFirst, flipped);
        MechanicalPeelerRenderer.renderShaftInContraption(context, renderWorld, matrices, buffer, state, facing, axisAlongFirst);
    }

    private static void renderBladeInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer, BlockState state, Direction facing, boolean axisAlongFirst, boolean flipped) {
        SuperByteBuffer superBuffer;
        if (facing.getAxis().isHorizontal()) {
            superBuffer = CachedBuffers.partial((PartialModel)CreateFisheryPartialModels.THRESHER_BLADE, (BlockState)state);
        } else {
            Direction.Axis kineticAxis;
            Direction.Axis axis = kineticAxis = axisAlongFirst ? Direction.Axis.X : Direction.Axis.Z;
            Direction horizontalFacing = kineticAxis == Direction.Axis.X ? (flipped ? Direction.SOUTH : Direction.NORTH) : (flipped ? Direction.WEST : Direction.EAST);
            superBuffer = CachedBuffers.partialFacingVertical((PartialModel)CreateFisheryPartialModels.THRESHER_BLADE, (BlockState)state, (Direction)horizontalFacing);
        }
        if (superBuffer == null) {
            return;
        }
        float speed = context.contraption.stalled || !VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)facing.getOpposite()) ? context.getAnimationSpeed() : 0.0f;
        float time = AnimationTickHolder.getRenderTime() / 20.0f;
        float angle = time * speed * 6.0f / 10.0f % 360.0f;
        superBuffer.transform(matrices.getModel());
        if (facing.getAxis().isHorizontal()) {
            ((SuperByteBuffer)((SuperByteBuffer)superBuffer.center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)facing))).uncenter();
            float originOffset = 0.0625f;
            float rotOffsetY = 8.0f * originOffset;
            float rotOffsetZ = 8.0f * originOffset;
            ((SuperByteBuffer)((SuperByteBuffer)superBuffer.translate(0.0f, rotOffsetY, rotOffsetZ)).rotateXDegrees(angle)).translate(0.0f, -rotOffsetY, -rotOffsetZ);
        } else {
            Direction.Axis kineticAxis;
            if (facing == Direction.DOWN) {
                ((SuperByteBuffer)((SuperByteBuffer)superBuffer.center()).rotateXDegrees(180.0f)).uncenter();
            }
            superBuffer.center();
            Direction.Axis axis = kineticAxis = axisAlongFirst ? Direction.Axis.X : Direction.Axis.Z;
            if (kineticAxis == Direction.Axis.X) {
                superBuffer.rotateXDegrees(angle);
            } else {
                superBuffer.rotateZDegrees(angle);
            }
            superBuffer.uncenter();
        }
        superBuffer.light(LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), buffer.getBuffer(RenderType.cutoutMipped()));
    }

    private static void renderShaftInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, MultiBufferSource buffer, BlockState state, Direction facing, boolean axisAlongFirst) {
        try {
            SuperByteBuffer shaftBuffer;
            if (facing.getAxis().isHorizontal()) {
                Direction oppositeFacing = facing.getOpposite();
                shaftBuffer = CachedBuffers.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (BlockState)state, (Direction)oppositeFacing);
            } else {
                shaftBuffer = CachedBuffers.partial((PartialModel)AllPartialModels.SHAFT, (BlockState)state);
            }
            if (shaftBuffer != null) {
                float speed = context.contraption.stalled || !VecHelper.isVecPointingTowards((Vec3)context.relativeMotion, (Direction)facing.getOpposite()) ? context.getAnimationSpeed() : 0.0f;
                float time = AnimationTickHolder.getRenderTime() / 20.0f;
                float angle = time * speed * 6.0f / 10.0f % 360.0f;
                shaftBuffer.transform(matrices.getModel());
                if (facing.getAxis().isHorizontal()) {
                    shaftBuffer.center();
                    shaftBuffer.rotateYDegrees(angle);
                    shaftBuffer.uncenter();
                } else {
                    Direction.Axis kineticAxis;
                    shaftBuffer.center();
                    Direction.Axis axis = kineticAxis = axisAlongFirst ? Direction.Axis.X : Direction.Axis.Z;
                    if (kineticAxis == Direction.Axis.X) {
                        shaftBuffer.rotateZDegrees(90.0f);
                        shaftBuffer.rotateYDegrees(-angle);
                    } else {
                        shaftBuffer.rotateXDegrees(90.0f);
                        shaftBuffer.rotateYDegrees(angle);
                    }
                    shaftBuffer.uncenter();
                }
                shaftBuffer.light(LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos)).useLevelLight((BlockAndTintGetter)context.world, matrices.getWorld()).renderInto(matrices.getViewProjection(), buffer.getBuffer(RenderType.solid()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

