/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.client.renderer;

import com.adonis.createfisheryindustry.block.MechanicalPeeler.MechanicalPeelerBlock;
import com.adonis.createfisheryindustry.client.CreateFisheryPartialModels;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.render.ActorVisual;
import com.simibubi.create.foundation.virtualWorld.VirtualRenderWorld;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.TransformedInstance;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class MechanicalPeelerActorVisual
extends ActorVisual {
    TransformedInstance thresherBlade;
    TransformedInstance shaft;
    private final Direction facing;
    private final Direction.Axis kineticShaftAxis;
    private final boolean axisAlongFirst;
    private final boolean flipped;
    private double rotation;
    private double previousRotation;
    private static final float PIVOT_OFFSET = 0.0625f;

    public MechanicalPeelerActorVisual(VisualizationContext visualizationContext, VirtualRenderWorld contraption, MovementContext context) {
        super(visualizationContext, (BlockAndTintGetter)contraption, context);
        BlockState state = context.state;
        this.facing = (Direction)state.getValue((Property)MechanicalPeelerBlock.FACING);
        this.axisAlongFirst = (Boolean)state.getValue((Property)MechanicalPeelerBlock.AXIS_ALONG_FIRST_COORDINATE);
        this.flipped = (Boolean)state.getValue((Property)MechanicalPeelerBlock.FLIPPED);
        this.kineticShaftAxis = this.getKineticShaftAxis(state);
        this.thresherBlade = (TransformedInstance)this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)CreateFisheryPartialModels.THRESHER_BLADE)).createInstance();
        this.shaft = this.facing.getAxis().isHorizontal() ? (TransformedInstance)this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance() : (TransformedInstance)this.instancerProvider.instancer(InstanceTypes.TRANSFORMED, Models.partial((PartialModel)AllPartialModels.SHAFT)).createInstance();
    }

    private Direction.Axis getKineticShaftAxis(BlockState state) {
        if (this.facing.getAxis().isHorizontal()) {
            return this.facing.getAxis();
        }
        return this.axisAlongFirst ? Direction.Axis.X : Direction.Axis.Z;
    }

    public void tick() {
        this.previousRotation = this.rotation;
        if (this.context.disabled || VecHelper.isVecPointingTowards((Vec3)this.context.relativeMotion, (Direction)this.facing.getOpposite())) {
            return;
        }
        float deg = this.context.getAnimationSpeed();
        this.rotation += (double)(deg / 20.0f);
        this.rotation %= 360.0;
    }

    public void beginFrame() {
        float angle = (float)this.getRotation();
        this.renderBlade(angle);
        this.renderShaft(angle);
    }

    private void renderBlade(float angle) {
        this.thresherBlade.setIdentityTransform().translate((Vec3i)this.context.localPos);
        if (this.facing.getAxis().isHorizontal()) {
            ((TransformedInstance)((TransformedInstance)this.thresherBlade.center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)this.facing))).uncenter();
            float rotOffsetY = 0.5f;
            float rotOffsetZ = 0.5f;
            ((TransformedInstance)this.thresherBlade.translate(0.0f, rotOffsetY, rotOffsetZ).rotateXDegrees(angle)).translate(0.0f, -rotOffsetY, -rotOffsetZ);
        } else {
            Direction horizontalFacing = this.kineticShaftAxis == Direction.Axis.X ? (this.flipped ? Direction.SOUTH : Direction.NORTH) : (this.flipped ? Direction.WEST : Direction.EAST);
            ((TransformedInstance)this.thresherBlade.center()).rotateYDegrees(AngleHelper.horizontalAngle((Direction)horizontalFacing));
            if (this.facing == Direction.DOWN) {
                this.thresherBlade.rotateXDegrees(180.0f);
            }
            if (this.kineticShaftAxis == Direction.Axis.X) {
                this.thresherBlade.rotateXDegrees(angle);
            } else {
                this.thresherBlade.rotateXDegrees(angle);
            }
            this.thresherBlade.uncenter();
        }
        this.thresherBlade.setChanged();
    }

    private void renderShaft(float angle) {
        this.shaft.setIdentityTransform().translate((Vec3i)this.context.localPos);
        if (this.facing.getAxis().isHorizontal()) {
            Direction oppositeFacing = this.facing.getOpposite();
            this.shaft.center();
            this.shaft.rotateToFace(this.facing);
            this.shaft.rotateZDegrees(angle);
            this.shaft.uncenter();
        } else {
            this.shaft.center();
            if (this.kineticShaftAxis == Direction.Axis.X) {
                this.shaft.rotateZDegrees(90.0f);
                this.shaft.rotateYDegrees(-angle);
            } else if (this.kineticShaftAxis == Direction.Axis.Z) {
                this.shaft.rotateXDegrees(90.0f);
                this.shaft.rotateYDegrees(angle);
            }
            this.shaft.uncenter();
        }
        this.shaft.setChanged();
    }

    protected double getRotation() {
        return AngleHelper.angleLerp((double)AnimationTickHolder.getPartialTicks(), (double)this.previousRotation, (double)this.rotation);
    }

    protected void _delete() {
        this.thresherBlade.delete();
        this.shaft.delete();
    }
}

