/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.client;

import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.item.CopperDivingLeggingsItem;
import com.adonis.createfisheryindustry.item.NetheriteDivingLeggingsItem;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ComputeFovModifierEvent;

@OnlyIn(value=Dist.CLIENT)
@EventBusSubscriber(modid="createfisheryindustry", value={Dist.CLIENT})
public class UnderwaterSprintFOVHandler {
    private static float currentFovModifier = 1.0f;
    private static float targetFovModifier = 1.0f;

    private static float getSprintFovMultiplier() {
        return (float)CreateFisheryCommonConfig.getDivingSprintFovMultiplier();
    }

    @SubscribeEvent
    public static void onComputeFov(ComputeFovModifierEvent event) {
        float transitionSpeed;
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        boolean isUnderwaterSprinting = UnderwaterSprintFOVHandler.isPlayerUnderwaterSprinting(player);
        targetFovModifier = isUnderwaterSprinting ? UnderwaterSprintFOVHandler.getSprintFovMultiplier() : 1.0f;
        if (Math.abs((currentFovModifier += (targetFovModifier - currentFovModifier) * (transitionSpeed = 0.5f)) - 1.0f) > 0.01f) {
            float newFov = event.getNewFovModifier() * currentFovModifier;
            event.setNewFovModifier(newFov);
        }
    }

    private static boolean isPlayerUnderwaterSprinting(Player player) {
        boolean hasDivingBoots = player.getItemBySlot(EquipmentSlot.FEET).getItem() instanceof DivingBootsItem;
        boolean hasDivingLeggings = player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof CopperDivingLeggingsItem || player.getItemBySlot(EquipmentSlot.LEGS).getItem() instanceof NetheriteDivingLeggingsItem;
        boolean inFluid = player.isInWater() || player.isInLava();
        boolean hasUnderwaterSprint = player.getPersistentData().getBoolean("CFI_UnderwaterSprint");
        return hasDivingBoots && hasDivingLeggings && inFluid && hasUnderwaterSprint && player.isSprinting();
    }
}

