/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.MechanicalPeeler;

import com.adonis.createfisheryindustry.block.MechanicalPeeler.MechanicalPeelerBlock;
import com.adonis.createfisheryindustry.data.PeelerEntityProcessing;
import com.adonis.createfisheryindustry.data.PeelerEntityProcessingManager;
import com.adonis.createfisheryindustry.recipe.CreateFisheryRecipeTypes;
import com.adonis.createfisheryindustry.recipe.PeelingRecipe;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.saw.TreeCutter;
import com.simibubi.create.content.processing.recipe.ProcessingInventory;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.DataMapHooks;
import net.neoforged.neoforge.common.IShearable;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

@ParametersAreNonnullByDefault
public class MechanicalPeelerBlockEntity
extends KineticBlockEntity
implements IHaveGoggleInformation {
    public static final double ENTITY_SCAN_RANGE = 0.5;
    private static final float INPUT_ANIMATION_TIME = 10.0f;
    private static final float OUTPUT_ANIMATION_TIME = 10.0f;
    private static final int BLOCK_BREAK_TIME = 60;
    private static final int ARMADILLO_TURTLE_COOLDOWN_TICKS = 1200;
    public static final int INPUT_SLOT = 0;
    private static final int MAX_SECONDARY_OUTPUTS_STORAGE = 4;
    public static final int OUTPUT_INV_PRIMARY_SLOT_TEMP = 0;
    private static final int OUTPUT_INV_SIZE = 5;
    public ProcessingInventory inputInventory;
    public ItemStackHandler outputInventory;
    private ItemStack playEvent;
    public final IItemHandler itemHandler;
    private final Map<UUID, Long> entityCooldowns = new HashMap<UUID, Long>();
    private Float cachedSpeed = null;
    private long lastSpeedCheck = 0L;
    private Direction currentInputDirection = null;
    private int blockProcessingTime = 0;
    private boolean isProcessingBlock = false;
    private BlockPos targetBlockPos = null;
    private static Item FARMERS_DELIGHT_TREE_BARK = null;
    private static boolean farmersDelightChecked = false;
    private static final String FARMERS_DELIGHT_MOD_ID = "farmersdelight";
    private static final String TREE_BARK_ITEM_ID = "tree_bark";

    public MechanicalPeelerBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.inputInventory = new CustomProcessingInventory(this, (NonNullConsumer<ItemStack>)((NonNullConsumer)this::startProcessingRecipe)).withSlotLimit(true);
        this.outputInventory = new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                MechanicalPeelerBlockEntity.this.setChanged();
                MechanicalPeelerBlockEntity.this.sendData();
            }

            public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                if (slot == 0) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
        this.playEvent = ItemStack.EMPTY;
        this.itemHandler = new PeelerItemHandler(this, this.inputInventory, this.outputInventory);
    }

    private void startProcessingRecipe(ItemStack stackInInputSlot) {
        if (!this.canProcess() || stackInInputSlot.isEmpty() || this.level != null && this.level.isClientSide && !this.isVirtual()) {
            return;
        }
        Optional<RecipeHolder<PeelingRecipe>> recipeHolder = this.getMatchingRecipe(new SingleRecipeInput(stackInInputSlot));
        if (recipeHolder.isPresent()) {
            PeelingRecipe recipe = (PeelingRecipe)recipeHolder.get().value();
            ArrayList<ItemStack> totalPotentialSecondaryProducts = new ArrayList<ItemStack>();
            RandomSource random = this.level.random;
            for (int i = 0; i < stackInInputSlot.getCount(); ++i) {
                totalPotentialSecondaryProducts.addAll(recipe.rollResultsFor(recipe.getSecondaryOutputs(), random));
            }
            if (!this.canStoreAllSecondaries(totalPotentialSecondaryProducts)) {
                // empty if block
            }
        }
        this.inputInventory.remainingTime = 10.0f;
        this.inputInventory.recipeDuration = 10.0f;
        this.inputInventory.appliedRecipe = false;
        this.setChanged();
        this.sendData();
    }

    private boolean canStoreAllSecondaries(List<ItemStack> secondaryProducts) {
        if (secondaryProducts.isEmpty()) {
            return true;
        }
        ItemStackHandler tempSecondaryInv = new ItemStackHandler(4);
        for (int i = 0; i < 4; ++i) {
            tempSecondaryInv.setStackInSlot(i, this.outputInventory.getStackInSlot(i + 1).copy());
        }
        for (ItemStack product : secondaryProducts) {
            ItemStack remainder = product.copy();
            for (int i = 0; i < tempSecondaryInv.getSlots() && !(remainder = tempSecondaryInv.insertItem(i, remainder.copy(), false)).isEmpty(); ++i) {
            }
            if (remainder.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private Optional<RecipeHolder<PeelingRecipe>> getMatchingRecipe(SingleRecipeInput input) {
        if (this.level == null || input.item().isEmpty()) {
            return Optional.empty();
        }
        return this.level.getRecipeManager().getRecipeFor(CreateFisheryRecipeTypes.PEELING.getType(), (RecipeInput)input, this.level);
    }

    private boolean isDirectionValidForAxis(Direction dir) {
        boolean alongLocalX;
        if (!dir.getAxis().isHorizontal()) {
            return false;
        }
        boolean bl = alongLocalX = (Boolean)this.getBlockState().getValue((Property)MechanicalPeelerBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        if (alongLocalX) {
            return dir == Direction.EAST || dir == Direction.WEST;
        }
        return dir == Direction.NORTH || dir == Direction.SOUTH;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        behaviours.add((BlockEntityBehaviour)new DirectBeltInputBehaviour((SmartBlockEntity)this).allowingBeltFunnelsWhen(this::canAcceptInput).setInsertionHandler((transported, side, simulate) -> {
            Direction inputDir = side.getOpposite();
            if (!this.canAcceptInput() || !this.isDirectionValidForAxis(inputDir)) {
                return transported.stack;
            }
            if (!simulate) {
                this.currentInputDirection = inputDir;
            }
            ItemStack stack = transported.stack;
            ItemStack remainder = this.inputInventory.insertItem(0, stack, simulate);
            if (!simulate && remainder.getCount() < stack.getCount() && this.inputInventory.remainingTime == -1.0f) {
                this.startProcessingRecipe(this.inputInventory.getStackInSlot(0));
            }
            return remainder;
        }));
    }

    private boolean canAcceptInput() {
        return this.canProcess() && this.inputInventory.getStackInSlot(0).isEmpty() && this.inputInventory.remainingTime <= 0.0f && this.outputInventory.getStackInSlot(0).isEmpty();
    }

    private static Item getFarmersDelightTreeBark() {
        if (!farmersDelightChecked) {
            Item barkItem;
            farmersDelightChecked = true;
            if (ModList.get().isLoaded(FARMERS_DELIGHT_MOD_ID) && (barkItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)FARMERS_DELIGHT_MOD_ID, (String)TREE_BARK_ITEM_ID))) != null && barkItem != Items.AIR) {
                FARMERS_DELIGHT_TREE_BARK = barkItem;
            }
        }
        return FARMERS_DELIGHT_TREE_BARK;
    }

    private List<BlockPos> findTreeLogs(BlockPos startPos, BlockState startState) {
        if (this.level == null) {
            return Collections.emptyList();
        }
        Block startBlock = startState.getBlock();
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)startBlock);
        if (blockId == null) {
            return Collections.emptyList();
        }
        String blockPath = blockId.getPath();
        if (!blockPath.contains("log") || blockPath.contains("stripped")) {
            return Collections.emptyList();
        }
        String strippedPath = "stripped_" + blockPath;
        ResourceLocation strippedId = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)strippedPath);
        if (!BuiltInRegistries.BLOCK.containsKey(strippedId)) {
            return Collections.emptyList();
        }
        TreeCutter.Tree tree = TreeCutter.findTree((BlockGetter)this.level, (BlockPos)startPos, (BlockState)startState);
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        try {
            logs = this.findConnectedLogs(startPos, startBlock);
        }
        catch (Exception e) {
            logs.add(startPos);
        }
        return logs;
    }

    private List<BlockPos> findConnectedLogs(BlockPos startPos, Block logType) {
        ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(startPos);
        while (!toCheck.isEmpty() && logs.size() < 256) {
            String currentPath;
            BlockPos current = (BlockPos)toCheck.remove(0);
            if (visited.contains(current)) continue;
            visited.add(current);
            BlockState currentState = this.level.getBlockState(current);
            Block currentBlock = currentState.getBlock();
            ResourceLocation currentId = BuiltInRegistries.BLOCK.getKey((Object)currentBlock);
            if (currentId == null || !(currentPath = currentId.getPath()).contains("log") || currentPath.contains("stripped") || !this.isSameWoodType(logType, currentBlock)) continue;
            logs.add(current);
            for (Direction dir : Direction.values()) {
                BlockPos neighbor = current.relative(dir);
                if (visited.contains(neighbor)) continue;
                toCheck.add(neighbor);
            }
        }
        return logs;
    }

    private boolean isSameWoodType(Block block1, Block block2) {
        ResourceLocation id1 = BuiltInRegistries.BLOCK.getKey((Object)block1);
        ResourceLocation id2 = BuiltInRegistries.BLOCK.getKey((Object)block2);
        if (id1 == null || id2 == null) {
            return false;
        }
        if (!id1.getNamespace().equals(id2.getNamespace())) {
            return false;
        }
        String path1 = id1.getPath();
        String path2 = id2.getPath();
        String type1 = this.extractWoodType(path1);
        String type2 = this.extractWoodType(path2);
        return type1.equals(type2);
    }

    private String extractWoodType(String blockPath) {
        if (blockPath.endsWith("_log")) {
            return blockPath.substring(0, blockPath.length() - 4);
        }
        return blockPath;
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.sendData();
        }
    }

    public void sendData() {
        if (this.level == null || !this.level.isClientSide) {
            // empty if block
        }
        super.sendData();
    }

    public void write(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        compound.put("InputInventory", (Tag)this.inputInventory.serializeNBT(registries));
        compound.put("OutputInventory", (Tag)this.outputInventory.serializeNBT(registries));
        compound.putBoolean("AppliedRecipe", this.inputInventory.appliedRecipe);
        compound.putFloat("RemainingTime", this.inputInventory.remainingTime);
        compound.putFloat("RecipeDuration", this.inputInventory.recipeDuration);
        if (this.currentInputDirection != null) {
            compound.putString("InputDirection", this.currentInputDirection.getName());
        }
        compound.putInt("BlockProcessingTime", this.blockProcessingTime);
        compound.putBoolean("IsProcessingBlock", this.isProcessingBlock);
        if (this.targetBlockPos != null) {
            compound.putLong("TargetBlockPos", this.targetBlockPos.asLong());
        }
        super.write(compound, registries, clientPacket);
        if (!clientPacket) {
            CompoundTag cooldownsTag = new CompoundTag();
            this.entityCooldowns.forEach((uuid, time) -> cooldownsTag.putLong(uuid.toString(), time.longValue()));
            compound.put("EntityCooldowns", (Tag)cooldownsTag);
        }
        if (clientPacket && !this.playEvent.isEmpty()) {
            compound.put("PlayEvent", this.playEvent.saveOptional(registries));
            this.playEvent = ItemStack.EMPTY;
        }
    }

    protected void read(CompoundTag compound, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(compound, registries, clientPacket);
        this.inputInventory.deserializeNBT(registries, compound.getCompound("InputInventory"));
        this.outputInventory.deserializeNBT(registries, compound.getCompound("OutputInventory"));
        if (compound.contains("AppliedRecipe")) {
            this.inputInventory.appliedRecipe = compound.getBoolean("AppliedRecipe");
        }
        if (compound.contains("RemainingTime")) {
            this.inputInventory.remainingTime = compound.getFloat("RemainingTime");
        }
        if (compound.contains("RecipeDuration")) {
            this.inputInventory.recipeDuration = compound.getFloat("RecipeDuration");
        }
        this.currentInputDirection = compound.contains("InputDirection") ? Direction.byName((String)compound.getString("InputDirection")) : null;
        this.blockProcessingTime = compound.getInt("BlockProcessingTime");
        this.isProcessingBlock = compound.getBoolean("IsProcessingBlock");
        this.targetBlockPos = compound.contains("TargetBlockPos") ? BlockPos.of((long)compound.getLong("TargetBlockPos")) : null;
        if (!clientPacket) {
            this.entityCooldowns.clear();
            if (compound.contains("EntityCooldowns", 10)) {
                CompoundTag cooldownsTag = compound.getCompound("EntityCooldowns");
                for (String key : cooldownsTag.getAllKeys()) {
                    try {
                        UUID uuid = UUID.fromString(key);
                        long time = cooldownsTag.getLong(key);
                        this.entityCooldowns.put(uuid, time);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
        }
        if (compound.contains("PlayEvent")) {
            this.playEvent = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)compound.getCompound("PlayEvent"));
        }
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.getBlockPos()).inflate(0.125);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        super.tickAudio();
        if (this.getSpeed() == 0.0f || this.playEvent.isEmpty() || this.level == null) {
            return;
        }
        boolean isWood = false;
        Item item = this.playEvent.getItem();
        if (item instanceof BlockItem) {
            Block block = ((BlockItem)item).getBlock();
            isWood = block.getSoundType(block.defaultBlockState(), (LevelReader)this.level, this.worldPosition, null) == SoundType.WOOD;
        }
        this.spawnEventParticles(this.playEvent);
        this.playEvent = ItemStack.EMPTY;
        if (!isWood) {
            AllSoundEvents.SAW_ACTIVATE_STONE.playAt(this.level, (Vec3i)this.worldPosition, 3.0f, 1.0f, true);
        } else {
            AllSoundEvents.SAW_ACTIVATE_WOOD.playAt(this.level, (Vec3i)this.worldPosition, 3.0f, 1.0f, true);
        }
    }

    protected void spawnEventParticles(ItemStack stack) {
        ItemParticleOption itemParticleOption;
        if (stack == null || stack.isEmpty() || this.level == null) {
            return;
        }
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            itemParticleOption = new BlockParticleOption(ParticleTypes.BLOCK, blockItem.getBlock().defaultBlockState());
        } else {
            itemParticleOption = new ItemParticleOption(ParticleTypes.ITEM, stack);
        }
        ItemParticleOption particleData = itemParticleOption;
        RandomSource r = this.level.random;
        Vec3 v = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(0.0, 0.3125, 0.0);
        for (int i = 0; i < 10; ++i) {
            Vec3 randomOffset = VecHelper.offsetRandomly((Vec3)Vec3.ZERO, (RandomSource)r, (float)0.125f);
            Vec3 m = randomOffset.add(0.0, 0.25, 0.0);
            this.level.addParticle((ParticleOptions)particleData, v.x, v.y, v.z, m.x, m.y, m.z);
        }
    }

    protected void spawnParticles(ItemStack stack) {
        ItemParticleOption particleData;
        if (stack == null || stack.isEmpty() || this.level == null || !this.canProcess()) {
            return;
        }
        float particleSpeed = 0.125f;
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            particleData = new BlockParticleOption(ParticleTypes.BLOCK, blockItem.getBlock().defaultBlockState());
            particleSpeed = 0.2f;
        } else {
            particleData = new ItemParticleOption(ParticleTypes.ITEM, stack);
        }
        RandomSource r = this.level.random;
        Vec3 itemMovementVec = this.getItemMovementVec();
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        float visualOffsetRatio = this.inputInventory.recipeDuration != 0.0f ? this.inputInventory.remainingTime / this.inputInventory.recipeDuration : 0.0f;
        visualOffsetRatio = !this.inputInventory.appliedRecipe ? (visualOffsetRatio + 1.0f) / 2.0f : (visualOffsetRatio /= 2.0f);
        visualOffsetRatio = Mth.clamp((float)visualOffsetRatio, (float)0.125f, (float)0.875f);
        Vec3 particlePos = center.add(itemMovementVec.x() * ((double)visualOffsetRatio - 0.5), 0.45, itemMovementVec.z() * ((double)visualOffsetRatio - 0.5));
        Vec3 particleMotion = new Vec3(-itemMovementVec.x() * (double)particleSpeed, (double)(r.nextFloat() * particleSpeed * 0.5f), -itemMovementVec.z() * (double)particleSpeed);
        this.level.addParticle((ParticleOptions)particleData, particlePos.x(), particlePos.y(), particlePos.z(), particleMotion.x, particleMotion.y, particleMotion.z);
    }

    public void tick() {
        Vec3 itemMovement;
        super.tick();
        if (this.level == null) {
            return;
        }
        if (!this.level.isClientSide && this.level.getGameTime() % 10L == 0L && this.getSpeed() != 0.0f) {
            AABB scanArea = new AABB(this.worldPosition).inflate(0.5);
            List entities = this.level.getEntitiesOfClass(Entity.class, scanArea, e -> e.isAlive() && (e instanceof Sheep || PeelerEntityProcessingManager.hasProcessing(e.getType())));
            for (Entity entity : entities) {
                this.processEntity(entity);
            }
        }
        if (!this.level.isClientSide && this.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING) == Direction.UP && this.level.getGameTime() % 5L == 0L && !Vec3.ZERO.equals((Object)(itemMovement = this.getItemMovementVec()))) {
            BlockPos inputPos = this.worldPosition.offset((Vec3i)BlockPos.containing((Position)itemMovement.reverse()));
            DirectBeltInputBehaviour directBeltInputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)inputPos, (BehaviourType)DirectBeltInputBehaviour.TYPE);
        }
        if (this.level.isClientSide) {
            if (!this.playEvent.isEmpty()) {
                this.tickAudio();
            }
            if (this.inputInventory.remainingTime > 0.0f && this.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING) == Direction.UP && this.canProcess()) {
                float speed = Math.abs(this.getSpeed()) / 24.0f;
                this.inputInventory.remainingTime = Math.max(0.0f, this.inputInventory.remainingTime - speed);
                if (!this.inputInventory.getStackInSlot(0).isEmpty() && !this.inputInventory.appliedRecipe) {
                    this.spawnParticles(this.inputInventory.getStackInSlot(0));
                } else if (!this.outputInventory.getStackInSlot(0).isEmpty() && this.inputInventory.appliedRecipe) {
                    this.spawnParticles(this.outputInventory.getStackInSlot(0));
                }
            }
            if (this.isProcessingBlock && this.targetBlockPos != null && this.blockProcessingTime > 0 && this.shouldProcessBlock() && this.level.getGameTime() % 3L == 0L) {
                this.spawnBlockProcessingParticles(this.level.getBlockState(this.targetBlockPos));
            }
            return;
        }
        if (this.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING) == Direction.UP) {
            if (!this.canProcess() || this.getSpeed() == 0.0f) {
                if (this.inputInventory.remainingTime <= 0.0f) {
                    if (!this.outputInventory.getStackInSlot(0).isEmpty()) {
                        this.ejectInputOrPrimaryOutput();
                    } else if (this.inputInventory.appliedRecipe && !this.inputInventory.getStackInSlot(0).isEmpty()) {
                        this.ejectInputOrPrimaryOutput();
                    }
                }
            } else if (this.inputInventory.remainingTime > 0.0f) {
                float speed = Math.abs(this.getSpeed()) / 24.0f;
                this.inputInventory.remainingTime -= speed;
                if (this.inputInventory.remainingTime <= 0.0f && !this.inputInventory.appliedRecipe) {
                    Optional<RecipeHolder<PeelingRecipe>> recipeHolder;
                    if (!this.inputInventory.getStackInSlot(0).isEmpty()) {
                        this.playEvent = this.inputInventory.getStackInSlot(0).copy();
                    }
                    if ((recipeHolder = this.getMatchingRecipe(new SingleRecipeInput(this.inputInventory.getStackInSlot(0)))).isPresent()) {
                        this.applyRecipeProducts(recipeHolder.get());
                    }
                    this.inputInventory.appliedRecipe = true;
                    this.inputInventory.recipeDuration = 10.0f;
                    this.inputInventory.remainingTime = 10.0f;
                    this.setChanged();
                    this.sendData();
                    this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
                } else if (this.inputInventory.remainingTime <= 0.0f && this.inputInventory.appliedRecipe) {
                    this.ejectInputOrPrimaryOutput();
                }
            } else if (!this.inputInventory.getStackInSlot(0).isEmpty() && !this.inputInventory.appliedRecipe && this.canAcceptInput()) {
                this.startProcessingRecipe(this.inputInventory.getStackInSlot(0));
            }
        }
        if (this.shouldProcessBlock() && this.getSpeed() != 0.0f) {
            this.processBlock();
        } else if (this.isProcessingBlock) {
            this.blockProcessingTime = 0;
            this.isProcessingBlock = false;
            this.targetBlockPos = null;
            this.setChanged();
            this.sendData();
        }
    }

    private void ejectInputOrPrimaryOutput() {
        BlockPos nextPos;
        DirectBeltInputBehaviour beltBehaviour;
        boolean isPassThroughOutput;
        ItemStack stackToEject;
        if (!this.outputInventory.getStackInSlot(0).isEmpty()) {
            stackToEject = this.outputInventory.getStackInSlot(0);
            isPassThroughOutput = false;
        } else if (this.inputInventory.appliedRecipe && !this.inputInventory.getStackInSlot(0).isEmpty()) {
            stackToEject = this.inputInventory.getStackInSlot(0);
            isPassThroughOutput = true;
        } else {
            this.inputInventory.remainingTime = -1.0f;
            this.inputInventory.appliedRecipe = false;
            this.inputInventory.recipeDuration = 0.0f;
            this.currentInputDirection = null;
            this.setChanged();
            this.sendData();
            return;
        }
        Vec3 itemMovement = this.getItemMovementVec();
        Vec3 outputMovement = itemMovement.scale(-1.0);
        Direction outputFacing = Direction.getNearest((double)outputMovement.x, (double)outputMovement.y, (double)outputMovement.z);
        ItemStack tryExportingToBeltFunnel = ((DirectBeltInputBehaviour)this.getBehaviour(DirectBeltInputBehaviour.TYPE)).tryExportingToBeltFunnel(stackToEject, outputFacing.getOpposite(), false);
        if (tryExportingToBeltFunnel != null) {
            if (tryExportingToBeltFunnel.getCount() != stackToEject.getCount()) {
                this.updateEjectedStack(isPassThroughOutput, tryExportingToBeltFunnel);
                return;
            }
            if (tryExportingToBeltFunnel.isEmpty()) {
                this.updateEjectedStack(isPassThroughOutput, ItemStack.EMPTY);
                this.resetStateAfterEjectionOrTryNext(isPassThroughOutput);
                return;
            }
        }
        if ((beltBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)this.level, (BlockPos)(nextPos = this.worldPosition.offset((Vec3i)BlockPos.containing((Position)outputMovement))), (BehaviourType)DirectBeltInputBehaviour.TYPE)) != null && beltBehaviour.canInsertFromSide(outputFacing)) {
            if (this.level.isClientSide && !this.isVirtual()) {
                return;
            }
            ItemStack currentStackCopy = stackToEject.copy();
            ItemStack beltRemainder = beltBehaviour.handleInsertion(currentStackCopy, outputFacing, false);
            if (!ItemStack.matches((ItemStack)beltRemainder, (ItemStack)currentStackCopy)) {
                this.updateEjectedStack(isPassThroughOutput, beltRemainder);
                if (beltRemainder.isEmpty()) {
                    this.resetStateAfterEjectionOrTryNext(isPassThroughOutput);
                }
                this.setChanged();
                this.sendData();
                return;
            }
        }
        Vec3 outPos = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(outputMovement.scale(0.5)).add(0.0, 0.5, 0.0);
        Vec3 outMotion = outputMovement.scale(0.0625).add(0.0, 0.125, 0.0);
        ItemEntity entityOut = new ItemEntity(this.level, outPos.x, outPos.y, outPos.z, stackToEject.copy());
        entityOut.setDeltaMovement(outMotion);
        this.level.addFreshEntity((Entity)entityOut);
        this.updateEjectedStack(isPassThroughOutput, ItemStack.EMPTY);
        this.resetStateAfterEjectionOrTryNext(isPassThroughOutput);
        this.level.updateNeighbourForOutputSignal(this.worldPosition, this.getBlockState().getBlock());
    }

    private void updateEjectedStack(boolean isPassThrough, ItemStack remainder) {
        if (isPassThrough) {
            this.inputInventory.setStackInSlot(0, remainder);
        } else {
            this.outputInventory.setStackInSlot(0, remainder);
        }
        this.setChanged();
        this.sendData();
    }

    private void resetStateAfterEjectionOrTryNext(boolean wasPassThroughOutput) {
        boolean inputSlotNowEmpty = this.inputInventory.getStackInSlot(0).isEmpty();
        boolean primaryOutputSlotNowEmpty = this.outputInventory.getStackInSlot(0).isEmpty();
        if (wasPassThroughOutput) {
            if (inputSlotNowEmpty) {
                this.inputInventory.remainingTime = -1.0f;
                this.inputInventory.appliedRecipe = false;
                this.inputInventory.recipeDuration = 0.0f;
                this.currentInputDirection = null;
            } else {
                this.startProcessingRecipe(this.inputInventory.getStackInSlot(0));
            }
        } else if (primaryOutputSlotNowEmpty) {
            this.inputInventory.remainingTime = -1.0f;
            this.inputInventory.appliedRecipe = false;
            this.inputInventory.recipeDuration = 0.0f;
            this.currentInputDirection = null;
            if (!this.inputInventory.getStackInSlot(0).isEmpty()) {
                this.startProcessingRecipe(this.inputInventory.getStackInSlot(0));
            }
        }
        this.setChanged();
        this.sendData();
    }

    private void applyRecipeProducts(RecipeHolder<PeelingRecipe> recipeHolder) {
        ItemEntity overflow;
        ItemStack inputStackForRecipe = this.inputInventory.getStackInSlot(0).copy();
        if (inputStackForRecipe.isEmpty() || this.level == null) {
            return;
        }
        PeelingRecipe recipe = (PeelingRecipe)recipeHolder.value();
        int itemsToProcess = inputStackForRecipe.getCount();
        this.inputInventory.setStackInSlot(0, ItemStack.EMPTY);
        ItemStack aggregatedPrimaryOutput = ItemStack.EMPTY;
        LinkedList aggregatedSecondaryOutputs = new LinkedList();
        List definedOutputs = recipe.getRollableResults();
        if (definedOutputs.isEmpty()) {
            this.setChanged();
            this.sendData();
            return;
        }
        ProcessingOutput primaryDefinedOutput = (ProcessingOutput)definedOutputs.get(0);
        List secondaryDefinedOutputs = definedOutputs.size() > 1 ? definedOutputs.subList(1, definedOutputs.size()) : Collections.emptyList();
        RandomSource random = this.level.random;
        for (int i = 0; i < itemsToProcess; ++i) {
            Item bark;
            ItemStack currentPrimaryRolledItem;
            List rolledPrimaryList = recipe.rollResults(Collections.singletonList(primaryDefinedOutput), random);
            if (!rolledPrimaryList.isEmpty() && !(currentPrimaryRolledItem = (ItemStack)rolledPrimaryList.get(0)).isEmpty()) {
                if (aggregatedPrimaryOutput.isEmpty()) {
                    aggregatedPrimaryOutput = currentPrimaryRolledItem.copy();
                } else if (ItemStack.isSameItemSameComponents((ItemStack)aggregatedPrimaryOutput, (ItemStack)currentPrimaryRolledItem)) {
                    aggregatedPrimaryOutput.grow(currentPrimaryRolledItem.getCount());
                } else {
                    Vec3 dropPos = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(0.0, 0.75, 0.0);
                    overflow = new ItemEntity(this.level, dropPos.x, dropPos.y, dropPos.z, currentPrimaryRolledItem);
                    this.level.addFreshEntity((Entity)overflow);
                }
            }
            if (!secondaryDefinedOutputs.isEmpty()) {
                List currentSecondaries = recipe.rollResults(secondaryDefinedOutputs, random);
                for (ItemStack secondaryStack : currentSecondaries) {
                    if (secondaryStack.isEmpty()) continue;
                    ItemHelper.addToList((ItemStack)secondaryStack.copy(), aggregatedSecondaryOutputs);
                }
            }
            if (!inputStackForRecipe.is(ItemTags.LOGS_THAT_BURN) || (bark = MechanicalPeelerBlockEntity.getFarmersDelightTreeBark()) == null) continue;
            ItemHelper.addToList((ItemStack)new ItemStack((ItemLike)bark, 1), aggregatedSecondaryOutputs);
        }
        this.outputInventory.setStackInSlot(0, aggregatedPrimaryOutput);
        for (ItemStack secondaryStack : aggregatedSecondaryOutputs) {
            if (secondaryStack.isEmpty()) continue;
            ItemStack remainderToStore = secondaryStack.copy();
            for (int slot = 1; slot < this.outputInventory.getSlots() && !(remainderToStore = this.outputInventory.insertItem(slot, remainderToStore, false)).isEmpty(); ++slot) {
            }
            if (remainderToStore.isEmpty()) continue;
            Vec3 dropPos = VecHelper.getCenterOf((Vec3i)this.worldPosition).add(0.0, 0.75, 0.0);
            overflow = new ItemEntity(this.level, dropPos.x, dropPos.y, dropPos.z, remainderToStore);
            this.level.addFreshEntity((Entity)overflow);
        }
        this.setChanged();
        this.sendData();
    }

    public Vec3 getItemMovementVec() {
        Direction facing = (Direction)this.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING);
        if (facing == Direction.UP) {
            boolean alongLocalX;
            if (this.currentInputDirection != null && this.currentInputDirection.getAxis().isHorizontal()) {
                return Vec3.atLowerCornerOf((Vec3i)this.currentInputDirection.getNormal());
            }
            boolean bl = alongLocalX = (Boolean)this.getBlockState().getValue((Property)MechanicalPeelerBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
            if (alongLocalX) {
                return new Vec3(0.0, 0.0, 1.0);
            }
            return new Vec3(1.0, 0.0, 0.0);
        }
        if (this.currentInputDirection != null && this.currentInputDirection.getAxis().isHorizontal()) {
            return Vec3.atLowerCornerOf((Vec3i)this.currentInputDirection.getNormal());
        }
        if (facing.getAxis().isHorizontal()) {
            return Vec3.atLowerCornerOf((Vec3i)facing.getClockWise().getNormal());
        }
        return Vec3.ZERO;
    }

    public void insertFromBelt(ItemStack stack, Direction from) {
        if (!this.canAcceptInput() || this.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING) != Direction.UP) {
            return;
        }
        if (!this.isDirectionValidForAxis(from)) {
            return;
        }
        this.currentInputDirection = from;
        ItemStack remainder = this.inputInventory.insertItem(0, stack, false);
        if (remainder.getCount() < stack.getCount() && this.inputInventory.remainingTime == -1.0f) {
            this.startProcessingRecipe(this.inputInventory.getStackInSlot(0));
        }
    }

    public void insertItem(ItemEntity entity) {
        Direction inputDir;
        Vec3 blockCenter;
        if (this.level == null || this.level.isClientSide || !entity.isAlive()) {
            return;
        }
        if (!this.canAcceptInput() || this.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING) != Direction.UP) {
            return;
        }
        Vec3 entityPos = entity.position();
        Vec3 diff = entityPos.subtract(blockCenter = VecHelper.getCenterOf((Vec3i)this.worldPosition)).normalize();
        if (Math.abs(diff.x()) > Math.abs(diff.z())) {
            inputDir = diff.x() > 0.0 ? Direction.EAST : Direction.WEST;
        } else {
            Direction direction = inputDir = diff.z() > 0.0 ? Direction.SOUTH : Direction.NORTH;
        }
        if (!this.isDirectionValidForAxis(inputDir)) {
            return;
        }
        this.currentInputDirection = inputDir;
        ItemStack toInsert = entity.getItem().copy();
        ItemStack remainder = this.inputInventory.insertItem(0, toInsert, false);
        if (!ItemStack.matches((ItemStack)remainder, (ItemStack)toInsert)) {
            entity.setItem(remainder);
            if (remainder.isEmpty()) {
                entity.discard();
            }
            if (this.inputInventory.remainingTime == -1.0f && !this.inputInventory.getStackInSlot(0).isEmpty()) {
                this.startProcessingRecipe(this.inputInventory.getStackInSlot(0));
            }
        }
    }

    protected boolean canProcess() {
        if (this.level != null && this.level.getGameTime() != this.lastSpeedCheck) {
            this.lastSpeedCheck = this.level.getGameTime();
            this.cachedSpeed = Float.valueOf(this.getSpeed());
        }
        return this.cachedSpeed != null && this.cachedSpeed.floatValue() != 0.0f;
    }

    public void processEntity(Entity entity) {
        Sheep sheep;
        if (this.level == null || this.level.isClientSide || entity.isRemoved() || this.getSpeed() == 0.0f) {
            return;
        }
        UUID entityId = entity.getUUID();
        if (this.isEntityOnCooldown(entityId)) {
            return;
        }
        boolean processedSuccessfully = false;
        if (entity instanceof Sheep && (sheep = (Sheep)entity) instanceof IShearable) {
            List drops;
            Sheep shearableTarget = sheep;
            if (shearableTarget.isShearable(null, ItemStack.EMPTY, this.level, entity.blockPosition()) && (drops = shearableTarget.onSheared(null, ItemStack.EMPTY, this.level, entity.blockPosition())) != null && !drops.isEmpty()) {
                for (ItemStack drop : drops) {
                    if (this.tryStoreItemInSecondaryOutput(drop)) continue;
                    ItemEntity itemEntity = new ItemEntity(this.level, entity.getX(), entity.getY() + 0.5, entity.getZ(), drop);
                    this.level.addFreshEntity((Entity)itemEntity);
                }
                processedSuccessfully = true;
            }
        } else if (PeelerEntityProcessingManager.hasProcessing(entity.getType())) {
            PeelerEntityProcessing processing = PeelerEntityProcessingManager.getProcessing(entity.getType());
            if (processing.condition().isPresent()) {
                // empty if block
            }
            ResourceKey lootTableKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)processing.lootTable());
            LootTable lootTable = this.level.getServer().reloadableRegistries().getLootTable(lootTableKey);
            if (lootTable != null && lootTable != LootTable.EMPTY) {
                LootParams params = new LootParams.Builder((ServerLevel)this.level).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)this.level.damageSources().generic()).create(LootContextParamSets.ENTITY);
                ObjectArrayList drops = lootTable.getRandomItems(params);
                for (ItemStack drop : drops) {
                    if (this.tryStoreItemInSecondaryOutput(drop)) continue;
                    ItemEntity itemEntity = new ItemEntity(this.level, entity.getX(), entity.getY() + 0.5, entity.getZ(), drop);
                    this.level.addFreshEntity((Entity)itemEntity);
                }
                this.level.playSound(null, entity, SoundEvents.ITEM_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                this.entityCooldowns.put(entityId, this.level.getGameTime() + (long)processing.cooldownTicks());
                processedSuccessfully = true;
            }
        }
        if (processedSuccessfully) {
            this.spawnProcessingParticlesEffect();
            this.setChanged();
            this.sendData();
        }
    }

    private boolean tryStoreItemInSecondaryOutput(ItemStack stackToStore) {
        if (stackToStore.isEmpty()) {
            return true;
        }
        ItemStack remainder = stackToStore.copy();
        for (int i = 1; i <= 4; ++i) {
            if (!(remainder = this.outputInventory.insertItem(i, remainder, false)).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isEntityOnCooldown(UUID entityId) {
        if (this.level == null) {
            return true;
        }
        return this.entityCooldowns.containsKey(entityId) && this.level.getGameTime() < this.entityCooldowns.get(entityId);
    }

    private void setEntityCooldown(UUID entityId) {
        if (this.level == null) {
            return;
        }
        this.entityCooldowns.put(entityId, this.level.getGameTime());
    }

    private void spawnProcessingParticlesEffect() {
        if (this.level == null || !this.level.isClientSide) {
            return;
        }
        RandomSource r = this.level.random;
        Vec3 center = VecHelper.getCenterOf((Vec3i)this.worldPosition);
        for (int i = 0; i < 5; ++i) {
            double motionX = (r.nextDouble() - 0.5) * 0.1;
            double motionY = r.nextDouble() * 0.1 + 0.1;
            double motionZ = (r.nextDouble() - 0.5) * 0.1;
            this.level.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, center.x + (r.nextDouble() - 0.5) * 0.6, center.y + 1.1, center.z + (r.nextDouble() - 0.5) * 0.6, motionX, motionY, motionZ);
        }
    }

    protected boolean shouldProcessBlock() {
        return true;
    }

    protected BlockPos getTargetBlockPos() {
        return this.getBlockPos().relative((Direction)this.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING));
    }

    private boolean canProcessBlock(BlockState state) {
        String blockPath;
        if (state.isAir()) {
            return false;
        }
        Block block = state.getBlock();
        if (DataMapHooks.INVERSE_OXIDIZABLES_DATAMAP.containsKey(block)) {
            return true;
        }
        if (DataMapHooks.INVERSE_WAXABLES_DATAMAP.containsKey(block)) {
            return true;
        }
        if (block == Blocks.AMETHYST_CLUSTER) {
            return true;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block);
        if (blockId != null && (blockPath = blockId.getPath()).contains("log") && !blockPath.contains("stripped")) {
            String strippedPath = "stripped_" + blockPath;
            ResourceLocation strippedId = ResourceLocation.fromNamespaceAndPath((String)blockId.getNamespace(), (String)strippedPath);
            return BuiltInRegistries.BLOCK.containsKey(strippedId);
        }
        return false;
    }

    private Block getProcessedBlock(Block currentBlock) {
        Block deoxidized = (Block)DataMapHooks.INVERSE_OXIDIZABLES_DATAMAP.get(currentBlock);
        if (deoxidized != null) {
            return deoxidized;
        }
        Block dewaxed = (Block)DataMapHooks.INVERSE_WAXABLES_DATAMAP.get(currentBlock);
        if (dewaxed != null) {
            return dewaxed;
        }
        ResourceLocation currentId = BuiltInRegistries.BLOCK.getKey((Object)currentBlock);
        if (currentId == null) {
            return currentBlock;
        }
        String blockPath = currentId.getPath();
        if (blockPath.contains("log") && !blockPath.startsWith("stripped_")) {
            String strippedPath = "stripped_" + blockPath;
            ResourceLocation strippedId = ResourceLocation.fromNamespaceAndPath((String)currentId.getNamespace(), (String)strippedPath);
            if (BuiltInRegistries.BLOCK.containsKey(strippedId)) {
                return (Block)BuiltInRegistries.BLOCK.get(strippedId);
            }
        }
        return currentBlock;
    }

    private void processBlock() {
        if (this.level == null || !this.shouldProcessBlock() || this.getSpeed() == 0.0f) {
            if (this.isProcessingBlock) {
                this.blockProcessingTime = 0;
                this.isProcessingBlock = false;
                this.targetBlockPos = null;
                this.setChanged();
            }
            return;
        }
        BlockPos currentTargetPos = this.getTargetBlockPos();
        BlockState targetState = this.level.getBlockState(currentTargetPos);
        if (!this.canProcessBlock(targetState)) {
            if (this.isProcessingBlock) {
                this.blockProcessingTime = 0;
                this.isProcessingBlock = false;
                this.targetBlockPos = null;
                this.setChanged();
            }
            return;
        }
        if (!this.isProcessingBlock || !currentTargetPos.equals((Object)this.targetBlockPos)) {
            this.targetBlockPos = currentTargetPos;
            this.isProcessingBlock = true;
            this.blockProcessingTime = 0;
            this.setChanged();
        }
        float processingSpeedFactor = Mth.clamp((float)(Math.abs(this.getSpeed()) / 24.0f), (float)1.0f, (float)128.0f);
        this.blockProcessingTime += (int)Math.max(1.0f, processingSpeedFactor);
        if (this.blockProcessingTime >= 60) {
            if (!this.level.isClientSide) {
                Block targetBlock = targetState.getBlock();
                if (targetBlock == Blocks.AMETHYST_CLUSTER) {
                    this.processAmethystCluster(currentTargetPos, targetState);
                } else {
                    ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)targetBlock);
                    if (blockId != null) {
                        String blockPath = blockId.getPath();
                        if (blockPath.contains("log") && !blockPath.contains("stripped")) {
                            this.processWholeTree(currentTargetPos, targetState);
                        } else {
                            this.processSingleBlock(currentTargetPos, targetState);
                        }
                    }
                }
            }
            this.blockProcessingTime = 0;
            this.isProcessingBlock = false;
            this.targetBlockPos = null;
            this.setChanged();
        } else {
            this.setChanged();
        }
    }

    private void processAmethystCluster(BlockPos pos, BlockState state) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        ItemStack amethystShards = new ItemStack((ItemLike)Items.AMETHYST_SHARD, 4);
        if (!this.tryStoreItemInSecondaryOutput(amethystShards)) {
            Vec3 dropPos = Vec3.atCenterOf((Vec3i)pos).add(0.0, 0.5, 0.0);
            ItemEntity itemEntity = new ItemEntity(this.level, dropPos.x, dropPos.y, dropPos.z, amethystShards);
            itemEntity.setDeltaMovement((this.level.random.nextDouble() - 0.5) * 0.1, this.level.random.nextDouble() * 0.1 + 0.1, (this.level.random.nextDouble() - 0.5) * 0.1);
            this.level.addFreshEntity((Entity)itemEntity);
        }
        this.level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        this.level.playSound(null, pos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        this.setChanged();
        this.sendData();
    }

    private void tryDropBarkForLog(BlockPos logPos, BlockState originalLogState) {
        ItemStack barkDrop;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)originalLogState.getBlock());
        if (blockId == null || !blockId.getPath().contains("log") || blockId.getPath().contains("stripped")) {
            return;
        }
        Item bark = MechanicalPeelerBlockEntity.getFarmersDelightTreeBark();
        if (bark != null && !this.tryStoreItemInSecondaryOutput(barkDrop = new ItemStack((ItemLike)bark, 1))) {
            Vec3 dropPosition = Vec3.atCenterOf((Vec3i)logPos).add(0.0, 0.25, 0.0);
            ItemEntity itemEntity = new ItemEntity(this.level, dropPosition.x, dropPosition.y, dropPosition.z, barkDrop);
            itemEntity.setDeltaMovement((this.level.random.nextDouble() - 0.5) * 0.1, this.level.random.nextDouble() * 0.1 + 0.05, (this.level.random.nextDouble() - 0.5) * 0.1);
            this.level.addFreshEntity((Entity)itemEntity);
        }
    }

    private void processSingleBlock(BlockPos pos, BlockState state) {
        Block processedBlock = this.getProcessedBlock(state.getBlock());
        if (processedBlock != state.getBlock()) {
            BlockState newState = processedBlock.defaultBlockState();
            for (Property property : state.getProperties()) {
                if (!newState.hasProperty(property)) continue;
                newState = MechanicalPeelerBlockEntity.copyPropertyUnchecked(state, newState, property);
            }
            this.level.setBlock(pos, newState, 3);
            this.level.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.tryDropBarkForLog(pos, state);
        }
    }

    private void processWholeTree(BlockPos startPos, BlockState startState) {
        List<BlockPos> logs = this.findTreeLogs(startPos, startState);
        if (logs.isEmpty()) {
            this.processSingleBlock(startPos, startState);
            return;
        }
        int processedCount = 0;
        for (BlockPos logPos : logs) {
            String logPath;
            BlockState logState = this.level.getBlockState(logPos);
            Block logBlock = logState.getBlock();
            ResourceLocation logId = BuiltInRegistries.BLOCK.getKey((Object)logBlock);
            if (logId == null || !(logPath = logId.getPath()).contains("log") || logPath.contains("stripped")) continue;
            String strippedPath = "stripped_" + logPath;
            ResourceLocation strippedId = ResourceLocation.fromNamespaceAndPath((String)logId.getNamespace(), (String)strippedPath);
            if (!BuiltInRegistries.BLOCK.containsKey(strippedId)) continue;
            Block strippedBlock = (Block)BuiltInRegistries.BLOCK.get(strippedId);
            BlockState newState = strippedBlock.defaultBlockState();
            for (Property property : logState.getProperties()) {
                if (!newState.hasProperty(property)) continue;
                newState = MechanicalPeelerBlockEntity.copyPropertyUnchecked(logState, newState, property);
            }
            this.level.setBlock(logPos, newState, 3);
            this.tryDropBarkForLog(logPos, logState);
            if (++processedCount % 3 != 1) continue;
            this.level.playSound(null, logPos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 0.8f, 1.0f);
        }
        if (processedCount > 0) {
            this.level.playSound(null, startPos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static <T extends Comparable<T>> BlockState copyPropertyUnchecked(BlockState from, BlockState to, Property<T> property) {
        return (BlockState)to.setValue(property, from.getValue(property));
    }

    private void dropByproducts(BlockPos pos, BlockState originalState, Block processedBlock) {
    }

    private void spawnBlockProcessingParticles(BlockState state) {
        if (this.targetBlockPos == null || this.level == null || !this.level.isClientSide) {
            return;
        }
        RandomSource random = this.level.random;
        Vec3 center = Vec3.atCenterOf((Vec3i)this.targetBlockPos);
        if (state.getBlock() == Blocks.AMETHYST_CLUSTER) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 2; ++i) {
                offsetX = (random.nextDouble() - 0.5) * 0.8;
                offsetY = (random.nextDouble() - 0.5) * 0.8;
                offsetZ = (random.nextDouble() - 0.5) * 0.8;
                this.level.addParticle((ParticleOptions)ParticleTypes.END_ROD, center.x + offsetX, center.y + offsetY, center.z + offsetZ, (random.nextDouble() - 0.5) * 0.1, random.nextDouble() * 0.1 + 0.02, (random.nextDouble() - 0.5) * 0.1);
            }
            for (i = 0; i < 1; ++i) {
                offsetX = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)this.level, this.targetBlockPos).bounds().getXsize();
                offsetY = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)this.level, this.targetBlockPos).bounds().getYsize();
                offsetZ = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)this.level, this.targetBlockPos).bounds().getZsize();
                this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), center.x + offsetX, center.y + offsetY, center.z + offsetZ, (random.nextDouble() - 0.5) * 0.2, random.nextDouble() * 0.1 + 0.05, (random.nextDouble() - 0.5) * 0.2);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                double offsetX = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)this.level, this.targetBlockPos).bounds().getXsize();
                double offsetY = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)this.level, this.targetBlockPos).bounds().getYsize();
                double offsetZ = (random.nextDouble() - 0.5) * state.getShape((BlockGetter)this.level, this.targetBlockPos).bounds().getZsize();
                this.level.addParticle((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), center.x + offsetX, center.y + offsetY, center.z + offsetZ, (random.nextDouble() - 0.5) * 0.2, random.nextDouble() * 0.1 + 0.05, (random.nextDouble() - 0.5) * 0.2);
            }
        }
    }

    public void setLevel(Level level) {
        super.setLevel(level);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        int i;
        boolean superAddedInformation = super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        boolean hasAnySecondaryOutput = false;
        for (i = 1; i < this.outputInventory.getSlots(); ++i) {
            if (this.outputInventory.getStackInSlot(i).isEmpty()) continue;
            hasAnySecondaryOutput = true;
            break;
        }
        if (hasAnySecondaryOutput) {
            if (superAddedInformation) {
                tooltip.add((Component)Component.literal((String)" "));
            }
            CreateLang.translate((String)"gui.goggles.peeler_stored_outputs", (Object[])new Object[0]).forGoggles(tooltip);
            for (i = 1; i < this.outputInventory.getSlots(); ++i) {
                ItemStack stack = this.outputInventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                tooltip.add((Component)CreateLang.text((String)"  ").add(Component.translatable((String)stack.getDescriptionId()).withStyle(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stack.getCount())).style(ChatFormatting.GREEN)).component());
            }
        } else {
            if (superAddedInformation) {
                tooltip.add((Component)Component.literal((String)" "));
            }
            CreateLang.translate((String)"gui.goggles.peeler_stored_outputs", (Object[])new Object[0]).forGoggles(tooltip);
            tooltip.add((Component)CreateLang.text((String)"  ").add(CreateLang.translate((String)"gui.goggles.inventory.empty", (Object[])new Object[0])).component());
        }
        return true;
    }

    public void invalidate() {
        super.invalidate();
    }

    public void destroy() {
        super.destroy();
        if (this.level != null && !this.level.isClientSide) {
            ItemHelper.dropContents((Level)this.level, (BlockPos)this.worldPosition, (IItemHandler)this.inputInventory);
            for (int i = 0; i < this.outputInventory.getSlots(); ++i) {
                Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)this.outputInventory.getStackInSlot(i));
            }
        }
    }

    private static class CustomProcessingInventory
    extends ProcessingInventory {
        private final MechanicalPeelerBlockEntity blockEntity;

        public CustomProcessingInventory(MechanicalPeelerBlockEntity be, NonNullConsumer<ItemStack> startProcessing) {
            super(startProcessing);
            this.blockEntity = be;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            super.setStackInSlot(slot, stack);
            if (this.blockEntity != null && this.blockEntity.hasLevel() && !this.blockEntity.getLevel().isClientSide()) {
                this.blockEntity.setChanged();
                this.blockEntity.sendData();
            }
        }

        public CompoundTag serializeNBT(HolderLookup.Provider registries) {
            CompoundTag tag = super.serializeNBT(registries);
            return tag;
        }

        public void deserializeNBT(HolderLookup.Provider registries, CompoundTag nbt) {
            super.deserializeNBT(registries, nbt);
        }
    }

    private static class PeelerItemHandler
    implements IItemHandler {
        private final MechanicalPeelerBlockEntity be;
        private final ProcessingInventory inputInv;
        private final ItemStackHandler outputInv;

        public PeelerItemHandler(MechanicalPeelerBlockEntity be, ProcessingInventory inputInventory, ItemStackHandler outputInventory) {
            this.be = be;
            this.inputInv = inputInventory;
            this.outputInv = outputInventory;
        }

        public int getSlots() {
            return 5;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot == 0) {
                return this.inputInv.getStackInSlot(0);
            }
            if (slot >= 1 && slot <= 4) {
                return this.outputInv.getStackInSlot(slot);
            }
            return ItemStack.EMPTY;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot == 0) {
                if (!this.be.canAcceptInput() || this.be.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING) != Direction.UP) {
                    return stack;
                }
                ItemStack remainder = this.inputInv.insertItem(0, stack, simulate);
                if (!simulate && remainder.getCount() < stack.getCount() && this.be.inputInventory.remainingTime == -1.0f) {
                    this.be.startProcessingRecipe(this.inputInv.getStackInSlot(0));
                }
                return remainder;
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot >= 1 && slot <= 4) {
                return this.outputInv.extractItem(slot, amount, simulate);
            }
            return ItemStack.EMPTY;
        }

        public int getSlotLimit(int slot) {
            if (slot == 0) {
                return this.inputInv.getSlotLimit(0);
            }
            if (slot >= 1 && slot <= 4) {
                return this.outputInv.getSlotLimit(slot);
            }
            return 0;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            if (slot == 0) {
                return this.be.getBlockState().getValue((Property)MechanicalPeelerBlock.FACING) == Direction.UP && this.be.canAcceptInput() && (this.be.getMatchingRecipe(new SingleRecipeInput(stack)).isPresent() || this.be.getMatchingRecipe(new SingleRecipeInput(stack)).isEmpty());
            }
            return false;
        }
    }
}

