/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.FrameTrap;

import com.adonis.createfisheryindustry.block.FrameTrap.FrameTrapContext;
import com.adonis.createfisheryindustry.block.FrameTrap.FrameTrapFakePlayer;
import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.registry.CreateFisheryItems;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;

public class FrameTrapMovementBehaviour
implements MovementBehaviour {
    private static final double MAX_COLLISION_BOX_SIZE = 0.8;
    private static final float WORN_HARPOON_CHANCE = 0.03f;

    public void tick(MovementContext context) {
        Level level = context.world;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            FrameTrapContext fishing = this.getFishingNetContext(context, level2);
            if (fishing.timeUntilCatch > 0) {
                --fishing.timeUntilCatch;
            }
        }
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        Level level = context.world;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            FrameTrapContext fishing = this.getFishingNetContext(context, level2);
            boolean inValidFluid = fishing.visitNewPosition(level2, pos);
            this.killNearbyEntities(context, pos, level2);
            this.collectNearbyItems(context, pos, level2);
            if (!inValidFluid || fishing.timeUntilCatch > 0) {
                return;
            }
            if (!CreateFisheryCommonConfig.isFishingEnabled()) {
                return;
            }
            if (fishing.canCatch(level2, pos)) {
                FrameTrapFakePlayer fakePlayer;
                FishingHook fishingHook;
                ItemFishedEvent event;
                LootTable lootTable = fishing.getLootTable(level2, pos);
                LootParams params = fishing.buildLootContext(context, level2, pos);
                ObjectArrayList loots = lootTable.getRandomItems(params);
                if (fishing.getFishingHook().getRandom().nextFloat() < 0.03f) {
                    ItemStack wornHarpoon = new ItemStack((ItemLike)CreateFisheryItems.WORN_HARPOON.get());
                    loots.add(wornHarpoon);
                }
                if (!(event = (ItemFishedEvent)NeoForge.EVENT_BUS.post((Event)new ItemFishedEvent((List)loots, 0, fishingHook = new FishingHook((Player)(fakePlayer = new FrameTrapFakePlayer(level2)), (Level)level2, 0, 0)))).isCanceled()) {
                    loots.forEach(stack -> this.dropItem(context, (ItemStack)stack));
                    boolean inLava = level2.getFluidState(pos).is(FluidTags.LAVA);
                    this.addExperienceNugget(context, level2, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5);
                    this.spawnFishingParticles(level2, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, inLava);
                }
                fishing.reset(level2, pos);
            }
        }
    }

    public void stopMoving(MovementContext context) {
        Object object = context.temporaryData;
        if (object instanceof FrameTrapContext) {
            FrameTrapContext fishing = (FrameTrapContext)object;
            object = context.world;
            if (object instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)object;
                fishing.invalidate(level);
            }
        }
    }

    protected FrameTrapContext getFishingNetContext(MovementContext context, ServerLevel level) {
        if (context.temporaryData == null || !(context.temporaryData instanceof FrameTrapContext)) {
            context.temporaryData = new FrameTrapContext(level, new ItemStack((ItemLike)Items.FISHING_ROD));
        }
        return (FrameTrapContext)context.temporaryData;
    }

    protected void collectNearbyItems(MovementContext context, BlockPos pos, ServerLevel level) {
        AABB boundingBox = new AABB(pos).inflate(0.2);
        List items = level.getEntitiesOfClass(ItemEntity.class, boundingBox);
        for (ItemEntity itemEntity : items) {
            ItemStack stack = itemEntity.getItem();
            if (stack.isEmpty()) continue;
            this.dropItem(context, stack.copy());
            itemEntity.discard();
        }
    }

    protected void killNearbyEntities(MovementContext context, BlockPos pos, ServerLevel level) {
        AABB boundingBox = new AABB(pos).inflate(0.5);
        List entities = level.getEntitiesOfClass(Entity.class, boundingBox);
        CreateFisheryCommonConfig.refreshCache();
        for (Entity entity : entities) {
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            EntityType entityType = entity.getType();
            ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entityType);
            if (CreateFisheryCommonConfig.isEntityBlacklisted(entityId)) continue;
            if (CreateFisheryCommonConfig.isEntityWhitelisted(entityId)) {
                this.processEntityDrops(context, level, mob);
                continue;
            }
            AABB collisionBox = entity.getBoundingBox();
            double width = collisionBox.getXsize();
            double height = collisionBox.getYsize();
            double depth = collisionBox.getZsize();
            if (!(width <= 0.8) || !(height <= 0.8) || !(depth <= 0.8)) continue;
            this.processEntityDrops(context, level, mob);
        }
    }

    private void processEntityDrops(MovementContext context, ServerLevel level, Mob mob) {
        Player nearestPlayer;
        ResourceKey lootTableKey = mob.getLootTable();
        if (lootTableKey == null) {
            return;
        }
        LootParams.Builder paramsBuilder = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)mob).withParameter(LootContextParams.ORIGIN, (Object)mob.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().generic());
        List players = level.getServer().getPlayerList().getPlayers();
        if (!players.isEmpty() && (nearestPlayer = level.getNearestPlayer((Entity)mob, -1.0)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)nearestPlayer;
            paramsBuilder.withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)serverPlayer);
        }
        LootParams params = paramsBuilder.create(LootContextParamSets.ENTITY);
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(lootTableKey);
        ObjectArrayList loots = lootTable.getRandomItems(params);
        for (ItemStack stack : loots) {
            this.dropItem(context, stack);
        }
        mob.setRemoved(Entity.RemovalReason.KILLED);
        boolean inLava = level.getFluidState(new BlockPos((int)mob.getX(), (int)mob.getY(), (int)mob.getZ())).is(FluidTags.LAVA);
        this.addExperienceNugget(context, level, mob.getX(), mob.getY() + 0.5, mob.getZ());
        this.spawnEntityCaptureParticles(level, mob.getX(), mob.getY() + 0.5, mob.getZ(), inLava);
    }

    private void addExperienceNugget(MovementContext context, ServerLevel level, double x, double y, double z) {
        Item expNuggetItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"create", (String)"experience_nugget"));
        if (expNuggetItem != null && expNuggetItem != BuiltInRegistries.ITEM.get(ResourceLocation.withDefaultNamespace((String)"air"))) {
            ItemStack expNugget = new ItemStack((ItemLike)expNuggetItem, 1);
            this.dropItem(context, expNugget);
        } else {
            level.addFreshEntity((Entity)new ExperienceOrb((Level)level, x, y, z, 1));
        }
    }

    private void spawnFishingParticles(ServerLevel level, double x, double y, double z, boolean inLava) {
        if (inLava) {
            level.sendParticles((ParticleOptions)ParticleTypes.LAVA, x, y, z, 10, 0.3, 0.3, 0.3, 0.1);
            level.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 5, 0.2, 0.2, 0.2, 0.05);
            level.playSound(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.LAVA_POP, SoundSource.BLOCKS, 1.0f, 1.2f);
        } else {
            level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, x, y, z, 15, 0.5, 0.5, 0.5, 0.1);
            level.playSound(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.BUCKET_FILL_FISH, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private void spawnEntityCaptureParticles(ServerLevel level, double x, double y, double z, boolean inLava) {
        if (inLava) {
            level.sendParticles((ParticleOptions)ParticleTypes.LAVA, x, y, z, 8, 0.4, 0.4, 0.4, 0.1);
            level.sendParticles((ParticleOptions)ParticleTypes.SMOKE, x, y, z, 5, 0.3, 0.3, 0.3, 0.05);
        } else {
            level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 15, 0.5, 0.5, 0.5, 0.1);
        }
        level.playSound(null, new BlockPos((int)x, (int)y, (int)z), SoundEvents.BUCKET_FILL_FISH, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    protected boolean isEntityWhitelisted(EntityType<?> type) {
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey(type);
        return CreateFisheryCommonConfig.isEntityWhitelisted(id);
    }

    protected boolean isEntityBlacklisted(EntityType<?> type) {
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey(type);
        return CreateFisheryCommonConfig.isEntityBlacklisted(id);
    }
}

