/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.FrameTrap;

import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class FrameTrapContext {
    protected final ItemStack fishingRod;
    protected final FishingHook fishingHook;
    protected final Set<BlockPos> visitedBlocks = new HashSet<BlockPos>();
    protected final int baseMinCatchTime = 800;
    protected final int baseMaxCatchTime = 1400;
    public int timeUntilCatch;

    public FrameTrapContext(ServerLevel level, ItemStack fishingRod) {
        this.fishingRod = fishingRod;
        this.fishingHook = new FishingHook(EntityType.FISHING_BOBBER, (Level)level);
        this.reset(level);
    }

    public void reset(ServerLevel level) {
        this.visitedBlocks.clear();
        double cooldownMultiplier = CreateFisheryCommonConfig.getFishingCooldownMultiplier();
        int adjustedMinTime = (int)(800.0 * cooldownMultiplier);
        int adjustedMaxTime = (int)(1400.0 * cooldownMultiplier);
        this.timeUntilCatch = Mth.nextInt((RandomSource)this.fishingHook.getRandom(), (int)adjustedMinTime, (int)adjustedMaxTime);
    }

    public void reset(ServerLevel level, BlockPos currentPos) {
        this.visitedBlocks.clear();
        boolean isLavaEnvironment = this.isValidLavaFishingPosition(level, currentPos);
        double cooldownMultiplier = isLavaEnvironment ? CreateFisheryCommonConfig.getLavaFishingCooldownMultiplier() : CreateFisheryCommonConfig.getFishingCooldownMultiplier();
        int adjustedMinTime = (int)(800.0 * cooldownMultiplier);
        int adjustedMaxTime = (int)(1400.0 * cooldownMultiplier);
        this.timeUntilCatch = Mth.nextInt((RandomSource)this.fishingHook.getRandom(), (int)adjustedMinTime, (int)adjustedMaxTime);
    }

    public boolean visitNewPosition(ServerLevel level, BlockPos pos) {
        boolean inWater = this.fishingHook.getOpenWaterTypeForBlock(pos) == FishingHook.OpenWaterType.INSIDE_WATER;
        boolean inLava = this.isValidLavaFishingPosition(level, pos);
        if (!inWater && !inLava) {
            return false;
        }
        this.visitedBlocks.add(pos);
        return true;
    }

    protected boolean isValidLavaFishingPosition(ServerLevel level, BlockPos pos) {
        return level.getFluidState(pos).is(FluidTags.LAVA) && level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty();
    }

    public LootTable getLootTable(ServerLevel level, BlockPos pos) {
        ReloadableServerRegistries.Holder registries = level.getServer().reloadableRegistries();
        if (this.isValidLavaFishingPosition(level, pos) && CreateFisheryCommonConfig.isLavaFishingEnabled()) {
            return this.getLavaFishingLootTable(level, registries);
        }
        return registries.getLootTable(BuiltInLootTables.FISHING);
    }

    private LootTable getLavaFishingLootTable(ServerLevel level, ReloadableServerRegistries.Holder registries) {
        if (!CreateFisheryCommonConfig.useNDULootTables()) {
            return registries.getLootTable(BuiltInLootTables.FISHING);
        }
        try {
            LootTable netherTable;
            ResourceLocation nduLavaFishing = ResourceLocation.fromNamespaceAndPath((String)"netherdepthsupgrade", (String)"gameplay/lava_fishing");
            ResourceLocation nduNetherFishing = ResourceLocation.fromNamespaceAndPath((String)"netherdepthsupgrade", (String)"gameplay/nether_fishing");
            ResourceKey lavaKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)nduLavaFishing);
            ResourceKey netherKey = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)nduNetherFishing);
            if (level.dimension() == Level.NETHER && (netherTable = registries.getLootTable(netherKey)) != LootTable.EMPTY) {
                return netherTable;
            }
            LootTable lavaTable = registries.getLootTable(lavaKey);
            if (lavaTable != LootTable.EMPTY) {
                return lavaTable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return registries.getLootTable(BuiltInLootTables.FISHING);
    }

    public LootParams buildLootContext(MovementContext context, ServerLevel level, BlockPos pos) {
        this.fishingHook.setPos(context.position);
        this.fishingHook.openWater = this.isValidLavaFishingPosition(level, pos) ? this.calculateOpenLava(level, pos) : this.fishingHook.getOpenWaterTypeForArea(pos.offset(-2, 0, -2), pos.offset(2, 0, 2)) == FishingHook.OpenWaterType.INSIDE_WATER;
        return new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)context.position).withParameter(LootContextParams.TOOL, (Object)this.fishingRod).withParameter(LootContextParams.THIS_ENTITY, (Object)this.fishingHook).withLuck((float)EnchantmentHelper.getFishingLuckBonus((ServerLevel)level, (ItemStack)this.fishingRod, (Entity)context.contraption.entity)).create(LootContextParamSets.FISHING);
    }

    private boolean calculateOpenLava(ServerLevel level, BlockPos pos) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                for (int y = -1; y <= 2; ++y) {
                    BlockPos checkPos = pos.offset(x, y, z);
                    if (!(y == -1 ? !level.getFluidState(checkPos).is(FluidTags.LAVA) : !level.getFluidState(checkPos).is(FluidTags.LAVA) && !level.getBlockState(checkPos).isAir())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public boolean canCatch() {
        double successRate = CreateFisheryCommonConfig.getFishingSuccessRate();
        return (double)this.fishingHook.getRandom().nextFloat() < successRate;
    }

    public boolean canCatch(ServerLevel level, BlockPos currentPos) {
        boolean isLavaEnvironment = this.isValidLavaFishingPosition(level, currentPos);
        double successRate = isLavaEnvironment ? CreateFisheryCommonConfig.getLavaFishingSuccessRate() : CreateFisheryCommonConfig.getFishingSuccessRate();
        boolean result = (double)this.fishingHook.getRandom().nextFloat() < successRate;
        return result;
    }

    public void invalidate(ServerLevel level) {
        this.reset(level);
        this.fishingHook.discard();
    }

    public FishingHook getFishingHook() {
        return this.fishingHook;
    }

    public ItemStack getFishingRod() {
        return this.fishingRod;
    }
}

