/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.cem.content.block.fan;

import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityVisual;
import com.simibubi.create.content.kinetics.base.RotatingInstance;
import com.simibubi.create.foundation.render.AllInstanceTypes;
import dev.engine_room.flywheel.api.instance.Instance;
import dev.engine_room.flywheel.api.material.CardinalLightingMode;
import dev.engine_room.flywheel.api.material.Material;
import dev.engine_room.flywheel.api.model.Model;
import dev.engine_room.flywheel.api.visualization.VisualizationContext;
import dev.engine_room.flywheel.lib.instance.FlatLit;
import dev.engine_room.flywheel.lib.instance.InstanceTypes;
import dev.engine_room.flywheel.lib.instance.PosedInstance;
import dev.engine_room.flywheel.lib.material.Materials;
import dev.engine_room.flywheel.lib.material.SimpleMaterial;
import dev.engine_room.flywheel.lib.model.Models;
import dev.engine_room.flywheel.lib.model.baked.BakedModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.BlockModelBuilder;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import io.github.cotrin8672.cem.content.block.fan.EnchantableEncasedFanBlockEntity;
import io.github.cotrin8672.cem.util.BlockEntityExtensionKt;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.createmod.ponder.api.level.PonderLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0007H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007H\u0016J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u001b\u001a\u00020\u0018H\u0014J\u0018\u0010\u001c\u001a\u00020\u00182\u000e\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001f0\u001eH\u0016R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lio/github/cotrin8672/cem/content/block/fan/EnchantableFanVisual;", "Lcom/simibubi/create/content/kinetics/base/KineticBlockEntityVisual;", "Lio/github/cotrin8672/cem/content/block/fan/EnchantableEncasedFanBlockEntity;", "context", "Ldev/engine_room/flywheel/api/visualization/VisualizationContext;", "blockEntity", "partialTick", "", "<init>", "(Ldev/engine_room/flywheel/api/visualization/VisualizationContext;Lio/github/cotrin8672/cem/content/block/fan/EnchantableEncasedFanBlockEntity;F)V", "shaft", "Lcom/simibubi/create/content/kinetics/base/RotatingInstance;", "kotlin.jvm.PlatformType", "enchantedShaft", "fan", "blockModel", "Ldev/engine_room/flywheel/lib/instance/PosedInstance;", "direction", "Lnet/minecraft/core/Direction;", "getDirection", "()Lnet/minecraft/core/Direction;", "opposite", "getFanSpeed", "update", "", "pt", "updateLight", "_delete", "collectCrumblingInstances", "consumer", "Ljava/util/function/Consumer;", "Ldev/engine_room/flywheel/api/instance/Instance;", "createenchantablemachinery"})
@SourceDebugExtension(value={"SMAP\nEnchantableFanVisual.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnchantableFanVisual.kt\nio/github/cotrin8672/cem/content/block/fan/EnchantableFanVisual\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,119:1\n1#2:120\n*E\n"})
public final class EnchantableFanVisual
extends KineticBlockEntityVisual<EnchantableEncasedFanBlockEntity> {
    private final RotatingInstance shaft;
    private final RotatingInstance enchantedShaft;
    private final RotatingInstance fan;
    @Nullable
    private final PosedInstance blockModel;
    @NotNull
    private final Direction direction;
    private final Direction opposite;

    public EnchantableFanVisual(@NotNull VisualizationContext context, @NotNull EnchantableEncasedFanBlockEntity blockEntity, float partialTick) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)blockEntity, (String)"blockEntity");
        super(context, (KineticBlockEntity)blockEntity, partialTick);
        this.shaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.SHAFT_HALF)).createInstance();
        this.enchantedShaft = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, (Model)new BakedModelBuilder(AllPartialModels.SHAFT_HALF.get()).materialFunc(EnchantableFanVisual::enchantedShaft$lambda$0).build()).createInstance();
        this.fan = (RotatingInstance)this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial((PartialModel)AllPartialModels.ENCASED_FAN_INNER)).createInstance();
        this.blockModel = !(blockEntity.getLevel() instanceof PonderLevel) ? (PosedInstance)context.createEmbedding(this.renderOrigin()).instancerProvider().instancer(InstanceTypes.POSED, (Model)new BlockModelBuilder((BlockAndTintGetter)BlockEntityExtensionKt.getNonNullLevel((BlockEntity)blockEntity), (Iterable)SetsKt.setOf((Object)blockEntity.getBlockPos())).materialFunc(EnchantableFanVisual::blockModel$lambda$0).build()).createInstance() : null;
        Comparable comparable = this.blockState.getValue((Property)BlockStateProperties.FACING);
        Intrinsics.checkNotNullExpressionValue((Object)comparable, (String)"getValue(...)");
        this.direction = (Direction)comparable;
        this.opposite = this.direction.getOpposite();
        this.shaft.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
        this.enchantedShaft.setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
        this.fan.setup((KineticBlockEntity)blockEntity, this.getFanSpeed()).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, this.opposite).setChanged();
        PosedInstance posedInstance = this.blockModel;
        if (posedInstance != null) {
            posedInstance.setChanged();
        }
    }

    @NotNull
    public final Direction getDirection() {
        return this.direction;
    }

    private final float getFanSpeed() {
        float speed = ((EnchantableEncasedFanBlockEntity)this.blockEntity).getSpeed() * (float)5;
        return speed > 0.0f ? Mth.clamp((float)speed, (float)80.0f, (float)1280.0f) : (speed < 0.0f ? Mth.clamp((float)speed, (float)-1280.0f, (float)-80.0f) : 0.0f);
    }

    public void update(float pt) {
        block0: {
            this.shaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
            this.enchantedShaft.setup((KineticBlockEntity)this.blockEntity).setChanged();
            this.fan.setup((KineticBlockEntity)this.blockEntity, this.getFanSpeed()).setChanged();
            PosedInstance posedInstance = this.blockModel;
            if (posedInstance == null) break block0;
            posedInstance.setChanged();
        }
    }

    public void updateLight(float partialTick) {
        block0: {
            BlockPos behind = this.pos.relative(this.opposite);
            FlatLit[] flatLitArray = new FlatLit[]{this.shaft};
            this.relight(behind, flatLitArray);
            flatLitArray = new FlatLit[]{this.enchantedShaft};
            this.relight(behind, flatLitArray);
            BlockPos inFront = this.pos.relative(this.direction);
            FlatLit[] flatLitArray2 = new FlatLit[]{this.fan};
            this.relight(inFront, flatLitArray2);
            PosedInstance posedInstance = this.blockModel;
            if (posedInstance == null) break block0;
            PosedInstance it = posedInstance;
            boolean bl = false;
            FlatLit[] flatLitArray3 = new FlatLit[]{it};
            this.relight(flatLitArray3);
        }
    }

    protected void _delete() {
        block0: {
            this.shaft.delete();
            this.enchantedShaft.delete();
            this.fan.delete();
            PosedInstance posedInstance = this.blockModel;
            if (posedInstance == null) break block0;
            posedInstance.delete();
        }
    }

    public void collectCrumblingInstances(@NotNull Consumer<Instance> consumer) {
        block0: {
            Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
            consumer.accept((Instance)this.shaft);
            consumer.accept((Instance)this.enchantedShaft);
            consumer.accept((Instance)this.fan);
            PosedInstance posedInstance = this.blockModel;
            if (posedInstance == null) break block0;
            PosedInstance it = posedInstance;
            boolean bl = false;
            consumer.accept((Instance)it);
        }
    }

    private static final Material enchantedShaft$lambda$0(RenderType renderType, Boolean bl) {
        return Materials.GLINT;
    }

    private static final Material blockModel$lambda$0(RenderType renderType, Boolean bl) {
        return (Material)SimpleMaterial.builderOf((Material)Materials.GLINT).cardinalLightingMode(CardinalLightingMode.CHUNK).polygonOffset(true);
    }
}

