/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools;

import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGDataComponents;
import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.world.OilChunksSavedData;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.RegistrateItemModelProvider;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class OilScannerItem
extends Item {
    public OilScannerItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getY() < (double)((Integer)CDGConfig.MAX_OIL_SCANNER_LEVEL.get()).intValue()) {
            stack.set(CDGDataComponents.OIL_SCANNER_PROGRESS, (Object)20);
            stack.set(CDGDataComponents.OIL_SCANNER_STATE, (Object)0);
            if (level.isClientSide) {
                player.displayClientMessage(CreateDieselGenerators.lang("actionbar.oil_scanner.searching", new Object[0]), true);
            }
        } else {
            level.playLocalSound(player.getX(), player.getY(), player.getZ(), AllSoundEvents.DENY.getMainEvent(), SoundSource.PLAYERS, 1.2f, 1.0f, true);
            if (level.isClientSide) {
                player.displayClientMessage(CreateDieselGenerators.lang("actionbar.oil_scanner.too_high_up", new Object[0]), true);
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!stack.has(CDGDataComponents.OIL_SCANNER_PROGRESS)) {
            return;
        }
        if ((Integer)stack.getOrDefault(CDGDataComponents.OIL_SCANNER_STATE, (Object)1) != 0) {
            return;
        }
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if ((Integer)stack.get(CDGDataComponents.OIL_SCANNER_PROGRESS) == 0) {
                stack.set(CDGDataComponents.OIL_SCANNER_PROGRESS, (Object)20);
                ChunkPos chunk = new ChunkPos(new BlockPos(entity.getBlockX(), 0, entity.getBlockZ()));
                int amount = OilChunksSavedData.getChunkOilAmount(sl, chunk);
                if (amount <= 0) {
                    stack.set(CDGDataComponents.OIL_SCANNER_STATE, (Object)1);
                } else if (amount >= ((Integer)CDGConfig.OIL_CHUNK_THRESHOLD.get() + (Integer)CDGConfig.OIL_CHUNK_INFINITE_THRESHOLD.get()) / 2) {
                    stack.set(CDGDataComponents.OIL_SCANNER_STATE, (Object)3);
                } else {
                    stack.set(CDGDataComponents.OIL_SCANNER_STATE, (Object)2);
                }
                if (entity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)entity;
                    if (amount <= 0) {
                        sp.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"createdieselgenerators.actionbar.oil_scanner.oil_none", (Object[])new Object[]{TooltipHelper.makeProgressBar((int)3, (int)0)}).withStyle(ChatFormatting.GRAY)));
                    } else if (amount == Integer.MAX_VALUE) {
                        sp.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"createdieselgenerators.actionbar.oil_scanner.oil_bottomless", (Object[])new Object[]{TooltipHelper.makeProgressBar((int)3, (int)3)}).withStyle(ChatFormatting.GOLD)));
                    } else if (amount >= ((Integer)CDGConfig.OIL_CHUNK_THRESHOLD.get() + (Integer)CDGConfig.OIL_CHUNK_INFINITE_THRESHOLD.get()) / 2) {
                        sp.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"createdieselgenerators.actionbar.oil_scanner.oil_high", (Object[])new Object[]{TooltipHelper.makeProgressBar((int)3, (int)2)}).withStyle(ChatFormatting.YELLOW)));
                    } else {
                        sp.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"createdieselgenerators.actionbar.oil_scanner.oil_low", (Object[])new Object[]{TooltipHelper.makeProgressBar((int)3, (int)1)}).withStyle(ChatFormatting.GREEN)));
                    }
                }
            }
            stack.set(CDGDataComponents.OIL_SCANNER_PROGRESS, (Object)((Integer)stack.getOrDefault(CDGDataComponents.OIL_SCANNER_PROGRESS, (Object)20) - 1));
        } else {
            level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), AllSoundEvents.SCROLL_VALUE.getMainEvent(), SoundSource.PLAYERS, 0.2f, 1.0f, true);
        }
        super.inventoryTick(stack, level, entity, slot, selected);
    }

    public void registerModelOverrides() {
        CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> ItemProperties.register((Item)((Item)CDGItems.OIL_SCANNER.get()), (ResourceLocation)CreateDieselGenerators.rl("oil_scanner_state"), (stack, level, entity, seed) -> ((Integer)stack.getOrDefault(CDGDataComponents.OIL_SCANNER_STATE, (Object)0)).intValue()));
    }

    public static ItemModelBuilder addOverrideModels(DataGenContext<Item, OilScannerItem> c, RegistrateItemModelProvider p) {
        ItemModelBuilder builder = p.generated(() -> c.getEntry(), new ResourceLocation[]{p.modLoc("item/oil_scanner_rotating")});
        builder.override().predicate(CreateDieselGenerators.rl("oil_scanner_state"), 0.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", CreateDieselGenerators.rl("item/oil_scanner_rotating"))).end();
        builder.override().predicate(CreateDieselGenerators.rl("oil_scanner_state"), 1.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName() + "_none")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", CreateDieselGenerators.rl("item/oil_scanner_none"))).end();
        builder.override().predicate(CreateDieselGenerators.rl("oil_scanner_state"), 2.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName() + "_medium")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", CreateDieselGenerators.rl("item/oil_scanner_medium"))).end();
        builder.override().predicate(CreateDieselGenerators.rl("oil_scanner_state"), 3.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)p.getBuilder(c.getName() + "_high")).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", CreateDieselGenerators.rl("item/oil_scanner_high"))).end();
        return builder;
    }
}

