/*
 * Decompiled with CFR 0.152.
 */
package com.cak.pattern_schematics;

import com.cak.pattern_schematics.PatternSchematics;
import com.cak.pattern_schematics.PatternSchematicsClient;
import com.cak.pattern_schematics.PatternSchematicsClientEvents;
import net.minecraft.client.gui.LayeredDraw;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterGuiLayersEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.VanillaGuiLayers;

@EventBusSubscriber(value={Dist.CLIENT})
public class PatternSchematicsForgeClientEvents {
    @SubscribeEvent
    public static void onTick(ClientTickEvent.Pre event) {
        PatternSchematicsClientEvents.onTick();
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        PatternSchematicsClientEvents.renderPatternSchematic(event.getPoseStack());
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        boolean pressed = event.getAction() != 0;
        PatternSchematicsClientEvents.onKeyInput(event.getKey(), pressed);
    }

    @SubscribeEvent
    public static void onMouseScrolled(InputEvent.MouseScrollingEvent event) {
        if (PatternSchematicsClientEvents.onMouseScrolled(event.getScrollDeltaY())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseButton.Pre event) {
        boolean pressed;
        int button = event.getButton();
        boolean bl = pressed = event.getAction() != 0;
        if (PatternSchematicsClientEvents.onMouseInput(button, pressed)) {
            event.setCanceled(true);
        }
    }

    @EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
    public static class ModBusEvents {
        @SubscribeEvent
        public static void registerGuiOverlays(RegisterGuiLayersEvent event) {
            event.registerAbove(VanillaGuiLayers.HOTBAR, PatternSchematics.asResource("pattern_schematic"), (LayeredDraw.Layer)PatternSchematicsClient.PATTERN_SCHEMATIC_HANDLER);
        }

        @SubscribeEvent
        public static void setupClient(FMLClientSetupEvent event) {
        }
    }
}

