/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

import com.github.underscore.Json;
import com.github.underscore.U;
import com.github.underscore.Xml;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class XmlBuilder {
    private static final String SELF_CLOSING = "-self-closing";
    private static final String TRUE = "true";
    private final Map<String, Object> data = new LinkedHashMap<String, Object>();
    private String path;
    private String savedPath;

    XmlBuilder(String rootName) {
        LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
        value.put(SELF_CLOSING, TRUE);
        this.data.put(rootName, value);
        this.path = rootName;
    }

    public static XmlBuilder create(String rootName) {
        return new XmlBuilder(rootName);
    }

    public static XmlBuilder parse(String xml) {
        Map<String, Object> xmlData = U.fromXmlMap(xml);
        XmlBuilder xmlBuilder = new XmlBuilder(Xml.XmlValue.getMapKey(xmlData));
        xmlBuilder.setData(xmlData);
        return xmlBuilder;
    }

    public XmlBuilder e(String elementName) {
        U.remove(this.data, this.path + ".-self-closing");
        LinkedHashMap<String, String> value = new LinkedHashMap<String, String>();
        value.put(SELF_CLOSING, TRUE);
        Object object = U.get(this.data, this.path + "." + elementName);
        if (object instanceof Map) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(object);
            list.add(value);
            U.set(this.data, this.path + "." + elementName, list);
            this.path = this.path + "." + elementName + ".1";
            this.savedPath = this.path;
        } else if (object instanceof List) {
            this.path = this.path + "." + elementName + "." + ((List)object).size();
            this.savedPath = this.path;
            ((List)object).add(value);
        } else {
            U.set(this.data, this.path + "." + elementName, value);
            this.path = this.path + "." + elementName;
        }
        return this;
    }

    public XmlBuilder a(String attributeName, String value) {
        U.remove(this.data, this.path + ".-self-closing");
        U.set(this.data, this.path + ".-" + attributeName, (Object)value);
        return this;
    }

    public XmlBuilder c(String comment) {
        U.remove(this.data, this.path + ".-self-closing");
        U.update(this.data, this.path + ".#comment", (Object)comment);
        return this;
    }

    public XmlBuilder i(String target, String value) {
        U.remove(this.data, this.path + ".-self-closing");
        U.set(this.data, "?" + target, (Object)value);
        return this;
    }

    public XmlBuilder d(String cdata) {
        U.remove(this.data, this.path + ".-self-closing");
        U.update(this.data, this.path + ".#cdata-section", (Object)cdata);
        return this;
    }

    public XmlBuilder t(String text) {
        U.remove(this.data, this.path + ".-self-closing");
        U.update(this.data, this.path + ".#text", (Object)text);
        return this;
    }

    public XmlBuilder importXmlBuilder(XmlBuilder xmlBuilder) {
        this.data.putAll(xmlBuilder.data);
        return this;
    }

    public XmlBuilder up() {
        if (this.path.equals(this.savedPath)) {
            this.path = this.path.substring(0, this.path.lastIndexOf("."));
        }
        this.path = this.path.substring(0, this.path.lastIndexOf("."));
        return this;
    }

    public XmlBuilder root() {
        int index = this.path.indexOf(".");
        XmlBuilder xmlBuilder = new XmlBuilder(index == -1 ? this.path : this.path.substring(0, index));
        xmlBuilder.setData(this.data);
        return xmlBuilder;
    }

    public Document getDocument() {
        try {
            return Xml.Document.createDocument(this.asString());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public XmlBuilder set(String path, Object value) {
        U.set(this.data, path, value);
        return this;
    }

    public XmlBuilder remove(String key) {
        U.remove(this.data, key);
        return this;
    }

    public Map<String, Object> build() {
        return U.deepCopyMap(this.data);
    }

    public XmlBuilder clear() {
        this.data.clear();
        return this;
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public int size() {
        return this.data.size();
    }

    public String asString() {
        return U.toXml(this.data);
    }

    public String toXml(Xml.XmlStringBuilder.Step identStep) {
        return Xml.toXml(this.data, identStep);
    }

    public String toXml() {
        return U.toXml(this.data);
    }

    public String toJson(Json.JsonStringBuilder.Step identStep) {
        return Json.toJson(this.data, identStep);
    }

    public String toJson() {
        return U.toJson(this.data);
    }

    private void setData(Map<String, Object> newData) {
        this.data.clear();
        this.data.putAll(newData);
    }
}

