/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

import com.github.underscore.Base32;
import java.io.IOException;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class Xml {
    private static final String NULL = "null";
    private static final String ELEMENT_TEXT = "element";
    private static final String CDATA = "#cdata-section";
    private static final String COMMENT = "#comment";
    private static final String ENCODING = "#encoding";
    private static final String STANDALONE = "#standalone";
    private static final String OMITXMLDECLARATION = "#omit-xml-declaration";
    private static final String YES = "yes";
    private static final String TEXT = "#text";
    private static final String NUMBER = "-number";
    private static final String ELEMENT = "<element>";
    private static final String CLOSED_ELEMENT = "</element>";
    private static final String EMPTY_ELEMENT = "<element></element>";
    private static final String NULL_TRUE = " null=\"true\"/>";
    private static final String NUMBER_TEXT = " number=\"true\"";
    private static final String NUMBER_TRUE = " number=\"true\">";
    private static final String ARRAY = "-array";
    private static final String ARRAY_TRUE = " array=\"true\"";
    private static final String NULL_ELEMENT = "<element null=\"true\"/>";
    private static final String BOOLEAN = "-boolean";
    private static final String TRUE = "true";
    private static final String SELF_CLOSING = "-self-closing";
    private static final String STRING = "-string";
    private static final String NULL_ATTR = "-null";
    private static final String EMPTY_ARRAY = "-empty-array";
    private static final String QUOT = "&quot;";
    private static final String XML_HEADER = "<?xml ";
    private static final String DOCTYPE_TEXT = "!DOCTYPE";
    private static final String ROOT = "root";
    private static final String DOCTYPE_HEADER = "<!DOCTYPE ";
    private static final Set<Character> SKIPPED_CHARS = Set.of(Character.valueOf(' '), Character.valueOf('\n'), Character.valueOf('\r'));
    private static final Map<String, String> XML_UNESCAPE = new HashMap<String, String>();
    private static final org.w3c.dom.Document DOCUMENT = Document.createDocument();

    private Xml() {
    }

    public static String toXml(Collection collection, XmlStringBuilder.Step identStep) {
        XmlStringBuilderWithoutRoot builder = new XmlStringBuilderWithoutRoot(identStep, StandardCharsets.UTF_8.name(), "");
        Xml.writeArray(collection, builder, ARRAY_TRUE);
        return ((XmlStringBuilder)builder).toString();
    }

    public static String toXmlWithoutRoot(Collection collection, XmlStringBuilder.Step identStep) {
        XmlStringBuilderWithoutHeader builder = new XmlStringBuilderWithoutHeader(identStep, 0);
        Xml.writeArray(collection, builder, ARRAY_TRUE);
        return ((XmlStringBuilder)builder).toString();
    }

    public static String toXml(Collection collection) {
        return Xml.toXml(collection, XmlStringBuilder.Step.TWO_SPACES);
    }

    public static String toXml(Map map, XmlStringBuilder.Step identStep) {
        return Xml.toXml(map, identStep, ROOT, ArrayTrue.ADD);
    }

    public static String toXml(Map map, XmlStringBuilder.Step identStep, String newRootName) {
        return Xml.toXml(map, identStep, newRootName, ArrayTrue.ADD);
    }

    public static String toXml(Map map, XmlStringBuilder.Step identStep, String newRootName, ArrayTrue arrayTrue) {
        XmlStringBuilder builder;
        Map localMap;
        if (map != null && map.containsKey(ENCODING)) {
            localMap = (Map)((LinkedHashMap)map).clone();
            builder = Xml.checkStandalone(String.valueOf(localMap.remove(ENCODING)), identStep, localMap);
        } else if (map != null && map.containsKey(STANDALONE)) {
            localMap = (Map)((LinkedHashMap)map).clone();
            builder = new XmlStringBuilderWithoutRoot(identStep, StandardCharsets.UTF_8.name(), " standalone=\"" + (YES.equals(map.get(STANDALONE)) ? YES : "no") + "\"");
            localMap.remove(STANDALONE);
        } else if (map != null && map.containsKey(OMITXMLDECLARATION)) {
            localMap = (Map)((LinkedHashMap)map).clone();
            builder = new XmlStringBuilderWithoutHeader(identStep, 0);
            localMap.remove(OMITXMLDECLARATION);
        } else {
            builder = new XmlStringBuilderWithoutRoot(identStep, StandardCharsets.UTF_8.name(), "");
            localMap = map;
        }
        Xml.checkLocalMap(builder, localMap, newRootName, arrayTrue == ArrayTrue.ADD ? ARRAY_TRUE : "");
        return builder.toString();
    }

    private static void checkLocalMap(XmlStringBuilder builder, Map localMap, String newRootName, String arrayTrue) {
        Map localMap2;
        if (localMap != null && localMap.containsKey(DOCTYPE_TEXT)) {
            localMap2 = (Map)((LinkedHashMap)localMap).clone();
            localMap2.remove(DOCTYPE_TEXT);
            builder.append(DOCTYPE_HEADER).append(String.valueOf(localMap.get(DOCTYPE_TEXT))).append(">").newLine();
        } else {
            localMap2 = localMap;
        }
        if (localMap2 == null || localMap2.size() != 1 || XmlValue.getMapKey(localMap2).startsWith("-") || XmlValue.getMapValue(localMap2) instanceof List) {
            if (ROOT.equals(XmlValue.getMapKey(localMap2))) {
                Xml.writeArray((List)XmlValue.getMapValue(localMap2), builder, arrayTrue);
            } else {
                XmlObject.writeXml(localMap2, Xml.getRootName(localMap2, newRootName), builder, false, new LinkedHashSet<String>(), false, arrayTrue);
            }
        } else {
            XmlObject.writeXml(localMap2, Xml.getRootName(localMap2, newRootName), builder, false, new LinkedHashSet<String>(), false, arrayTrue);
        }
    }

    private static void writeArray(Collection collection, XmlStringBuilder builder, String arrayTrue) {
        builder.append("<root");
        if (collection != null && collection.isEmpty()) {
            builder.append(" empty-array=\"true\"");
        }
        builder.append(">").incIdent();
        if (collection != null && !collection.isEmpty()) {
            builder.newLine();
        }
        XmlArray.writeXml(collection, null, builder, false, new LinkedHashSet<String>(), false, arrayTrue);
        if (collection != null && !collection.isEmpty()) {
            builder.newLine();
        }
        builder.append("</root>");
    }

    private static XmlStringBuilder checkStandalone(String encoding, XmlStringBuilder.Step identStep, Map localMap) {
        XmlStringBuilderWithoutRoot builder;
        if (localMap.containsKey(STANDALONE)) {
            builder = new XmlStringBuilderWithoutRoot(identStep, encoding, " standalone=\"" + (YES.equals(localMap.get(STANDALONE)) ? YES : "no") + "\"");
            localMap.remove(STANDALONE);
        } else {
            builder = new XmlStringBuilderWithoutRoot(identStep, encoding, "");
        }
        return builder;
    }

    private static String getRootName(Map localMap, String newRootName) {
        int foundAttrs = 0;
        int foundElements = 0;
        int foundListElements = 0;
        if (localMap != null) {
            for (Map.Entry entry : localMap.entrySet()) {
                if (String.valueOf(entry.getKey()).startsWith("-")) {
                    ++foundAttrs;
                    continue;
                }
                if (String.valueOf(entry.getKey()).startsWith(COMMENT) || String.valueOf(entry.getKey()).startsWith(CDATA) || String.valueOf(entry.getKey()).startsWith("?")) continue;
                if (entry.getValue() instanceof List && ((List)entry.getValue()).size() > 1) {
                    ++foundListElements;
                }
                ++foundElements;
            }
        }
        return foundAttrs == 0 && foundElements == 1 && foundListElements == 0 ? null : newRootName;
    }

    public static String toXml(Map map) {
        return Xml.toXml(map, XmlStringBuilder.Step.TWO_SPACES, ROOT);
    }

    private static Object getValue(String name, Object value, FromType fromType) {
        Map.Entry entry;
        Object localValue = value instanceof Map && ((Map)value).entrySet().size() == 1 ? (TEXT.equals((entry = ((Map)value).entrySet().iterator().next()).getKey()) || fromType == FromType.FOR_CONVERT && ELEMENT_TEXT.equals(entry.getKey()) ? entry.getValue() : value) : value;
        return localValue instanceof String && name.startsWith("-") ? XmlValue.unescape((String)localValue) : localValue;
    }

    public static Object stringToNumber(String number) {
        Number localValue = number.contains(".") || number.contains("e") || number.contains("E") ? (Number)(number.length() > 9 || number.contains(".") && number.length() - number.lastIndexOf(46) > 2 && number.charAt(number.length() - 1) == '0' ? new BigDecimal(number) : Double.valueOf(number)) : (Number)(number.length() > 19 ? new BigInteger(number) : Long.valueOf(number));
        return localValue;
    }

    private static Object createMap(Node node, BiFunction<Object, Set<String>, String> elementMapper, Function<Object, Object> nodeMapper, Map<String, Object> attrMap, int[] uniqueIds, String source, int[] sourceIndex, Set<String> namespaces, FromType fromType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(attrMap);
        NodeList nodeList = node.getChildNodes();
        for (int index = 0; index < nodeList.getLength(); ++index) {
            Object value;
            Node currentNode = nodeList.item(index);
            Object name = currentNode.getNodeType() == 7 ? "?" + currentNode.getNodeName() : currentNode.getNodeName();
            if (currentNode.getNodeType() == 1) {
                sourceIndex[0] = source.indexOf("<" + (String)name, sourceIndex[0]) + ((String)name).length() + 1;
                value = Xml.addElement(sourceIndex, source, elementMapper, nodeMapper, uniqueIds, currentNode, namespaces, fromType);
            } else {
                if (COMMENT.equals(name)) {
                    sourceIndex[0] = source.indexOf("-->", sourceIndex[0]) + 3;
                } else if (CDATA.equals(name)) {
                    sourceIndex[0] = source.indexOf("]]>", sourceIndex[0]) + 3;
                }
                value = currentNode.getTextContent();
            }
            if (TEXT.equals(name) && node.getChildNodes().getLength() > 1 && String.valueOf(value).trim().isEmpty()) continue;
            if (currentNode.getNodeType() == 10) {
                Xml.addNodeValue(map, DOCTYPE_TEXT, Xml.getDoctypeValue(source), elementMapper, nodeMapper, uniqueIds, namespaces, fromType);
                continue;
            }
            Xml.addNodeValue(map, (String)name, value, elementMapper, nodeMapper, uniqueIds, namespaces, fromType);
        }
        return Xml.checkNumberAndBoolean(map, node.getNodeName());
    }

    private static Object checkNumberAndBoolean(Map<String, Object> map, String name) {
        Map localMap2;
        Map localMap;
        if (map.containsKey(NUMBER) && TRUE.equals(map.get(NUMBER)) && map.containsKey(TEXT)) {
            localMap = (Map)((LinkedHashMap)map).clone();
            localMap.remove(NUMBER);
            localMap.put(TEXT, Xml.stringToNumber(String.valueOf(localMap.get(TEXT))));
        } else {
            localMap = map;
        }
        if (map.containsKey(BOOLEAN) && TRUE.equals(map.get(BOOLEAN)) && map.containsKey(TEXT)) {
            localMap2 = (Map)((LinkedHashMap)localMap).clone();
            localMap2.remove(BOOLEAN);
            localMap2.put(TEXT, Boolean.valueOf(String.valueOf(localMap.get(TEXT))));
        } else {
            localMap2 = localMap;
        }
        return Xml.checkArray(localMap2, name);
    }

    private static Object checkArray(Map<String, Object> map, String name) {
        ArrayList object2;
        Object object;
        Map<String, Object> localMap = Xml.checkNullAndString(map);
        if (map.containsKey(ARRAY) && TRUE.equals(map.get(ARRAY))) {
            Map localMap4 = (Map)((LinkedHashMap)localMap).clone();
            localMap4.remove(ARRAY);
            localMap4.remove(SELF_CLOSING);
            object = name.equals(XmlValue.getMapKey(localMap4)) ? new ArrayList<Object>(Collections.singletonList(Xml.getValue(name, XmlValue.getMapValue(localMap4), FromType.FOR_CONVERT))) : new ArrayList<Object>(Collections.singletonList(Xml.getValue(name, localMap4, FromType.FOR_CONVERT)));
        } else {
            object = localMap;
        }
        if (map.containsKey(EMPTY_ARRAY) && TRUE.equals(map.get(EMPTY_ARRAY))) {
            Map localMap4 = (Map)((LinkedHashMap)map).clone();
            localMap4.remove(EMPTY_ARRAY);
            if (localMap4.containsKey(ARRAY) && TRUE.equals(localMap4.get(ARRAY)) && localMap4.size() == 1) {
                object2 = new ArrayList();
                ((List)object2).add(new ArrayList());
            } else {
                object2 = localMap4.isEmpty() ? new ArrayList() : localMap4;
            }
        } else {
            object2 = object;
        }
        return object2;
    }

    private static Map<String, Object> checkNullAndString(Map<String, Object> map) {
        Map localMap2;
        Map localMap;
        if (map.containsKey(NULL_ATTR) && TRUE.equals(map.get(NULL_ATTR))) {
            localMap = (Map)((LinkedHashMap)map).clone();
            localMap.remove(NULL_ATTR);
            if (!map.containsKey(TEXT)) {
                localMap.put(TEXT, null);
            }
        } else {
            localMap = map;
        }
        if (map.containsKey(STRING) && TRUE.equals(map.get(STRING))) {
            localMap2 = (Map)((LinkedHashMap)localMap).clone();
            localMap2.remove(STRING);
            if (!map.containsKey(TEXT)) {
                localMap2.put(TEXT, "");
            }
        } else {
            localMap2 = localMap;
        }
        return localMap2;
    }

    private static Object addElement(int[] sourceIndex, String source, BiFunction<Object, Set<String>, String> elementMapper, Function<Object, Object> nodeMapper, int[] uniqueIds, Node currentNode, Set<String> namespaces, FromType fromType) {
        LinkedHashMap<String, Object> attrMapLocal = new LinkedHashMap<String, Object>();
        if (currentNode.getAttributes().getLength() > 0) {
            Map<String, String> attributes = Xml.parseAttributes(Xml.getAttributes(sourceIndex[0], source));
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                if (!attribute.getKey().startsWith("xmlns:")) continue;
                namespaces.add(attribute.getKey().substring(6));
            }
            for (Map.Entry<String, String> attribute : attributes.entrySet()) {
                Xml.addNodeValue(attrMapLocal, "-" + attribute.getKey(), attribute.getValue(), elementMapper, nodeMapper, uniqueIds, namespaces, fromType);
            }
        }
        if (!(!Xml.getAttributes(sourceIndex[0], source).endsWith("/") || attrMapLocal.containsKey(SELF_CLOSING) || attrMapLocal.size() == 1 && (attrMapLocal.containsKey(STRING) && TRUE.equals(attrMapLocal.get(STRING)) || attrMapLocal.containsKey(NULL_ATTR) && TRUE.equals(attrMapLocal.get(NULL_ATTR))))) {
            attrMapLocal.put(SELF_CLOSING, TRUE);
        }
        return Xml.createMap(currentNode, elementMapper, nodeMapper, attrMapLocal, uniqueIds, source, sourceIndex, namespaces, fromType);
    }

    static Map<String, String> parseAttributes(String source) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        boolean inQuotes = false;
        boolean expectingValue = false;
        for (char c : source.toCharArray()) {
            if (c == '\"') {
                boolean bl = inQuotes = !inQuotes;
                if (inQuotes || !expectingValue) continue;
                result.put(key.toString(), value.toString());
                key.setLength(0);
                value.setLength(0);
                expectingValue = false;
                continue;
            }
            if (c == '=' && !inQuotes) {
                expectingValue = true;
                continue;
            }
            if (inQuotes) {
                value.append(c);
                continue;
            }
            if (SKIPPED_CHARS.contains(Character.valueOf(c))) continue;
            key.append(c);
        }
        return result;
    }

    static String getAttributes(int sourceIndex, String source) {
        boolean scanQuote = false;
        for (int index = sourceIndex; index < source.length(); ++index) {
            if (source.charAt(index) == '\"') {
                scanQuote = !scanQuote;
                continue;
            }
            if (scanQuote || source.charAt(index) != '>') continue;
            return source.substring(sourceIndex, index);
        }
        return "";
    }

    private static String unescapeName(String name) {
        if (name == null) {
            return null;
        }
        int length = name.length();
        if ("__EE__EMPTY__EE__".equals(name)) {
            return "";
        }
        if ("-__EE__EMPTY__EE__".equals(name)) {
            return "-";
        }
        if (!name.contains("__")) {
            return name;
        }
        StringBuilder result = new StringBuilder();
        int underlineCount = 0;
        StringBuilder lastChars = new StringBuilder();
        int i = 0;
        block2: while (i < length) {
            char ch = name.charAt(i);
            if (ch == '_') {
                lastChars.append(ch);
            } else {
                if (lastChars.length() == 2) {
                    StringBuilder nameToDecode = new StringBuilder();
                    for (int j = i; j < length; ++j) {
                        if (name.charAt(j) == '_') {
                            if (++underlineCount != 2) continue;
                            try {
                                result.append(Base32.decode(nameToDecode.toString()));
                            }
                            catch (Base32.DecodingException ex) {
                                result.append("__").append((CharSequence)nameToDecode).append((CharSequence)lastChars);
                            }
                            i = j;
                            underlineCount = 0;
                            lastChars.setLength(0);
                            ++i;
                            continue block2;
                        }
                        nameToDecode.append(name.charAt(j));
                        underlineCount = 0;
                    }
                }
                result.append((CharSequence)lastChars).append(ch);
                lastChars.setLength(0);
            }
            ++i;
        }
        return result.append((CharSequence)lastChars).toString();
    }

    private static void addNodeValue(Map<String, Object> map, String name, Object value, BiFunction<Object, Set<String>, String> elementMapper, Function<Object, Object> nodeMapper, int[] uniqueIds, Set<String> namespaces, FromType fromType) {
        String elementName = Xml.unescapeName(elementMapper.apply(name, namespaces));
        if (map.containsKey(elementName)) {
            if (TEXT.equals(elementName)) {
                map.put(elementName + uniqueIds[0], nodeMapper.apply(Xml.getValue(name, value, fromType)));
                uniqueIds[0] = uniqueIds[0] + 1;
            } else if (COMMENT.equals(elementName)) {
                map.put(elementName + uniqueIds[1], nodeMapper.apply(Xml.getValue(name, value, fromType)));
                uniqueIds[1] = uniqueIds[1] + 1;
            } else if (CDATA.equals(elementName)) {
                map.put(elementName + uniqueIds[2], nodeMapper.apply(Xml.getValue(name, value, fromType)));
                uniqueIds[2] = uniqueIds[2] + 1;
            } else {
                Object object = map.get(elementName);
                if (object instanceof List) {
                    Xml.addText(map, elementName, (List)object, value, fromType);
                } else {
                    ArrayList<Object> objects = new ArrayList<Object>();
                    objects.add(object);
                    Xml.addText(map, elementName, objects, value, fromType);
                    map.put(elementName, objects);
                }
            }
        } else if (elementName != null) {
            map.put(elementName, nodeMapper.apply(Xml.getValue(name, value, fromType)));
        }
    }

    private static void addText(Map<String, Object> map, String name, List<Object> objects, Object value, FromType fromType) {
        Map.Entry lastElement;
        int lastIndex = map.size() - 1;
        int index = objects.size();
        while (!name.equals(String.valueOf((lastElement = (Map.Entry)map.entrySet().toArray()[lastIndex]).getKey()))) {
            LinkedHashMap item = new LinkedHashMap();
            LinkedHashMap<String, Object> text = new LinkedHashMap<String, Object>();
            text.put(String.valueOf(lastElement.getKey()), map.remove(lastElement.getKey()));
            item.put("#item", text);
            objects.add(index, item);
            --lastIndex;
        }
        Object newValue = Xml.getValue(name, value, fromType);
        if (newValue instanceof List) {
            objects.add(((List)newValue).get(0));
        } else {
            objects.add(newValue);
        }
    }

    public static Object fromXml(String xml) {
        return Xml.fromXml(xml, FromType.FOR_CONVERT);
    }

    public static Object fromXml(String xml, FromType fromType) {
        if (xml == null) {
            return null;
        }
        try {
            org.w3c.dom.Document document = Document.createDocument(xml);
            Object result = Xml.createMap(document, (object, namespaces) -> String.valueOf(object), object -> object, Collections.emptyMap(), new int[]{1, 1, 1}, xml, new int[]{0}, new LinkedHashSet<String>(), fromType);
            if (Xml.checkResult(xml, document, result, fromType)) {
                return ((Map)result).entrySet().iterator().next().getValue();
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static boolean checkResult(String xml, org.w3c.dom.Document document, Object result, FromType fromType) {
        Map<String, String> headerAttributes = Xml.getHeaderAttributes(xml);
        if (document.getXmlEncoding() != null && !"UTF-8".equalsIgnoreCase(document.getXmlEncoding())) {
            ((Map)result).put(ENCODING, document.getXmlEncoding());
            if (headerAttributes.containsKey(STANDALONE.substring(1))) {
                ((Map)result).put(STANDALONE, headerAttributes.get(STANDALONE.substring(1)));
            }
        } else if (headerAttributes.containsKey(STANDALONE.substring(1))) {
            ((Map)result).put(STANDALONE, headerAttributes.get(STANDALONE.substring(1)));
        } else if (fromType == FromType.FOR_CONVERT && XmlValue.getMapKey(result).equals(ROOT) && (XmlValue.getMapValue(result) instanceof List || XmlValue.getMapValue(result) instanceof Map)) {
            if (xml.startsWith(XML_HEADER)) {
                return true;
            }
            ((Map)result).put(OMITXMLDECLARATION, YES);
        } else if (!xml.startsWith(XML_HEADER)) {
            ((Map)result).put(OMITXMLDECLARATION, YES);
        }
        return false;
    }

    private static Map<String, String> getHeaderAttributes(String xml) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (xml.startsWith(XML_HEADER)) {
            String xmlLocal = xml.substring(XML_HEADER.length(), Math.max(XML_HEADER.length(), xml.indexOf("?>", XML_HEADER.length())));
            Map<String, String> attributes = Xml.parseAttributes(xmlLocal);
            result.putAll(attributes);
        }
        return result;
    }

    static String getDoctypeValue(String xml) {
        int startIndex = xml.indexOf(DOCTYPE_HEADER) + DOCTYPE_HEADER.length();
        char charToFind = '>';
        int endIndexPlus = 0;
        for (int endIndex = startIndex; endIndex < xml.length(); ++endIndex) {
            if (xml.charAt(endIndex) == '[') {
                charToFind = ']';
                endIndexPlus = 1;
                continue;
            }
            if (xml.charAt(endIndex) != charToFind) continue;
            return xml.substring(startIndex, endIndex + endIndexPlus);
        }
        return "";
    }

    public static Object fromXmlMakeArrays(String xml) {
        try {
            org.w3c.dom.Document document = Document.createDocument(xml);
            Object result = Xml.createMap(document, (object, namespaces) -> String.valueOf(object), object -> object instanceof List ? object : new ArrayList<Object>(Collections.singletonList(object)), Collections.emptyMap(), new int[]{1, 1, 1}, xml, new int[]{0}, new LinkedHashSet<String>(), FromType.FOR_CONVERT);
            if (Xml.checkResult(xml, document, result, FromType.FOR_CONVERT)) {
                return ((Map)result).entrySet().iterator().next().getValue();
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static Object fromXmlWithElementMapper(String xml, BiFunction<Object, Set<String>, String> elementMapper) {
        try {
            org.w3c.dom.Document document = Document.createDocument(xml);
            Object result = Xml.createMap(document, elementMapper, object -> object, Collections.emptyMap(), new int[]{1, 1, 1}, xml, new int[]{0}, new LinkedHashSet<String>(), FromType.FOR_CONVERT);
            if (Xml.checkResult(xml, document, result, FromType.FOR_CONVERT)) {
                return ((Map)result).entrySet().iterator().next().getValue();
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static Object fromXmlWithoutNamespaces(String xml) {
        return Xml.fromXmlWithElementMapper(xml, (object, namespaces) -> {
            String localString = String.valueOf(object);
            String substring = localString.substring(Math.max(0, localString.indexOf(58) + 1));
            Object result = localString.startsWith("-") && namespaces.contains(localString.substring(1, Math.max(1, localString.indexOf(58)))) ? "-" + substring : (namespaces.contains(localString.substring(0, Math.max(0, localString.indexOf(58)))) ? substring : String.valueOf(object));
            return result;
        });
    }

    public static Object fromXmlWithoutAttributes(String xml) {
        return Xml.fromXmlWithElementMapper(xml, (object, namespaces) -> String.valueOf(object).startsWith("-") ? null : String.valueOf(object));
    }

    public static Object fromXmlWithoutNamespacesAndAttributes(String xml) {
        return Xml.fromXmlWithElementMapper(xml, (object, namespaces) -> {
            String localString = String.valueOf(object);
            String result = localString.startsWith("-") ? null : (namespaces.contains(localString.substring(0, Math.max(0, localString.indexOf(58)))) ? localString.substring(Math.max(0, localString.indexOf(58) + 1)) : String.valueOf(object));
            return result;
        });
    }

    public static String formatXml(String xml, XmlStringBuilder.Step identStep) {
        Object result = Xml.fromXml(xml, FromType.FOR_FORMAT);
        return Xml.toXml((Map)result, identStep, ROOT);
    }

    public static String formatXml(String xml) {
        return Xml.formatXml(xml, XmlStringBuilder.Step.TWO_SPACES);
    }

    public static String changeXmlEncoding(String xml, XmlStringBuilder.Step identStep, String encoding) {
        Object result = Xml.fromXml(xml, FromType.FOR_FORMAT);
        if (result instanceof Map) {
            ((Map)result).put(ENCODING, encoding);
            return Xml.toXml((Map)result, identStep, ROOT);
        }
        return xml;
    }

    public static String changeXmlEncoding(String xml, String encoding) {
        return Xml.changeXmlEncoding(xml, XmlStringBuilder.Step.TWO_SPACES, encoding);
    }

    static {
        XML_UNESCAPE.put(QUOT, "\"");
        XML_UNESCAPE.put("&amp;", "&");
        XML_UNESCAPE.put("&lt;", "<");
        XML_UNESCAPE.put("&gt;", ">");
        XML_UNESCAPE.put("&apos;", "'");
    }

    public static class XmlStringBuilderWithoutRoot
    extends XmlStringBuilder {
        public XmlStringBuilderWithoutRoot(XmlStringBuilder.Step identStep, String encoding, String standalone) {
            super(new StringBuilder("<?xml version=\"1.0\" encoding=\"" + XmlValue.escape(encoding).replace("\"", Xml.QUOT) + "\"" + standalone + "?>" + (identStep == XmlStringBuilder.Step.COMPACT ? "" : "\n")), identStep, 0);
        }

        @Override
        public String toString() {
            return this.builder.toString();
        }
    }

    public static class XmlStringBuilder {
        protected final StringBuilder builder;
        private final Step identStep;
        private int ident;

        public XmlStringBuilder() {
            this.builder = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<root>\n");
            this.identStep = Step.TWO_SPACES;
            this.ident = 2;
        }

        public XmlStringBuilder(StringBuilder builder, Step identStep, int ident) {
            this.builder = builder;
            this.identStep = identStep;
            this.ident = ident;
        }

        public XmlStringBuilder append(String string) {
            this.builder.append(string);
            return this;
        }

        public XmlStringBuilder fillSpaces() {
            this.builder.append(String.valueOf(this.identStep == Step.TABS ? (char)'\t' : ' ').repeat(Math.max(0, this.ident)));
            return this;
        }

        public XmlStringBuilder incIdent() {
            this.ident += this.identStep.getIdent();
            return this;
        }

        public XmlStringBuilder decIdent() {
            this.ident -= this.identStep.getIdent();
            return this;
        }

        public XmlStringBuilder newLine() {
            if (this.identStep != Step.COMPACT) {
                this.builder.append("\n");
            }
            return this;
        }

        public int getIdent() {
            return this.ident;
        }

        public Step getIdentStep() {
            return this.identStep;
        }

        public String toString() {
            return this.builder.toString() + "\n</root>";
        }

        public static enum Step {
            TWO_SPACES(2),
            THREE_SPACES(3),
            FOUR_SPACES(4),
            COMPACT(0),
            TABS(1);

            private final int ident;

            private Step(int ident) {
                this.ident = ident;
            }

            public int getIdent() {
                return this.ident;
            }
        }
    }

    public static class XmlStringBuilderWithoutHeader
    extends XmlStringBuilder {
        public XmlStringBuilderWithoutHeader(XmlStringBuilder.Step identStep, int ident) {
            super(new StringBuilder(), identStep, ident);
        }

        @Override
        public String toString() {
            return this.builder.toString();
        }
    }

    public static enum ArrayTrue {
        ADD,
        SKIP;

    }

    public static class XmlValue {
        private XmlValue() {
        }

        public static void writeXml(Object value, String name, XmlStringBuilder builder, boolean parentTextFound, Set<String> namespaces, boolean addArray, String arrayTrue) {
            if (value instanceof Map) {
                XmlObject.writeXml((Map)value, name, builder, parentTextFound, namespaces, addArray, arrayTrue);
                return;
            }
            if (value instanceof Collection) {
                XmlArray.writeXml((Collection)value, name, builder, parentTextFound, namespaces, addArray, arrayTrue);
                return;
            }
            if (!parentTextFound) {
                builder.fillSpaces();
            }
            if (value == null) {
                builder.append("<" + XmlValue.escapeName(name, namespaces) + Xml.NULL_TRUE);
            } else if (value instanceof String) {
                if (((String)value).isEmpty()) {
                    builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? arrayTrue : ""));
                    if (name.startsWith("?")) {
                        builder.append("?>");
                    } else {
                        builder.append(" string=\"true\"/>");
                    }
                } else {
                    builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? arrayTrue : "") + (name.startsWith("?") ? " " : ">"));
                    builder.append(XmlValue.escape((String)value));
                    if (name.startsWith("?")) {
                        builder.append("?>");
                    } else {
                        builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
                    }
                }
            } else {
                XmlValue.processArrays(value, builder, name, parentTextFound, namespaces, addArray, arrayTrue);
            }
        }

        private static void processArrays(Object value, XmlStringBuilder builder, String name, boolean parentTextFound, Set<String> namespaces, boolean addArray, String arrayTrue) {
            if (value instanceof Double) {
                if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                    builder.append(Xml.NULL_ELEMENT);
                } else {
                    builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? arrayTrue : "") + Xml.NUMBER_TRUE);
                    builder.append(value.toString());
                    builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
                }
            } else if (value instanceof Float) {
                if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                    builder.append(Xml.NULL_ELEMENT);
                } else {
                    builder.append("<" + XmlValue.escapeName(name, namespaces) + Xml.NUMBER_TRUE);
                    builder.append(value.toString());
                    builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
                }
            } else if (value instanceof Number) {
                builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? arrayTrue : "") + Xml.NUMBER_TRUE);
                builder.append(value.toString());
                builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
            } else if (value instanceof Boolean) {
                builder.append("<" + XmlValue.escapeName(name, namespaces) + (addArray ? arrayTrue : "") + " boolean=\"true\">");
                builder.append(value.toString());
                builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
            } else {
                builder.append("<" + XmlValue.escapeName(name, namespaces) + ">");
                if (value instanceof byte[]) {
                    builder.newLine().incIdent();
                    XmlArray.writeXml((byte[])value, builder);
                    builder.decIdent().newLine().fillSpaces();
                } else if (value instanceof short[]) {
                    builder.newLine().incIdent();
                    XmlArray.writeXml((short[])value, builder);
                    builder.decIdent().newLine().fillSpaces();
                } else {
                    XmlValue.processArrays2(value, builder, name, parentTextFound, namespaces, arrayTrue);
                }
                builder.append("</" + XmlValue.escapeName(name, namespaces) + ">");
            }
        }

        private static void processArrays2(Object value, XmlStringBuilder builder, String name, boolean parentTextFound, Set<String> namespaces, String arrayTrue) {
            if (value instanceof int[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((int[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof long[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((long[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof float[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((float[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof double[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((double[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof boolean[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((boolean[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof char[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((char[])value, builder);
                builder.decIdent().newLine().fillSpaces();
            } else if (value instanceof Object[]) {
                builder.newLine().incIdent();
                XmlArray.writeXml((Object[])value, name, builder, parentTextFound, namespaces, arrayTrue);
                builder.decIdent().newLine().fillSpaces();
            } else {
                builder.append(value.toString());
            }
        }

        public static String escapeName(String name, Set<String> namespaces) {
            int length = name.length();
            if (length == 0) {
                return "__EE__EMPTY__EE__";
            }
            StringBuilder result = new StringBuilder();
            char ch = name.charAt(0);
            if (ch != ':') {
                try {
                    if (ch != '?') {
                        DOCUMENT.createElement(String.valueOf(ch));
                    }
                    result.append(ch);
                }
                catch (Exception ex) {
                    result.append("__").append(Base32.encode(Character.toString(ch))).append("__");
                }
            } else {
                result.append("__").append(Base32.encode(Character.toString(ch))).append("__");
            }
            for (int i = 1; i < length; ++i) {
                ch = name.charAt(i);
                if (ch == ':' && ("xmlns".equals(name.substring(0, i)) || namespaces.contains(name.substring(0, i)))) {
                    result.append(ch);
                    continue;
                }
                if (ch != ':') {
                    try {
                        DOCUMENT.createElement("a" + ch);
                        result.append(ch);
                    }
                    catch (Exception ex) {
                        result.append("__").append(Base32.encode(Character.toString(ch))).append("__");
                    }
                    continue;
                }
                result.append("__").append(Base32.encode(Character.toString(ch))).append("__");
            }
            return result.toString();
        }

        public static String escape(String s) {
            if (s == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            XmlValue.escape(s, sb);
            return sb.toString();
        }

        private static void escape(String s, StringBuilder sb) {
            int len = s.length();
            block12: for (int i = 0; i < len; ++i) {
                char ch = s.charAt(i);
                switch (ch) {
                    case '\'': {
                        sb.append("'");
                        continue block12;
                    }
                    case '&': {
                        sb.append("&amp;");
                        continue block12;
                    }
                    case '<': {
                        sb.append("&lt;");
                        continue block12;
                    }
                    case '>': {
                        sb.append("&gt;");
                        continue block12;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block12;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block12;
                    }
                    case '\n': {
                        sb.append("\n");
                        continue block12;
                    }
                    case '\r': {
                        sb.append("&#xD;");
                        continue block12;
                    }
                    case '\t': {
                        sb.append("\t");
                        continue block12;
                    }
                    case '\u20ac': {
                        sb.append("\u20ac");
                        continue block12;
                    }
                    default: {
                        if (ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                            String ss = Integer.toHexString(ch);
                            sb.append("&#x");
                            sb.append("0".repeat(4 - ss.length()));
                            sb.append(ss.toUpperCase()).append(";");
                            continue block12;
                        }
                        sb.append(ch);
                    }
                }
            }
        }

        public static String unescape(String s) {
            if (s == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            XmlValue.unescape(s, sb);
            return sb.toString();
        }

        private static void unescape(String s, StringBuilder sb) {
            int len = s.length();
            StringBuilder localSb = new StringBuilder();
            int index = 0;
            while (index < len) {
                int skipChars = XmlValue.translate(s, index, localSb);
                if (skipChars > 0) {
                    sb.append((CharSequence)localSb);
                    localSb.setLength(0);
                    index += skipChars;
                    continue;
                }
                sb.append(s.charAt(index));
                ++index;
            }
        }

        private static int translate(CharSequence input, int index, StringBuilder builder) {
            int shortest = 4;
            int longest = 6;
            if ('&' == input.charAt(index)) {
                int max = 6;
                if (index + 6 > input.length()) {
                    max = input.length() - index;
                }
                for (int i = max; i >= 4; --i) {
                    CharSequence subSeq = input.subSequence(index, index + i);
                    String result = XML_UNESCAPE.get(subSeq.toString());
                    if (result == null) continue;
                    builder.append(result);
                    return i;
                }
            }
            return 0;
        }

        public static String getMapKey(Object map) {
            return map instanceof Map && !((Map)map).isEmpty() ? String.valueOf(((Map)map).entrySet().iterator().next().getKey()) : "";
        }

        public static Object getMapValue(Object map) {
            return map instanceof Map && !((Map)map).isEmpty() ? ((Map)map).entrySet().iterator().next().getValue() : null;
        }
    }

    public static class XmlObject {
        private XmlObject() {
        }

        public static void writeXml(Map map, String name, XmlStringBuilder builder, boolean parentTextFound, Set<String> namespaces, boolean addArray, String arrayTrue) {
            if (map == null) {
                XmlValue.writeXml(Xml.NULL, name, builder, false, namespaces, addArray, arrayTrue);
                return;
            }
            ArrayList<XmlStringBuilder> elems = new ArrayList<XmlStringBuilder>();
            ArrayList<String> attrs = new ArrayList<String>();
            XmlStringBuilder.Step identStep = builder.getIdentStep();
            int ident = builder.getIdent() + (name == null ? 0 : builder.getIdentStep().getIdent());
            ArrayList entries = new ArrayList(map.entrySet());
            LinkedHashSet<String> attrKeys = new LinkedHashSet<String>();
            XmlObject.fillNamespacesAndAttrs(map, namespaces, attrKeys);
            for (int index = 0; index < entries.size(); ++index) {
                boolean addNewLine;
                Map.Entry entry = (Map.Entry)entries.get(index);
                boolean bl = addNewLine = index < entries.size() - 1 && !String.valueOf(((Map.Entry)entries.get(index + 1)).getKey()).startsWith(Xml.TEXT);
                if (String.valueOf(entry.getKey()).startsWith("-") && entry.getValue() instanceof String) {
                    attrs.add(" " + XmlValue.escapeName(String.valueOf(entry.getKey()).substring(1), namespaces) + "=\"" + XmlValue.escape(String.valueOf(entry.getValue())).replace("\"", Xml.QUOT) + "\"");
                    continue;
                }
                if (String.valueOf(entry.getKey()).startsWith(Xml.TEXT)) {
                    XmlObject.addText(entry, elems, identStep, ident, attrKeys, attrs);
                    continue;
                }
                boolean localParentTextFound = !elems.isEmpty() && elems.get(elems.size() - 1) instanceof XmlStringBuilderText || parentTextFound;
                XmlObject.processElements(entry, identStep, ident, addNewLine, elems, namespaces, localParentTextFound, arrayTrue);
            }
            if (addArray && !attrKeys.contains(Xml.ARRAY)) {
                attrs.add(arrayTrue);
            }
            XmlObject.addToBuilder(name, parentTextFound, builder, namespaces, attrs, elems);
        }

        private static void fillNamespacesAndAttrs(Map map, Set<String> namespaces, Set<String> attrKeys) {
            for (Map.Entry entry : map.entrySet()) {
                if (!String.valueOf(entry.getKey()).startsWith("-") || entry.getValue() instanceof Map || entry.getValue() instanceof List) continue;
                if (String.valueOf(entry.getKey()).startsWith("-xmlns:")) {
                    namespaces.add(String.valueOf(entry.getKey()).substring(7));
                }
                attrKeys.add(String.valueOf(entry.getKey()));
            }
        }

        private static void addToBuilder(String name, boolean parentTextFound, XmlStringBuilder builder, Set<String> namespaces, List<String> attrs, List<XmlStringBuilder> elems) {
            boolean selfClosing = attrs.remove(" self-closing=\"true\"");
            XmlObject.addOpenElement(name, parentTextFound, builder, namespaces, selfClosing, attrs, elems);
            if (!selfClosing) {
                for (XmlStringBuilder localBuilder1 : elems) {
                    builder.append(localBuilder1.toString());
                }
            }
            if (name != null) {
                builder.decIdent();
                if (!elems.isEmpty() && !(elems.get(elems.size() - 1) instanceof XmlStringBuilderText)) {
                    builder.newLine().fillSpaces();
                }
                if (!selfClosing) {
                    builder.append("</").append(XmlValue.escapeName(name, namespaces)).append(">");
                }
            }
        }

        private static void addOpenElement(String name, boolean parentTextFound, XmlStringBuilder builder, Set<String> namespaces, boolean selfClosing, List<String> attrs, List<XmlStringBuilder> elems) {
            if (name != null) {
                if (!parentTextFound) {
                    builder.fillSpaces();
                }
                builder.append("<").append(XmlValue.escapeName(name, namespaces)).append(String.join((CharSequence)"", attrs));
                if (selfClosing) {
                    builder.append("/");
                }
                builder.append(">").incIdent();
                if (!elems.isEmpty() && !(elems.get(0) instanceof XmlStringBuilderText)) {
                    builder.newLine();
                }
            }
        }

        private static void processElements(Map.Entry entry, XmlStringBuilder.Step identStep, int ident, boolean addNewLine, List<XmlStringBuilder> elems, Set<String> namespaces, boolean parentTextFound, String arrayTrue) {
            if (String.valueOf(entry.getKey()).startsWith(Xml.COMMENT)) {
                XmlObject.addComment(entry, identStep, ident, parentTextFound, addNewLine, elems);
            } else if (String.valueOf(entry.getKey()).startsWith(Xml.CDATA)) {
                XmlObject.addCdata(entry, identStep, ident, addNewLine, elems);
            } else if (entry.getValue() instanceof List && !((List)entry.getValue()).isEmpty()) {
                XmlObject.addElements(identStep, ident, entry, namespaces, elems, addNewLine, arrayTrue);
            } else {
                XmlObject.addElement(identStep, ident, entry, namespaces, elems, addNewLine, arrayTrue);
            }
        }

        private static void addText(Map.Entry entry, List<XmlStringBuilder> elems, XmlStringBuilder.Step identStep, int ident, Set<String> attrKeys, List<String> attrs) {
            if (entry.getValue() instanceof List) {
                for (Object value : (List)entry.getValue()) {
                    elems.add(new XmlStringBuilderText(identStep, ident).append(XmlValue.escape(String.valueOf(value))));
                }
            } else {
                if (entry.getValue() instanceof Number && !attrKeys.contains(Xml.NUMBER)) {
                    attrs.add(Xml.NUMBER_TEXT);
                } else if (entry.getValue() instanceof Boolean && !attrKeys.contains(Xml.BOOLEAN)) {
                    attrs.add(" boolean=\"true\"");
                } else {
                    if (entry.getValue() == null && !attrKeys.contains(Xml.NULL_ATTR)) {
                        attrs.add(" null=\"true\"");
                        return;
                    }
                    if ("".equals(entry.getValue()) && !attrKeys.contains(Xml.STRING)) {
                        attrs.add(" string=\"true\"");
                        return;
                    }
                }
                elems.add(new XmlStringBuilderText(identStep, ident).append(XmlValue.escape(String.valueOf(entry.getValue()))));
            }
        }

        private static void addElements(XmlStringBuilder.Step identStep, int ident, Map.Entry entry, Set<String> namespaces, List<XmlStringBuilder> elems, boolean addNewLine, String arrayTrue) {
            boolean parentTextFound = !elems.isEmpty() && elems.get(elems.size() - 1) instanceof XmlStringBuilderText;
            XmlStringBuilderWithoutHeader localBuilder = new XmlStringBuilderWithoutHeader(identStep, ident);
            XmlArray.writeXml((List)entry.getValue(), localBuilder, String.valueOf(entry.getKey()), parentTextFound, namespaces, arrayTrue);
            if (addNewLine) {
                localBuilder.newLine();
            }
            elems.add(localBuilder);
        }

        private static void addElement(XmlStringBuilder.Step identStep, int ident, Map.Entry entry, Set<String> namespaces, List<XmlStringBuilder> elems, boolean addNewLine, String arrayTrue) {
            boolean parentTextFound = !elems.isEmpty() && elems.get(elems.size() - 1) instanceof XmlStringBuilderText;
            XmlStringBuilderWithoutHeader localBuilder = new XmlStringBuilderWithoutHeader(identStep, ident);
            XmlValue.writeXml(entry.getValue(), String.valueOf(entry.getKey()), localBuilder, parentTextFound, namespaces, false, arrayTrue);
            if (addNewLine) {
                localBuilder.newLine();
            }
            elems.add(localBuilder);
        }

        private static void addComment(Map.Entry entry, XmlStringBuilder.Step identStep, int ident, boolean parentTextFound, boolean addNewLine, List<XmlStringBuilder> elems) {
            if (entry.getValue() instanceof List) {
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    elems.add(XmlObject.addCommentValue(identStep, ident, String.valueOf(iterator.next()), parentTextFound, iterator.hasNext() || addNewLine));
                }
            } else {
                elems.add(XmlObject.addCommentValue(identStep, ident, String.valueOf(entry.getValue()), parentTextFound, addNewLine));
            }
        }

        private static XmlStringBuilder addCommentValue(XmlStringBuilder.Step identStep, int ident, String value, boolean parentTextFound, boolean addNewLine) {
            XmlStringBuilderWithoutHeader localBuilder = new XmlStringBuilderWithoutHeader(identStep, ident);
            if (!parentTextFound) {
                localBuilder.fillSpaces();
            }
            localBuilder.append("<!--").append(value).append("-->");
            if (addNewLine) {
                localBuilder.newLine();
            }
            return localBuilder;
        }

        private static void addCdata(Map.Entry entry, XmlStringBuilder.Step identStep, int ident, boolean addNewLine, List<XmlStringBuilder> elems) {
            if (entry.getValue() instanceof List) {
                Iterator iterator = ((List)entry.getValue()).iterator();
                while (iterator.hasNext()) {
                    elems.add(XmlObject.addCdataValue(identStep, ident, String.valueOf(iterator.next()), iterator.hasNext() || addNewLine));
                }
            } else {
                elems.add(XmlObject.addCdataValue(identStep, ident, String.valueOf(entry.getValue()), addNewLine));
            }
        }

        private static XmlStringBuilder addCdataValue(XmlStringBuilder.Step identStep, int ident, String value, boolean addNewLine) {
            XmlStringBuilderText localBuilder = new XmlStringBuilderText(identStep, ident);
            localBuilder.append("<![CDATA[").append(value).append("]]>");
            if (addNewLine) {
                localBuilder.newLine();
            }
            return localBuilder;
        }
    }

    public static class XmlArray {
        private XmlArray() {
        }

        public static void writeXml(Collection<?> collection, String name, XmlStringBuilder builder, boolean parentTextFound, Set<String> namespaces, boolean addArray, String arrayTrue) {
            if (collection == null) {
                builder.append(Xml.NULL);
                return;
            }
            if (name != null) {
                builder.fillSpaces().append("<").append(XmlValue.escapeName(name, namespaces));
                if (addArray) {
                    builder.append(arrayTrue);
                }
                if (collection.isEmpty()) {
                    builder.append(" empty-array=\"true\"");
                }
                builder.append(">").incIdent();
                if (!collection.isEmpty()) {
                    builder.newLine();
                }
            }
            XmlArray.writeXml(collection, builder, name, parentTextFound, namespaces, arrayTrue);
            if (name != null) {
                builder.decIdent();
                if (!collection.isEmpty()) {
                    builder.newLine().fillSpaces();
                }
                builder.append("</").append(XmlValue.escapeName(name, namespaces)).append(">");
            }
        }

        private static void writeXml(Collection<?> collection, XmlStringBuilder builder, String name, boolean parentTextFound, Set<String> namespaces, String arrayTrue) {
            boolean localParentTextFound = parentTextFound;
            ArrayList entries = new ArrayList(collection);
            for (int index = 0; index < entries.size(); ++index) {
                boolean addNewLine;
                Object value = entries.get(index);
                boolean bl = addNewLine = index < entries.size() - 1 && !XmlValue.getMapKey(XmlValue.getMapValue(entries.get(index + 1))).startsWith(Xml.TEXT);
                if (value == null) {
                    builder.fillSpaces().append("<" + (name == null ? Xml.ELEMENT_TEXT : XmlValue.escapeName(name, namespaces)) + (collection.size() == 1 ? arrayTrue : "") + Xml.NULL_TRUE);
                } else {
                    if (value instanceof Map && ((Map)value).size() == 1 && XmlValue.getMapKey(value).equals("#item") && XmlValue.getMapValue(value) instanceof Map) {
                        XmlObject.writeXml((Map)XmlValue.getMapValue(value), null, builder, localParentTextFound, namespaces, true, arrayTrue);
                        if (XmlValue.getMapKey(XmlValue.getMapValue(value)).startsWith(Xml.TEXT)) {
                            localParentTextFound = true;
                            continue;
                        }
                    } else {
                        XmlValue.writeXml(value, name == null ? Xml.ELEMENT_TEXT : name, builder, localParentTextFound, namespaces, collection.size() == 1 || value instanceof Collection, arrayTrue);
                    }
                    localParentTextFound = false;
                }
                if (!addNewLine) continue;
                builder.newLine();
            }
        }

        public static void writeXml(byte[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(short[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(int[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(long[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(float[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(double[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(boolean[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(char[] array, XmlStringBuilder builder) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    builder.fillSpaces().append(Xml.ELEMENT);
                    builder.append(String.valueOf(array[i]));
                    builder.append(Xml.CLOSED_ELEMENT);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }

        public static void writeXml(Object[] array, String name, XmlStringBuilder builder, boolean parentTextFound, Set<String> namespaces, String arrayTrue) {
            if (array == null) {
                builder.fillSpaces().append(Xml.NULL_ELEMENT);
            } else if (array.length == 0) {
                builder.fillSpaces().append(Xml.EMPTY_ELEMENT);
            } else {
                for (int i = 0; i < array.length; ++i) {
                    XmlValue.writeXml(array[i], name == null ? Xml.ELEMENT_TEXT : name, builder, parentTextFound, namespaces, false, arrayTrue);
                    if (i == array.length - 1) continue;
                    builder.newLine();
                }
            }
        }
    }

    public static enum FromType {
        FOR_CONVERT,
        FOR_FORMAT;

    }

    protected static class Document {
        private Document() {
        }

        public static org.w3c.dom.Document createDocument(String xml) throws IOException, ParserConfigurationException, SAXException {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new DefaultHandler());
            builder.setEntityResolver(new MyEntityResolver());
            return builder.parse(new InputSource(new StringReader(xml)));
        }

        private static org.w3c.dom.Document createDocument() {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                Document.setupFactory(factory);
                DocumentBuilder builder = factory.newDocumentBuilder();
                return builder.newDocument();
            }
            catch (ParserConfigurationException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        private static void setupFactory(DocumentBuilderFactory factory) {
            try {
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class MyEntityResolver
    implements EntityResolver {
        private MyEntityResolver() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            return new InputSource(new StringReader(""));
        }
    }

    public static class XmlStringBuilderText
    extends XmlStringBuilderWithoutHeader {
        public XmlStringBuilderText(XmlStringBuilder.Step identStep, int ident) {
            super(identStep, ident);
        }
    }
}

