/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

import com.github.underscore.Json;
import com.github.underscore.Underscore;
import com.github.underscore.Xml;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class U<T>
extends Underscore<T> {
    private static final int DEFAULT_TRUNC_LENGTH = 30;
    private static final String DEFAULT_TRUNC_OMISSION = "...";
    private static final Pattern RE_LATIN_1 = Pattern.compile("[\\xc0-\\xd6\\xd8-\\xde\\xdf-\\xf6\\xf8-\\xff]");
    private static final Pattern RE_PROP_NAME = Pattern.compile("[^.\\[\\]]+|\\[(?:(-?\\d+(?:\\.\\d+)?)|([\"'])((?:(?!\u0002)\\[^\\]|\\.)*?)\u0002)\\]|(?=(\\.|\\[\\])(?:\u0004|$))");
    private static final Map<String, String> DEBURRED_LETTERS = new LinkedHashMap<String, String>();
    private static final Map<String, List<String>> DEFAULT_HEADER_FIELDS = new HashMap<String, List<String>>();
    private static final Set<String> SUPPORTED_HTTP_METHODS = new HashSet<String>(Arrays.asList("GET", "POST", "PUT", "DELETE"));
    private static final int BUFFER_LENGTH_1024 = 1024;
    private static final int RESPONSE_CODE_400 = 400;
    private static final String ROOT = "root";
    private static final String UPPER = "[A-Z\\xc0-\\xd6\\xd8-\\xde\\u0400-\\u04FF]";
    private static final String LOWER = "[a-z\\xdf-\\xf6\\xf8-\\xff]+";
    private static final String SELF_CLOSING = "-self-closing";
    private static final String NIL_KEY = "-nil";
    private static final String OMIT_XML_DECL = "#omit-xml-declaration";
    private static final String YES = "yes";
    private static final Pattern RE_WORDS = Pattern.compile("[A-Z\\xc0-\\xd6\\xd8-\\xde\\u0400-\\u04FF]+(?=[A-Z\\xc0-\\xd6\\xd8-\\xde\\u0400-\\u04FF][a-z\\xdf-\\xf6\\xf8-\\xff]+)|[A-Z\\xc0-\\xd6\\xd8-\\xde\\u0400-\\u04FF]?[a-z\\xdf-\\xf6\\xf8-\\xff]+|[A-Z\\xc0-\\xd6\\xd8-\\xde\\u0400-\\u04FF]+|\\d+");
    private static final String ENCODING = "#encoding";

    public U(Iterable<T> iterable) {
        super(iterable);
    }

    public U(String string) {
        super(string);
    }

    public static Chain<String> chain(String item) {
        return new Chain<String>(item);
    }

    public static <T> Chain<T> chain(List<T> list) {
        return new Chain<T>(list);
    }

    public static Chain<Map<String, Object>> chain(Map<String, Object> map) {
        return new Chain<Map<String, Object>>(map);
    }

    public static <T> Chain<T> chain(Iterable<T> iterable) {
        return new Chain<T>(U.newArrayList(iterable));
    }

    public static <T> Chain<T> chain(Iterable<T> iterable, int size) {
        return new Chain<T>(U.newArrayList(iterable, size));
    }

    public static <T> Chain<T> chain(T ... list) {
        return new Chain<T>(Arrays.asList(list));
    }

    public static Chain<Integer> chain(int[] array) {
        return new Chain<Integer>(U.newIntegerList(array));
    }

    @Override
    public Chain<T> chain() {
        return new Chain(U.newArrayList(this.value()));
    }

    public static Chain<String> of(String item) {
        return new Chain<String>(item);
    }

    public static <T> Chain<T> of(List<T> list) {
        return new Chain<T>(list);
    }

    public static Chain<Map<String, Object>> of(Map<String, Object> map) {
        return new Chain<Map<String, Object>>(map);
    }

    public static <T> Chain<T> of(Iterable<T> iterable) {
        return new Chain<T>(U.newArrayList(iterable));
    }

    public static <T> Chain<T> of(Iterable<T> iterable, int size) {
        return new Chain<T>(U.newArrayList(iterable, size));
    }

    public static <T> Chain<T> of(T ... list) {
        return new Chain<T>(Arrays.asList(list));
    }

    public static Chain<Integer> of(int[] array) {
        return new Chain<Integer>(U.newIntegerList(array));
    }

    @Override
    public Chain<T> of() {
        return new Chain(U.newArrayList(this.value()));
    }

    public static <T> List<T> drop(Iterable<T> iterable) {
        return U.rest(U.newArrayList(iterable));
    }

    public List<T> drop() {
        return U.drop(this.getIterable());
    }

    public static <T> List<T> drop(Iterable<T> iterable, Integer n) {
        return U.rest(U.newArrayList(iterable), (int)n);
    }

    public List<T> drop(Integer n) {
        return U.drop(this.getIterable(), n);
    }

    public static <T> List<T> dropRight(Iterable<T> iterable) {
        return U.initial(U.newArrayList(iterable));
    }

    public List<T> dropRight() {
        return U.dropRight(this.getIterable());
    }

    public static <T> List<T> dropRight(Iterable<T> iterable, Integer n) {
        return U.initial(U.newArrayList(iterable), (int)n);
    }

    public List<T> dropRight(Integer n) {
        return U.dropRight(this.getIterable(), n);
    }

    public static <T> List<T> dropWhile(Iterable<T> iterable, Predicate<T> pred) {
        return U.rest(U.newArrayList(iterable), U.findIndex(U.newArrayList(iterable), U.negate(pred)));
    }

    public List<T> dropWhile(Predicate<T> pred) {
        return U.dropWhile(this.getIterable(), pred);
    }

    public static <T> List<T> dropRightWhile(Iterable<T> iterable, Predicate<T> pred) {
        return U.reverse(U.dropWhile(U.reverse(iterable), pred));
    }

    public List<T> dropRightWhile(Predicate<T> pred) {
        return U.dropRightWhile(this.getIterable(), pred);
    }

    public static <T> List<T> fill(List<T> list, T item) {
        for (int i = 0; i < U.size(list); ++i) {
            list.set(i, item);
        }
        return list;
    }

    public static <T> T[] fill(T[] array, T item) {
        Arrays.fill(array, item);
        return array;
    }

    public List<Object> fill(Object value) {
        return U.fill((List)this.getIterable(), value);
    }

    public static List<Object> fill(List<Object> list, Object value, Integer start, Integer end) {
        for (int index = start.intValue(); index < end; ++index) {
            list.set(index, value);
        }
        return list;
    }

    public List<Object> fill(Object value, Integer start, Integer end) {
        return U.fill((List)this.getIterable(), value, start, end);
    }

    public static <E> List<E> flattenDeep(List<?> list) {
        return U.flatten(list, false);
    }

    public List<T> flattenDeep() {
        return U.flattenDeep((List)this.getIterable());
    }

    public static List<Object> pull(List<Object> list, Object ... values) {
        List<Object> valuesList = Arrays.asList(values);
        list.removeIf(valuesList::contains);
        return list;
    }

    public List<Object> pull(Object ... values) {
        return U.pull((List)this.getIterable(), values);
    }

    public static List<Object> pullAt(List<Object> list, Integer ... indexes) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<Integer> indexesList = Arrays.asList(indexes);
        int index = 0;
        Iterator<Object> iterator = list.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (indexesList.contains(index)) {
                result.add(object);
                iterator.remove();
            }
            ++index;
        }
        return result;
    }

    public List<Object> pullAt(Integer ... indexes) {
        return U.pullAt((List)this.getIterable(), indexes);
    }

    public static <T> List<T> remove(List<T> list, Predicate<T> pred) {
        ArrayList<T> result = new ArrayList<T>();
        Iterator<T> iterator = list.iterator();
        while (iterator.hasNext()) {
            T object = iterator.next();
            if (!pred.test(object)) continue;
            result.add(object);
            iterator.remove();
        }
        return result;
    }

    public List<T> remove(Predicate<T> pred) {
        return U.remove((List)this.getIterable(), pred);
    }

    public static <T> List<T> take(Iterable<T> iterable) {
        return U.first(U.newArrayList(iterable), 1);
    }

    public List<T> take() {
        return U.take(this.getIterable());
    }

    public static <T> List<T> takeRight(Iterable<T> iterable) {
        return U.last(U.newArrayList(iterable), 1);
    }

    public List<T> takeRight() {
        return U.takeRight(this.getIterable());
    }

    public static <T> List<T> take(Iterable<T> iterable, Integer n) {
        return U.first(U.newArrayList(iterable), n);
    }

    public List<T> take(Integer n) {
        return U.take(this.getIterable(), n);
    }

    public static <T> List<T> takeRight(Iterable<T> iterable, Integer n) {
        return U.last(U.newArrayList(iterable), n);
    }

    public List<T> takeRight(Integer n) {
        return U.takeRight(this.getIterable(), n);
    }

    public static <T> List<T> takeWhile(Iterable<T> iterable, Predicate<T> pred) {
        return U.first(U.newArrayList(iterable), U.findIndex(U.newArrayList(iterable), U.negate(pred)));
    }

    public List<T> takeWhile(Predicate<T> pred) {
        return U.takeWhile(this.getIterable(), pred);
    }

    public static <T> List<T> takeRightWhile(Iterable<T> iterable, Predicate<T> pred) {
        return U.reverse(U.takeWhile(U.reverse(iterable), pred));
    }

    public List<T> takeRightWhile(Predicate<T> pred) {
        return U.takeRightWhile(this.getIterable(), pred);
    }

    public static <T> List<T> xor(List<T> ... lists) {
        int index = -1;
        int length = lists.length;
        List<T> result = null;
        while (++index < length) {
            List<T> array = lists[index];
            result = result == null ? array : U.concat(U.difference(result, array), U.difference(array, result));
        }
        return U.uniq(result);
    }

    public List<T> xor(List<T> list) {
        return U.xor((List)this.getIterable(), list);
    }

    public static <T> List<T> at(List<T> list, Integer ... indexes) {
        ArrayList<T> result = new ArrayList<T>();
        List<Integer> indexesList = Arrays.asList(indexes);
        int index = 0;
        for (T object : list) {
            if (indexesList.contains(index)) {
                result.add(object);
            }
            ++index;
        }
        return result;
    }

    public List<T> at(Integer ... indexes) {
        return U.at((List)this.getIterable(), indexes);
    }

    public static <T extends Number> Double average(Iterable<T> iterable) {
        T sum = U.sum(iterable);
        if (sum == null) {
            return null;
        }
        return ((Number)sum).doubleValue() / (double)U.size(iterable);
    }

    public static <E, F extends Number> Double average(Iterable<E> iterable, Function<E, F> func) {
        F sum = U.sum(iterable, func);
        if (sum == null) {
            return null;
        }
        return ((Number)sum).doubleValue() / (double)U.size(iterable);
    }

    public static <N extends Number> Double average(N[] array) {
        Number sum = U.sum(array);
        if (sum == null) {
            return null;
        }
        return sum.doubleValue() / (double)array.length;
    }

    public static Double average(BigDecimal first, BigDecimal second) {
        if (first == null || second == null) {
            return null;
        }
        return U.sum(first, second).doubleValue() / 2.0;
    }

    public static Double average(BigInteger first, BigInteger second) {
        if (first == null || second == null) {
            return null;
        }
        return U.sum(first, second).doubleValue() / 2.0;
    }

    public static Double average(Byte first, Byte second) {
        if (first == null || second == null) {
            return null;
        }
        return U.sum(first, second).doubleValue() / 2.0;
    }

    public static Double average(Double first, Double second) {
        if (first == null || second == null) {
            return null;
        }
        return U.sum(first, second) / 2.0;
    }

    public static Double average(Float first, Float second) {
        if (first == null || second == null) {
            return null;
        }
        return U.sum(first, second).doubleValue() / 2.0;
    }

    public static Double average(Integer first, Integer second) {
        if (first == null || second == null) {
            return null;
        }
        return U.sum(first, second).doubleValue() / 2.0;
    }

    public static Double average(Long first, Long second) {
        if (first == null || second == null) {
            return null;
        }
        return U.sum(first, second).doubleValue() / 2.0;
    }

    public static <T extends Number> T sum(Iterable<T> iterable) {
        Number result = null;
        for (Number item : iterable) {
            result = U.add(result, item);
        }
        return (T)result;
    }

    public static <E, F extends Number> F sum(Iterable<E> iterable, Function<E, F> func) {
        Number result = null;
        for (E item : iterable) {
            result = U.add(result, (Number)func.apply(item));
        }
        return (F)result;
    }

    public static <N extends Number> N sum(N[] array) {
        Object result = null;
        for (N item : array) {
            result = U.add(result, item);
        }
        return result;
    }

    public <F extends Number> F sum() {
        return (F)U.sum((List)this.getIterable());
    }

    public <E, F extends Number> F sum(Function<E, F> func) {
        return U.sum((List)this.getIterable(), func);
    }

    public static <T extends Number> T add(T first, T second) {
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first instanceof BigDecimal) {
            return (T)U.sum((BigDecimal)first, (BigDecimal)second);
        }
        if (second instanceof BigInteger) {
            return (T)U.sum((BigInteger)first, (BigInteger)second);
        }
        if (first instanceof Byte) {
            return (T)U.sum((Byte)first, (Byte)second);
        }
        if (first instanceof Double) {
            return (T)U.sum((Double)first, (Double)second);
        }
        if (first instanceof Float) {
            return (T)U.sum((Float)first, (Float)second);
        }
        if (first instanceof Integer) {
            return (T)U.sum((Integer)first, (Integer)second);
        }
        if (first instanceof Long) {
            return (T)U.sum((Long)first, (Long)second);
        }
        if (first instanceof Short) {
            return (T)U.sum((Short)first, (Short)second);
        }
        throw new UnsupportedOperationException("Sum only supports official subclasses of Number");
    }

    private static BigDecimal sum(BigDecimal first, BigDecimal second) {
        return first.add(second);
    }

    private static BigInteger sum(BigInteger first, BigInteger second) {
        return first.add(second);
    }

    private static Byte sum(Byte first, Byte second) {
        return (byte)(first + second);
    }

    private static Double sum(Double first, Double second) {
        return first + second;
    }

    private static Float sum(Float first, Float second) {
        return Float.valueOf(first.floatValue() + second.floatValue());
    }

    private static Integer sum(Integer first, Integer second) {
        return first + second;
    }

    private static Long sum(Long first, Long second) {
        return first + second;
    }

    private static Short sum(Short first, Short second) {
        return (short)(first + second);
    }

    public static <T extends Number> T subtract(T ... values) {
        if (values.length == 0) {
            return null;
        }
        Object result = values[0];
        for (int i = 1; i < values.length; ++i) {
            Number value;
            if (result instanceof BigDecimal) {
                value = (BigDecimal)values[i];
                result = U.add(result, ((BigDecimal)value).negate());
                continue;
            }
            if (result instanceof BigInteger) {
                value = (BigInteger)values[i];
                result = U.add(result, ((BigInteger)value).negate());
                continue;
            }
            if (result instanceof Byte) {
                result = U.add(result, (byte)(((Number)values[i]).byteValue() * -1));
                continue;
            }
            if (result instanceof Double) {
                result = U.add(result, ((Number)values[i]).doubleValue() * -1.0);
                continue;
            }
            if (result instanceof Float) {
                result = U.add(result, Float.valueOf(((Number)values[i]).floatValue() * -1.0f));
                continue;
            }
            if (result instanceof Integer) {
                result = U.add(result, ((Number)values[i]).intValue() * -1);
                continue;
            }
            if (result instanceof Long) {
                result = U.add(result, ((Number)values[i]).longValue() * -1L);
                continue;
            }
            if (result instanceof Short) {
                result = U.add(result, (short)(((Number)values[i]).shortValue() * -1));
                continue;
            }
            throw new UnsupportedOperationException("Subtract only supports official subclasses of Number");
        }
        return result;
    }

    public static <T extends Number> double mean(Iterable<T> iterable) {
        Number result = null;
        int count = 0;
        for (Number item : iterable) {
            result = U.add(result, item);
            ++count;
        }
        if (result == null) {
            return 0.0;
        }
        return result.doubleValue() / (double)count;
    }

    public double mean() {
        return U.mean(this.getIterable());
    }

    public static <T extends Number> double median(Iterable<T> iterable) {
        List<T> result = U.newArrayList((Collection)iterable);
        int size = U.size(iterable);
        if (size == 0) {
            throw new IllegalArgumentException("Iterable cannot be empty");
        }
        if (size % 2 != 0) {
            return ((Number)result.get(size / 2)).doubleValue();
        }
        return (((Number)result.get(size / 2 - 1)).doubleValue() + ((Number)result.get(size / 2)).doubleValue()) / 2.0;
    }

    public double median() {
        return U.median(this.getIterable());
    }

    public static String camelCase(String string) {
        return U.createCompounder((result, word, index) -> {
            String localWord = word.toLowerCase(Locale.getDefault());
            return result + (String)(index > 0 ? localWord.substring(0, 1).toUpperCase(Locale.getDefault()) + localWord.substring(1) : localWord);
        }).apply(string);
    }

    public static String lowerFirst(String string) {
        return U.createCaseFirst("toLowerCase").apply(string);
    }

    public static String upperFirst(String string) {
        return U.createCaseFirst("toUpperCase").apply(string);
    }

    public static String capitalize(String string) {
        return U.upperFirst(U.baseToString(string));
    }

    public static String uncapitalize(String string) {
        return U.lowerFirst(U.baseToString(string));
    }

    private static String baseToString(String value) {
        return value == null ? "" : value;
    }

    public static String deburr(String string) {
        String localString = U.baseToString(string);
        StringBuilder sb = new StringBuilder();
        for (String str : localString.split("")) {
            if (RE_LATIN_1.matcher(str).matches()) {
                sb.append(DEBURRED_LETTERS.get(str));
                continue;
            }
            sb.append(str);
        }
        return sb.toString();
    }

    public static List<String> words(String string) {
        String localString = U.baseToString(string);
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = RE_WORDS.matcher(localString);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        return result;
    }

    private static Function<String, String> createCompounder(Underscore.Function3<String, String, Integer, String> callback) {
        return string -> {
            int index = -1;
            List<String> array = U.words(U.deburr(string));
            int length = array.size();
            String result = "";
            while (++index < length) {
                result = (String)callback.apply(result, array.get(index), index);
            }
            return result;
        };
    }

    private static Function<String, String> createCaseFirst(String methodName) {
        return string -> {
            String localString = U.baseToString(string);
            String chr = localString.isEmpty() ? "" : localString.substring(0, 1);
            String trailing = localString.length() > 1 ? localString.substring(1) : "";
            return Underscore.invoke(Collections.singletonList(chr), methodName).get(0) + trailing;
        };
    }

    public static boolean endsWith(String string, String target) {
        return U.endsWith(string, target, null);
    }

    public static boolean endsWith(String string, String target, Integer position) {
        if (string == null || target == null) {
            return false;
        }
        String localString = U.baseToString(string);
        int length = localString.length();
        int fixedPosition = position == null || position < 0 ? 0 : position;
        int localPosition = position == null ? length : Math.min(fixedPosition, length);
        int localPosition2 = localPosition - target.length();
        return localPosition2 >= 0 && localString.indexOf(target, localPosition2) == localPosition2;
    }

    public static String kebabCase(String string) {
        return U.createCompounder((result, word, index) -> result + (index > 0 ? "-" : "") + word.toLowerCase(Locale.getDefault())).apply(string);
    }

    public static String repeat(String string, int length) {
        StringBuilder result = new StringBuilder();
        StringBuilder localString = new StringBuilder(U.baseToString(string));
        if (length < 1 || string == null) {
            return result.toString();
        }
        int n = length;
        do {
            if (n % 2 != 0) {
                result.append((CharSequence)localString);
            }
            n = (int)Math.floor((double)n / 2.0);
            localString.append((CharSequence)localString);
        } while (n > 0);
        return result.toString();
    }

    private static String createPadding(String string, int length, String chars) {
        int strLength = string.length();
        int padLength = length - strLength;
        String localChars = chars == null ? " " : chars;
        return U.repeat(localChars, (int)Math.ceil((double)padLength / (double)localChars.length())).substring(0, padLength);
    }

    public static String pad(String string, int length) {
        return U.pad(string, length, null);
    }

    public static String pad(String string, int length, String chars) {
        String localString = U.baseToString(string);
        int strLength = localString.length();
        if (strLength >= length) {
            return localString;
        }
        double mid = (double)(length - strLength) / 2.0;
        int leftLength = (int)Math.floor(mid);
        int rightLength = (int)Math.ceil(mid);
        String localChars = U.createPadding("", rightLength, chars);
        return localChars.substring(0, leftLength) + localString + localChars;
    }

    private static Underscore.Function3<String, Integer, String, String> createPadDir(boolean fromRight) {
        return (string, length, chars) -> {
            String localString = U.baseToString(string);
            return (fromRight ? localString : "") + U.createPadding(localString, length, chars) + (fromRight ? "" : localString);
        };
    }

    public static String padStart(String string, Integer length) {
        return U.createPadDir(false).apply(string, length, null);
    }

    public static String padStart(String string, Integer length, String chars) {
        return U.createPadDir(false).apply(string, length, chars);
    }

    public static String padEnd(String string, Integer length) {
        return U.createPadDir(true).apply(string, length, null);
    }

    public static String padEnd(String string, Integer length, String chars) {
        return U.createPadDir(true).apply(string, length, chars);
    }

    public static String snakeCase(String string) {
        return U.createCompounder((result, word, index) -> result + (index > 0 ? "_" : "") + word.toLowerCase(Locale.getDefault())).apply(string);
    }

    public static String startCase(String string) {
        return U.createCompounder((result, word, index) -> result + (index > 0 ? " " : "") + word.substring(0, 1).toUpperCase(Locale.getDefault()) + word.substring(1)).apply(string);
    }

    public static boolean startsWith(String string, String target) {
        return U.startsWith(string, target, null);
    }

    public static boolean startsWith(String string, String target, Integer position) {
        int localPosition;
        if (string == null || target == null) {
            return false;
        }
        String localString = U.baseToString(string);
        int length = localString.length();
        if (position == null) {
            localPosition = 0;
        } else {
            int from = position < 0 ? 0 : position;
            localPosition = Math.min(from, length);
        }
        return localString.lastIndexOf(target, localPosition) == localPosition;
    }

    private static int charsLeftIndex(String string, String chars) {
        int index;
        int length = string.length();
        for (index = 0; index < length && chars.indexOf(string.charAt(index)) > -1; ++index) {
        }
        return index == length ? -1 : index;
    }

    private static int charsRightIndex(String string, String chars) {
        int index;
        for (index = string.length() - 1; index >= 0 && chars.indexOf(string.charAt(index)) > -1; --index) {
        }
        return index;
    }

    public static String trim(String string) {
        return U.trim(string, null);
    }

    public static String trim(String string, String chars) {
        String localString = U.baseToString(string);
        if (localString.isEmpty()) {
            return localString;
        }
        String localChars = chars == null ? " " : chars;
        int leftIndex = U.charsLeftIndex(localString, localChars);
        int rightIndex = U.charsRightIndex(localString, localChars);
        return leftIndex > -1 ? localString.substring(leftIndex, rightIndex + 1) : localString;
    }

    public static String trimStart(String string) {
        return U.trimStart(string, null);
    }

    public static String trimStart(String string, String chars) {
        String localString = U.baseToString(string);
        if (localString.isEmpty()) {
            return localString;
        }
        String localChars = chars == null ? " " : chars;
        int leftIndex = U.charsLeftIndex(localString, localChars);
        return leftIndex > -1 ? localString.substring(leftIndex) : localString;
    }

    public static String trimEnd(String string) {
        return U.trimEnd(string, null);
    }

    public static String trimEnd(String string, String chars) {
        String localString = U.baseToString(string);
        if (localString.isEmpty()) {
            return localString;
        }
        String localChars = chars == null ? " " : chars;
        int rightIndex = U.charsRightIndex(localString, localChars);
        return rightIndex > -1 ? localString.substring(0, rightIndex + 1) : localString;
    }

    public static String trunc(String string) {
        return U.trunc(string, 30);
    }

    public static String trunc(String string, Integer length) {
        String localString = U.baseToString(string);
        String omission = DEFAULT_TRUNC_OMISSION;
        if (length >= localString.length()) {
            return localString;
        }
        int end = length - DEFAULT_TRUNC_OMISSION.length();
        String result = localString.substring(0, end);
        return result + DEFAULT_TRUNC_OMISSION;
    }

    public static List<String> stringToPath(String string) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = RE_PROP_NAME.matcher(U.baseToString(string));
        while (matcher.find()) {
            result.add(matcher.group(1) == null ? matcher.group(0) : matcher.group(1));
        }
        return result;
    }

    private static <T> T baseGetOrSetOrRemove(Map<String, Object> object, List<String> paths, Object value, OperationType operationType) {
        int index = 0;
        int length = paths.size();
        Object localObject = object;
        Map<String, Object> savedLocalObject = null;
        String savedPath = null;
        while (localObject != null && index < length) {
            if (localObject instanceof Map) {
                Map.Entry mapEntry = U.getMapEntry(localObject);
                if (mapEntry != null && "#item".equals(mapEntry.getKey())) {
                    localObject = mapEntry.getValue();
                    continue;
                }
                savedLocalObject = localObject;
                savedPath = paths.get(index);
                localObject = localObject.get(paths.get(index));
            } else {
                if (!(localObject instanceof List)) break;
                savedLocalObject = localObject;
                savedPath = paths.get(index);
                localObject = ((List)localObject).get(Integer.parseInt(paths.get(index)));
            }
            ++index;
        }
        if (index > 0 && index == length) {
            U.checkSetAndRemove(value, operationType, savedLocalObject, savedPath);
            return (T)localObject;
        }
        return null;
    }

    private static void checkSetAndRemove(Object value, OperationType operationType, Object savedLocalObject, String savedPath) {
        if (operationType == OperationType.SET || operationType == OperationType.UPDATE) {
            if (savedLocalObject instanceof Map) {
                U.checkSetOrUpdate(value, operationType, (Map)savedLocalObject, savedPath);
            } else {
                ((List)savedLocalObject).set(Integer.parseInt(savedPath), value);
            }
        } else if (operationType == OperationType.REMOVE) {
            if (savedLocalObject instanceof Map) {
                ((Map)savedLocalObject).remove(savedPath);
            } else {
                ((List)savedLocalObject).remove(Integer.parseInt(savedPath));
            }
        }
    }

    private static void checkSetOrUpdate(Object value, OperationType operationType, Map<String, Object> savedLocalObject, String savedPath) {
        if (operationType == OperationType.UPDATE && savedLocalObject.containsKey(savedPath)) {
            savedLocalObject.put(Underscore.uniqueId(savedPath), value);
        } else {
            savedLocalObject.put(savedPath, value);
        }
    }

    private static Map.Entry getMapEntry(Map map) {
        return map.isEmpty() ? null : map.entrySet().iterator().next();
    }

    public static <T> T get(Map<String, Object> object, String path) {
        return U.get(object, U.stringToPath(path));
    }

    public static <T> T get(Map<String, Object> object, List<String> paths) {
        return U.baseGetOrSetOrRemove(object, paths, null, OperationType.GET);
    }

    public static String selectToken(Map<String, Object> object, String expression) {
        String xml = U.toXml(object);
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Document document = Xml.Document.createDocument(xml);
            NodeList nodes = (NodeList)xPath.compile(expression).evaluate(document, XPathConstants.NODESET);
            if (nodes.getLength() == 0) {
                return null;
            }
            return nodes.item(0).getNodeValue();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static List<String> selectTokens(Map<String, Object> object, String expression) {
        String xml = U.toXml(object);
        try {
            XPath xPath = XPathFactory.newInstance().newXPath();
            Document document = Xml.Document.createDocument(xml);
            NodeList nodes = (NodeList)xPath.compile(expression).evaluate(document, XPathConstants.NODESET);
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                result.add(nodes.item(i).getNodeValue());
            }
            return result;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static <T> T set(Map<String, Object> object, String path, Object value) {
        return U.set(object, U.stringToPath(path), value);
    }

    public static <T> T set(Map<String, Object> object, List<String> paths, Object value) {
        return U.baseGetOrSetOrRemove(object, paths, value, OperationType.SET);
    }

    public static <T> T update(Map<String, Object> object, String path, Object value) {
        return U.update(object, U.stringToPath(path), value);
    }

    public static <T> T update(Map<String, Object> object, List<String> paths, Object value) {
        return U.baseGetOrSetOrRemove(object, paths, value, OperationType.UPDATE);
    }

    public static <T> T remove(Map<String, Object> object, String path) {
        return U.remove(object, U.stringToPath(path));
    }

    public static <T> T remove(Map<String, Object> object, List<String> paths) {
        return U.baseGetOrSetOrRemove(object, paths, null, OperationType.REMOVE);
    }

    public static Map<String, Object> rename(Map<String, Object> map, String oldKey, String newKey) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().equals(oldKey)) {
                outMap.put(newKey, U.makeObjectForRename(entry.getValue(), oldKey, newKey));
                continue;
            }
            outMap.put(entry.getKey(), U.makeObjectForRename(entry.getValue(), oldKey, newKey));
        }
        return outMap;
    }

    private static Object makeObjectForRename(Object value, String oldKey, String newKey) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.rename((Map)item, oldKey, newKey) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.rename(value, oldKey, newKey) : value;
        }
        return result;
    }

    public static Map<String, Object> setValue(Map<String, Object> map, String key, Object newValue) {
        return U.setValue(map, key, (String key1, Object value) -> newValue);
    }

    public static Map<String, Object> setValue(Map<String, Object> map, String key, BiFunction<String, Object, Object> newValue) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getKey().equals(key)) {
                outMap.put(key, U.makeObjectForSetValue(newValue.apply(key, entry.getValue()), key, newValue));
                continue;
            }
            outMap.put(entry.getKey(), U.makeObjectForSetValue(entry.getValue(), key, newValue));
        }
        return outMap;
    }

    private static Object makeObjectForSetValue(Object value, String key, BiFunction<String, Object, Object> newValue) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.setValue((Map<String, Object>)((Map)item), key, newValue) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.setValue(value, key, newValue) : value;
        }
        return result;
    }

    public static Map<String, Object> update(Map<String, Object> map1, Map<String, Object> map2) {
        Object value2;
        String key;
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map1.entrySet()) {
            key = entry.getKey();
            value2 = entry.getValue();
            if (map2.containsKey(key)) {
                U.createKey(map2, key, value2, outMap);
                continue;
            }
            outMap.put(key, value2);
        }
        for (Map.Entry<String, Object> entry : map2.entrySet()) {
            key = entry.getKey();
            value2 = entry.getValue();
            if (map1.containsKey(key)) {
                U.createKey(map1, key, value2, outMap);
                continue;
            }
            outMap.put(key, value2);
        }
        return outMap;
    }

    private static void createKey(Map<String, Object> map, String key, Object value2, Map<String, Object> outMap) {
        Object value1 = map.get(key);
        if (value1 instanceof Map && value2 instanceof Map) {
            outMap.put(key, U.update((Map)value1, (Map)value2));
        } else if (value1 instanceof List && value2 instanceof List) {
            outMap.put(key, U.merge((List)value1, (List)value2));
        } else if (value1 instanceof List) {
            outMap.put(key, U.merge((List)value1, U.newArrayList(value2)));
        } else if (value2 instanceof List) {
            outMap.put(key, U.merge(U.newArrayList(value1), (List)value2));
        } else {
            outMap.put(key, value2);
        }
    }

    public static List<Object> merge(List<Object> list1, List<Object> list2) {
        List<Object> outList1 = U.newArrayList(list1);
        List<Object> outList2 = U.newArrayList(list2);
        outList2.removeAll(list1);
        outList1.addAll(outList2);
        return outList1;
    }

    public static long downloadUrl(String url, String fileName) throws IOException, URISyntaxException {
        URL website = new URI(url).toURL();
        try (ReadableByteChannel rbc = Channels.newChannel(website.openStream());){
            long l;
            try (FileOutputStream fos = new FileOutputStream(fileName);){
                l = fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
            }
            return l;
        }
    }

    public static void decompressGzip(String sourceFileName, String targetFileName) throws IOException {
        try (GZIPInputStream gis = new GZIPInputStream(new FileInputStream(sourceFileName));){
            Files.copy(gis, Paths.get(targetFileName, new String[0]), new CopyOption[0]);
        }
    }

    public static FetchResponse fetch(String url) {
        return U.fetch(url, null, null, DEFAULT_HEADER_FIELDS, null, null);
    }

    public static FetchResponse fetch(String url, Integer connectTimeout, Integer readTimeout) {
        return U.fetch(url, null, null, DEFAULT_HEADER_FIELDS, connectTimeout, readTimeout);
    }

    public static FetchResponse fetch(String url, Integer connectTimeout, Integer readTimeout, Integer retryCount, Integer timeBetweenRetry) {
        return Fetch.fetch(url, null, null, DEFAULT_HEADER_FIELDS, connectTimeout, readTimeout, retryCount, timeBetweenRetry);
    }

    public static FetchResponse fetch(String url, String method, String body) {
        return U.fetch(url, method, body, DEFAULT_HEADER_FIELDS, null, null);
    }

    public static void setupConnection(HttpURLConnection connection, String method, Map<String, List<String>> headerFields, Integer connectTimeout, Integer readTimeout) throws IOException {
        String localMethod = SUPPORTED_HTTP_METHODS.contains(method) ? method : "GET";
        connection.setRequestMethod(localMethod);
        if (connectTimeout != null) {
            connection.setConnectTimeout(connectTimeout);
        }
        if (readTimeout != null) {
            connection.setReadTimeout(readTimeout);
        }
        if (connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(new BaseHttpSslSocketFactory());
        }
        if (headerFields != null) {
            for (Map.Entry<String, List<String>> header : headerFields.entrySet()) {
                connection.setRequestProperty(header.getKey(), U.join((Iterable)header.getValue(), ";"));
            }
        }
    }

    public static FetchResponse fetch(String url, String method, String body, Map<String, List<String>> headerFields, Integer connectTimeout, Integer readTimeout) {
        try {
            int length;
            int responseCode;
            URL localUrl = new URI(url).toURL();
            HttpURLConnection connection = (HttpURLConnection)localUrl.openConnection();
            U.setupConnection(connection, method, headerFields, connectTimeout, readTimeout);
            if (body != null) {
                connection.setDoOutput(true);
                DataOutputStream outputStream = new DataOutputStream(connection.getOutputStream());
                outputStream.write(body.getBytes(StandardCharsets.UTF_8));
                outputStream.close();
            }
            InputStream inputStream = (responseCode = connection.getResponseCode()) < 400 ? connection.getInputStream() : connection.getErrorStream();
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                result.write(buffer, 0, length);
            }
            inputStream.close();
            return new FetchResponse(responseCode < 400, responseCode, connection.getHeaderFields(), result);
        }
        catch (IOException | URISyntaxException ex) {
            throw new UnsupportedOperationException(ex);
        }
    }

    public static List<String> explode(String input) {
        ArrayList<String> result = new ArrayList<String>();
        if (U.isNull(input)) {
            return result;
        }
        for (char character : input.toCharArray()) {
            result.add(String.valueOf(character));
        }
        return result;
    }

    public static String implode(String[] input) {
        StringBuilder builder = new StringBuilder();
        for (String character : input) {
            if (!U.nonNull(character)) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public static String implode(Iterable<String> input) {
        StringBuilder builder = new StringBuilder();
        for (String character : input) {
            if (!U.nonNull(character)) continue;
            builder.append(character);
        }
        return builder.toString();
    }

    public String camelCase() {
        return U.camelCase(this.getString().get());
    }

    public String lowerFirst() {
        return U.lowerFirst(this.getString().get());
    }

    public String upperFirst() {
        return U.upperFirst(this.getString().get());
    }

    public String capitalize() {
        return U.capitalize(this.getString().get());
    }

    public String deburr() {
        return U.deburr(this.getString().get());
    }

    public boolean endsWith(String target) {
        return U.endsWith(this.getString().get(), target);
    }

    public boolean endsWith(String target, Integer position) {
        return U.endsWith(this.getString().get(), target, position);
    }

    public String kebabCase() {
        return U.kebabCase(this.getString().get());
    }

    public String repeat(int length) {
        return U.repeat(this.getString().get(), length);
    }

    public String pad(int length) {
        return U.pad(this.getString().get(), length);
    }

    public String pad(int length, String chars) {
        return U.pad(this.getString().get(), length, chars);
    }

    public String padStart(int length) {
        return U.padStart(this.getString().get(), length);
    }

    public String padStart(int length, String chars) {
        return U.padStart(this.getString().get(), length, chars);
    }

    public String padEnd(int length) {
        return U.padEnd(this.getString().get(), length);
    }

    public String padEnd(int length, String chars) {
        return U.padEnd(this.getString().get(), length, chars);
    }

    public String snakeCase() {
        return U.snakeCase(this.getString().get());
    }

    public String startCase() {
        return U.startCase(this.getString().get());
    }

    public boolean startsWith(String target) {
        return U.startsWith(this.getString().get(), target);
    }

    public boolean startsWith(String target, Integer position) {
        return U.startsWith(this.getString().get(), target, position);
    }

    public String trim() {
        return U.trim(this.getString().get());
    }

    public String trimWith(String chars) {
        return U.trim(this.getString().get(), chars);
    }

    public String trimStart() {
        return U.trimStart(this.getString().get());
    }

    public String trimStartWith(String chars) {
        return U.trimStart(this.getString().get(), chars);
    }

    public String trimEnd() {
        return U.trimEnd(this.getString().get());
    }

    public String trimEndWith(String chars) {
        return U.trimEnd(this.getString().get(), chars);
    }

    public String trunc() {
        return U.trunc(this.getString().get());
    }

    public String trunc(int length) {
        return U.trunc(this.getString().get(), length);
    }

    public String uncapitalize() {
        return U.uncapitalize(this.getString().get());
    }

    public List<String> words() {
        return U.words(this.getString().get());
    }

    public static <K, V> LruCache<K, V> createLruCache(int capacity) {
        return new LruCache(capacity);
    }

    public static <T> List<List<T>> createPermutationWithRepetition(List<T> list, int permutationLength) {
        long resultSize = (long)Math.pow(list.size(), permutationLength);
        ArrayList<List<T>> result = new ArrayList<List<T>>((int)resultSize);
        int[] bitVector = new int[permutationLength];
        int index = 0;
        while ((long)index < resultSize) {
            int index3;
            ArrayList<T> result2 = new ArrayList<T>(permutationLength);
            for (int index2 = 0; index2 < permutationLength; ++index2) {
                result2.add(list.get(bitVector[index2]));
            }
            for (index3 = 0; index3 < permutationLength && bitVector[index3] == list.size() - 1; ++index3) {
                bitVector[index3] = 0;
            }
            if (index3 < permutationLength) {
                int n = index3;
                bitVector[n] = bitVector[n] + 1;
            }
            result.add(result2);
            ++index;
        }
        return result;
    }

    public List<List<T>> createPermutationWithRepetition(int permutationLength) {
        return U.createPermutationWithRepetition((List)this.value(), permutationLength);
    }

    protected static <T> List<T> newArrayList(Iterable<T> iterable) {
        return Underscore.newArrayList(iterable);
    }

    public static <T> String join(Iterable<T> iterable, String separator) {
        return Underscore.join(iterable, separator);
    }

    public static <T> String joinToString(Iterable<T> iterable, String separator, String prefix, String postfix, int limit, String truncated, Function<T, String> transform) {
        return Underscore.joinToString(iterable, separator, prefix, postfix, limit, truncated, transform);
    }

    public static String toJson(Collection collection) {
        return Json.toJson(collection);
    }

    public static String toJson(Map map) {
        return Json.toJson(map);
    }

    public String toJson() {
        return Json.toJson((Collection)this.getIterable());
    }

    public static <T> T fromXml(String xml) {
        return (T)Xml.fromXml(xml);
    }

    public static Map<String, Object> fromXmlMap(String xml) {
        return U.fromXmlMap(xml, Xml.FromType.FOR_CONVERT);
    }

    public static Map<String, Object> fromXmlMap(String xml, Xml.FromType fromType) {
        Object object = Xml.fromXml(xml, fromType);
        return U.getStringObjectMap(object);
    }

    public static <T> T fromXml(String xml, Xml.FromType fromType) {
        return (T)Xml.fromXml(xml, fromType);
    }

    public static <T> T fromXmlMakeArrays(String xml) {
        return (T)Xml.fromXmlMakeArrays(xml);
    }

    public static <T> T fromXmlWithoutNamespaces(String xml) {
        return (T)Xml.fromXmlWithoutNamespaces(xml);
    }

    public static Map<String, Object> fromXmlWithoutNamespacesMap(String xml) {
        Object object = Xml.fromXmlWithoutNamespaces(xml);
        return U.getStringObjectMap(object);
    }

    public static <T> T fromXmlWithoutAttributes(String xml) {
        return (T)Xml.fromXmlWithoutAttributes(xml);
    }

    public static <T> T fromXmlWithoutNamespacesAndAttributes(String xml) {
        return (T)Xml.fromXmlWithoutNamespacesAndAttributes(xml);
    }

    public static String toXml(Collection collection) {
        return Xml.toXml(collection);
    }

    public static String toXml(Map map) {
        return Xml.toXml(map);
    }

    public static <T> T fromJson(String string) {
        return (T)Json.fromJson(string);
    }

    public Object fromJson() {
        return Json.fromJson(this.getString().get());
    }

    public static Map<String, Object> fromJsonMap(String string) {
        Object object = Json.fromJson(string);
        return U.getStringObjectMap(object);
    }

    public static Map<String, Object> fromJsonMap(String string, int maxDepth) {
        Object object = Json.fromJson(string, maxDepth);
        return U.getStringObjectMap(object);
    }

    private static Map<String, Object> getStringObjectMap(Object object) {
        LinkedHashMap<String, Object> result;
        if (object instanceof Map) {
            result = (LinkedHashMap<String, Object>)object;
        } else {
            result = new LinkedHashMap<String, Object>();
            result.put("value", object);
        }
        return result;
    }

    public String toXml() {
        return Xml.toXml((Collection)this.getIterable());
    }

    public Object fromXml() {
        return Xml.fromXml(this.getString().get());
    }

    public static String jsonToXml(String json, Xml.XmlStringBuilder.Step identStep, JsonToXmlMode mode, String newRootName) {
        Object object = Json.fromJson(json);
        if (object instanceof Map) {
            String result;
            if (mode == JsonToXmlMode.FORCE_ATTRIBUTE_USAGE) {
                result = Xml.toXml(U.forceAttributeUsage((Map)object), identStep, newRootName);
            } else if (mode == JsonToXmlMode.DEFINE_ROOT_NAME) {
                result = Xml.toXml((Map)object, identStep, newRootName);
            } else if (mode == JsonToXmlMode.REPLACE_NULL_WITH_EMPTY_VALUE) {
                result = Xml.toXml(U.replaceNullWithEmptyValue((Map)object), identStep, newRootName);
            } else if (mode == JsonToXmlMode.REPLACE_EMPTY_STRING_WITH_EMPTY_VALUE) {
                result = Xml.toXml(U.replaceEmptyStringWithEmptyValue((Map)object), identStep, newRootName);
            } else if (mode == JsonToXmlMode.ADD_ROOT && !Xml.XmlValue.getMapKey(object).equals(ROOT)) {
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                map.put(newRootName, object);
                result = Xml.toXml(map, identStep);
            } else {
                result = mode == JsonToXmlMode.REMOVE_ARRAY_ATTRIBUTE ? Xml.toXml((Map)object, identStep, newRootName, Xml.ArrayTrue.SKIP) : (mode == JsonToXmlMode.REMOVE_ATTRIBUTES ? Xml.toXml(U.replaceNumberAndBooleanWithString((Map)object), identStep, newRootName, Xml.ArrayTrue.SKIP) : Xml.toXml((Map)object, identStep));
            }
            return result;
        }
        return Xml.toXml((List)object, identStep);
    }

    public static String jsonToXml(String json, Xml.XmlStringBuilder.Step identStep) {
        return U.jsonToXml(json, identStep, null, ROOT);
    }

    public static String jsonToXml(String json, JsonToXmlMode mode) {
        return U.jsonToXml(json, Xml.XmlStringBuilder.Step.TWO_SPACES, mode, ROOT);
    }

    public static String jsonToXml(String json, JsonToXmlMode mode, String newRootName) {
        return U.jsonToXml(json, Xml.XmlStringBuilder.Step.TWO_SPACES, mode, newRootName);
    }

    public static String jsonToXml(String json, String newRootName) {
        return U.jsonToXml(json, Xml.XmlStringBuilder.Step.TWO_SPACES, JsonToXmlMode.DEFINE_ROOT_NAME, newRootName);
    }

    public static String jsonToXml(String json) {
        return U.jsonToXml(json, Xml.XmlStringBuilder.Step.TWO_SPACES, null, null);
    }

    public static String jsonToXmlMinimum(String json, Xml.XmlStringBuilder.Step identStep) {
        Object object = Json.fromJson(json);
        if (object instanceof Map) {
            ((Map)object).put(OMIT_XML_DECL, YES);
            return Xml.toXml(U.replaceNumberAndBooleanWithString((Map)object), identStep);
        }
        return Xml.toXmlWithoutRoot((List)object, identStep);
    }

    public static String jsonToXmlMinimum(String json) {
        return U.jsonToXmlMinimum(json, Xml.XmlStringBuilder.Step.TWO_SPACES);
    }

    public static String xmlToJson(String xml, Json.JsonStringBuilder.Step identStep, XmlToJsonMode mode) {
        Object object = Xml.fromXml(xml);
        if (object instanceof Map) {
            String result = mode == XmlToJsonMode.REPLACE_SELF_CLOSING_WITH_NULL ? Json.toJson(U.replaceSelfClosingWithNull((Map)object), identStep) : (mode == XmlToJsonMode.REPLACE_SELF_CLOSING_WITH_STRING ? Json.toJson(U.replaceSelfClosingWithEmpty((Map)object), identStep) : (mode == XmlToJsonMode.REPLACE_EMPTY_VALUE_WITH_NULL ? Json.toJson(U.replaceEmptyValueWithNull((Map)object), identStep) : (mode == XmlToJsonMode.REPLACE_MINUS_WITH_AT ? Json.toJson(U.replaceMinusWithAt((Map)object), identStep) : (mode == XmlToJsonMode.REPLACE_EMPTY_TAG_WITH_NULL_AND_MINUS_WITH_AT ? Json.toJson(U.replaceMinusWithAt(U.replaceEmptyValueWithNull(U.replaceSelfClosingWithNull((Map)object))), identStep) : (mode == XmlToJsonMode.REPLACE_EMPTY_TAG_WITH_NULL ? Json.toJson(U.replaceEmptyValueWithNull(U.replaceSelfClosingWithNull((Map)object)), identStep) : (mode == XmlToJsonMode.REPLACE_EMPTY_TAG_WITH_STRING ? Json.toJson((Map)U.replaceEmptyValueWithEmptyString(U.replaceSelfClosingWithEmpty((Map)object)), identStep) : (mode == XmlToJsonMode.REMOVE_FIRST_LEVEL ? Json.toJson(U.replaceFirstLevel((Map)object), identStep) : (mode == XmlToJsonMode.WITHOUT_NAMESPACES ? Json.toJson((Map)Xml.fromXmlWithoutNamespaces(xml), identStep) : Json.toJson((Map)object, identStep)))))))));
            return result;
        }
        return Json.toJson((List)object, identStep);
    }

    public static String xmlToJson(String xml) {
        return U.xmlToJson(xml, Json.JsonStringBuilder.Step.TWO_SPACES, null);
    }

    public static String xmlToJsonMinimum(String xml, Json.JsonStringBuilder.Step identStep) {
        Object object = Xml.fromXml(xml);
        if (object instanceof Map) {
            ((Map)object).remove(OMIT_XML_DECL);
            return Json.toJson(U.replaceSelfClosingWithEmpty((Map)object), identStep);
        }
        return Json.toJson((List)object, identStep);
    }

    public static String xmlToJsonMinimum(String xml) {
        return U.xmlToJsonMinimum(xml, Json.JsonStringBuilder.Step.TWO_SPACES);
    }

    public static String xmlToJson(String xml, Json.JsonStringBuilder.Step identStep) {
        return U.xmlToJson(xml, identStep, null);
    }

    public static String xmlToJson(String xml, XmlToJsonMode mode) {
        return U.xmlToJson(xml, Json.JsonStringBuilder.Step.TWO_SPACES, mode);
    }

    public static void fileXmlToJson(String xmlFileName, String jsonFileName, Json.JsonStringBuilder.Step identStep) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(xmlFileName, new String[0]));
        String xmlText = new String(U.removeBom(bytes), U.detectEncoding(bytes));
        Files.write(Paths.get(jsonFileName, new String[0]), U.formatString(U.xmlToJson(xmlText, identStep), System.lineSeparator()).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static void fileXmlToJson(String xmlFileName, String jsonFileName) throws IOException {
        U.fileXmlToJson(xmlFileName, jsonFileName, Json.JsonStringBuilder.Step.TWO_SPACES);
    }

    public static void streamXmlToJson(InputStream xmlInputStream, OutputStream jsonOutputStream, Json.JsonStringBuilder.Step indentStep) throws IOException {
        byte[] bytes = xmlInputStream.readAllBytes();
        String encoding = U.detectEncoding(bytes);
        String xmlText = new String(U.removeBom(bytes), encoding);
        String jsonText = U.xmlToJson(xmlText, indentStep);
        String formattedJson = U.formatString(jsonText, System.lineSeparator());
        jsonOutputStream.write(formattedJson.getBytes(StandardCharsets.UTF_8));
    }

    public static void streamXmlToJson(InputStream xmlInputStream, OutputStream jsonOutputStream) throws IOException {
        U.streamXmlToJson(xmlInputStream, jsonOutputStream, Json.JsonStringBuilder.Step.TWO_SPACES);
    }

    public static void fileJsonToXml(String jsonFileName, String xmlFileName, Xml.XmlStringBuilder.Step identStep) throws IOException {
        byte[] bytes = Files.readAllBytes(Paths.get(jsonFileName, new String[0]));
        String jsonText = new String(U.removeBom(bytes), U.detectEncoding(bytes));
        Object result = U.fromJson(jsonText);
        Path xmlFilePath = Paths.get(xmlFileName, new String[0]);
        String lineSeparator = System.lineSeparator();
        if (result instanceof Map) {
            if (((Map)result).containsKey(ENCODING)) {
                String encoding = String.valueOf(((Map)result).get(ENCODING));
                Files.write(xmlFilePath, U.formatString(Xml.toXml((Map)result, identStep), lineSeparator).getBytes(encoding), new OpenOption[0]);
            } else {
                Files.write(xmlFilePath, U.formatString(Xml.toXml((Map)result, identStep), lineSeparator).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
        } else {
            Files.write(xmlFilePath, U.formatString(Xml.toXml((List)result, identStep), lineSeparator).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
    }

    public static void fileJsonToXml(String jsonFileName, String xmlFileName) throws IOException {
        U.fileJsonToXml(jsonFileName, xmlFileName, Xml.XmlStringBuilder.Step.TWO_SPACES);
    }

    public static void jsonFolderToXml(String jsonFolder, String xmlFolder, final Xml.XmlStringBuilder.Step identStep) throws IOException {
        final Path sourceRoot = Paths.get(jsonFolder, new String[0]);
        final Path targetRoot = Paths.get(xmlFolder, new String[0]);
        Files.walkFileTree(sourceRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                U.covertJsonToXml(path, sourceRoot, targetRoot, identStep);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void jsonFolderToXml(String jsonFolder, String xmlFolder) throws IOException {
        U.jsonFolderToXml(jsonFolder, xmlFolder, Xml.XmlStringBuilder.Step.TWO_SPACES);
    }

    public static void covertJsonToXml(Path path, Path sourceRoot, Path targetRoot, Xml.XmlStringBuilder.Step identStep) throws IOException {
        Path relativePath = sourceRoot.relativize(path);
        String fileName = relativePath.getFileName().toString();
        if (!fileName.endsWith(".json")) {
            return;
        }
        String xmlFileName = fileName.substring(0, fileName.length() - 5) + ".xml";
        Path targetPath = targetRoot.resolve(relativePath).getParent().resolve(xmlFileName);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        U.fileJsonToXml(path.toAbsolutePath().toString(), targetPath.toString(), identStep);
    }

    public static void xmlFolderToJson(String xmlFolder, String jsonFolder, final Json.JsonStringBuilder.Step identStep) throws IOException {
        final Path sourceRoot = Paths.get(xmlFolder, new String[0]);
        final Path targetRoot = Paths.get(jsonFolder, new String[0]);
        Files.walkFileTree(sourceRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                U.covertXmlToJson(path, sourceRoot, targetRoot, identStep);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void xmlFolderToJson(String xmlFolder, String jsonFolder) throws IOException {
        U.xmlFolderToJson(xmlFolder, jsonFolder, Json.JsonStringBuilder.Step.TWO_SPACES);
    }

    public static void covertXmlToJson(Path path, Path sourceRoot, Path targetRoot, Json.JsonStringBuilder.Step identStep) throws IOException {
        Path relativePath = sourceRoot.relativize(path);
        String fileName = relativePath.getFileName().toString();
        if (!fileName.endsWith(".xml")) {
            return;
        }
        String xmlFileName = fileName.substring(0, fileName.length() - 4) + ".json";
        Path targetPath = targetRoot.resolve(relativePath).getParent().resolve(xmlFileName);
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        U.fileXmlToJson(path.toAbsolutePath().toString(), targetPath.toString(), identStep);
    }

    public static void streamJsonToXml(InputStream jsonInputStream, OutputStream xmlOutputStream, Xml.XmlStringBuilder.Step identStep) throws IOException {
        byte[] bytes = jsonInputStream.readAllBytes();
        String jsonText = new String(U.removeBom(bytes), U.detectEncoding(bytes));
        Object jsonObject = U.fromJson(jsonText);
        String lineSeparator = System.lineSeparator();
        if (jsonObject instanceof Map) {
            String xml = U.formatString(Xml.toXml((Map)jsonObject, identStep), lineSeparator);
            if (((Map)jsonObject).containsKey(ENCODING)) {
                String encoding = String.valueOf(((Map)jsonObject).get(ENCODING));
                xmlOutputStream.write(xml.getBytes(encoding));
            } else {
                xmlOutputStream.write(xml.getBytes(StandardCharsets.UTF_8));
            }
        } else {
            String xml = U.formatString(Xml.toXml((List)jsonObject, identStep), lineSeparator);
            xmlOutputStream.write(xml.getBytes(StandardCharsets.UTF_8));
        }
    }

    public static void streamJsonToXml(InputStream jsonInputStream, OutputStream xmlOutputStream) throws IOException {
        U.streamJsonToXml(jsonInputStream, xmlOutputStream, Xml.XmlStringBuilder.Step.TWO_SPACES);
    }

    public static byte[] removeBom(byte[] bytes) {
        if (bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return Arrays.copyOfRange(bytes, 3, bytes.length);
        }
        if (bytes.length >= 2 && bytes[0] == -1 && bytes[1] == -2) {
            return Arrays.copyOfRange(bytes, 2, bytes.length);
        }
        if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
            return Arrays.copyOfRange(bytes, 2, bytes.length);
        }
        return bytes;
    }

    public static String detectEncoding(byte[] buffer) {
        if (buffer.length < 4) {
            return "UTF8";
        }
        String encoding = null;
        int n = (buffer[0] & 0xFF) << 24 | (buffer[1] & 0xFF) << 16 | (buffer[2] & 0xFF) << 8 | buffer[3] & 0xFF;
        block0 : switch (n) {
            case 60: 
            case 65279: {
                encoding = "UTF_32BE";
                break;
            }
            case 3932223: {
                encoding = "UnicodeBigUnmarked";
                break;
            }
            case -131072: 
            case 0x3C000000: {
                encoding = "UTF_32LE";
                break;
            }
            case 1006649088: {
                encoding = "UnicodeLittleUnmarked";
                break;
            }
            case 1010792557: {
                encoding = "UTF8";
                break;
            }
            default: {
                if (n >>> 8 == 0xEFBBBF) {
                    encoding = "UTF8";
                    break;
                }
                if (n >>> 24 == 60) break;
                switch (n >>> 16) {
                    case 65534: {
                        encoding = "UnicodeLittleUnmarked";
                        break block0;
                    }
                    case 65279: {
                        encoding = "UnicodeBigUnmarked";
                        break block0;
                    }
                }
            }
        }
        return encoding == null ? "UTF8" : encoding;
    }

    public static String formatString(String data, String lineSeparator) {
        if ("\n".equals(lineSeparator)) {
            return data;
        }
        return data.replace("\n", lineSeparator);
    }

    public static String xmlOrJsonToJson(String xmlOrJson, Json.JsonStringBuilder.Step identStep) {
        TextType textType = U.getTextType(xmlOrJson);
        String result = textType == TextType.JSON ? U.getJsonString(identStep, U.fromJson(xmlOrJson)) : (textType == TextType.XML ? U.getJsonString(identStep, U.fromXml(xmlOrJson)) : xmlOrJson);
        return result;
    }

    public static String xmlOrJsonToJson(String xmlOrJson) {
        return U.xmlOrJsonToJson(xmlOrJson, Json.JsonStringBuilder.Step.TWO_SPACES);
    }

    public static String mergeXmlsOrJsonsToJson(List<String> xmlsOrJsons, Json.JsonStringBuilder.Step identStep) {
        Map<String, Object> resultJsonMap = new LinkedHashMap<String, Object>();
        for (String xmlOrJsonToJson : xmlsOrJsons) {
            Map<String, Object> jsonOrXmlMap;
            TextType textType = U.getTextType(xmlOrJsonToJson);
            if (textType == TextType.JSON) {
                jsonOrXmlMap = U.fromJsonMap(xmlOrJsonToJson);
            } else {
                if (textType != TextType.XML) continue;
                jsonOrXmlMap = U.fromXmlMap(xmlOrJsonToJson);
            }
            resultJsonMap = U.update(resultJsonMap, jsonOrXmlMap);
        }
        return resultJsonMap.isEmpty() ? "" : Json.toJson(resultJsonMap, identStep);
    }

    public static String mergeXmlsOrJsonsToJson(List<String> xmlsOrJsons) {
        return U.mergeXmlsOrJsonsToJson(xmlsOrJsons, Json.JsonStringBuilder.Step.TWO_SPACES);
    }

    public static String mergeXmlsOrJsonsToXml(List<String> xmlsOrJsons, Xml.XmlStringBuilder.Step identStep) {
        Map<String, Object> resultXmlMap = new LinkedHashMap<String, Object>();
        for (String xmlOrJsonToXml : xmlsOrJsons) {
            Map<String, Object> jsonOrXmlMap;
            TextType textType = U.getTextType(xmlOrJsonToXml);
            if (textType == TextType.JSON) {
                jsonOrXmlMap = U.fromJsonMap(xmlOrJsonToXml);
            } else {
                if (textType != TextType.XML) continue;
                jsonOrXmlMap = U.fromXmlMap(xmlOrJsonToXml);
            }
            resultXmlMap = U.update(resultXmlMap, jsonOrXmlMap);
        }
        return resultXmlMap.isEmpty() ? "" : Xml.toXml(resultXmlMap, identStep);
    }

    public static String mergeXmlsOrJsonsToXml(List<String> xmlsOrJsons) {
        return U.mergeXmlsOrJsonsToXml(xmlsOrJsons, Xml.XmlStringBuilder.Step.TWO_SPACES);
    }

    private static String getJsonString(Json.JsonStringBuilder.Step identStep, Object object) {
        String result = object instanceof Map ? Json.toJson((Map)object, identStep) : Json.toJson((List)object, identStep);
        return result;
    }

    public static String xmlOrJsonToXml(String xmlOrJson, Xml.XmlStringBuilder.Step identStep) {
        TextType textType = U.getTextType(xmlOrJson);
        String result = textType == TextType.JSON ? U.getXmlString(identStep, U.fromJson(xmlOrJson)) : (textType == TextType.XML ? U.getXmlString(identStep, U.fromXml(xmlOrJson)) : xmlOrJson);
        return result;
    }

    public static String xmlOrJsonToXml(String xmlOrJson) {
        return U.xmlOrJsonToXml(xmlOrJson, Xml.XmlStringBuilder.Step.TWO_SPACES);
    }

    private static String getXmlString(Xml.XmlStringBuilder.Step identStep, Object object) {
        String result = object instanceof Map ? Xml.toXml((Map)object, identStep) : Xml.toXml((List)object, identStep);
        return result;
    }

    public static TextType getTextType(String text) {
        String trimmed = U.trim(text);
        TextType textType = trimmed.startsWith("{") && trimmed.endsWith("}") || trimmed.startsWith("[") && trimmed.endsWith("]") ? TextType.JSON : (trimmed.startsWith("<") && trimmed.endsWith(">") ? TextType.XML : TextType.OTHER);
        return textType;
    }

    public static String formatJsonOrXml(String jsonOrXml, String identStep) {
        TextType textType = U.getTextType(jsonOrXml);
        String result = textType == TextType.JSON ? U.formatJson(jsonOrXml, Json.JsonStringBuilder.Step.valueOf(identStep)) : (textType == TextType.XML ? U.formatXml(jsonOrXml, Xml.XmlStringBuilder.Step.valueOf(identStep)) : jsonOrXml);
        return result;
    }

    public static String formatJsonOrXml(String jsonOrXml) {
        return U.formatJsonOrXml(jsonOrXml, "TWO_SPACES");
    }

    public static String formatJson(String json, Json.JsonStringBuilder.Step identStep) {
        return Json.formatJson(json, identStep);
    }

    public static String formatJson(String json) {
        return Json.formatJson(json);
    }

    public static String formatXml(String xml, Xml.XmlStringBuilder.Step identStep) {
        return Xml.formatXml(xml, identStep);
    }

    public static String formatXml(String xml) {
        return Xml.formatXml(xml);
    }

    public static String changeXmlEncoding(String xml, Xml.XmlStringBuilder.Step identStep, String encoding) {
        return Xml.changeXmlEncoding(xml, identStep, encoding);
    }

    public static String changeXmlEncoding(String xml, String encoding) {
        return Xml.changeXmlEncoding(xml, encoding);
    }

    public static Map<String, Object> removeMinusesAndConvertNumbers(Map<String, Object> map) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String newKey = entry.getKey().startsWith("-") ? entry.getKey().substring(1) : entry.getKey();
            if (entry.getKey().equals(SELF_CLOSING) || entry.getKey().equals(OMIT_XML_DECL)) continue;
            outMap.put(newKey, U.makeObject(entry.getValue()));
        }
        return outMap;
    }

    private static Object makeObject(Object value) {
        Object result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)value) {
                values.add(item instanceof Map ? U.removeMinusesAndConvertNumbers((Map)item) : item);
            }
            result = values;
        } else {
            String stringValue;
            result = value instanceof Map ? U.removeMinusesAndConvertNumbers((Map)value) : (U.isJsonNumber(stringValue = String.valueOf(value)) ? Xml.stringToNumber(stringValue) : value);
        }
        return result;
    }

    public static boolean isJsonNumber(String string) {
        boolean eFound = false;
        boolean periodValid = true;
        boolean pmValid = true;
        boolean numberEncountered = false;
        for (char ch : string.toCharArray()) {
            if (pmValid) {
                pmValid = false;
                if (ch == '-') continue;
            }
            if (!(eFound || ch != 'e' && ch != 'E')) {
                eFound = true;
                periodValid = false;
                pmValid = true;
                numberEncountered = false;
                continue;
            }
            if (periodValid && ch == '.') {
                periodValid = false;
                continue;
            }
            if (ch < '0' || ch > '9') {
                return false;
            }
            numberEncountered = true;
        }
        return numberEncountered;
    }

    public static Map<String, Object> replaceSelfClosingWithNull(Map<String, Object> map) {
        return (Map)U.replaceSelfClosingWithValue(map, null);
    }

    public static Map<String, Object> replaceSelfClosingWithEmpty(Map<String, Object> map) {
        Object result = U.replaceSelfClosingWithValue(map, "");
        if (result instanceof Map) {
            return (Map)result;
        }
        return Collections.emptyMap();
    }

    public static Object replaceSelfClosingWithValue(Map<String, Object> map, String value) {
        Object outMap = new LinkedHashMap();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (SELF_CLOSING.equals(entry.getKey()) && "true".equals(entry.getValue())) {
                if (map.size() != 1) continue;
                outMap = value;
                break;
            }
            ((Map)outMap).put(String.valueOf(entry.getKey()), U.makeObjectSelfClose(entry.getValue(), value));
        }
        return outMap;
    }

    private static Object makeObjectSelfClose(Object value, String newValue) {
        Object result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)value) {
                values.add(item instanceof Map ? U.replaceSelfClosingWithValue((Map)item, newValue) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.replaceSelfClosingWithValue((Map)((Object)value), newValue) : value;
        }
        return result;
    }

    public static Map<String, Object> replaceMinusWithAt(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            outMap.put((String)(String.valueOf(entry.getKey()).startsWith("-") ? "@" + String.valueOf(entry.getKey()).substring(1) : String.valueOf(entry.getKey())), U.replaceMinusWithAtValue(entry.getValue()));
        }
        return outMap;
    }

    private static Object replaceMinusWithAtValue(Object value) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.replaceMinusWithAt((Map)item) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.replaceMinusWithAt(value) : value;
        }
        return result;
    }

    public static Map<String, Object> replaceEmptyValueWithNull(Map<String, Object> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            outMap.put(String.valueOf(entry.getKey()), U.makeObjectEmptyValue(entry.getValue()));
        }
        return outMap;
    }

    private static Object makeObjectEmptyValue(Object value) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.replaceEmptyValueWithNull((Map)item) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.replaceEmptyValueWithNull(value) : value;
        }
        return result;
    }

    public static Object replaceEmptyValueWithEmptyString(Map<String, Object> map) {
        if (map.isEmpty()) {
            return "";
        }
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            outMap.put(String.valueOf(entry.getKey()), U.makeObjectEmptyString(entry.getValue()));
        }
        return outMap;
    }

    private static Object makeObjectEmptyString(Object value) {
        Object result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)value) {
                values.add(item instanceof Map ? U.replaceEmptyValueWithEmptyString((Map)item) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.replaceEmptyValueWithEmptyString((Map)((Object)value)) : value;
        }
        return result;
    }

    public static Map<String, Object> forceAttributeUsage(Map<String, Object> map) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            outMap.put((String)(entry.getValue() instanceof Map || entry.getValue() instanceof List || String.valueOf(entry.getKey()).startsWith("-") ? String.valueOf(entry.getKey()) : "-" + entry.getKey()), U.makeAttributeUsage(entry.getValue()));
        }
        return outMap;
    }

    private static Object makeAttributeUsage(Object value) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.forceAttributeUsage((Map)item) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.forceAttributeUsage(value) : value;
        }
        return result;
    }

    public static Map<String, Object> replaceNullWithEmptyValue(Map<String, Object> map) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            outMap.put(entry.getKey(), entry.getValue() == null ? new LinkedHashMap() : U.makeReplaceNullValue(entry.getValue()));
        }
        return outMap;
    }

    private static Object makeReplaceNullValue(Object value) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.replaceNullWithEmptyValue((Map)item) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.replaceNullWithEmptyValue(value) : value;
        }
        return result;
    }

    public static Map<String, Object> replaceEmptyStringWithEmptyValue(Map<String, Object> map) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            outMap.put(entry.getKey(), "".equals(entry.getValue()) ? new LinkedHashMap() : U.makeReplaceEmptyString(entry.getValue()));
        }
        return outMap;
    }

    private static Object makeReplaceEmptyString(Object value) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.replaceEmptyStringWithEmptyValue((Map)item) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.replaceEmptyStringWithEmptyValue(value) : value;
        }
        return result;
    }

    public static Map<String, Object> replaceNumberAndBooleanWithString(Map<String, Object> map) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            outMap.put(entry.getKey(), entry.getValue() instanceof Boolean || entry.getValue() instanceof Number ? String.valueOf(entry.getValue()) : U.makeReplaceNumberAndBoolean(entry.getValue()));
        }
        return outMap;
    }

    private static Object makeReplaceNumberAndBoolean(Object value) {
        Object result;
        if (value instanceof List) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object item : (List)value) {
                if (item instanceof Map) {
                    values.add(U.replaceNumberAndBooleanWithString((Map)item));
                    continue;
                }
                if (item instanceof Number || item instanceof Boolean || U.isNull(item)) {
                    values.add(String.valueOf(item));
                    continue;
                }
                values.add(item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.replaceNumberAndBooleanWithString((Map)value) : (U.isNull(value) ? "null" : value);
        }
        return result;
    }

    public static Map<String, Object> replaceFirstLevel(Map<String, Object> map) {
        return U.replaceFirstLevel(map, 0);
    }

    public static Map<String, Object> replaceFirstLevel(Map<String, Object> map, int level) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            outMap.put(entry.getKey(), U.makeReplaceFirstLevel(entry.getValue(), level + 1));
        }
        if (level == 0 && Xml.XmlValue.getMapValue(outMap) instanceof Map) {
            Map outMap2 = (Map)Xml.XmlValue.getMapValue(outMap);
            if (SELF_CLOSING.equals(Xml.XmlValue.getMapKey(outMap2)) && "true".equals(Xml.XmlValue.getMapValue(outMap2))) {
                outMap2.remove(SELF_CLOSING);
            }
            return outMap2;
        }
        return outMap;
    }

    private static Object makeReplaceFirstLevel(Object value, int level) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.replaceFirstLevel((Map)item, level + 1) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.replaceFirstLevel(value, level + 1) : value;
        }
        return result;
    }

    public static Map<String, Object> replaceNilWithNull(Map<String, Object> map) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object outValue = U.makeReplaceNilWithNull(entry.getValue());
            if (outValue instanceof Map && (NIL_KEY.equals(Xml.XmlValue.getMapKey(outValue)) || Xml.XmlValue.getMapKey(outValue).endsWith(":nil")) && "true".equals(Xml.XmlValue.getMapValue(outValue)) && ((Map)outValue).containsKey(SELF_CLOSING) && "true".equals(((Map)outValue).get(SELF_CLOSING))) {
                outValue = null;
            }
            outMap.put(entry.getKey(), outValue);
        }
        return outMap;
    }

    private static Object makeReplaceNilWithNull(Object value) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.replaceNilWithNull((Map)item) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.replaceNilWithNull(value) : value;
        }
        return result;
    }

    public static Map<String, Object> deepCopyMap(Map<String, Object> map) {
        LinkedHashMap<String, Object> outMap = new LinkedHashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            outMap.put(entry.getKey(), U.makeDeepCopyMap(entry.getValue()));
        }
        return outMap;
    }

    private static Object makeDeepCopyMap(Object value) {
        Map<String, Object> result;
        if (value instanceof List) {
            ArrayList values = new ArrayList();
            for (Object item : (List)((Object)value)) {
                values.add(item instanceof Map ? U.deepCopyMap((Map)item) : item);
            }
            result = values;
        } else {
            result = value instanceof Map ? U.deepCopyMap(value) : value;
        }
        return result;
    }

    public static Builder objectBuilder() {
        return new Builder();
    }

    public static ArrayBuilder arrayBuilder() {
        return new ArrayBuilder();
    }

    public static Map<String, Object> propertiesToMap(Properties properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (properties != null && !properties.isEmpty()) {
            Enumeration<?> enumProperties = properties.propertyNames();
            while (enumProperties.hasMoreElements()) {
                String name = (String)enumProperties.nextElement();
                map.put(name, properties.getProperty(name));
            }
        }
        return map;
    }

    public static Properties mapToProperties(Map<String, Object> map) {
        Properties properties = new Properties();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                if (U.isNull(entry.getValue())) continue;
                properties.put(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        return properties;
    }

    static {
        String[] deburredLetters = new String[]{"\u00c0", "A", "\u00c1", "A", "\u00c2", "A", "\u00c3", "A", "\u00c4", "A", "\u00c5", "A", "\u00e0", "a", "\u00e1", "a", "\u00e2", "a", "\u00e3", "a", "\u00e4", "a", "\u00e5", "a", "\u00c7", "C", "\u00e7", "c", "\u00d0", "D", "\u00f0", "d", "\u00c8", "E", "\u00c9", "E", "\u00ca", "E", "\u00cb", "E", "\u00e8", "e", "\u00e9", "e", "\u00ea", "e", "\u00eb", "e", "\u00cc", "I", "\u00cd", "I", "\u00ce", "I", "\u00cf", "I", "\u00ec", "i", "\u00ed", "i", "\u00ee", "i", "\u00ef", "i", "\u00d1", "N", "\u00f1", "n", "\u00d2", "O", "\u00d3", "O", "\u00d4", "O", "\u00d5", "O", "\u00d6", "O", "\u00d8", "O", "\u00f2", "o", "\u00f3", "o", "\u00f4", "o", "\u00f5", "o", "\u00f6", "o", "\u00f8", "o", "\u00d9", "U", "\u00da", "U", "\u00db", "U", "\u00dc", "U", "\u00f9", "u", "\u00fa", "u", "\u00fb", "u", "\u00fc", "u", "\u00dd", "Y", "\u00fd", "y", "\u00ff", "y", "\u00c6", "Ae", "\u00e6", "ae", "\u00de", "Th", "\u00fe", "th", "\u00df", "ss"};
        for (int index = 0; index < deburredLetters.length; index += 2) {
            DEBURRED_LETTERS.put(deburredLetters[index], deburredLetters[index + 1]);
        }
        DEFAULT_HEADER_FIELDS.put("Content-Type", Arrays.asList("application/json", "charset=utf-8"));
    }

    public static class Chain<T>
    extends Underscore.Chain<T> {
        public Chain(T item) {
            super(item);
        }

        public Chain(List<T> list) {
            super(list);
        }

        public Chain(Map<String, Object> map) {
            super(map);
        }

        @Override
        public Chain<T> first() {
            return new Chain(Underscore.first(this.value()));
        }

        @Override
        public Chain<T> first(int n) {
            return new Chain(Underscore.first(this.value(), n));
        }

        @Override
        public Chain<T> firstOrNull() {
            return new Chain(Underscore.firstOrNull(this.value()));
        }

        @Override
        public Chain<T> firstOrNull(Predicate<T> pred) {
            return new Chain(Underscore.firstOrNull(this.value(), pred));
        }

        @Override
        public Chain<T> initial() {
            return new Chain(Underscore.initial(this.value()));
        }

        @Override
        public Chain<T> initial(int n) {
            return new Chain(Underscore.initial(this.value(), n));
        }

        @Override
        public Chain<T> last() {
            return new Chain(Underscore.last(this.value()));
        }

        @Override
        public Chain<T> last(int n) {
            return new Chain(Underscore.last(this.value(), n));
        }

        @Override
        public Chain<T> lastOrNull() {
            return new Chain(Underscore.lastOrNull(this.value()));
        }

        @Override
        public Chain<T> lastOrNull(Predicate<T> pred) {
            return new Chain(Underscore.lastOrNull(this.value(), pred));
        }

        @Override
        public Chain<T> rest() {
            return new Chain(Underscore.rest(this.value()));
        }

        @Override
        public Chain<T> rest(int n) {
            return new Chain(Underscore.rest(this.value(), n));
        }

        @Override
        public Chain<T> compact() {
            return new Chain(Underscore.compact(this.value()));
        }

        @Override
        public Chain<T> compact(T falsyValue) {
            return new Chain(Underscore.compactList(this.value(), falsyValue));
        }

        @Override
        public Chain flatten() {
            return new Chain(Underscore.flatten(this.value()));
        }

        @Override
        public <F> Chain<F> map(Function<? super T, F> func) {
            return new Chain<F>(Underscore.map(this.value(), func));
        }

        @Override
        public <F> Chain<F> mapMulti(BiConsumer<? super T, ? super Consumer<F>> mapper) {
            return new Chain(Underscore.mapMulti(this.value(), mapper));
        }

        @Override
        public <F> Chain<F> mapIndexed(BiFunction<Integer, ? super T, F> func) {
            return new Chain<F>(Underscore.mapIndexed(this.value(), func));
        }

        @Override
        public Chain<T> filter(Predicate<T> pred) {
            return new Chain(Underscore.filter(this.value(), pred));
        }

        @Override
        public Chain<T> filterIndexed(Underscore.PredicateIndexed<T> pred) {
            return new Chain(Underscore.filterIndexed(this.value(), pred));
        }

        @Override
        public Chain<T> rejectIndexed(Underscore.PredicateIndexed<T> pred) {
            return new Chain(Underscore.rejectIndexed(this.value(), pred));
        }

        @Override
        public Chain<T> reject(Predicate<T> pred) {
            return new Chain(Underscore.reject(this.value(), pred));
        }

        @Override
        public Chain<T> filterFalse(Predicate<T> pred) {
            return new Chain(Underscore.filterFalse(this.value(), pred));
        }

        @Override
        public <F> Chain<F> reduce(BiFunction<F, T, F> func, F zeroElem) {
            return new Chain<F>(Underscore.reduce(this.value(), func, zeroElem));
        }

        @Override
        public Chain<Optional<T>> reduce(BinaryOperator<T> func) {
            return new Chain(Underscore.reduce(this.value(), func));
        }

        @Override
        public <F> Chain<F> reduceRight(BiFunction<F, T, F> func, F zeroElem) {
            return new Chain<F>(Underscore.reduceRight(this.value(), func, zeroElem));
        }

        @Override
        public Chain<Optional<T>> reduceRight(BinaryOperator<T> func) {
            return new Chain(Underscore.reduceRight(this.value(), func));
        }

        @Override
        public Chain<Optional<T>> find(Predicate<T> pred) {
            return new Chain(Underscore.find(this.value(), pred));
        }

        @Override
        public Chain<Optional<T>> findLast(Predicate<T> pred) {
            return new Chain(Underscore.findLast(this.value(), pred));
        }

        public Chain<Comparable> max() {
            return new Chain<Comparable>((Comparable)Underscore.max(this.value()));
        }

        @Override
        public <F extends Comparable<? super F>> Chain<T> max(Function<T, F> func) {
            return new Chain(Underscore.max(this.value(), func));
        }

        public Chain<Comparable> min() {
            return new Chain<Comparable>((Comparable)Underscore.min(this.value()));
        }

        @Override
        public <F extends Comparable<? super F>> Chain<T> min(Function<T, F> func) {
            return new Chain(Underscore.min(this.value(), func));
        }

        public Chain<Comparable> sort() {
            return new Chain<Comparable>(Underscore.sort(this.value()));
        }

        @Override
        public <F extends Comparable<? super F>> Chain<F> sortWith(Comparator<F> comparator) {
            return new Chain(Underscore.sortWith(this.value(), comparator));
        }

        @Override
        public <F extends Comparable<? super F>> Chain<T> sortBy(Function<T, F> func) {
            return new Chain(Underscore.sortBy(this.value(), func));
        }

        @Override
        public <K> Chain<Map<K, Comparable>> sortBy(K key) {
            return new Chain<Map<K, Comparable>>(Underscore.sortBy(this.value(), key));
        }

        @Override
        public <F> Chain<Map<F, List<T>>> groupBy(Function<T, F> func) {
            return new Chain(Underscore.groupBy(this.value(), func));
        }

        @Override
        public <F> Chain<Map<F, T>> associateBy(Function<T, F> func) {
            return new Chain(Underscore.associateBy(this.value(), func));
        }

        @Override
        public <F> Chain<Map<F, Optional<T>>> groupBy(Function<T, F> func, BinaryOperator<T> binaryOperator) {
            return new Chain(Underscore.groupBy(this.value(), func, binaryOperator));
        }

        @Override
        public Chain<Map<Object, List<T>>> indexBy(String property) {
            return new Chain<Map<Object, List<T>>>(Underscore.indexBy(this.value(), property));
        }

        @Override
        public <F> Chain<Map<F, Integer>> countBy(Function<T, F> func) {
            return new Chain<Map<F, Integer>>(Underscore.countBy(this.value(), func));
        }

        @Override
        public Chain<Map<T, Integer>> countBy() {
            return new Chain(Underscore.countBy(this.value()));
        }

        @Override
        public Chain<T> shuffle() {
            return new Chain(Underscore.shuffle(this.value()));
        }

        @Override
        public Chain<T> sample() {
            return new Chain(Underscore.sample(this.value()));
        }

        @Override
        public Chain<T> sample(int howMany) {
            return new Chain(U.newArrayList(Underscore.sample(this.value(), howMany)));
        }

        @Override
        public Chain<T> tap(Consumer<T> func) {
            Underscore.tap(this.value(), func);
            return new Chain(this.value());
        }

        @Override
        public Chain<T> forEach(Consumer<T> func) {
            Underscore.forEach(this.value(), func);
            return new Chain(this.value());
        }

        @Override
        public Chain<T> forEachRight(Consumer<T> func) {
            Underscore.forEachRight(this.value(), func);
            return new Chain(this.value());
        }

        public Chain<Boolean> every(Predicate<T> pred) {
            return new Chain<Boolean>(Underscore.every(this.value(), pred));
        }

        public Chain<Boolean> some(Predicate<T> pred) {
            return new Chain<Boolean>(Underscore.some(this.value(), pred));
        }

        public Chain<Integer> count(Predicate<T> pred) {
            return new Chain<Integer>(Underscore.count(this.value(), pred));
        }

        public Chain<Boolean> contains(T elem) {
            return new Chain<Boolean>(Underscore.contains(this.value(), elem));
        }

        public Chain<Boolean> containsWith(T elem) {
            return new Chain<Boolean>(Underscore.containsWith(this.value(), elem));
        }

        @Override
        public Chain<T> invoke(String methodName, List<Object> args) {
            return new Chain(Underscore.invoke(this.value(), methodName, args));
        }

        @Override
        public Chain<T> invoke(String methodName) {
            return new Chain(Underscore.invoke(this.value(), methodName));
        }

        public Chain<Object> pluck(String propertyName) {
            return new Chain<Object>(Underscore.pluck(this.value(), propertyName));
        }

        @Override
        public <E> Chain<T> where(List<Map.Entry<String, E>> properties) {
            return new Chain(Underscore.where(this.value(), properties));
        }

        @Override
        public <E> Chain<Optional<T>> findWhere(List<Map.Entry<String, E>> properties) {
            return new Chain(Underscore.findWhere(this.value(), properties));
        }

        @Override
        public Chain<T> uniq() {
            return new Chain(Underscore.uniq(this.value()));
        }

        @Override
        public <F> Chain<T> uniq(Function<T, F> func) {
            return new Chain(U.newArrayList(Underscore.uniq(this.value(), func)));
        }

        @Override
        public Chain<T> distinct() {
            return new Chain(Underscore.uniq(this.value()));
        }

        @Override
        public <F> Chain<F> distinctBy(Function<T, F> func) {
            return new Chain(U.newArrayList(Underscore.uniq(this.value(), func)));
        }

        @Override
        public Chain<T> union(List<T> ... lists) {
            return new Chain(Underscore.union(this.value(), lists));
        }

        @Override
        public Chain<T> intersection(List<T> ... lists) {
            return new Chain(Underscore.intersection(this.value(), lists));
        }

        @Override
        public Chain<T> difference(List<T> ... lists) {
            return new Chain(Underscore.difference(this.value(), lists));
        }

        public Chain<Integer> range(int stop) {
            return new Chain<Integer>(Underscore.range(stop));
        }

        public Chain<Integer> range(int start, int stop) {
            return new Chain<Integer>(Underscore.range(start, stop));
        }

        public Chain<Integer> range(int start, int stop, int step) {
            return new Chain<Integer>(Underscore.range(start, stop, step));
        }

        @Override
        public Chain<List<T>> chunk(int size) {
            return new Chain(Underscore.chunk(this.value(), size, size));
        }

        @Override
        public Chain<List<T>> chunk(int size, int step) {
            return new Chain(Underscore.chunk(this.value(), size, step));
        }

        @Override
        public Chain<List<T>> chunkFill(int size, T fillValue) {
            return new Chain(Underscore.chunkFill(this.value(), size, size, fillValue));
        }

        @Override
        public Chain<List<T>> chunkFill(int size, int step, T fillValue) {
            return new Chain(Underscore.chunkFill(this.value(), size, step, fillValue));
        }

        @Override
        public Chain<T> cycle(int times) {
            return new Chain(Underscore.cycle(this.value(), times));
        }

        @Override
        public Chain<T> interpose(T element) {
            return new Chain(Underscore.interpose(this.value(), element));
        }

        @Override
        public Chain<T> interposeByList(Iterable<T> interIter) {
            return new Chain(Underscore.interposeByList(this.value(), interIter));
        }

        @Override
        public Chain<T> concat(List<T> ... lists) {
            return new Chain(Underscore.concat(this.value(), lists));
        }

        @Override
        public Chain<T> slice(int start) {
            return new Chain(Underscore.slice(this.value(), start));
        }

        @Override
        public Chain<T> slice(int start, int end) {
            return new Chain(Underscore.slice(this.value(), start, end));
        }

        public Chain<Map<String, Object>> set(String path, Object value) {
            U.set(this.map(), path, value);
            return new Chain<Map<String, Object>>(this.map());
        }

        public Chain<Map<String, Object>> set(List<String> paths, Object value) {
            U.set(this.map(), paths, value);
            return new Chain<Map<String, Object>>(this.map());
        }

        @Override
        public Chain<T> reverse() {
            return new Chain(Underscore.reverse(this.value()));
        }

        public Chain<String> join() {
            return new Chain<String>(Underscore.join(this.value()));
        }

        public Chain<String> join(String separator) {
            return new Chain<String>(Underscore.join(this.value(), separator));
        }

        @Override
        public Chain<T> skip(int numberToSkip) {
            return new Chain(this.value().subList(numberToSkip, this.value().size()));
        }

        @Override
        public Chain<T> limit(int size) {
            return new Chain(this.value().subList(0, size));
        }

        @Override
        public <K, V> Chain<Map<K, V>> toMap() {
            return new Chain(Underscore.toMap(this.value()));
        }

        public Chain<T> drop() {
            return new Chain(Underscore.drop(this.value()));
        }

        public Chain<T> drop(Integer n) {
            return new Chain(Underscore.drop(this.value(), (int)n));
        }

        public Chain<T> dropRight() {
            return new Chain(U.dropRight(this.value()));
        }

        public Chain<T> dropRight(Integer n) {
            return new Chain(U.dropRight(this.value(), n));
        }

        public Chain<T> dropWhile(Predicate<T> pred) {
            return new Chain(U.dropWhile(this.value(), pred));
        }

        public Chain<T> dropRightWhile(Predicate<T> pred) {
            return new Chain(U.dropRightWhile(this.value(), pred));
        }

        public Chain<Object> fill(Object value) {
            return new Chain<Object>(U.fill(this.value(), value));
        }

        public Chain<Object> fill(Object value, Integer start, Integer end) {
            return new Chain<Object>(U.fill(this.value(), value, start, end));
        }

        public Chain<Object> flattenDeep() {
            return new Chain<Object>(U.flattenDeep(this.value()));
        }

        public Chain<Object> pull(Object ... values) {
            return new Chain<Object>(U.pull(this.value(), values));
        }

        public Chain<Object> pullAt(Integer ... indexes) {
            return new Chain<Object>(U.pullAt(this.value(), indexes));
        }

        public Chain<T> remove(Predicate<T> pred) {
            return new Chain(U.remove(this.value(), pred));
        }

        public Chain<T> take() {
            return new Chain(U.take(this.value()));
        }

        public Chain<T> takeRight() {
            return new Chain(U.takeRight(this.value()));
        }

        public Chain<T> take(Integer n) {
            return new Chain(U.take(this.value(), n));
        }

        public Chain<T> takeRight(Integer n) {
            return new Chain(U.takeRight(this.value(), n));
        }

        public Chain<T> takeWhile(Predicate<T> pred) {
            return new Chain(U.takeWhile(this.value(), pred));
        }

        public Chain<T> takeRightWhile(Predicate<T> pred) {
            return new Chain(U.takeRightWhile(this.value(), pred));
        }

        public Chain<T> xor(List<T> list) {
            return new Chain(U.xor(this.value(), list));
        }

        public Chain<T> at(Integer ... indexes) {
            return new Chain(U.at(this.value(), indexes));
        }

        public <F extends Number> Chain<F> sum() {
            return new Chain(U.sum(this.value()));
        }

        public <F extends Number> Chain<F> sum(Function<T, F> func) {
            return new Chain<F>(U.sum(this.value(), func));
        }

        public Chain<Double> mean() {
            return new Chain<Double>(U.mean(this.value()));
        }

        public Chain<Double> median() {
            return new Chain<Double>(U.median(this.value()));
        }

        public Chain<String> camelCase() {
            return new Chain<String>(U.camelCase((String)this.item()));
        }

        public Chain<String> lowerFirst() {
            return new Chain<String>(U.lowerFirst((String)this.item()));
        }

        public Chain<String> upperFirst() {
            return new Chain<String>(U.upperFirst((String)this.item()));
        }

        public Chain<String> capitalize() {
            return new Chain<String>(U.capitalize((String)this.item()));
        }

        public Chain<String> deburr() {
            return new Chain<String>(U.deburr((String)this.item()));
        }

        public Chain<Boolean> endsWith(String target) {
            return new Chain<Boolean>(U.endsWith((String)this.item(), target));
        }

        public Chain<Boolean> endsWith(String target, Integer position) {
            return new Chain<Boolean>(U.endsWith((String)this.item(), target, position));
        }

        public Chain<String> kebabCase() {
            return new Chain<String>(U.kebabCase((String)this.item()));
        }

        public Chain<String> repeat(int length) {
            return new Chain<String>(U.repeat((String)this.item(), length));
        }

        public Chain<String> pad(int length) {
            return new Chain<String>(U.pad((String)this.item(), length));
        }

        public Chain<String> pad(int length, String chars) {
            return new Chain<String>(U.pad((String)this.item(), length, chars));
        }

        public Chain<String> padStart(int length) {
            return new Chain<String>(U.padStart((String)this.item(), length));
        }

        public Chain<String> padStart(int length, String chars) {
            return new Chain<String>(U.padStart((String)this.item(), length, chars));
        }

        public Chain<String> padEnd(int length) {
            return new Chain<String>(U.padEnd((String)this.item(), length));
        }

        public Chain<String> padEnd(int length, String chars) {
            return new Chain<String>(U.padEnd((String)this.item(), length, chars));
        }

        public Chain<String> snakeCase() {
            return new Chain<String>(U.snakeCase((String)this.item()));
        }

        public Chain<String> startCase() {
            return new Chain<String>(U.startCase((String)this.item()));
        }

        public Chain<Boolean> startsWith(String target) {
            return new Chain<Boolean>(U.startsWith((String)this.item(), target));
        }

        public Chain<Boolean> startsWith(String target, Integer position) {
            return new Chain<Boolean>(U.startsWith((String)this.item(), target, position));
        }

        public Chain<String> trim() {
            return new Chain<String>(U.trim((String)this.item()));
        }

        public Chain<String> trim(String chars) {
            return new Chain<String>(U.trim((String)this.item(), chars));
        }

        public Chain<String> trimStart() {
            return new Chain<String>(U.trimStart((String)this.item()));
        }

        public Chain<String> trimStart(String chars) {
            return new Chain<String>(U.trimStart((String)this.item(), chars));
        }

        public Chain<String> trimEnd() {
            return new Chain<String>(U.trimEnd((String)this.item()));
        }

        public Chain<String> trunc() {
            return new Chain<String>(U.trunc((String)this.item()));
        }

        public Chain<String> trunc(int length) {
            return new Chain<String>(U.trunc((String)this.item(), length));
        }

        public Chain<String> trimEnd(String chars) {
            return new Chain<String>(U.trimEnd((String)this.item(), chars));
        }

        public Chain<String> uncapitalize() {
            return new Chain<String>(U.uncapitalize((String)this.item()));
        }

        public Chain<String> words() {
            return new Chain<String>(U.words((String)this.item()));
        }

        public Chain<String> toJson() {
            return new Chain<String>(Json.toJson(this.value()));
        }

        public Chain<Object> fromJson() {
            return new Chain<Object>(Json.fromJson((String)this.item()));
        }

        public Chain<String> toXml() {
            return new Chain<String>(Xml.toXml(this.value()));
        }

        public Chain<Object> fromXml() {
            return new Chain<Object>(Xml.fromXml((String)this.item()));
        }

        public Chain<String> fetch() {
            return new Chain<String>(U.fetch((String)this.item()).text());
        }

        public Chain<String> fetch(String method, String body) {
            return new Chain<String>(U.fetch((String)this.item(), method, body).text());
        }

        public Chain<List<T>> createPermutationWithRepetition(int permutationLength) {
            return new Chain(U.createPermutationWithRepetition(this.value(), permutationLength));
        }

        public Chain<String> xmlToJson() {
            return new Chain<String>(U.xmlToJson((String)this.item()));
        }

        public Chain<String> jsonToXml() {
            return new Chain<String>(U.jsonToXml((String)this.item()));
        }
    }

    private static enum OperationType {
        GET,
        SET,
        UPDATE,
        REMOVE;

    }

    public static class FetchResponse {
        private final boolean ok;
        private final int status;
        private final Map<String, List<String>> headerFields;
        private final ByteArrayOutputStream stream;

        public FetchResponse(boolean ok, int status, Map<String, List<String>> headerFields, ByteArrayOutputStream stream) {
            this.ok = ok;
            this.status = status;
            this.stream = stream;
            this.headerFields = headerFields;
        }

        public boolean isOk() {
            return this.ok;
        }

        public int getStatus() {
            return this.status;
        }

        public Map<String, List<String>> getHeaderFields() {
            return this.headerFields;
        }

        public byte[] blob() {
            return this.stream.toByteArray();
        }

        public String text() {
            return this.stream.toString(StandardCharsets.UTF_8);
        }

        public Object json() {
            return Json.fromJson(this.text());
        }

        public Map<String, Object> jsonMap() {
            return U.fromJsonMap(this.text());
        }

        public Object xml() {
            return Xml.fromXml(this.text());
        }

        public Map<String, Object> xmlMap() {
            return U.fromXmlMap(this.text());
        }
    }

    public static class Fetch {
        private Fetch() {
        }

        public static FetchResponse fetch(String url, String method, String body, Map<String, List<String>> headerFields, Integer connectTimeout, Integer readTimeout, Integer retryCount, Integer timeBetweenRetry) {
            if (Underscore.nonNull(retryCount) && retryCount > 0 && retryCount <= 10 && Underscore.nonNull(timeBetweenRetry) && timeBetweenRetry > 0) {
                UnsupportedOperationException saveException;
                int localRetryCount = 0;
                do {
                    try {
                        FetchResponse fetchResponse = U.fetch(url, method, body, headerFields, connectTimeout, readTimeout);
                        if (fetchResponse.getStatus() != 429) {
                            return fetchResponse;
                        }
                        saveException = new UnsupportedOperationException("Too Many Requests");
                    }
                    catch (UnsupportedOperationException ex) {
                        saveException = ex;
                    }
                    ++localRetryCount;
                    try {
                        TimeUnit.MILLISECONDS.sleep(timeBetweenRetry.intValue());
                    }
                    catch (InterruptedException ex) {
                        saveException = new UnsupportedOperationException(ex);
                        Thread.currentThread().interrupt();
                    }
                } while (localRetryCount <= retryCount);
                throw saveException;
            }
            return U.fetch(url, method, body, headerFields, connectTimeout, readTimeout);
        }
    }

    public static class BaseHttpSslSocketFactory
    extends SSLSocketFactory {
        private SSLContext getSslContext() {
            return this.createEasySslContext();
        }

        @Override
        public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
            return this.getSslContext().getSocketFactory().createSocket(arg0, arg1, arg2, arg3);
        }

        @Override
        public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
            return this.getSslContext().getSocketFactory().createSocket(arg0, arg1, arg2, arg3);
        }

        @Override
        public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
            return this.getSslContext().getSocketFactory().createSocket(arg0, arg1);
        }

        @Override
        public Socket createSocket(String arg0, int arg1) throws IOException {
            return this.getSslContext().getSocketFactory().createSocket(arg0, arg1);
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return new String[0];
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return new String[0];
        }

        @Override
        public Socket createSocket(Socket arg0, String arg1, int arg2, boolean arg3) throws IOException {
            return this.getSslContext().getSocketFactory().createSocket(arg0, arg1, arg2, arg3);
        }

        private SSLContext createEasySslContext() {
            try {
                SSLContext context = SSLContext.getInstance("SSL");
                context.init(null, new TrustManager[]{MyX509TrustManager.manger}, null);
                return context;
            }
            catch (Exception ex) {
                throw new UnsupportedOperationException(ex);
            }
        }

        public static class MyX509TrustManager
        implements X509TrustManager {
            static MyX509TrustManager manger = new MyX509TrustManager();

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }
        }
    }

    public static class LruCache<K, V> {
        private static final boolean SORT_BY_ACCESS = true;
        private static final float LOAD_FACTOR = 0.75f;
        private final Map<K, V> lruCacheMap;
        private final int capacity;

        public LruCache(int capacity) {
            this.capacity = capacity;
            this.lruCacheMap = new LinkedHashMap(capacity, 0.75f, true);
        }

        public V get(K key) {
            return this.lruCacheMap.get(key);
        }

        public void put(K key, V value) {
            if (this.lruCacheMap.containsKey(key)) {
                this.lruCacheMap.remove(key);
            } else if (this.lruCacheMap.size() >= this.capacity) {
                this.lruCacheMap.remove(this.lruCacheMap.keySet().iterator().next());
            }
            this.lruCacheMap.put(key, value);
        }
    }

    public static enum JsonToXmlMode {
        FORCE_ATTRIBUTE_USAGE,
        DEFINE_ROOT_NAME,
        REPLACE_NULL_WITH_EMPTY_VALUE,
        REPLACE_EMPTY_STRING_WITH_EMPTY_VALUE,
        ADD_ROOT,
        REMOVE_ARRAY_ATTRIBUTE,
        REMOVE_ATTRIBUTES;

    }

    public static enum XmlToJsonMode {
        REPLACE_SELF_CLOSING_WITH_NULL,
        REPLACE_SELF_CLOSING_WITH_STRING,
        REPLACE_EMPTY_VALUE_WITH_NULL,
        REPLACE_EMPTY_TAG_WITH_NULL,
        REPLACE_EMPTY_TAG_WITH_STRING,
        REMOVE_FIRST_LEVEL,
        WITHOUT_NAMESPACES,
        REPLACE_MINUS_WITH_AT,
        REPLACE_EMPTY_TAG_WITH_NULL_AND_MINUS_WITH_AT;

    }

    public static enum TextType {
        JSON,
        XML,
        OTHER;

    }

    public static class Builder {
        private final Map<String, Object> data = new LinkedHashMap<String, Object>();

        public Builder add(String key, Object value) {
            this.data.put(key, value);
            return this;
        }

        public Builder add(Object value) {
            this.data.put(String.valueOf(this.data.size()), value);
            return this;
        }

        public <T> T get(String path) {
            return U.get(this.data, path);
        }

        public <T> T get(List<String> paths) {
            return U.get(this.data, paths);
        }

        public Builder set(String path, Object value) {
            U.set(this.data, path, value);
            return this;
        }

        public Builder set(List<String> paths, Object value) {
            U.set(this.data, paths, value);
            return this;
        }

        public Builder remove(String key) {
            U.remove(this.data, key);
            return this;
        }

        public Builder remove(List<String> keys) {
            U.remove(this.data, keys);
            return this;
        }

        public Builder clear() {
            this.data.clear();
            return this;
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public int size() {
            return this.data.size();
        }

        public Builder add(Builder builder) {
            this.data.put(String.valueOf(this.data.size()), builder.build());
            return this;
        }

        public Builder add(String key, ArrayBuilder builder) {
            this.data.put(key, builder.build());
            return this;
        }

        public Builder add(String key, Builder builder) {
            this.data.put(key, builder.build());
            return this;
        }

        public Builder add(Map<String, Object> map) {
            this.data.putAll(U.deepCopyMap(map));
            return this;
        }

        public Builder update(Map<String, Object> map) {
            U.update(this.data, U.deepCopyMap(map));
            return this;
        }

        public Builder addNull(String key) {
            this.data.put(key, null);
            return this;
        }

        public Map<String, Object> build() {
            return (Map)((LinkedHashMap)this.data).clone();
        }

        public String toXml() {
            return Xml.toXml(this.data);
        }

        public static Builder fromXml(String xml) {
            Builder builder = new Builder();
            builder.data.putAll(U.fromXmlMap(xml));
            return builder;
        }

        public static Builder fromMap(Map<String, Object> map) {
            Builder builder = new Builder();
            builder.data.putAll(U.deepCopyMap(map));
            return builder;
        }

        public String toJson() {
            return Json.toJson(this.data);
        }

        public static Builder fromJson(String json) {
            Builder builder = new Builder();
            builder.data.putAll(U.fromJsonMap(json));
            return builder;
        }

        public Chain<Object> toChain() {
            return new Chain<Object>(this.data.entrySet());
        }

        public String toString() {
            return this.data.toString();
        }
    }

    public static class ArrayBuilder {
        private final List<Object> data = new ArrayList<Object>();

        public ArrayBuilder add(Object value) {
            this.data.add(value);
            return this;
        }

        public ArrayBuilder addNull() {
            this.data.add(null);
            return this;
        }

        public <T> T get(String path) {
            return U.get(U.getStringObjectMap(this.data), "value." + path);
        }

        public <T> T get(List<String> paths) {
            ArrayList<String> newPaths = new ArrayList<String>();
            newPaths.add("value");
            newPaths.addAll(paths);
            return U.get(U.getStringObjectMap(this.data), newPaths);
        }

        public ArrayBuilder set(int index, Object value) {
            this.data.set(index, value);
            return this;
        }

        public ArrayBuilder remove(int index) {
            this.data.remove(index);
            return this;
        }

        public ArrayBuilder clear() {
            this.data.clear();
            return this;
        }

        public boolean isEmpty() {
            return this.data.isEmpty();
        }

        public int size() {
            return this.data.size();
        }

        public ArrayBuilder add(ArrayBuilder builder) {
            this.data.addAll(builder.build());
            return this;
        }

        public ArrayBuilder add(Builder builder) {
            this.data.add(builder.build());
            return this;
        }

        public ArrayBuilder merge(List<Object> list) {
            U.merge(this.data, (List)((ArrayList)list).clone());
            return this;
        }

        public List<Object> build() {
            return (List)((ArrayList)this.data).clone();
        }

        public String toXml() {
            return Xml.toXml(this.data);
        }

        public static ArrayBuilder fromXml(String xml) {
            ArrayBuilder builder = new ArrayBuilder();
            builder.data.addAll((Collection)U.fromXml(xml));
            return builder;
        }

        public String toJson() {
            return Json.toJson(this.data);
        }

        public static ArrayBuilder fromJson(String json) {
            ArrayBuilder builder = new ArrayBuilder();
            builder.data.addAll((Collection)U.fromJson(json));
            return builder;
        }

        public Chain<Object> toChain() {
            return new Chain<Object>(this.data);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

