/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class Json {
    private static final int PARSE_MAX_DEPTH = 10000;
    private static final String NULL = "null";
    private static final String DIGIT = "digit";

    private Json() {
    }

    public static String toJson(Collection collection, JsonStringBuilder.Step identStep) {
        JsonStringBuilder builder = new JsonStringBuilder(identStep);
        JsonArray.writeJson(collection, builder);
        return builder.toString();
    }

    public static String toJson(Collection collection) {
        return Json.toJson(collection, JsonStringBuilder.Step.TWO_SPACES);
    }

    public static String toJson(Map map, JsonStringBuilder.Step identStep) {
        JsonStringBuilder builder = new JsonStringBuilder(identStep);
        JsonObject.writeJson(map, builder);
        return builder.toString();
    }

    public static String toJson(Map map) {
        return Json.toJson(map, JsonStringBuilder.Step.TWO_SPACES);
    }

    public static Object fromJson(String string) {
        return Json.fromJson(string, 10000);
    }

    public static Object fromJson(String string, int maxDepth) {
        return new JsonParser(string, maxDepth).parse();
    }

    public static String formatJson(String json, JsonStringBuilder.Step identStep) {
        Object result = Json.fromJson(json);
        if (result instanceof Map) {
            return Json.toJson((Map)result, identStep);
        }
        return Json.toJson((List)result, identStep);
    }

    public static String formatJson(String json) {
        return Json.formatJson(json, JsonStringBuilder.Step.TWO_SPACES);
    }

    public static class JsonStringBuilder {
        private final StringBuilder builder = new StringBuilder();
        private final Step identStep;
        private int indent;

        public JsonStringBuilder(Step identStep) {
            this.identStep = identStep;
        }

        public JsonStringBuilder() {
            this.identStep = Step.TWO_SPACES;
        }

        public JsonStringBuilder append(char character) {
            this.builder.append(character);
            return this;
        }

        public JsonStringBuilder append(String string) {
            this.builder.append(string);
            return this;
        }

        public JsonStringBuilder fillSpaces() {
            this.builder.append(String.valueOf(this.identStep == Step.TABS ? (char)'\t' : ' ').repeat(Math.max(0, this.indent)));
            return this;
        }

        public JsonStringBuilder incIndent() {
            this.indent += this.identStep.getIndent();
            return this;
        }

        public JsonStringBuilder decIndent() {
            this.indent -= this.identStep.getIndent();
            return this;
        }

        public JsonStringBuilder newLine() {
            if (this.identStep != Step.COMPACT) {
                this.builder.append('\n');
            }
            return this;
        }

        public Step getIdentStep() {
            return this.identStep;
        }

        public String toString() {
            return this.builder.toString();
        }

        public static enum Step {
            TWO_SPACES(2),
            THREE_SPACES(3),
            FOUR_SPACES(4),
            COMPACT(0),
            TABS(1);

            private final int indent;

            private Step(int indent) {
                this.indent = indent;
            }

            public int getIndent() {
                return this.indent;
            }
        }
    }

    public static class JsonArray {
        private JsonArray() {
        }

        public static void writeJson(Collection collection, JsonStringBuilder builder) {
            if (collection == null) {
                builder.append(Json.NULL);
                return;
            }
            Iterator iter = collection.iterator();
            builder.append('[').incIndent();
            if (!collection.isEmpty()) {
                builder.newLine();
            }
            while (iter.hasNext()) {
                Object value = iter.next();
                builder.fillSpaces();
                JsonValue.writeJson(value, builder);
                if (!iter.hasNext()) continue;
                builder.append(',').newLine();
            }
            builder.newLine().decIndent().fillSpaces().append(']');
        }

        public static void writeJson(byte[] byteArray, JsonStringBuilder builder) {
            if (byteArray == null) {
                builder.append(Json.NULL);
            } else if (byteArray.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIndent().newLine();
                builder.fillSpaces().append(String.valueOf(byteArray[0]));
                for (int i = 1; i < byteArray.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(byteArray[i]));
                }
                builder.newLine().decIndent().fillSpaces().append(']');
            }
        }

        public static void writeJson(short[] shortArray, JsonStringBuilder builder) {
            if (shortArray == null) {
                builder.append(Json.NULL);
            } else if (shortArray.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIndent().newLine();
                builder.fillSpaces().append(String.valueOf(shortArray[0]));
                for (int i = 1; i < shortArray.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(shortArray[i]));
                }
                builder.newLine().decIndent().fillSpaces().append(']');
            }
        }

        public static void writeJson(int[] intArray, JsonStringBuilder builder) {
            if (intArray == null) {
                builder.append(Json.NULL);
            } else if (intArray.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIndent().newLine();
                builder.fillSpaces().append(String.valueOf(intArray[0]));
                for (int i = 1; i < intArray.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(intArray[i]));
                }
                builder.newLine().decIndent().fillSpaces().append(']');
            }
        }

        public static void writeJson(long[] longArray, JsonStringBuilder builder) {
            if (longArray == null) {
                builder.append(Json.NULL);
            } else if (longArray.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIndent().newLine();
                builder.fillSpaces().append(String.valueOf(longArray[0]));
                for (int i = 1; i < longArray.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(longArray[i]));
                }
                builder.newLine().decIndent().fillSpaces().append(']');
            }
        }

        public static void writeJson(float[] floatArray, JsonStringBuilder builder) {
            if (floatArray == null) {
                builder.append(Json.NULL);
            } else if (floatArray.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIndent().newLine();
                builder.fillSpaces().append(String.valueOf(floatArray[0]));
                for (int i = 1; i < floatArray.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(floatArray[i]));
                }
                builder.newLine().decIndent().fillSpaces().append(']');
            }
        }

        public static void writeJson(double[] doubleArray, JsonStringBuilder builder) {
            if (doubleArray == null) {
                builder.append(Json.NULL);
            } else if (doubleArray.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIndent().newLine();
                builder.fillSpaces().append(String.valueOf(doubleArray[0]));
                for (int i = 1; i < doubleArray.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(doubleArray[i]));
                }
                builder.newLine().decIndent().fillSpaces().append(']');
            }
        }

        public static void writeJson(boolean[] booleanArray, JsonStringBuilder builder) {
            if (booleanArray == null) {
                builder.append(Json.NULL);
            } else if (booleanArray.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIndent().newLine();
                builder.fillSpaces().append(String.valueOf(booleanArray[0]));
                for (int i = 1; i < booleanArray.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append(String.valueOf(booleanArray[i]));
                }
                builder.newLine().decIndent().fillSpaces().append(']');
            }
        }

        public static void writeJson(char[] charArray, JsonStringBuilder builder) {
            if (charArray == null) {
                builder.append(Json.NULL);
            } else if (charArray.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').incIndent().newLine();
                builder.fillSpaces().append('\"').append(String.valueOf(charArray[0])).append('\"');
                for (int i = 1; i < charArray.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    builder.append('\"').append(String.valueOf(charArray[i])).append('\"');
                }
                builder.newLine().decIndent().fillSpaces().append(']');
            }
        }

        public static void writeJson(Object[] objectArray, JsonStringBuilder builder) {
            if (objectArray == null) {
                builder.append(Json.NULL);
            } else if (objectArray.length == 0) {
                builder.append("[]");
            } else {
                builder.append('[').newLine().incIndent().fillSpaces();
                JsonValue.writeJson(objectArray[0], builder);
                for (int i = 1; i < objectArray.length; ++i) {
                    builder.append(',').newLine().fillSpaces();
                    JsonValue.writeJson(objectArray[i], builder);
                }
                builder.newLine().decIndent().fillSpaces().append(']');
            }
        }
    }

    public static class JsonObject {
        private JsonObject() {
        }

        public static void writeJson(Map map, JsonStringBuilder builder) {
            if (map == null) {
                builder.append(Json.NULL);
                return;
            }
            Iterator iter = map.entrySet().iterator();
            builder.append('{').incIndent();
            if (!map.isEmpty()) {
                builder.newLine();
            }
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                builder.fillSpaces().append('\"');
                builder.append(JsonValue.escape(String.valueOf(entry.getKey())));
                builder.append('\"');
                builder.append(':');
                if (builder.getIdentStep() != JsonStringBuilder.Step.COMPACT) {
                    builder.append(' ');
                }
                JsonValue.writeJson(entry.getValue(), builder);
                if (!iter.hasNext()) continue;
                builder.append(',').newLine();
            }
            builder.newLine().decIndent().fillSpaces().append('}');
        }
    }

    public static class JsonParser {
        private final String json;
        private int index;
        private int line;
        private int lineOffset;
        private int current;
        private final StringBuilder captureBuffer = new StringBuilder();
        private int captureStart;
        private final int maxDepth;

        public JsonParser(String string, int maxDepth) {
            this.json = string;
            this.maxDepth = maxDepth;
            this.line = 1;
            this.captureStart = -1;
        }

        public Object parse() {
            this.read();
            this.skipWhiteSpace();
            Object result = this.readValue(0);
            this.skipWhiteSpace();
            if (!this.isEndOfText()) {
                throw this.error("Unexpected character");
            }
            return result;
        }

        private Object readValue(int depth) {
            if (depth > this.maxDepth) {
                throw this.error("Maximum depth exceeded");
            }
            switch (this.current) {
                case 110: {
                    return this.readNull();
                }
                case 116: {
                    return this.readTrue();
                }
                case 102: {
                    return this.readFalse();
                }
                case 34: {
                    return this.readString();
                }
                case 91: {
                    return this.readArray(depth + 1);
                }
                case 123: {
                    return this.readObject(depth + 1);
                }
                case 45: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.readNumber();
                }
            }
            throw this.expected("value");
        }

        private List<Object> readArray(int depth) {
            this.read();
            ArrayList<Object> array = new ArrayList<Object>();
            this.skipWhiteSpace();
            if (this.readChar(']')) {
                return array;
            }
            do {
                this.skipWhiteSpace();
                array.add(this.readValue(depth));
                this.skipWhiteSpace();
            } while (this.readChar(','));
            if (!this.readChar(']')) {
                throw this.expected("',' or ']'");
            }
            return array;
        }

        private Map<String, Object> readObject(int depth) {
            this.read();
            LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
            this.skipWhiteSpace();
            if (this.readChar('}')) {
                return object;
            }
            do {
                this.skipWhiteSpace();
                String name = this.readName();
                this.skipWhiteSpace();
                if (!this.readChar(':')) {
                    throw this.expected("':'");
                }
                this.skipWhiteSpace();
                object.put(name, this.readValue(depth));
                this.skipWhiteSpace();
            } while (this.readChar(','));
            if (!this.readChar('}')) {
                throw this.expected("',' or '}'");
            }
            return object;
        }

        private String readName() {
            if (this.current != 34) {
                throw this.expected("name");
            }
            return this.readString();
        }

        private String readNull() {
            this.read();
            this.readRequiredChar('u');
            this.readRequiredChar('l');
            this.readRequiredChar('l');
            return null;
        }

        private Boolean readTrue() {
            this.read();
            this.readRequiredChar('r');
            this.readRequiredChar('u');
            this.readRequiredChar('e');
            return Boolean.TRUE;
        }

        private Boolean readFalse() {
            this.read();
            this.readRequiredChar('a');
            this.readRequiredChar('l');
            this.readRequiredChar('s');
            this.readRequiredChar('e');
            return Boolean.FALSE;
        }

        private void readRequiredChar(char ch) {
            if (!this.readChar(ch)) {
                throw this.expected("'" + ch + "'");
            }
        }

        private String readString() {
            this.read();
            this.startCapture();
            while (this.current != 34) {
                if (this.current == 92) {
                    this.pauseCapture();
                    this.readEscape();
                    this.startCapture();
                    continue;
                }
                if (this.current < 32) {
                    throw this.expected("valid string character");
                }
                this.read();
            }
            String string = this.endCapture();
            this.read();
            return string;
        }

        private void readEscape() {
            this.read();
            switch (this.current) {
                case 34: 
                case 47: 
                case 92: {
                    this.captureBuffer.append((char)this.current);
                    break;
                }
                case 98: {
                    this.captureBuffer.append('\b');
                    break;
                }
                case 102: {
                    this.captureBuffer.append('\f');
                    break;
                }
                case 110: {
                    this.captureBuffer.append('\n');
                    break;
                }
                case 114: {
                    this.captureBuffer.append('\r');
                    break;
                }
                case 116: {
                    this.captureBuffer.append('\t');
                    break;
                }
                case 117: {
                    char[] hexChars = new char[4];
                    boolean isHexCharsDigits = true;
                    for (int i = 0; i < 4; ++i) {
                        this.read();
                        if (!this.isHexDigit()) {
                            isHexCharsDigits = false;
                        }
                        hexChars[i] = (char)this.current;
                    }
                    if (isHexCharsDigits) {
                        this.captureBuffer.append((char)Integer.parseInt(new String(hexChars), 16));
                        break;
                    }
                    this.captureBuffer.append("\\u").append(hexChars[0]).append(hexChars[1]).append(hexChars[2]).append(hexChars[3]);
                    break;
                }
                default: {
                    throw this.expected("valid escape sequence");
                }
            }
            this.read();
        }

        private Number readNumber() {
            this.startCapture();
            this.readChar('-');
            int firstDigit = this.current;
            if (!this.readDigit()) {
                throw this.expected(Json.DIGIT);
            }
            if (firstDigit != 48) {
                while (this.readDigit()) {
                }
            }
            this.readFraction();
            this.readExponent();
            String number = this.endCapture();
            Number result = number.contains(".") || number.contains("e") || number.contains("E") ? (Number)(number.length() > 9 || number.contains(".") && number.length() - number.lastIndexOf(46) > 2 && number.charAt(number.length() - 1) == '0' ? new BigDecimal(number) : Double.valueOf(number)) : (Number)(number.length() > 19 ? new BigInteger(number) : Long.valueOf(number));
            return result;
        }

        private void readFraction() {
            if (!this.readChar('.')) {
                return;
            }
            if (!this.readDigit()) {
                throw this.expected(Json.DIGIT);
            }
            while (this.readDigit()) {
            }
        }

        private void readExponent() {
            if (!this.readChar('e') && !this.readChar('E')) {
                return;
            }
            if (!this.readChar('+')) {
                this.readChar('-');
            }
            if (!this.readDigit()) {
                throw this.expected(Json.DIGIT);
            }
            while (this.readDigit()) {
            }
        }

        private boolean readChar(char ch) {
            if (this.current != ch) {
                return false;
            }
            this.read();
            return true;
        }

        private boolean readDigit() {
            if (!this.isDigit()) {
                return false;
            }
            this.read();
            return true;
        }

        private void skipWhiteSpace() {
            while (this.isWhiteSpace()) {
                this.read();
            }
        }

        private void read() {
            if (this.index == this.json.length()) {
                this.current = -1;
                return;
            }
            if (this.current == 10) {
                ++this.line;
                this.lineOffset = this.index;
            }
            this.current = this.json.charAt(this.index++);
        }

        private void startCapture() {
            this.captureStart = this.index - 1;
        }

        private void pauseCapture() {
            this.captureBuffer.append(this.json, this.captureStart, this.index - 1);
            this.captureStart = -1;
        }

        private String endCapture() {
            String captured;
            int end;
            int n = end = this.current == -1 ? this.index : this.index - 1;
            if (this.captureBuffer.length() > 0) {
                this.captureBuffer.append(this.json, this.captureStart, end);
                captured = this.captureBuffer.toString();
                this.captureBuffer.setLength(0);
            } else {
                captured = this.json.substring(this.captureStart, end);
            }
            this.captureStart = -1;
            return captured;
        }

        private ParseException expected(String expected) {
            if (this.isEndOfText()) {
                return this.error("Unexpected end of input");
            }
            return this.error("Expected " + expected);
        }

        private ParseException error(String message) {
            int absIndex = this.index;
            int column = absIndex - this.lineOffset;
            int offset = this.isEndOfText() ? absIndex : absIndex - 1;
            return new ParseException(message, offset, this.line, column - 1);
        }

        private boolean isWhiteSpace() {
            return this.current == 32 || this.current == 9 || this.current == 10 || this.current == 13;
        }

        private boolean isDigit() {
            return this.current >= 48 && this.current <= 57;
        }

        private boolean isHexDigit() {
            return this.isDigit() || this.current >= 97 && this.current <= 102 || this.current >= 65 && this.current <= 70;
        }

        private boolean isEndOfText() {
            return this.current == -1;
        }
    }

    public static class ParseException
    extends RuntimeException {
        private final int offset;
        private final int line;
        private final int column;

        public ParseException(String message, int offset, int line, int column) {
            super(String.format("%s at %d:%d", message, line, column));
            this.offset = offset;
            this.line = line;
            this.column = column;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }

    public static class JsonValue {
        private JsonValue() {
        }

        public static void writeJson(Object value, JsonStringBuilder builder) {
            if (value == null) {
                builder.append(Json.NULL);
            } else if (value instanceof String) {
                builder.append('\"').append(JsonValue.escape((String)value)).append('\"');
            } else if (value instanceof Double) {
                if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                    builder.append(Json.NULL);
                } else {
                    builder.append(value.toString());
                }
            } else if (value instanceof Float) {
                if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                    builder.append(Json.NULL);
                } else {
                    builder.append(value.toString());
                }
            } else if (value instanceof Number) {
                builder.append(value.toString());
            } else if (value instanceof Boolean) {
                builder.append(value.toString());
            } else if (value instanceof Map) {
                JsonObject.writeJson((Map)value, builder);
            } else if (value instanceof Collection) {
                JsonArray.writeJson((Collection)value, builder);
            } else {
                JsonValue.doWriteJson(value, builder);
            }
        }

        private static void doWriteJson(Object value, JsonStringBuilder builder) {
            if (value instanceof byte[]) {
                JsonArray.writeJson((byte[])value, builder);
            } else if (value instanceof short[]) {
                JsonArray.writeJson((short[])value, builder);
            } else if (value instanceof int[]) {
                JsonArray.writeJson((int[])value, builder);
            } else if (value instanceof long[]) {
                JsonArray.writeJson((long[])value, builder);
            } else if (value instanceof float[]) {
                JsonArray.writeJson((float[])value, builder);
            } else if (value instanceof double[]) {
                JsonArray.writeJson((double[])value, builder);
            } else if (value instanceof boolean[]) {
                JsonArray.writeJson((boolean[])value, builder);
            } else if (value instanceof char[]) {
                JsonArray.writeJson((char[])value, builder);
            } else if (value instanceof Object[]) {
                JsonArray.writeJson((Object[])value, builder);
            } else {
                builder.append('\"').append(JsonValue.escape(value.toString())).append('\"');
            }
        }

        public static String escape(String inputString) {
            if (inputString == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            JsonValue.escape(inputString, sb);
            return sb.toString();
        }

        private static void escape(String inputString, StringBuilder sb) {
            int len = inputString.length();
            block10: for (int i = 0; i < len; ++i) {
                char ch = inputString.charAt(i);
                switch (ch) {
                    case '\"': {
                        sb.append("\\\"");
                        continue block10;
                    }
                    case '\\': {
                        sb.append("\\\\");
                        continue block10;
                    }
                    case '\b': {
                        sb.append("\\b");
                        continue block10;
                    }
                    case '\f': {
                        sb.append("\\f");
                        continue block10;
                    }
                    case '\n': {
                        sb.append("\\n");
                        continue block10;
                    }
                    case '\r': {
                        sb.append("\\r");
                        continue block10;
                    }
                    case '\t': {
                        sb.append("\\t");
                        continue block10;
                    }
                    case '\u20ac': {
                        sb.append('\u20ac');
                        continue block10;
                    }
                    default: {
                        if (ch <= '\u001f' || ch >= '\u007f' && ch <= '\u009f' || ch >= '\u2000' && ch <= '\u20ff') {
                            String ss = Integer.toHexString(ch);
                            sb.append("\\u");
                            sb.append("0".repeat(4 - ss.length()));
                            sb.append(ss.toUpperCase());
                            continue block10;
                        }
                        sb.append(ch);
                    }
                }
            }
        }
    }
}

