/*
 * Decompiled with CFR 0.152.
 */
package com.github.underscore;

import java.util.HashMap;
import java.util.Map;

public final class Base32 {
    private static final Base32 INSTANCE = new Base32();
    private final char[] digits = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdef".toCharArray();
    private final int mask = this.digits.length - 1;
    private final int shift = Integer.numberOfTrailingZeros(this.digits.length);
    private final Map<Character, Integer> charMap = new HashMap<Character, Integer>();

    private Base32() {
        for (int index = 0; index < this.digits.length; ++index) {
            this.charMap.put(Character.valueOf(this.digits[index]), index);
        }
    }

    public static String decode(String encoded) {
        return new String(INSTANCE.decodeInternal(encoded));
    }

    private byte[] decodeInternal(String encoded) {
        if (encoded.isEmpty()) {
            return new byte[0];
        }
        int encodedLength = encoded.length();
        int outLength = encodedLength * this.shift / 8;
        byte[] result = new byte[outLength];
        int buffer = 0;
        int next = 0;
        int bitsLeft = 0;
        for (char c : encoded.toCharArray()) {
            if (!this.charMap.containsKey(Character.valueOf(c))) {
                throw new DecodingException("Illegal character: " + c);
            }
            buffer <<= this.shift;
            buffer |= this.charMap.get(Character.valueOf(c)) & this.mask;
            if ((bitsLeft += this.shift) < 8) continue;
            result[next++] = (byte)(buffer >> bitsLeft - 8);
            bitsLeft -= 8;
        }
        return result;
    }

    public static String encode(String data) {
        return INSTANCE.encodeInternal(data.getBytes());
    }

    private String encodeInternal(byte[] data) {
        if (data.length == 0) {
            return "";
        }
        int outputLength = (data.length * 8 + this.shift - 1) / this.shift;
        StringBuilder result = new StringBuilder(outputLength);
        int buffer = data[0];
        int next = 1;
        for (int bitsLeft = 8; bitsLeft > 0 || next < data.length; bitsLeft -= this.shift) {
            if (bitsLeft < this.shift) {
                if (next < data.length) {
                    buffer <<= 8;
                    buffer |= data[next++] & 0xFF;
                    bitsLeft += 8;
                } else {
                    int pad = this.shift - bitsLeft;
                    buffer <<= pad;
                    bitsLeft += pad;
                }
            }
            int index = this.mask & buffer >> bitsLeft - this.shift;
            result.append(this.digits[index]);
        }
        return result.toString();
    }

    public static class DecodingException
    extends RuntimeException {
        public DecodingException(String message) {
            super(message);
        }
    }
}

