/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.createstuffadditions.item;

import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.mcreator.createstuffadditions.client.model.Modelandesite_exoskeleton;
import net.mcreator.createstuffadditions.init.CreateSaModItems;
import net.mcreator.createstuffadditions.network.CreateSaModVariables;
import net.mcreator.createstuffadditions.procedures.AndesiteExoskeletonBodyTickEventProcedure;
import net.mcreator.createstuffadditions.procedures.LocalizationHandlerProcedure;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.RegisterEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public abstract class AndesiteExoskeletonItem
extends ArmorItem {
    public static Holder<ArmorMaterial> ARMOR_MATERIAL = null;

    @SubscribeEvent
    public static void registerArmorMaterial(RegisterEvent event) {
        event.register(Registries.ARMOR_MATERIAL, registerHelper -> {
            ArmorMaterial armorMaterial = new ArmorMaterial((Map)Util.make(new EnumMap(ArmorItem.Type.class), map -> {
                map.put(ArmorItem.Type.BOOTS, 2);
                map.put(ArmorItem.Type.LEGGINGS, 5);
                map.put(ArmorItem.Type.CHESTPLATE, 7);
                map.put(ArmorItem.Type.HELMET, 2);
                map.put(ArmorItem.Type.BODY, 7);
            }), 9, (Holder)DeferredHolder.create((ResourceKey)Registries.SOUND_EVENT, (ResourceLocation)ResourceLocation.parse((String)"item.armor.equip_netherite")), () -> Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Blocks.ANDESITE), new ItemStack((ItemLike)Items.IRON_INGOT)}), List.of(new ArmorMaterial.Layer(ResourceLocation.parse((String)"create_sa:invisible"))), 0.0f, 0.0f);
            registerHelper.register(ResourceLocation.parse((String)"create_sa:andesite_exoskeleton"), (Object)armorMaterial);
            ARMOR_MATERIAL = BuiltInRegistries.ARMOR_MATERIAL.wrapAsHolder((Object)armorMaterial);
        });
    }

    @SubscribeEvent
    public static void registerItemExtensions(RegisterClientExtensionsEvent event) {
        event.registerItem(new IClientItemExtensions(){

            @OnlyIn(value=Dist.CLIENT)
            public HumanoidModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("body", new Modelandesite_exoskeleton<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelandesite_exoskeleton.LAYER_LOCATION)).body, "left_arm", new Modelandesite_exoskeleton<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelandesite_exoskeleton.LAYER_LOCATION)).leftArm, "right_arm", new Modelandesite_exoskeleton<T>((ModelPart)Minecraft.getInstance().getEntityModels().bakeLayer((ModelLayerLocation)Modelandesite_exoskeleton.LAYER_LOCATION)).rightArm, "head", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                armorModel.crouching = living.isShiftKeyDown();
                armorModel.riding = defaultModel.riding;
                armorModel.young = living.isBaby();
                return armorModel;
            }
        }, new Item[]{(Item)CreateSaModItems.ANDESITE_EXOSKELETON_CHESTPLATE.get()});
    }

    public AndesiteExoskeletonItem(ArmorItem.Type type, Item.Properties properties) {
        super(ARMOR_MATERIAL, type, properties);
    }

    public static class Chestplate
    extends AndesiteExoskeletonItem {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE, new Item.Properties().stacksTo(1));
        }

        public boolean isBarVisible(ItemStack stack) {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getBarWidth(ItemStack stack) {
            LocalPlayer entity;
            LocalPlayer localPlayer = entity = Minecraft.getInstance().player != null ? Minecraft.getInstance().player : null;
            if (entity != null) {
                if (((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") > CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity) {
                    return 13;
                }
                return (int)(((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") * (1.0 / CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity) * 13.0);
            }
            return (int)(((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") * 0.0 * 13.0);
        }

        public int getBarColor(ItemStack stack) {
            return 16099696;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
            LocalPlayer entity = Minecraft.getInstance().player != null ? Minecraft.getInstance().player : null;
            int tagFuel = 0;
            tagFuel = (int)((CustomData)itemstack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel");
            if (entity != null) {
                if (Screen.hasShiftDown()) {
                    list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString().replace("\u00a77", "\u00a7f")));
                    list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.fuel").getString() + " \u00a78" + tagFuel + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
                    list.add((Component)Component.literal((String)" "));
                    list.addAll(LocalizationHandlerProcedure.execute(Component.translatable((String)"item_desc.andesite_exoskeleton.desc").getString(), 0));
                    list.add((Component)Component.literal((String)" "));
                    list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.used").getString()));
                    list.addAll(LocalizationHandlerProcedure.execute(Component.translatable((String)"item_desc.andesite_exoskeleton.desc2").getString(), 1));
                } else {
                    list.add((Component)Component.literal((String)Component.translatable((String)"item_desc.holdshift").getString()));
                    list.add((Component)Component.literal((String)(Component.translatable((String)"item_desc.fuel").getString() + " \u00a78" + tagFuel + "/" + Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)entity.level()).gadgetCapacity))));
                }
            }
            super.appendHoverText(itemstack, context, list, flag);
        }

        public boolean isEnchantable(ItemStack stack) {
            return true;
        }

        public ResourceLocation getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, ArmorMaterial.Layer layer, boolean innerModel) {
            double tagRotate = 0.0;
            tagRotate = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagRotate");
            if (tagRotate == 2.0) {
                return ResourceLocation.parse((String)"create_sa:textures/entities/andesite_exoskeleton/andesite_exoskeleton_2.png");
            }
            if (tagRotate == 3.0) {
                return ResourceLocation.parse((String)"create_sa:textures/entities/andesite_exoskeleton/andesite_exoskeleton_3.png");
            }
            if (tagRotate == 4.0) {
                return ResourceLocation.parse((String)"create_sa:textures/entities/andesite_exoskeleton/andesite_exoskeleton_4.png");
            }
            if (tagRotate == 5.0) {
                return ResourceLocation.parse((String)"create_sa:textures/entities/andesite_exoskeleton/andesite_exoskeleton_5.png");
            }
            if (tagRotate == 6.0) {
                return ResourceLocation.parse((String)"create_sa:textures/entities/andesite_exoskeleton/andesite_exoskeleton_6.png");
            }
            if (tagRotate == 7.0) {
                return ResourceLocation.parse((String)"create_sa:textures/entities/andesite_exoskeleton/andesite_exoskeleton_7.png");
            }
            if (tagRotate == 8.0) {
                return ResourceLocation.parse((String)"create_sa:textures/entities/andesite_exoskeleton/andesite_exoskeleton_8.png");
            }
            return ResourceLocation.parse((String)"create_sa:textures/entities/andesite_exoskeleton/andesite_exoskeleton_1.png");
        }

        public boolean overrideOtherStackedOnMe(ItemStack localTool, ItemStack potentialFuel, Slot slot, ClickAction action, Player player, SlotAccess access) {
            if (localTool.getCount() > 1) {
                return false;
            }
            if (action != ClickAction.SECONDARY || !slot.allowModification(player)) {
                return false;
            }
            if (potentialFuel.getBurnTime(null) > 0) {
                if (((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") >= CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity) {
                    return false;
                }
                double fuelBonus = Math.round((double)potentialFuel.getBurnTime(null) * 0.005);
                if (Screen.hasControlDown()) {
                    int insertedAmount = potentialFuel.getCount();
                    double totalFuelBonus = fuelBonus * (double)potentialFuel.getCount();
                    if (((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + fuelBonus > CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity) {
                        insertedAmount += (int)Math.round(CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity - ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") / fuelBonus);
                    }
                    CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)localTool, tag -> tag.putDouble("tagFuel", ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + totalFuelBonus > CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity ? CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity : ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + totalFuelBonus));
                    if (potentialFuel.getItem() == Items.LAVA_BUCKET) {
                        if (potentialFuel.getCount() == 1) {
                            access.set(new ItemStack((ItemLike)Items.BUCKET));
                        }
                        if (potentialFuel.getCount() > 1) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET));
                        }
                    }
                    potentialFuel.shrink(insertedAmount);
                } else {
                    CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)localTool, tag -> tag.putDouble("tagFuel", ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + fuelBonus > CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity ? CreateSaModVariables.MapVariables.get((LevelAccessor)player.level()).gadgetCapacity : ((CustomData)localTool.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("tagFuel") + fuelBonus));
                    if (potentialFuel.getItem() == Items.LAVA_BUCKET) {
                        if (potentialFuel.getCount() == 1) {
                            access.set(new ItemStack((ItemLike)Items.BUCKET));
                        }
                        if (potentialFuel.getCount() > 1) {
                            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.BUCKET));
                        }
                    }
                    potentialFuel.shrink(1);
                }
                this.playSound(player, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.fire.extinguish")));
                return true;
            }
            return false;
        }

        protected void playSound(Player player, SoundEvent soundEvent) {
            player.playSound(soundEvent, 0.8f, 0.8f + player.level().getRandom().nextFloat() * 0.1f);
        }

        public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
            Player player;
            super.inventoryTick(itemstack, world, entity, slot, selected);
            if (entity instanceof Player && Iterables.contains((Iterable)(player = (Player)entity).getArmorSlots(), (Object)itemstack)) {
                AndesiteExoskeletonBodyTickEventProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
            }
        }
    }
}

