/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.integration.mmlib.farming.harvest;

import cn.mcmod_mmf.mmlib.block.HighCropBlock;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createintegratedfarming.api.harvester.CustomHarvestBehaviour;

public class HighCropHarvestBehaviour
implements CustomHarvestBehaviour {
    private final HighCropBlock crop;

    protected HighCropHarvestBehaviour(HighCropBlock crop) {
        this.crop = crop;
    }

    @Nullable
    public static HighCropHarvestBehaviour create(Block block) {
        if (block instanceof HighCropBlock) {
            HighCropBlock crop = (HighCropBlock)block;
            return new HighCropHarvestBehaviour(crop);
        }
        return null;
    }

    @Override
    public void harvest(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state) {
        Level level = context.world;
        boolean replant = CustomHarvestBehaviour.replant();
        int age = this.crop.getAge(state);
        if (age < this.crop.getMaxAge() && !CustomHarvestBehaviour.partial()) {
            return;
        }
        if (replant) {
            int growUpperAge = this.crop.getGrowUpperAge();
            if (age < growUpperAge) {
                return;
            }
            MutableBoolean seedSubtracted = new MutableBoolean(false);
            CustomHarvestBehaviour.harvestBlock(level, pos, (BlockState)this.crop.getStateForAge(growUpperAge).setValue((Property)HighCropBlock.UPPER, (Comparable)((Boolean)state.getValue((Property)HighCropBlock.UPPER))), null, CustomHarvestBehaviour.getHarvestTool(context), 1.0f, stack -> {
                if (!seedSubtracted.getValue().booleanValue() && stack.is(this.crop.asItem())) {
                    stack.shrink(1);
                    seedSubtracted.setTrue();
                }
                behaviour.dropItem(context, stack);
            });
        } else {
            this.destroy(level, behaviour, context, pos, state);
        }
    }

    protected void destroy(Level level, HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state) {
        BlockPos abovePos;
        BlockState aboveState;
        boolean upper = (Boolean)state.getValue((Property)HighCropBlock.UPPER);
        if (upper && (aboveState = level.getBlockState(abovePos = pos.above())).is((Block)this.crop)) {
            this.destroy(level, behaviour, context, abovePos, aboveState);
        }
        BlockHelper.destroyBlockAs((Level)level, (BlockPos)pos, null, (ItemStack)CustomHarvestBehaviour.getHarvestTool(context), (float)1.0f, stack -> behaviour.dropItem(context, stack));
    }
}

