/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.integration.delightoflight.farming.harvest;

import com.cloudmeow.delightoflight.block.CloudshroomColonyBlock;
import com.cloudmeow.delightoflight.registry.DFItems;
import com.simibubi.create.content.contraptions.actors.harvester.HarvesterMovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createintegratedfarming.api.harvester.CustomHarvestBehaviour;

public class CloudshroomColonyHarvestBehaviour
implements CustomHarvestBehaviour {
    CloudshroomColonyBlock colony;

    public CloudshroomColonyHarvestBehaviour(CloudshroomColonyBlock colony) {
        this.colony = colony;
    }

    @Nullable
    public static CloudshroomColonyHarvestBehaviour create(Block block) {
        if (!(block instanceof CloudshroomColonyBlock)) {
            return null;
        }
        CloudshroomColonyBlock colony = (CloudshroomColonyBlock)block;
        return new CloudshroomColonyHarvestBehaviour(colony);
    }

    @Override
    public void harvest(HarvesterMovementBehaviour behaviour, MovementContext context, BlockPos pos, BlockState state) {
        int age = (Integer)state.getValue((Property)this.colony.getAgeProperty());
        if (age == 0) {
            return;
        }
        if (age < this.colony.getMaxAge() && !CustomHarvestBehaviour.partial()) {
            return;
        }
        Level level = context.world;
        level.playSound(null, pos, SoundEvents.MOOSHROOM_SHEAR, SoundSource.BLOCKS, 1.0f, 1.0f);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.colony.getAgeProperty(), (Comparable)Integer.valueOf(0)));
        int weather = (Integer)state.getValue((Property)CloudshroomColonyBlock.WEATHER_AGE);
        Item mushroom = weather == 2 ? (Item)DFItems.THUNDER_CLOUDSHROOM.get() : (weather == 1 ? (Item)DFItems.RAINY_CLOUDSHROOM.get() : (Item)DFItems.CLEAR_CLOUDSHROOM.get());
        behaviour.dropItem(context, new ItemStack((ItemLike)mushroom, age));
    }
}

