/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createintegratedfarming.common.ranching.roost.chicken;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import plus.dragons.createintegratedfarming.common.ranching.roost.RoostBlock;
import plus.dragons.createintegratedfarming.common.ranching.roost.RoostCapturable;
import plus.dragons.createintegratedfarming.common.ranching.roost.chicken.ChickenRoostBlockEntity;
import plus.dragons.createintegratedfarming.common.registry.CIFBlockEntities;

public class ChickenRoostBlock
extends RoostBlock
implements IBE<ChickenRoostBlockEntity>,
RoostCapturable {
    protected final Holder<Block> empty;

    public ChickenRoostBlock(BlockBehaviour.Properties properties, Holder<Block> empty) {
        super(properties);
        this.empty = empty;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return this.onBlockEntityUse((BlockGetter)level, pos, coop -> {
            ItemStack stack = coop.outputHandler.extractItem(0, 64, false);
            if (!stack.isEmpty()) {
                player.getInventory().placeItemBackInInventory(stack);
                level.playSound(player, pos, SoundEvents.CHICKEN_EGG, SoundSource.BLOCKS, 1.0f, (level.random.nextFloat() - level.random.nextFloat()) * 0.2f + 1.0f);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        });
    }

    @Override
    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.is(Items.LEAD)) {
            Chicken chicken = new Chicken(EntityType.CHICKEN, level);
            chicken.setPos(pos.getCenter());
            chicken.setLeashedTo((Entity)player, true);
            level.addFreshEntity((Entity)chicken);
            level.setBlockAndUpdate(pos, ((Block)this.empty.value()).withPropertiesOf(state));
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return this.onBlockEntityUseItemOn((BlockGetter)level, pos, coop -> {
            if (coop != null && coop.feedItem(stack, false)) {
                if (!player.hasInfiniteMaterials()) {
                    stack.shrink(1);
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        });
    }

    public void updateEntityAfterFallOn(BlockGetter level, Entity entity) {
        super.updateEntityAfterFallOn(level, entity);
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (!entity.isAlive()) {
            return;
        }
        if (entity.level().isClientSide) {
            return;
        }
        DirectBeltInputBehaviour inputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)entity.blockPosition(), (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        ItemStack remainder = inputBehaviour.handleInsertion(itemEntity.getItem(), Direction.UP, false);
        itemEntity.setItem(remainder);
        if (remainder.isEmpty()) {
            itemEntity.discard();
        }
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return ItemHelper.calcRedstoneFromBlockEntity((IBE)this, (Level)level, (BlockPos)pos);
    }

    protected MapCodec<? extends ChickenRoostBlock> codec() {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)ChickenRoostBlock.propertiesCodec(), (App)BuiltInRegistries.BLOCK.holderByNameCodec().fieldOf("empty").forGetter(block -> block.empty)).apply((Applicative)instance, ChickenRoostBlock::new));
    }

    public Class<ChickenRoostBlockEntity> getBlockEntityClass() {
        return ChickenRoostBlockEntity.class;
    }

    public BlockEntityType<? extends ChickenRoostBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CIFBlockEntities.CHICKEN_ROOST.get();
    }

    @Override
    public ItemInteractionResult captureBlock(Level level, BlockState state, BlockPos pos, ItemStack stack, Player player, Entity entity) {
        Chicken chicken;
        if (entity instanceof Chicken && !(chicken = (Chicken)entity).isBaby()) {
            level.setBlockAndUpdate(pos, this.withPropertiesOf(state));
            chicken.playSound(SoundEvents.CHICKEN_HURT);
            chicken.discard();
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Override
    public InteractionResult captureItem(Level level, ItemStack stack, InteractionHand hand, Player player, Entity entity) {
        Chicken chicken;
        if (entity instanceof Chicken && !(chicken = (Chicken)entity).isBaby()) {
            if (player.hasInfiniteMaterials()) {
                player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)this));
            } else if (stack.getCount() == 1) {
                player.setItemInHand(hand, new ItemStack((ItemLike)this));
            } else {
                player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)this));
                stack.shrink(1);
            }
            chicken.playSound(SoundEvents.CHICKEN_HURT);
            chicken.discard();
            return InteractionResult.sidedSuccess((boolean)player.level().isClientSide);
        }
        return InteractionResult.PASS;
    }
}

