/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.dynlight.lamb;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.Contraption;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.core.BlockPos;
import top.leonx.dynlight.lamb.CreateDynLightSource;
import top.leonx.dynlight.lamb.CreateDynLightSourceCreator;
import top.leonx.dynlight.lamb.LambDynLightsDelegate;

public class CreateDynLightSourceHolder {
    public static final CreateDynLightSourceHolder INSTANCE = new CreateDynLightSourceHolder();
    AtomicInteger atomicInt = new AtomicInteger(0);
    Map<LightSourceKey, CreateDynLightSource> lightSources = new HashMap<LightSourceKey, CreateDynLightSource>();
    private final ReentrantReadWriteLock lightSourcesLock = new ReentrantReadWriteLock();

    private CreateDynLightSourceHolder() {
    }

    public CreateDynLightSource create(AbstractContraptionEntity entity, BlockPos blockPos, int luminance) {
        int id = this.atomicInt.incrementAndGet();
        CreateDynLightSource lightSource = CreateDynLightSourceCreator.createDynLightSource(id, entity, blockPos, luminance);
        this.lightSourcesLock.writeLock().lock();
        this.lightSources.put(new LightSourceKey(entity.getId(), blockPos), lightSource);
        this.lightSourcesLock.writeLock().unlock();
        LambDynLightsDelegate.addLightSource(lightSource);
        return lightSource;
    }

    public void remove(int entityId, BlockPos blockPos) {
        this.lightSourcesLock.writeLock().lock();
        CreateDynLightSource lightSource = this.lightSources.remove(new LightSourceKey(entityId, blockPos));
        if (lightSource != null) {
            LambDynLightsDelegate.removeLightSource(lightSource);
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public void removeAll(AbstractContraptionEntity contraptionEntity) {
        Contraption contraption = contraptionEntity.getContraption();
        if (contraption == null) {
            return;
        }
        this.lightSourcesLock.writeLock().lock();
        for (BlockPos blockPos : contraptionEntity.getContraption().getBlocks().keySet()) {
            CreateDynLightSource lightSource = this.lightSources.remove(new LightSourceKey(contraptionEntity.getId(), blockPos));
            if (lightSource == null) continue;
            LambDynLightsDelegate.removeLightSource(lightSource);
        }
        this.lightSourcesLock.writeLock().unlock();
    }

    public Optional<CreateDynLightSource> get(int entityId, BlockPos blockPos) {
        return this.get(new LightSourceKey(entityId, blockPos));
    }

    public CreateDynLightSource getOrCreate(AbstractContraptionEntity entity, BlockPos blockPos, int luminance) {
        return this.get(entity.getId(), blockPos).orElseGet(() -> this.create(entity, blockPos, luminance));
    }

    public Optional<CreateDynLightSource> get(LightSourceKey key) {
        this.lightSourcesLock.readLock().lock();
        CreateDynLightSource lightSource = this.lightSources.get(key);
        this.lightSourcesLock.readLock().unlock();
        return Optional.ofNullable(lightSource);
    }

    public static class LightSourceKey {
        private final int entityId;
        private final BlockPos blockPos;

        public LightSourceKey(int entityId, BlockPos blockPos) {
            this.entityId = entityId;
            this.blockPos = blockPos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LightSourceKey that = (LightSourceKey)o;
            return this.entityId == that.entityId && Objects.equals(this.blockPos, that.blockPos);
        }

        public int hashCode() {
            return Objects.hash(this.entityId, this.blockPos.asLong());
        }
    }
}

