/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.dynlight.lamb;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import top.leonx.dynlight.config.CreateDynLightAllConfigs;
import top.leonx.dynlight.lamb.LambDynLightsDelegate;

public abstract class CreateDynLightSource {
    private final AbstractContraptionEntity contraptionEntity;
    private final BlockPos localPos;
    private Vec3 lastPosition;
    private Vec3 position;
    private int luminance;
    private int lastLuminance;
    private final int id;
    private long lambDynLightsLastUpdate;
    private ChunkPos chunkPosition;
    private BlockPos blockPos;
    private LongOpenHashSet lambdynlights$trackedLitChunkPos = new LongOpenHashSet();

    public CreateDynLightSource(int id, AbstractContraptionEntity entity, BlockPos localPos, int luminance) {
        this.contraptionEntity = entity;
        this.id = id;
        this.luminance = luminance;
        this.lastPosition = Vec3.ZERO;
        this.localPos = localPos;
        Vec3 worldPos = entity.toGlobalVector(VecHelper.getCenterOf((Vec3i)localPos), 1.0f);
        this.setPosition(worldPos);
    }

    private void setPosition(Vec3 position) {
        this.position = position;
        int x = Mth.floor((double)position.x());
        int y = Mth.floor((double)position.y());
        int z = Mth.floor((double)position.z());
        this.blockPos = new BlockPos(x, y, z);
        this.chunkPosition = new ChunkPos(this.blockPos);
    }

    public BlockPos blockPosition() {
        return this.blockPos;
    }

    public double getDynamicLightX() {
        return this.position.x;
    }

    public double getDynamicLightY() {
        return this.position.y;
    }

    public double getDynamicLightZ() {
        return this.position.z;
    }

    public Level getDynamicLightLevel() {
        return this.contraptionEntity.level();
    }

    public void resetDynamicLight() {
        this.luminance = 0;
    }

    public int getLuminance() {
        return (int)((double)this.luminance * (Double)CreateDynLightAllConfigs.client().luminanceMultiplier.get());
    }

    public void dynamicLightTick() {
    }

    public void syncPositionAndLuminance() {
        if (this.contraptionEntity.level() == Minecraft.getInstance().level) {
            int newLuminance;
            Vec3 newPosition = this.contraptionEntity.toGlobalVector(VecHelper.getCenterOf((Vec3i)this.localPos), 1.0f);
            this.setPosition(newPosition);
            StructureTemplate.StructureBlockInfo blockInfo = (StructureTemplate.StructureBlockInfo)this.contraptionEntity.getContraption().getBlocks().get(this.localPos);
            if (blockInfo != null && (newLuminance = blockInfo.state().getLightEmission()) != this.luminance) {
                this.luminance = newLuminance;
            }
        }
    }

    public boolean shouldUpdateDynamicLight() {
        if (!((Boolean)CreateDynLightAllConfigs.client().enableLambDynamicLight.get()).booleanValue() || !LambDynLightsDelegate.getDynamicLightsModeEnabled()) {
            return false;
        }
        int delay = CreateDynLightAllConfigs.client().getUpdateInterval();
        if (delay > 0) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lambDynLightsLastUpdate + (long)delay) {
                return false;
            }
            this.lambDynLightsLastUpdate = currentTime;
        }
        return true;
    }

    public boolean lambdynlights$updateDynamicLight(@NotNull LevelRenderer renderer) {
        if (!this.shouldUpdateDynamicLight()) {
            return false;
        }
        this.syncPositionAndLuminance();
        double deltaX = this.position.x() - this.lastPosition.x();
        double deltaY = this.position.y() - this.lastPosition.y();
        double deltaZ = this.position.z() - this.lastPosition.z();
        int luminance = this.getLuminance();
        if (Math.abs(deltaX) > 0.1 || Math.abs(deltaY) > 0.1 || Math.abs(deltaZ) > 0.1 || luminance != this.lastLuminance) {
            this.lastPosition = new Vec3(this.position.x(), this.position.y(), this.position.z());
            this.lastLuminance = luminance;
            LongOpenHashSet newPos = new LongOpenHashSet();
            if (luminance > 0) {
                ChunkPos entityChunkPos = this.chunkPosition;
                BlockPos.MutableBlockPos chunkPos = new BlockPos.MutableBlockPos(entityChunkPos.x, SectionPos.posToSectionCoord((double)this.position.y), entityChunkPos.z);
                LambDynLightsDelegate.scheduleChunkRebuild(renderer, chunkPos);
                LambDynLightsDelegate.updateTrackedChunks(chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                Direction directionX = (this.blockPosition().getX() & 0xF) >= 8 ? Direction.EAST : Direction.WEST;
                Direction directionY = (this.blockPosition().getY() & 0xF) >= 8 ? Direction.UP : Direction.DOWN;
                Direction directionZ = (this.blockPosition().getZ() & 0xF) >= 8 ? Direction.SOUTH : Direction.NORTH;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.move(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.move(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.move(directionX.getOpposite());
                    } else {
                        chunkPos.move(directionZ.getOpposite());
                        chunkPos.move(directionY);
                    }
                    LambDynLightsDelegate.scheduleChunkRebuild(renderer, chunkPos);
                    LambDynLightsDelegate.updateTrackedChunks(chunkPos, this.lambdynlights$trackedLitChunkPos, newPos);
                }
            }
            this.lambdynlights$scheduleTrackedChunksRebuild(renderer);
            this.lambdynlights$trackedLitChunkPos = newPos;
            return true;
        }
        return false;
    }

    public void lambdynlights$scheduleTrackedChunksRebuild(@NotNull LevelRenderer renderer) {
        if (this.contraptionEntity.level() == Minecraft.getInstance().level) {
            LongIterator longIterator = this.lambdynlights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                LambDynLightsDelegate.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

