/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.dynlight;

import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import top.leonx.dynlight.config.CreateDynLightAllConfigs;

public class LightMovementBehaviour
implements MovementBehaviour {
    private final int luminance;
    private static final String LightBlockPrevPosKey = "LightBlockPrevPos";

    public LightMovementBehaviour(int luminance) {
        this.luminance = luminance;
    }

    public void stopMoving(MovementContext context) {
        if (context.world.isClientSide()) {
            return;
        }
        this.cleanPreviousLightBlock(context);
    }

    public void visitNewPosition(MovementContext context, BlockPos pos) {
        if (context.world.isClientSide()) {
            return;
        }
        this.cleanPreviousLightBlock(context);
        this.createNewLightBlock(context, pos);
    }

    private void cleanPreviousLightBlock(MovementContext context) {
        Optional prevBlockPos;
        if (context.data.contains(LightBlockPrevPosKey) && (prevBlockPos = NbtUtils.readBlockPos((CompoundTag)context.data, (String)LightBlockPrevPosKey)).isPresent()) {
            context.world.setBlock((BlockPos)prevBlockPos.get(), Blocks.AIR.defaultBlockState(), 2);
            context.data.remove(LightBlockPrevPosKey);
        }
    }

    private void createNewLightBlock(MovementContext context, BlockPos pos) {
        if (!((Boolean)CreateDynLightAllConfigs.server().enableLightBlock.get()).booleanValue() || (Integer)CreateDynLightAllConfigs.server().lightBlockEmissionLowerLimit.get() > this.luminance) {
            return;
        }
        BlockState originBlockState = context.world.getBlockState(pos);
        if (originBlockState.is(Blocks.AIR)) {
            context.world.setBlock(pos, Blocks.LIGHT.defaultBlockState(), 2);
            context.data.put(LightBlockPrevPosKey, NbtUtils.writeBlockPos((BlockPos)pos));
        }
    }
}

