/*
 * Decompiled with CFR 0.152.
 */
package top.leonx.dynlight;

import com.mojang.logging.LogUtils;
import com.simibubi.create.api.behaviour.movement.MovementBehaviour;
import com.simibubi.create.api.registry.SimpleRegistry;
import java.util.Collection;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import org.slf4j.Logger;
import top.leonx.dynlight.LightBehaviourProvider;
import top.leonx.dynlight.LightMovementBehaviour;
import top.leonx.dynlight.config.CreateDynLightAllConfigs;

@Mod(value="createdynlight")
public class CreateDynLight {
    public static final String MODID = "createdynlight";
    public static final Logger LOGGER = LogUtils.getLogger();

    public CreateDynLight(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        CreateDynLightAllConfigs.register(modLoadingContext, modContainer);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> MovementBehaviour.REGISTRY.registerProvider((SimpleRegistry.Provider)new LightBehaviourProvider()));
    }

    public static void registerBehaviours(Collection<Block> blocks) {
        LOGGER.info("Registering DynLightMovementBehaviours");
        blocks.forEach(block -> {
            int lightEmission = block.defaultBlockState().getLightEmission();
            if (MovementBehaviour.REGISTRY.get(block) == null) {
                MovementBehaviour.REGISTRY.register(block, (Object)new LightMovementBehaviour(lightEmission));
            }
        });
        LOGGER.info("Registered LightMovementBehaviour for [{}]", (Object)String.join((CharSequence)", ", blocks.stream().map(Block::getDescriptionId).toList()));
    }
}

