/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.transmitter;

import com.krei.cmpackagecouriers.ServerConfig;
import com.krei.cmpackagecouriers.transmitter.LocationTransmitterReg;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class LocationTransmitterItem
extends Item {
    public LocationTransmitterItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public boolean isFoil(@NotNull ItemStack stack) {
        return LocationTransmitterItem.isEnabled(stack);
    }

    public static boolean isEnabled(ItemStack stack) {
        CompoundTag tag = LocationTransmitterItem.ensureTag(stack);
        return tag.getBoolean("Enabled");
    }

    public static void toggleState(ItemStack stack) {
        boolean currentState = LocationTransmitterItem.isEnabled(stack);
        CompoundTag tag = LocationTransmitterItem.ensureTag(stack);
        tag.putBoolean("Enabled", !currentState);
        stack.set(LocationTransmitterReg.TRANSMITTER_ENABLED, (Object)CustomData.of((CompoundTag)tag));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext tooltipContext, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, tooltipContext, tooltipComponents, tooltipFlag);
        boolean enabled = LocationTransmitterItem.isEnabled(stack);
        MutableComponent statusText = Component.translatable((String)(enabled ? "item.cmpackagecouriers.location_transmitter.enabled" : "item.cmpackagecouriers.location_transmitter.disabled")).withStyle(enabled ? ChatFormatting.GREEN : ChatFormatting.RED);
        tooltipComponents.add((Component)Component.translatable((String)"item.cmpackagecouriers.location_transmitter.status").append(": ").append((Component)statusText));
        tooltipComponents.add((Component)Component.translatable((String)"item.cmpackagecouriers.location_transmitter.server_config").append(": ").append((Component)Component.literal((String)String.valueOf(ServerConfig.locationTransmitterNeeded)).withStyle(ServerConfig.locationTransmitterNeeded ? ChatFormatting.GREEN : ChatFormatting.RED)));
        tooltipComponents.add((Component)Component.translatable((String)"item.cmpackagecouriers.location_transmitter.tooltip").withStyle(ChatFormatting.GRAY));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!level.isClientSide) {
            boolean currentState = LocationTransmitterItem.isEnabled(stack);
            LocationTransmitterItem.toggleState(stack);
            MutableComponent message = Component.translatable((String)(!currentState ? "item.cmpackagecouriers.location_transmitter.activated" : "item.cmpackagecouriers.location_transmitter.deactivated")).withStyle(!currentState ? ChatFormatting.GREEN : ChatFormatting.RED);
            player.displayClientMessage((Component)message, true);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.inventoryMenu.broadcastChanges();
            }
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private static CompoundTag ensureTag(ItemStack stack) {
        CompoundTag tag = ((CustomData)stack.getOrDefault(LocationTransmitterReg.TRANSMITTER_ENABLED, (Object)CustomData.EMPTY)).copyTag();
        if (!tag.contains("Enabled")) {
            tag.putBoolean("Enabled", false);
            stack.set(LocationTransmitterReg.TRANSMITTER_ENABLED, (Object)CustomData.of((CompoundTag)tag));
        }
        return tag;
    }
}

