/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.plane;

import com.krei.cmpackagecouriers.PackageCouriers;
import com.krei.cmpackagecouriers.ServerConfig;
import com.krei.cmpackagecouriers.compat.Mods;
import com.krei.cmpackagecouriers.compat.curios.CuriosCompat;
import com.krei.cmpackagecouriers.marker.AddressMarkerHandler;
import com.krei.cmpackagecouriers.plane.CardboardPlaneEntity;
import com.krei.cmpackagecouriers.plane.CardboardPlaneItemRenderer;
import com.krei.cmpackagecouriers.plane.EjectorLaunchEffect;
import com.krei.cmpackagecouriers.transmitter.LocationTransmitterItem;
import com.simibubi.create.content.logistics.box.PackageItem;
import com.simibubi.create.content.logistics.box.PackageStyles;
import com.simibubi.create.content.logistics.depot.DepotBlockEntity;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class CardboardPlaneItem
extends Item
implements EjectorLaunchEffect {
    public CardboardPlaneItem(Item.Properties p) {
        super(p.stacksTo(1));
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (this.getUseDuration(stack, entityLiving) - timeLeft >= 10 && !level.isClientSide()) {
                String address = CardboardPlaneItem.getAddress(stack);
                ItemContainerContents container = (ItemContainerContents)stack.get(PackageCouriers.PLANE_PACKAGE);
                ItemStack packageItem = container != null && container.getStackInSlot(0).getItem() instanceof PackageItem ? container.getStackInSlot(0) : PackageStyles.getRandomBox();
                MinecraftServer server = level.getServer();
                if (server != null) {
                    CardboardPlaneEntity plane = new CardboardPlaneEntity(level);
                    plane.setPos(player.getX(), player.getEyeY() - (double)0.1f, player.getZ());
                    plane.setPackage(packageItem);
                    plane.setUnpack((Boolean)stack.getOrDefault(PackageCouriers.PRE_OPENED, (Object)false));
                    plane.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 0.8f, 1.0f);
                    ServerPlayer serverPlayer = server.getPlayerList().getPlayerByName(address);
                    if (serverPlayer != null && ServerConfig.planePlayerTargets) {
                        if (!ServerConfig.locationTransmitterNeeded || CardboardPlaneItem.hasEnabledLocationTransmitter(serverPlayer)) {
                            plane.setTarget((Entity)serverPlayer);
                            level.addFreshEntity((Entity)plane);
                            stack.shrink(1);
                        }
                    } else {
                        AddressMarkerHandler.MarkerTarget target = AddressMarkerHandler.getMarkerTarget(address);
                        if (target != null && CardboardPlaneItem.hasSpace(level, target.pos) && ServerConfig.planeLocationTargets) {
                            plane.setTarget(target.pos, target.level);
                            level.addFreshEntity((Entity)plane);
                            stack.shrink(1);
                        }
                    }
                    player.displayClientMessage((Component)Component.translatable((String)"cmpackagecouriers.message.no_address"), true);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        if (player.isCrouching()) {
            ItemStack box = CardboardPlaneItem.getPackage(player.getItemInHand(hand));
            player.getItemInHand(hand).shrink(1);
            player.getInventory().placeItemBackInInventory(box);
            player.getInventory().placeItemBackInInventory(PackageCouriers.CARDBOARD_PLANE_PARTS_ITEM.asStack());
        } else {
            player.startUsingItem(hand);
        }
        return InteractionResultHolder.consume((Object)player.getItemInHand(hand));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    @Override
    public boolean onEject(ItemStack stack, Level level, BlockPos pos) {
        if (level.isClientSide()) {
            return false;
        }
        float yaw = switch ((Direction)level.getBlockState(pos).getValue((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            case Direction.NORTH -> 180.0f;
            case Direction.SOUTH -> 0.0f;
            case Direction.WEST -> 90.0f;
            default -> -90.0f;
        };
        String address = CardboardPlaneItem.getAddress(stack);
        ItemContainerContents container = (ItemContainerContents)stack.get(PackageCouriers.PLANE_PACKAGE);
        ItemStack packageItem = container != null && container.getStackInSlot(0).getItem() instanceof PackageItem ? container.getStackInSlot(0) : PackageStyles.getRandomBox();
        MinecraftServer server = level.getServer();
        if (server != null) {
            CardboardPlaneEntity plane = new CardboardPlaneEntity(level);
            plane.setPos(Vec3.atCenterOf((Vec3i)pos).add(0.0, 1.0, 0.0));
            plane.setPackage(packageItem);
            plane.setUnpack((Boolean)stack.getOrDefault(PackageCouriers.PRE_OPENED, (Object)false));
            plane.shootFromRotation(-37.5f, yaw, 0.0f, 0.8f, 1.0f);
            ServerPlayer serverPlayer = server.getPlayerList().getPlayerByName(address);
            if (serverPlayer != null && ServerConfig.planePlayerTargets) {
                if (!ServerConfig.locationTransmitterNeeded || CardboardPlaneItem.hasEnabledLocationTransmitter(serverPlayer)) {
                    plane.setTarget((Entity)serverPlayer);
                    level.addFreshEntity((Entity)plane);
                    return true;
                }
            } else {
                AddressMarkerHandler.MarkerTarget target = AddressMarkerHandler.getMarkerTarget(address);
                if (target != null && CardboardPlaneItem.hasSpace(level, target.pos) && ServerConfig.planeLocationTargets) {
                    plane.setTarget(target.pos, target.level);
                    level.addFreshEntity((Entity)plane);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean hasSpace(Level level, BlockPos pos) {
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof DepotBlockEntity) {
            DepotBlockEntity depotBlockEntity = (DepotBlockEntity)be;
            return depotBlockEntity.getHeldItem().isEmpty();
        }
        return true;
    }

    public static boolean hasEnabledLocationTransmitter(ServerPlayer player) {
        for (ItemStack stack : player.getInventory().items) {
            if (!(stack.getItem() instanceof LocationTransmitterItem) || !LocationTransmitterItem.isEnabled(stack)) continue;
            return true;
        }
        if (Mods.CURIOS.isLoaded() && CuriosCompat.isCuriosLoaded()) {
            return CuriosCompat.hasEnabledLocationTransmitterInCurios(player);
        }
        return false;
    }

    public static ItemStack withPackage(ItemStack box) {
        ItemStack plane = PackageCouriers.CARDBOARD_PLANE_ITEM.asStack();
        CardboardPlaneItem.setPackage(plane, box);
        return plane;
    }

    public static void setPackage(ItemStack plane, ItemStack box) {
        if (box.getItem() instanceof PackageItem) {
            ItemContainerContents container = ItemContainerContents.fromItems((List)NonNullList.of((Object)ItemStack.EMPTY, (Object[])new ItemStack[]{box.copy()}));
            plane.set(PackageCouriers.PLANE_PACKAGE, (Object)container);
        }
    }

    public static ItemStack getPackage(ItemStack plane) {
        ItemContainerContents container = (ItemContainerContents)plane.get(PackageCouriers.PLANE_PACKAGE);
        if (container == null) {
            return ItemStack.EMPTY;
        }
        return container.getStackInSlot(0);
    }

    public static String getAddress(ItemStack plane) {
        if (plane.getItem() instanceof CardboardPlaneItem) {
            String address = PackageItem.getAddress((ItemStack)CardboardPlaneItem.getPackage(plane));
            int atIndex = address.indexOf(64);
            if (atIndex != -1) {
                address = address.substring(atIndex + 1);
            }
            return address;
        }
        return "";
    }

    public static void setPreOpened(ItemStack plane, boolean preopened) {
        ItemContainerContents container;
        Object object;
        if (plane.getItem() instanceof CardboardPlaneItem && (object = plane.get(PackageCouriers.PLANE_PACKAGE)) instanceof ItemContainerContents && PackageItem.isPackage((ItemStack)(container = (ItemContainerContents)object).getStackInSlot(0))) {
            plane.set(PackageCouriers.PRE_OPENED, (Object)preopened);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        ItemStack box = CardboardPlaneItem.getPackage(stack);
        if (box != null) {
            if (((Boolean)stack.getOrDefault(PackageCouriers.PRE_OPENED, (Object)false)).booleanValue()) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.cmpackagecouriers.cardboard_plane.preopened").withStyle(ChatFormatting.AQUA));
            }
            box.getItem().appendHoverText(box, context, tooltipComponents, tooltipFlag);
        } else {
            super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new CardboardPlaneItemRenderer()));
    }
}

