/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.plane;

import com.krei.cmpackagecouriers.plane.CardboardPlaneEntity;
import com.krei.cmpackagecouriers.plane.CardboardPlaneItemRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CardboardPlaneEntityRenderer
extends EntityRenderer<CardboardPlaneEntity> {
    public CardboardPlaneEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(CardboardPlaneEntity entity, float yaw, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light) {
        ms.pushPose();
        ms.translate(0.0, 0.25, 0.0);
        ms.scale(0.75f, 0.75f, 0.75f);
        ms.mulPose(Axis.YP.rotationDegrees(90.0f + yaw));
        ms.mulPose(Axis.XP.rotationDegrees(Mth.lerp((float)partialTicks, (float)entity.oldDeltaYaw, (float)entity.newDeltaYaw) * -4.0f));
        ms.mulPose(Axis.ZP.rotationDegrees(-Mth.lerp((float)partialTicks, (float)entity.xRotO, (float)entity.getXRot())));
        CardboardPlaneItemRenderer.renderPlane(entity.getPackage(), ms, buffer, light);
        ms.popPose();
        super.render((Entity)entity, yaw, partialTicks, ms, buffer, light);
    }

    public ResourceLocation getTextureLocation(CardboardPlaneEntity entity) {
        return null;
    }

    public static void init() {
    }
}

