/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers.compat.curios;

import com.krei.cmpackagecouriers.transmitter.LocationTransmitterItem;
import java.util.Map;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat {
    public static boolean hasEnabledLocationTransmitterInCurios(ServerPlayer player) {
        return CuriosApi.getCuriosInventory((LivingEntity)player).map(curiosInventory -> {
            Map curios = curiosInventory.getCurios();
            for (ICurioStacksHandler handler : curios.values()) {
                IDynamicStackHandler stacks = handler.getStacks();
                for (int i = 0; i < stacks.getSlots(); ++i) {
                    ItemStack stack = stacks.getStackInSlot(i);
                    if (!(stack.getItem() instanceof LocationTransmitterItem) || !LocationTransmitterItem.isEnabled(stack)) continue;
                    return true;
                }
            }
            return false;
        }).orElse(false);
    }

    public static boolean isCuriosLoaded() {
        try {
            Class.forName("top.theillusivec4.curios.api.CuriosApi");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

