/*
 * Decompiled with CFR 0.152.
 */
package com.krei.cmpackagecouriers;

import com.krei.cmpackagecouriers.ServerConfig;
import com.krei.cmpackagecouriers.compat.Mods;
import com.krei.cmpackagecouriers.compat.curios.Curios;
import com.krei.cmpackagecouriers.plane.CardboardPlaneEntity;
import com.krei.cmpackagecouriers.plane.CardboardPlaneEntityRenderer;
import com.krei.cmpackagecouriers.plane.CardboardPlaneItem;
import com.krei.cmpackagecouriers.plane.CardboardPlaneItemRenderer;
import com.krei.cmpackagecouriers.plane.CardboardPlanePartsItem;
import com.krei.cmpackagecouriers.ponder.PonderScenes;
import com.krei.cmpackagecouriers.stock_ticker.PortableStockTickerReg;
import com.krei.cmpackagecouriers.transmitter.LocationTransmitterReg;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.simibubi.create.AllCreativeModeTabs;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.item.ItemDescription;
import com.simibubi.create.foundation.item.KineticStats;
import com.simibubi.create.foundation.item.TooltipModifier;
import com.tterrag.registrate.util.entry.EntityEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import java.util.function.Supplier;
import net.createmod.catnip.lang.FontHelper;
import net.createmod.ponder.api.registration.PonderPlugin;
import net.createmod.ponder.foundation.PonderIndex;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.component.ItemContainerContents;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

@Mod(value="cmpackagecouriers")
public class PackageCouriers {
    public static final String MODID = "cmpackagecouriers";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final CreateRegistrate REGISTRATE = (CreateRegistrate)CreateRegistrate.create((String)"cmpackagecouriers").defaultCreativeTab(AllCreativeModeTabs.BASE_CREATIVE_TAB.getKey());
    public static final EntityEntry<CardboardPlaneEntity> CARDBOARD_PLANE_ENTITY;
    public static final ItemEntry<CardboardPlaneItem> CARDBOARD_PLANE_ITEM;
    public static final ItemEntry<CardboardPlanePartsItem> CARDBOARD_PLANE_PARTS_ITEM;
    public static final DeferredRegister.DataComponents DATA_COMPONENTS;
    public static final Supplier<DataComponentType<ItemContainerContents>> PLANE_PACKAGE;
    public static final Supplier<DataComponentType<Boolean>> PRE_OPENED;

    public PackageCouriers(IEventBus modEventBus, ModContainer modContainer) {
        if (!Mods.CREATE_MOBILE_PACKAGES.isLoaded()) {
            PortableStockTickerReg.register();
        }
        LocationTransmitterReg.register();
        modContainer.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.SPEC);
        REGISTRATE.registerEventListeners(modEventBus);
        DATA_COMPONENTS.register(modEventBus);
        modEventBus.addListener(PackageCouriers::clientInit);
        Mods.CURIOS.executeIfInstalled(() -> () -> Curios.init(modEventBus));
        CardboardPlaneEntity.init();
        modEventBus.addListener(ServerConfig::onLoad);
        modEventBus.addListener(ServerConfig::onReload);
    }

    public static void clientInit(FMLClientSetupEvent event) {
        CardboardPlaneEntityRenderer.init();
        CardboardPlaneItemRenderer.init();
        PonderIndex.addPlugin((PonderPlugin)new PonderScenes());
        EntityRenderers.register((EntityType)((EntityType)CARDBOARD_PLANE_ENTITY.get()), CardboardPlaneEntityRenderer::new);
    }

    static {
        REGISTRATE.setTooltipModifierFactory(item -> new ItemDescription.Modifier(item, FontHelper.Palette.STANDARD_CREATE).andThen(TooltipModifier.mapNull((TooltipModifier)KineticStats.create((Item)item))));
        CARDBOARD_PLANE_ENTITY = REGISTRATE.entity("cardboard_plane", CardboardPlaneEntity::createEmpty, MobCategory.MISC).properties(p -> p.sized(0.5f, 0.5f).eyeHeight(0.25f).clientTrackingRange(80).updateInterval(1)).register();
        CARDBOARD_PLANE_ITEM = REGISTRATE.item("cardboard_plane", CardboardPlaneItem::new).model((ctx, prov) -> {}).register();
        CARDBOARD_PLANE_PARTS_ITEM = REGISTRATE.item("cardboard_plane_parts", CardboardPlanePartsItem::new).model((ctx, prov) -> {}).register();
        DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)MODID);
        PLANE_PACKAGE = DATA_COMPONENTS.registerComponentType("plane_package", builder -> builder.persistent(ItemContainerContents.CODEC).networkSynchronized(ItemContainerContents.STREAM_CODEC));
        PRE_OPENED = DATA_COMPONENTS.registerComponentType("plane_preopened", builder -> builder.persistent((Codec)Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    }
}

