/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.butchery.block.WardencarcassBlock;
import net.mcreator.butchery.block.entity.WardencarcassBlockEntity;
import net.mcreator.butchery.client.model.Modelwarden_carcass;
import net.mcreator.butchery.client.model.animations.warden_armlessAnimation;
import net.mcreator.butchery.client.model.animations.warden_bodylessAnimation;
import net.mcreator.butchery.client.model.animations.warden_headlessAnimation;
import net.mcreator.butchery.client.model.animations.warden_riblessAnimation;
import net.mcreator.butchery.init.ButcheryModBlockEntities;
import net.mcreator.butchery.procedures.Wardenanimationcondition1Procedure;
import net.mcreator.butchery.procedures.Wardenanimationcondition2Procedure;
import net.mcreator.butchery.procedures.Wardenanimationcondition3Procedure;
import net.mcreator.butchery.procedures.Wardenanimationcondition4Procedure;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class WardencarcassRenderer
implements BlockEntityRenderer<WardencarcassBlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;

    WardencarcassRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modelwarden_carcass.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"butchery:textures/block/warden.png");
    }

    private void updateRenderState(WardencarcassBlockEntity blockEntity) {
        int tickCount = (int)blockEntity.getLevel().getGameTime();
        blockEntity.animationState0.animateWhen(Wardenanimationcondition1Procedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState1.animateWhen(Wardenanimationcondition2Procedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState2.animateWhen(Wardenanimationcondition3Procedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
        blockEntity.animationState3.animateWhen(Wardenanimationcondition4Procedure.execute((LevelAccessor)blockEntity.getLevel(), blockEntity.getBlockPos().getX(), blockEntity.getBlockPos().getY(), blockEntity.getBlockPos().getZ()), tickCount);
    }

    public void render(WardencarcassBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        this.updateRenderState(blockEntity);
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)WardencarcassBlock.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, (float)blockEntity.getLevel().getGameTime() + partialTick);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ButcheryModBlockEntities.WARDEN_CARCASS.get(), WardencarcassRenderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modelwarden_carcass {
        private final ModelPart root;
        private final BlockEntityHierarchicalModel animator = new BlockEntityHierarchicalModel();

        public CustomHierarchicalModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupBlockEntityAnim(WardencarcassBlockEntity blockEntity, float ageInTicks) {
            this.animator.setupBlockEntityAnim(blockEntity, ageInTicks);
            super.setupAnim(null, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        }

        public ModelPart getRoot() {
            return this.root;
        }

        private class BlockEntityHierarchicalModel
        extends HierarchicalModel<Entity> {
            private BlockEntityHierarchicalModel() {
            }

            public ModelPart root() {
                return CustomHierarchicalModel.this.root;
            }

            public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            }

            public void setupBlockEntityAnim(WardencarcassBlockEntity blockEntity, float ageInTicks) {
                CustomHierarchicalModel.this.animator.root().getAllParts().forEach(ModelPart::resetPose);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState0, warden_headlessAnimation.headless, ageInTicks, 1.0f);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState1, warden_armlessAnimation.armless, ageInTicks, 1.0f);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState2, warden_riblessAnimation.ribless, ageInTicks, 1.0f);
                CustomHierarchicalModel.this.animator.animate(blockEntity.animationState3, warden_bodylessAnimation.bodyless, ageInTicks, 1.0f);
            }
        }
    }
}

