/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.butchery.client.renderer.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mcreator.butchery.block.Enderdragoncut11Block;
import net.mcreator.butchery.block.entity.Enderdragoncut11BlockEntity;
import net.mcreator.butchery.client.model.Modelender_dragon_cut_11;
import net.mcreator.butchery.init.ButcheryModBlockEntities;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class Enderdragoncut11Renderer
implements BlockEntityRenderer<Enderdragoncut11BlockEntity> {
    private final CustomHierarchicalModel model;
    private final ResourceLocation texture;

    Enderdragoncut11Renderer(BlockEntityRendererProvider.Context context) {
        this.model = new CustomHierarchicalModel(context.bakeLayer(Modelender_dragon_cut_11.LAYER_LOCATION));
        this.texture = ResourceLocation.parse((String)"butchery:textures/block/end_dragon.png");
    }

    public void render(Enderdragoncut11BlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource renderer, int light, int overlayLight) {
        poseStack.pushPose();
        poseStack.scale(-1.0f, -1.0f, 1.0f);
        poseStack.translate(-0.5, -0.5, 0.5);
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)Enderdragoncut11Block.FACING);
        switch (facing) {
            case NORTH: {
                break;
            }
            case EAST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case WEST: {
                poseStack.mulPose(Axis.YP.rotationDegrees(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
            }
        }
        poseStack.translate(0.0f, -1.0f, 0.0f);
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.model.setupBlockEntityAnim(blockEntity, (float)blockEntity.getLevel().getGameTime() + partialTick);
        this.model.renderToBuffer(poseStack, builder, light, overlayLight);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void registerBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ButcheryModBlockEntities.ENDERDRAGONCUT_11.get(), Enderdragoncut11Renderer::new);
    }

    private static final class CustomHierarchicalModel
    extends Modelender_dragon_cut_11 {
        private final ModelPart root;
        private final BlockEntityHierarchicalModel animator = new BlockEntityHierarchicalModel();

        public CustomHierarchicalModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        public void setupBlockEntityAnim(Enderdragoncut11BlockEntity blockEntity, float ageInTicks) {
            this.animator.setupBlockEntityAnim(blockEntity, ageInTicks);
            super.setupAnim(null, 0.0f, 0.0f, ageInTicks, 0.0f, 0.0f);
        }

        public ModelPart getRoot() {
            return this.root;
        }

        private class BlockEntityHierarchicalModel
        extends HierarchicalModel<Entity> {
            private BlockEntityHierarchicalModel() {
            }

            public ModelPart root() {
                return CustomHierarchicalModel.this.root;
            }

            public void setupAnim(Entity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            }

            public void setupBlockEntityAnim(Enderdragoncut11BlockEntity blockEntity, float ageInTicks) {
                CustomHierarchicalModel.this.animator.root().getAllParts().forEach(ModelPart::resetPose);
            }
        }
    }
}

