/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.weathered_girder;

import com.kipti.bnb.content.weathered_girder.WeatheredGirderEncasedShaftBlock;
import com.kipti.bnb.content.weathered_girder.WeatheredGirderPlacementHelper;
import com.kipti.bnb.content.weathered_girder.WeatheredGirderWrenchBehaviour;
import com.kipti.bnb.registry.BnbBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.decoration.girder.GirderBlock;
import com.simibubi.create.content.decoration.girder.GirderEncasedShaftBlock;
import com.simibubi.create.content.decoration.placard.PlacardBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.logistics.chute.AbstractChuteBlock;
import com.simibubi.create.content.redstone.nixieTube.NixieTubeBlock;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WeatheredGirderBlock
extends GirderBlock {
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new WeatheredGirderPlacementHelper());

    public WeatheredGirderBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (AllBlocks.SHAFT.isIn(stack)) {
            KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)pos, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)BnbBlocks.WEATHERED_METAL_GIRDER_ENCASED_SHAFT.getDefaultState().setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)))).setValue((Property)TOP, (Comparable)((Boolean)state.getValue((Property)TOP)))).setValue((Property)BOTTOM, (Comparable)((Boolean)state.getValue((Property)BOTTOM)))).setValue(GirderEncasedShaftBlock.HORIZONTAL_AXIS, (Comparable)((Boolean)state.getValue((Property)X) != false || hitResult.getDirection().getAxis() == Direction.Axis.Z ? Direction.Axis.Z : Direction.Axis.X))));
            level.playSound(null, pos, SoundEvents.NETHERITE_BLOCK_HIT, SoundSource.BLOCKS, 0.5f, 1.25f);
            if (!level.isClientSide && !player.isCreative()) {
                stack.shrink(1);
                if (stack.isEmpty()) {
                    player.setItemInHand(hand, ItemStack.EMPTY);
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        if (AllItems.WRENCH.isIn(stack) && !player.isShiftKeyDown()) {
            if (WeatheredGirderWrenchBehaviour.handleClick(level, pos, state, hitResult)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return ItemInteractionResult.FAIL;
        }
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(stack)) {
            return helper.getOffset(player, level, state, pos, hitResult).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hitResult);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static boolean isConnected(BlockAndTintGetter world, BlockPos pos, BlockState state, Direction side) {
        Direction.Axis axis = side.getAxis();
        if (state.getBlock() instanceof WeatheredGirderBlock && !((Boolean)state.getValue((Property)(axis == Direction.Axis.X ? X : Z))).booleanValue()) {
            return false;
        }
        if (state.getBlock() instanceof WeatheredGirderEncasedShaftBlock && state.getValue(WeatheredGirderEncasedShaftBlock.HORIZONTAL_AXIS) == axis) {
            return false;
        }
        BlockPos relative = pos.relative(side);
        BlockState blockState = world.getBlockState(relative);
        if (blockState.isAir()) {
            return false;
        }
        if (blockState.getBlock() instanceof NixieTubeBlock && NixieTubeBlock.getFacing((BlockState)blockState) == side) {
            return true;
        }
        if (WeatheredGirderBlock.isFacingBracket((BlockAndTintGetter)world, (BlockPos)pos, (Direction)side)) {
            return true;
        }
        if (blockState.getBlock() instanceof PlacardBlock && PlacardBlock.connectedDirection((BlockState)blockState) == side) {
            return true;
        }
        VoxelShape shape = blockState.getShape((BlockGetter)world, relative);
        if (shape.isEmpty()) {
            return false;
        }
        if (Block.isFaceFull((VoxelShape)shape, (Direction)side.getOpposite()) && blockState.isSolid()) {
            return true;
        }
        return AbstractChuteBlock.getChuteFacing((BlockState)blockState) == Direction.DOWN;
    }
}

