/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.nixie.foundation;

import com.kipti.bnb.content.nixie.foundation.ConfigurableDisplayOptionTransform;
import com.kipti.bnb.content.nixie.foundation.DoubleOrientedBlockModel;
import com.kipti.bnb.content.nixie.foundation.DyeProviderBlock;
import com.kipti.bnb.content.nixie.foundation.GenericNixieDisplayBlockEntity;
import com.kipti.bnb.content.nixie.foundation.TextBlockSubAtlas;
import com.kipti.bnb.content.nixie.large_nixie_tube.LargeNixieTubeBlockNixie;
import com.kipti.bnb.content.nixie.nixie_board.NixieBoardBlockNixie;
import com.kipti.bnb.mixin_accessor.FontAccess;
import com.kipti.bnb.mixin_accessor.ReverseRenderableBakedGlyph;
import com.kipti.bnb.registry.BnbBlocks;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.simibubi.create.foundation.utility.DyeHelper;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.data.Couple;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class GenericNixieDisplayBoardRenderer
extends SmartBlockEntityRenderer<GenericNixieDisplayBlockEntity> {
    public GenericNixieDisplayBoardRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderSafe(GenericNixieDisplayBlockEntity be, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        DyeColor dyeColor;
        super.renderSafe((SmartBlockEntity)be, partialTicks, ms, buffer, light, overlay);
        Font fontRenderer = Minecraft.getInstance().font;
        FontSet fontSet = ((FontAccess)fontRenderer).bits_n_bobs$getFontSet(Style.DEFAULT_FONT);
        if (fontSet == null) {
            return;
        }
        boolean isNixieBoard = BnbBlocks.NIXIE_BOARD.is((Object)be.getBlockState().getBlock()) || BnbBlocks.DYED_NIXIE_BOARD.contains(be.getBlockState().getBlock());
        float scale = isNixieBoard ? 0.0625f : 0.05f;
        float offset = isNixieBoard ? 0.0f : 0.125f;
        ms.pushPose();
        Direction facing = (Direction)be.getBlockState().getValue((Property)NixieBoardBlockNixie.FACING);
        Direction orientation = (Direction)be.getBlockState().getValue((Property)NixieBoardBlockNixie.ORIENTATION);
        float orientationOffset = 0.0f;
        boolean isLargeNixieTube = be.getBlockState().getBlock() instanceof LargeNixieTubeBlockNixie;
        if (be.currentDisplayOption != GenericNixieDisplayBlockEntity.ConfigurableDisplayOptions.ALWAYS_UP && facing != Direction.UP) {
            ((PoseTransformStack)TransformStack.of((PoseStack)ms).center()).mulPose((Matrix4fc)DoubleOrientedBlockModel.getRotation(facing, orientation)).uncenter();
            orientationOffset = isLargeNixieTube ? -0.125f : 0.0f;
        } else {
            ((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).center()).translate(Vec3.atLowerCornerOf((Vec3i)facing.getNormal()).scale(0.125))).mulPose((Matrix4fc)DoubleOrientedBlockModel.getRotation(Direction.UP, orientation)).uncenter();
            orientationOffset = -0.25f;
        }
        ms.translate(0.5, (double)(1.0f + orientationOffset), 0.5);
        ms.scale(0.0625f, 0.0625f, 0.0625f);
        if (isLargeNixieTube) {
            ms.scale(0.85f, 0.85f, 0.85f);
        }
        ms.scale(-1.0f, -1.0f, 1.0f);
        Block block = be.getBlockState().getBlock();
        if (block instanceof DyeProviderBlock) {
            DyeProviderBlock dyeProviderBlock = (DyeProviderBlock)block;
            dyeColor = dyeProviderBlock.getDyeColor();
        } else {
            dyeColor = DyeColor.ORANGE;
        }
        Couple baseColor = DyeHelper.getDyeColors((DyeColor)dyeColor);
        ConfigurableDisplayOptionTransform transform = be.getCurrentDisplayOption().renderTransform.get();
        TextBlockSubAtlas subAtlas = transform.isMoreThanOneCharacter() ? TextBlockSubAtlas.SMALL_NIXIE_TEXT_SUB_ATLAS : TextBlockSubAtlas.NIXIE_TEXT_SUB_ATLAS;
        transform.render(ms, be, glyph -> {
            Couple color;
            if (glyph.charValue() == ' ') {
                return;
            }
            char charCode = glyph.charValue();
            Couple couple = color = subAtlas.isInColorExcludedCharacterSet(charCode) ? DyeHelper.getDyeColors((DyeColor)DyeColor.WHITE) : baseColor;
            if (subAtlas.isInCharacterSet(charCode)) {
                GenericNixieDisplayBoardRenderer.renderGlyphUsingSpecialFont(ms, buffer, overlay, charCode, ms.last().pose(), (Couple<Integer>)color);
            } else {
                GenericNixieDisplayBoardRenderer.renderUsingNormalFont(ms, buffer, fontSet, charCode, ms.last().pose(), (Couple<Integer>)color);
            }
        });
        ms.popPose();
    }

    private static int getTextColor(GenericNixieDisplayBlockEntity be) {
        LargeNixieTubeBlockNixie lnb;
        NixieBoardBlockNixie nbb;
        int col = -1;
        Block block = be.getBlockState().getBlock();
        if (block instanceof NixieBoardBlockNixie && (nbb = (NixieBoardBlockNixie)block).getDyeColor() != null) {
            col = nbb.getDyeColor().getTextureDiffuseColor() | 0xFF;
        }
        if (block instanceof LargeNixieTubeBlockNixie && (lnb = (LargeNixieTubeBlockNixie)block).getDyeColor() != null) {
            col = lnb.getDyeColor().getTextureDiffuseColor() | 0xFF;
        }
        return col;
    }

    private static void renderGlyphUsingSpecialFont(PoseStack ms, MultiBufferSource buffer, int overlay, int glyph, Matrix4f pose, Couple<Integer> col) {
        VertexConsumer cutoutBuffer = buffer.getBuffer(RenderType.cutout());
        ms.translate(-6.0f, -3.0f, 0.0f);
        TextBlockSubAtlas.Uv characterUv = TextBlockSubAtlas.NIXIE_TEXT_SUB_ATLAS.getUvForCharacter(glyph);
        float u0 = characterUv.getU0();
        float u1 = characterUv.getU1();
        float v0 = characterUv.getV0();
        float v1 = characterUv.getV1();
        int primary = FastColor.ARGB32.opaque((int)((Integer)col.get(true)));
        GenericNixieDisplayBoardRenderer.addVerticesForChar(overlay, cutoutBuffer, pose, u0, v1, v0, u1, primary);
        pose = pose.translate(0.5f, 0.5f, 0.1f);
        int secondary = FastColor.ARGB32.opaque((int)((Integer)col.get(false)));
        GenericNixieDisplayBoardRenderer.addVerticesForChar(overlay, cutoutBuffer, pose, u0, v1, v0, u1, secondary);
    }

    private static void addVerticesForChar(int overlay, VertexConsumer cutoutBuffer, Matrix4f pose, float u0, float v1, float v0, float u1, int col) {
        cutoutBuffer.addVertex(pose, 0.0f, 12.0f, 0.0f).setColor(col).setUv(u0, v1).setOverlay(overlay).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        cutoutBuffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(col).setUv(u0, v0).setOverlay(overlay).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        cutoutBuffer.addVertex(pose, 12.0f, 0.0f, 0.0f).setColor(col).setUv(u1, v0).setOverlay(overlay).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        cutoutBuffer.addVertex(pose, 12.0f, 12.0f, 0.0f).setColor(col).setUv(u1, v1).setOverlay(overlay).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        cutoutBuffer.addVertex(pose, 12.0f, 12.0f, 0.0f).setColor(col).setUv(u1, v1).setOverlay(overlay).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        cutoutBuffer.addVertex(pose, 12.0f, 0.0f, 0.0f).setColor(col).setUv(u1, v0).setOverlay(overlay).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        cutoutBuffer.addVertex(pose, 0.0f, 0.0f, 0.0f).setColor(col).setUv(u0, v0).setOverlay(overlay).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
        cutoutBuffer.addVertex(pose, 0.0f, 12.0f, 0.0f).setColor(col).setUv(u0, v1).setOverlay(overlay).setLight(0xF000F0).setNormal(1.0f, 0.0f, 0.0f);
    }

    private static void renderUsingNormalFont(PoseStack ms, MultiBufferSource buffer, FontSet fontSet, int glyph, Matrix4f pose, Couple<Integer> colours) {
        BakedGlyph bakedGlyph = fontSet.getGlyph(glyph);
        RenderType renderType = bakedGlyph.renderType(Font.DisplayMode.NORMAL);
        VertexConsumer vertexconsumer = buffer.getBuffer(renderType);
        float width = fontSet.getGlyphInfo(glyph, true).getAdvance(false) - 1.0f;
        float r = (float)((Integer)colours.get(true) >> 16 & 0xFF) / 255.0f;
        float g = (float)((Integer)colours.get(true) >> 8 & 0xFF) / 255.0f;
        float b = (float)((Integer)colours.get(true) & 0xFF) / 255.0f;
        float rSecondary = (float)((Integer)colours.get(false) >> 16 & 0xFF) / 255.0f;
        float gSecondary = (float)((Integer)colours.get(false) >> 8 & 0xFF) / 255.0f;
        float bSecondary = (float)((Integer)colours.get(false) & 0xFF) / 255.0f;
        GenericNixieDisplayBoardRenderer.renderGlyph(ms, 0.0f, bakedGlyph, width, vertexconsumer, r, g, b);
        ms.pushPose();
        ms.translate(0.0f, 0.0f, 0.1f);
        GenericNixieDisplayBoardRenderer.renderGlyph(ms, 0.5f, bakedGlyph, width, vertexconsumer, rSecondary, gSecondary, bSecondary);
        ms.popPose();
    }

    private static void renderGlyph(PoseStack ms, float offset, BakedGlyph bakedGlyph, float width, VertexConsumer vertexconsumer, float r, float g, float b) {
        bakedGlyph.render(false, -width / 2.0f + offset, offset, ms.last().pose(), vertexconsumer, r, g, b, 1.0f, 0xF000F0);
        if (bakedGlyph instanceof ReverseRenderableBakedGlyph) {
            ((ReverseRenderableBakedGlyph)bakedGlyph).bits_n_bobs$renderReverse(false, -width / 2.0f + offset, offset, ms.last().pose(), vertexconsumer, r, g, b, 1.0f, 0xF000F0);
        }
    }
}

