/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.GirderStrutBlock;
import com.kipti.bnb.content.girder_strut.GirderStrutBlockEntity;
import com.kipti.bnb.registry.BnbDataComponents;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GirderStrutBlockItem
extends BlockItem {
    private static final double MAX_ANGLE_DEGREES = 75.0;
    private static final double MIN_DOT_THRESHOLD = Math.cos(Math.toRadians(75.0));

    public GirderStrutBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        ConnectionResult result;
        ItemStack stack = context.getItemInHand();
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction face = context.getClickedFace();
        if (context.isSecondaryUseActive()) {
            if (stack.has(BnbDataComponents.GIRDER_STRUT_FROM) || stack.has(BnbDataComponents.GIRDER_STRUT_FROM_FACE)) {
                stack.remove(BnbDataComponents.GIRDER_STRUT_FROM);
                stack.remove(BnbDataComponents.GIRDER_STRUT_FROM_FACE);
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        }
        BlockPos placementPos = this.resolvePlacementPos(level, clickedPos, face);
        Direction targetFace = face;
        if (placementPos != null && level.getBlockState(placementPos).getBlock().equals(this.getBlock())) {
            targetFace = (Direction)level.getBlockState(placementPos).getValue((Property)GirderStrutBlock.FACING);
        }
        if (!stack.has(BnbDataComponents.GIRDER_STRUT_FROM)) {
            if (placementPos == null) {
                return InteractionResult.FAIL;
            }
            stack.set(BnbDataComponents.GIRDER_STRUT_FROM, (Object)placementPos);
            stack.set(BnbDataComponents.GIRDER_STRUT_FROM_FACE, (Object)targetFace);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        BlockPos fromPos = (BlockPos)stack.get(BnbDataComponents.GIRDER_STRUT_FROM);
        Direction fromFace = (Direction)stack.get(BnbDataComponents.GIRDER_STRUT_FROM_FACE);
        if (fromPos == null) {
            stack.remove(BnbDataComponents.GIRDER_STRUT_FROM);
            stack.remove(BnbDataComponents.GIRDER_STRUT_FROM_FACE);
            return InteractionResult.FAIL;
        }
        if (placementPos == null) {
            return InteractionResult.FAIL;
        }
        if (fromFace == null) {
            BlockState fromState = level.getBlockState(fromPos);
            fromFace = fromState.getBlock().equals(this.getBlock()) ? (Direction)fromState.getValue((Property)GirderStrutBlock.FACING) : targetFace.getOpposite();
        }
        if (!level.isClientSide && (result = this.tryConnect(context, fromPos, fromFace, placementPos, targetFace)) != ConnectionResult.SUCCESS) {
            if (result == ConnectionResult.INVALID) {
                stack.remove(BnbDataComponents.GIRDER_STRUT_FROM);
                stack.remove(BnbDataComponents.GIRDER_STRUT_FROM_FACE);
            }
            return InteractionResult.FAIL;
        }
        stack.remove(BnbDataComponents.GIRDER_STRUT_FROM);
        stack.remove(BnbDataComponents.GIRDER_STRUT_FROM_FACE);
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public boolean isFoil(ItemStack stack) {
        return stack.has(BnbDataComponents.GIRDER_STRUT_FROM) || super.isFoil(stack);
    }

    public static boolean isValidConnection(Level level, BlockPos fromPos, Direction fromFace, BlockPos toPos, Direction toFace) {
        int diffZ;
        int diffY;
        if (fromPos == null || toPos == null || fromFace == null || toFace == null) {
            return false;
        }
        if (fromPos.equals((Object)toPos)) {
            return false;
        }
        int diffX = toPos.getX() - fromPos.getX();
        int nonZero = (diffX != 0 ? 1 : 0) + ((diffY = toPos.getY() - fromPos.getY()) != 0 ? 1 : 0) + ((diffZ = toPos.getZ() - fromPos.getZ()) != 0 ? 1 : 0);
        if (nonZero >= 3) {
            return false;
        }
        double lengthSq = diffX * diffX + diffY * diffY + diffZ * diffZ;
        if (lengthSq > 64.0) {
            return false;
        }
        Vec3 fromCenter = Vec3.atCenterOf((Vec3i)fromPos);
        Vec3 toCenter = Vec3.atCenterOf((Vec3i)toPos);
        Vec3 connection = toCenter.subtract(fromCenter);
        Vec3 reverseConnection = fromCenter.subtract(toCenter);
        if (!GirderStrutBlockItem.isWithinAngle(connection, fromFace)) {
            return false;
        }
        return GirderStrutBlockItem.isWithinAngle(reverseConnection, toFace);
    }

    private static boolean isWithinAngle(Vec3 vector, Direction face) {
        Vec3 faceNormal;
        if (vector.lengthSqr() < 1.0E-6) {
            return false;
        }
        Vec3 unitVec = vector.normalize();
        double dot = unitVec.dot(faceNormal = Vec3.atLowerCornerOf((Vec3i)face.getNormal()).normalize());
        return dot >= MIN_DOT_THRESHOLD;
    }

    private ConnectionResult tryConnect(UseOnContext context, BlockPos fromPos, Direction fromFace, BlockPos targetPos, Direction targetFace) {
        Level level = context.getLevel();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        if (!GirderStrutBlockItem.isValidConnection(level, fromPos, fromFace, targetPos, targetFace)) {
            return ConnectionResult.INVALID;
        }
        BlockState fromState = level.getBlockState(fromPos);
        BlockState targetState = level.getBlockState(targetPos);
        boolean fromNeedsPlacement = !fromState.getBlock().equals(this.getBlock());
        boolean targetNeedsPlacement = !targetState.getBlock().equals(this.getBlock());
        int requiredAnchors = (fromNeedsPlacement ? 1 : 0) + (targetNeedsPlacement ? 1 : 0);
        if (fromNeedsPlacement && !this.canOccupy(level, fromPos)) {
            return ConnectionResult.INVALID;
        }
        if (targetNeedsPlacement && !this.canOccupy(level, targetPos)) {
            return ConnectionResult.INVALID;
        }
        if (player != null && !player.getAbilities().instabuild && !this.hasRequiredAnchors(player, stack, requiredAnchors)) {
            return ConnectionResult.MISSING_ITEMS;
        }
        int placedCount = 0;
        if (fromNeedsPlacement) {
            if (!this.placeAnchor(level, fromPos, fromFace, player, stack.copy())) {
                return ConnectionResult.INVALID;
            }
            ++placedCount;
        } else if (fromState.getValue((Property)GirderStrutBlock.FACING) != fromFace) {
            level.setBlock(fromPos, (BlockState)fromState.setValue((Property)GirderStrutBlock.FACING, (Comparable)fromFace), 3);
        }
        if (targetNeedsPlacement) {
            if (!this.placeAnchor(level, targetPos, targetFace, player, stack.copy())) {
                if (fromNeedsPlacement) {
                    level.removeBlock(fromPos, false);
                }
                return ConnectionResult.INVALID;
            }
            ++placedCount;
        } else if (targetState.getValue((Property)GirderStrutBlock.FACING) != targetFace) {
            level.setBlock(targetPos, (BlockState)targetState.setValue((Property)GirderStrutBlock.FACING, (Comparable)targetFace), 3);
        }
        BlockState newFromState = level.getBlockState(fromPos);
        BlockState newTargetState = level.getBlockState(targetPos);
        if (!newFromState.getBlock().equals(this.getBlock()) || !newTargetState.getBlock().equals(this.getBlock())) {
            return ConnectionResult.INVALID;
        }
        if (placedCount > 0) {
            this.consumeAnchors(player, stack, placedCount);
        }
        SoundType soundType = this.getBlock().defaultBlockState().getSoundType((LevelReader)level, targetPos, (Entity)context.getPlayer());
        level.playSound(null, targetPos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        this.connect(level, fromPos, targetPos);
        return ConnectionResult.SUCCESS;
    }

    private void connect(Level level, BlockPos fromPos, BlockPos targetPos) {
        BlockEntity blockEntity = level.getBlockEntity(fromPos);
        if (!(blockEntity instanceof GirderStrutBlockEntity)) {
            return;
        }
        GirderStrutBlockEntity from = (GirderStrutBlockEntity)blockEntity;
        BlockEntity blockEntity2 = level.getBlockEntity(targetPos);
        if (!(blockEntity2 instanceof GirderStrutBlockEntity)) {
            return;
        }
        GirderStrutBlockEntity target = (GirderStrutBlockEntity)blockEntity2;
        from.addConnection(targetPos);
        target.addConnection(fromPos);
        BlockState updatedFromState = level.getBlockState(fromPos);
        BlockState updatedTargetState = level.getBlockState(targetPos);
        level.sendBlockUpdated(fromPos, updatedFromState, updatedFromState, 3);
        level.sendBlockUpdated(targetPos, updatedTargetState, updatedTargetState, 3);
    }

    private boolean hasRequiredAnchors(Player player, ItemStack heldStack, int required) {
        if (required <= 0) {
            return true;
        }
        if (player == null) {
            return heldStack.getCount() >= required;
        }
        int available = this.countAnchors(player, heldStack);
        if (available < required) {
            this.notifyMissingAnchors(player, required - available);
            return false;
        }
        return true;
    }

    private void consumeAnchors(Player player, ItemStack heldStack, int amount) {
        if (amount <= 0 || player == null || player.getAbilities().instabuild) {
            return;
        }
        int remaining = amount;
        remaining -= this.drainStack(heldStack, remaining);
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize() && remaining > 0; ++i) {
            ItemStack slotStack = inventory.getItem(i);
            if (slotStack == heldStack || !this.isMatchingStrut(slotStack, heldStack)) continue;
            remaining -= this.drainStack(slotStack, remaining);
        }
    }

    private int drainStack(ItemStack stack, int amount) {
        if (amount <= 0) {
            return 0;
        }
        int toRemove = Math.min(stack.getCount(), amount);
        if (toRemove > 0) {
            stack.shrink(toRemove);
        }
        return toRemove;
    }

    private int countAnchors(Player player, ItemStack reference) {
        Inventory inventory = player.getInventory();
        int total = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack slotStack = inventory.getItem(i);
            if (!this.isMatchingStrut(slotStack, reference)) continue;
            total += slotStack.getCount();
        }
        return total;
    }

    private boolean isMatchingStrut(ItemStack candidate, ItemStack reference) {
        return !candidate.isEmpty() && candidate.getItem() == reference.getItem();
    }

    private void notifyMissingAnchors(Player player, int missing) {
        if (missing <= 0) {
            return;
        }
        MutableComponent message = Component.translatable((String)"message.bits_n_bobs.girder_strut.missing_anchors", (Object[])new Object[]{missing}).withStyle(ChatFormatting.RED);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.displayClientMessage((Component)message, true);
        } else {
            player.displayClientMessage((Component)message, true);
        }
    }

    private boolean placeAnchor(Level level, BlockPos pos, Direction face, Player player, ItemStack stackSnapshot) {
        BlockState newState = (BlockState)((BlockState)this.getBlock().defaultBlockState().setValue((Property)GirderStrutBlock.FACING, (Comparable)face)).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        if (!level.setBlock(pos, newState, 3)) {
            return false;
        }
        Block block = newState.getBlock();
        block.setPlacedBy(level, pos, newState, (LivingEntity)player, stackSnapshot);
        SoundType soundType = newState.getSoundType();
        level.playSound(player, pos, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
        level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_PLACE, pos);
        return true;
    }

    private boolean canOccupy(Level level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.canBeReplaced() || state.getBlock().equals(this.getBlock());
    }

    private BlockPos resolvePlacementPos(Level level, BlockPos clickedPos, Direction face) {
        BlockState clickedState = level.getBlockState(clickedPos);
        if (clickedState.getBlock().equals(this.getBlock())) {
            return clickedPos;
        }
        BlockPos pos = clickedPos.relative(face);
        BlockState state = level.getBlockState(pos);
        if (!state.canBeReplaced() && !state.getBlock().equals(this.getBlock())) {
            return null;
        }
        return pos;
    }

    private static enum ConnectionResult {
        SUCCESS,
        INVALID,
        MISSING_ITEMS;

    }
}

