/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.girder_strut;

import com.kipti.bnb.content.girder_strut.IBlockEntityRelighter;
import com.simibubi.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class GirderStrutBlockEntity
extends SmartBlockEntity
implements IBlockEntityRelighter,
SpecialBlockEntityItemRequirement {
    private final Set<BlockPos> connections = new HashSet<BlockPos>();
    @Nullable
    public SuperByteBuffer connectionRenderBufferCache;

    public GirderStrutBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addConnection(BlockPos other) {
        if (!other.equals((Object)this.getBlockPos()) && this.connections.add(other.immutable().subtract((Vec3i)this.getBlockPos()))) {
            this.setChanged();
            this.sendData();
            this.notifyModelChange();
        }
    }

    public void removeConnection(BlockPos pos) {
        if (this.connections.remove(pos.subtract((Vec3i)this.getBlockPos()))) {
            this.setChanged();
            this.sendData();
            this.notifyModelChange();
        }
    }

    public boolean hasConnectionTo(BlockPos pos) {
        return this.connections.contains(pos.subtract((Vec3i)this.getBlockPos()));
    }

    public int connectionCount() {
        return this.connections.size();
    }

    public Set<BlockPos> getConnectionsCopy() {
        return Set.copyOf(this.connections);
    }

    protected void write(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(tag, registries, clientPacket);
        ListTag list = new ListTag();
        for (BlockPos p : this.connections) {
            CompoundTag ct = new CompoundTag();
            ct.putInt("X", p.getX());
            ct.putInt("Y", p.getY());
            ct.putInt("Z", p.getZ());
            list.add((Object)ct);
        }
        tag.put("Connections", (Tag)list);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(tag, registries, clientPacket);
        this.connections.clear();
        if (tag.contains("Connections", 9)) {
            ListTag list = tag.getList("Connections", 10);
            for (Tag t : list) {
                if (!(t instanceof CompoundTag)) continue;
                CompoundTag ct = (CompoundTag)t;
                this.connections.add(new BlockPos(ct.getInt("X"), ct.getInt("Y"), ct.getInt("Z")));
            }
        }
        if (clientPacket) {
            this.notifyModelChange();
        }
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    private void notifyModelChange() {
        if (this.level != null) {
            if (this.level.isClientSide) {
                this.requestModelDataUpdate();
            }
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

