/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.item;

import com.kipti.bnb.content.cogwheel_chain.graph.ChainInteractionFailedException;
import com.kipti.bnb.content.cogwheel_chain.graph.PlacingCogwheelChain;
import com.kipti.bnb.network.packets.from_client.PlaceCogwheelChainPacket;
import com.kipti.bnb.registry.BnbFeatureFlag;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import org.jetbrains.annotations.Nullable;

@EventBusSubscriber(value={Dist.CLIENT})
public class CogwheelChainPlacementInteraction {
    @Nullable
    protected static PlacingCogwheelChain currentBuildingChain = null;
    @Nullable
    protected static ResourceKey<Level> currentChainLevel = null;

    @SubscribeEvent
    public static void onClickInput(InputEvent.InteractionKeyMappingTriggered event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.screen != null) {
            return;
        }
        KeyMapping key = event.getKeyMapping();
        if (key == mc.options.keyUse && CogwheelChainPlacementInteraction.onRightClick(event)) {
            event.setCanceled(true);
        }
    }

    private static boolean onRightClick(InputEvent.InteractionKeyMappingTriggered event) {
        ItemStack itemInHand;
        LocalPlayer player = Minecraft.getInstance().player;
        ClientLevel level = Minecraft.getInstance().level;
        if (player == null || level == null) {
            return false;
        }
        Object object = player.getMainHandItem().is(Items.CHAIN) ? player.getMainHandItem() : (itemInHand = player.getOffhandItem().is(Items.CHAIN) ? player.getOffhandItem() : null);
        if (itemInHand == null) {
            return false;
        }
        if (player.isShiftKeyDown()) {
            if (currentBuildingChain != null) {
                currentBuildingChain = null;
                currentChainLevel = null;
            }
            return true;
        }
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult == null || hitResult.getType() != HitResult.Type.BLOCK) {
            return currentBuildingChain != null;
        }
        BlockHitResult bhr = (BlockHitResult)hitResult;
        BlockPos hitPos = bhr.getBlockPos();
        BlockState targetedState = level.getBlockState(hitPos);
        boolean validBlockTarget = PlacingCogwheelChain.isValidBlockTarget(targetedState);
        if (validBlockTarget && !BnbFeatureFlag.COGWHEEL_CHAIN_DRIVES.get()) {
            player.displayClientMessage(new ChainInteractionFailedException("config_forbids").getComponent(), true);
            return true;
        }
        if (!validBlockTarget) {
            return currentBuildingChain != null;
        }
        event.setSwingHand(true);
        if (currentBuildingChain == null || currentChainLevel == null || !currentChainLevel.equals((Object)level.dimension())) {
            currentBuildingChain = new PlacingCogwheelChain(hitPos, (Direction.Axis)targetedState.getValue((Property)CogWheelBlock.AXIS), PlacingCogwheelChain.isLargeBlockTarget(targetedState), PlacingCogwheelChain.hasSmallCogwheelOffset(targetedState));
            currentChainLevel = level.dimension();
            player.displayClientMessage((Component)Component.translatable((String)"tooltip.bits_n_bobs.chain_drive_placing_hint"), true);
        } else {
            if (currentBuildingChain.getLastNode().pos().equals((Object)hitPos)) {
                currentBuildingChain.getNodes().removeLast();
                if (currentBuildingChain.getNodes().isEmpty()) {
                    currentBuildingChain = null;
                    currentChainLevel = null;
                }
                return true;
            }
            try {
                boolean completed;
                boolean added = currentBuildingChain.tryAddNode(hitPos, targetedState);
                if (!added) {
                    return true;
                }
                try {
                    completed = currentBuildingChain.canBuildChainIfLooping();
                }
                catch (ChainInteractionFailedException exception) {
                    player.displayClientMessage(exception.getComponent(), true);
                    currentBuildingChain = null;
                    currentChainLevel = null;
                    return true;
                }
                if (completed) {
                    CatnipServices.NETWORK.sendToServer((CustomPacketPayload)new PlaceCogwheelChainPacket(currentBuildingChain, event.getHand().ordinal()));
                    currentBuildingChain = null;
                    currentChainLevel = null;
                }
            }
            catch (ChainInteractionFailedException exception) {
                player.displayClientMessage(exception.getComponent(), true);
            }
        }
        return true;
    }
}

