/*
 * Decompiled with CFR 0.152.
 */
package com.kipti.bnb.content.cogwheel_chain.graph;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.createmod.catnip.codecs.stream.CatnipStreamCodecs;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;

public record RenderedChainPathNode(BlockPos relativePos, Vec3 nodeOffset) {
    public static final Codec<RenderedChainPathNode> CODEC = RecordCodecBuilder.create(p_337946_ -> p_337946_.group((App)BlockPos.CODEC.fieldOf("relativePos").forGetter(RenderedChainPathNode::relativePos), (App)Vec3.CODEC.fieldOf("nodeEnter").forGetter(RenderedChainPathNode::nodeOffset)).apply((Applicative)p_337946_, RenderedChainPathNode::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, RenderedChainPathNode> STREAM_CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, RenderedChainPathNode::relativePos, (StreamCodec)CatnipStreamCodecs.VEC3, RenderedChainPathNode::nodeOffset, RenderedChainPathNode::new);

    public Vec3 getPosition() {
        return this.relativePos.getCenter().add(this.nodeOffset);
    }

    public void write(CompoundTag tag) {
        tag.putInt("X", this.relativePos.getX());
        tag.putInt("Y", this.relativePos.getY());
        tag.putInt("Z", this.relativePos.getZ());
        tag.putDouble("OffsetX", this.nodeOffset.x);
        tag.putDouble("OffsetY", this.nodeOffset.y);
        tag.putDouble("OffsetZ", this.nodeOffset.z);
    }

    public static RenderedChainPathNode read(CompoundTag tag) {
        BlockPos pos = new BlockPos(tag.getInt("X"), tag.getInt("Y"), tag.getInt("Z"));
        Vec3 offset = new Vec3(tag.getDouble("OffsetX"), tag.getDouble("OffsetY"), tag.getDouble("OffsetZ"));
        return new RenderedChainPathNode(pos, offset);
    }
}

