/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.events.behaviors;

import net.mehvahdjukaar.amendments.common.entity.MediumFireball;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.ItemUse;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class FireChargeShoot
implements ItemUse {
    @Override
    public boolean isEnabled() {
        return CommonConfigs.THROWABLE_FIRE_CHARGES.get();
    }

    @Override
    public boolean appliesToItem(Item item) {
        return item == Items.FIRE_CHARGE;
    }

    @Override
    public InteractionResult tryPerformingAction(Level level, Player player, InteractionHand usedHand, ItemStack stack, BlockHitResult hit) {
        ItemStack itemStack = player.getItemInHand(usedHand);
        level.playSound(null, player.getX(), player.getEyeY() - 0.1, player.getZ(), SoundEvents.FIRECHARGE_USE, SoundSource.NEUTRAL, 0.5f, 0.6f + 0.4f / (level.getRandom().nextFloat() * 0.4f + 0.8f));
        player.getCooldowns().addCooldown(itemStack.getItem(), 10);
        if (!level.isClientSide) {
            MediumFireball ball = new MediumFireball(level, (LivingEntity)player);
            ball.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.1f, 1.0f);
            level.addFreshEntity((Entity)ball);
        }
        player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
        if (!player.getAbilities().instabuild) {
            itemStack.shrink(1);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }
}

