/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.tile;

import net.mehvahdjukaar.amendments.common.block.WallLanternBlock;
import net.mehvahdjukaar.amendments.common.tile.SwayingBlockTile;
import net.mehvahdjukaar.amendments.configs.ClientConfigs;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.integration.ThinAirCompat;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IBlockHolder;
import net.mehvahdjukaar.moonlight.api.block.MimicBlockTile;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.TickPriority;
import org.joml.Vector3f;

public class WallLanternBlockTile
extends SwayingBlockTile
implements IBlockHolder,
IExtraModelDataProvider {
    public static final ModelDataKey<BlockState> MIMIC_KEY = MimicBlockTile.MIMIC_KEY;
    private BlockState mimic = Blocks.LANTERN.defaultBlockState();
    protected double attachmentOffset = 0.0;
    protected boolean isRedstoneLantern = false;

    public WallLanternBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.WALL_LANTERN_TILE.get(), pos, state);
    }

    public boolean isNeverFancy() {
        return ClientConfigs.FAST_LANTERNS.get();
    }

    public boolean isRedstoneLantern() {
        return this.isRedstoneLantern;
    }

    public double getAttachmentOffset() {
        return this.attachmentOffset;
    }

    @Override
    public Vector3f getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)WallLanternBlock.FACING)).step();
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        super.addExtraModelData(builder);
        builder.with(MIMIC_KEY, (Object)this.getHeldBlock());
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.setHeldBlock(Utils.readBlockState((CompoundTag)tag.getCompound("Lantern"), (Level)this.level));
        this.isRedstoneLantern = tag.getBoolean("IsRedstone");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put("Lantern", (Tag)NbtUtils.writeBlockState((BlockState)this.mimic));
        tag.putBoolean("IsRedstone", this.isRedstoneLantern);
    }

    public BlockState getHeldBlock(int index) {
        return this.mimic;
    }

    public boolean setHeldBlock(BlockState state, int index) {
        if (state.hasProperty((Property)LanternBlock.HANGING)) {
            state = (BlockState)state.setValue((Property)LanternBlock.HANGING, (Comparable)Boolean.valueOf(false));
        }
        if (CompatHandler.THIN_AIR && this.level != null && ThinAirCompat.isAirLantern(state)) {
            BlockState newState = ThinAirCompat.maybeSetAirQuality(state, Vec3.atCenterOf((Vec3i)this.worldPosition), this.level);
            if (newState != null) {
                state = newState;
            }
            this.level.scheduleTick(this.worldPosition, this.getBlockState().getBlock(), 20, TickPriority.NORMAL);
        }
        this.mimic = state;
        int light = ForgeHelper.getLightEmission((BlockState)state, (Level)this.level, (BlockPos)this.worldPosition);
        boolean lit = true;
        ResourceLocation res = Utils.getID((Block)this.mimic.getBlock());
        if (res.toString().equals("charm:redstone_lantern")) {
            this.isRedstoneLantern = true;
            light = 15;
            lit = false;
        }
        if (this.level != null && !this.mimic.isAir()) {
            VoxelShape shape = state.getShape((BlockGetter)this.level, this.worldPosition);
            if (!shape.isEmpty() && !res.getNamespace().equals("twigs")) {
                this.attachmentOffset = shape.bounds().maxY - 0.5625;
            }
            if ((Integer)this.getBlockState().getValue((Property)WallLanternBlock.LIGHT_LEVEL) != light) {
                if (light == 0) {
                    lit = false;
                }
                BlockState newState = (BlockState)((BlockState)this.getBlockState().setValue((Property)WallLanternBlock.LIT, (Comparable)Boolean.valueOf(lit))).setValue((Property)WallLanternBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(Math.max(light, 5)));
                this.getLevel().setBlock(this.worldPosition, newState, 20);
            }
        }
        return true;
    }
}

