/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.network.ClientBoundPlaySplashParticlesMessage;
import net.mehvahdjukaar.amendments.common.recipe.CauldronRecipeUtils;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemCraftResult;
import net.mehvahdjukaar.amendments.common.recipe.FluidAndItemsCraftResult;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.events.behaviors.CauldronConversion;
import net.mehvahdjukaar.amendments.reg.ModRegistry;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.block.ILightable;
import net.mehvahdjukaar.moonlight.api.fluids.MLBuiltinSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.misc.InvPlacer;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public final class CommonCauldronCode {
    public static void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, Supplier<Double> heightProvider) {
        boolean shouldCheckFluid;
        boolean canFluidExtinguish = true;
        boolean bl = shouldCheckFluid = !entity.wasTouchingWater || entity.isOnFire();
        if (shouldCheckFluid && CommonCauldronCode.getFluidOrWater(state, pos, (LevelAccessor)level).is(ModTags.CANT_EXTINGUISH)) {
            canFluidExtinguish = false;
        }
        if (canFluidExtinguish) {
            entity.wasTouchingWater = true;
        }
        if (level.isClientSide) {
            return;
        }
        if (((Boolean)state.getValue((Property)ModCauldronBlock.BOILING)).booleanValue() && entity instanceof LivingEntity) {
            entity.hurt(new DamageSource(ModRegistry.BOILING_DAMAGE.getHolder(level)), 1.0f);
        }
        if (entity.isOnFire() && canFluidExtinguish) {
            CommonCauldronCode.playExtinguishSound(level, pos, entity);
            if (!(state.getBlock() instanceof LayeredCauldronBlock)) {
                CommonCauldronCode.extinguishLikeSuperLayeredCauldron(level, pos, entity);
            }
        }
        CommonCauldronCode.attemptInWorldCrafting(state, level, pos, entity, heightProvider);
    }

    private static void extinguishLikeSuperLayeredCauldron(Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        entity.clearFire();
        if (entity.mayInteract(level, pos) && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            te.consumeOneLayer();
            level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
        }
    }

    private static void playExtinguishSound(Level level, BlockPos pos, Entity entity) {
        level.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, entity.getSoundSource(), 0.7f, 1.6f + (level.random.nextFloat() - level.random.nextFloat()) * 0.4f);
    }

    public static BlockState updateBoilingState(Direction direction, BlockState neighborState, LevelAccessor level, BlockPos neighborPos, BlockState newState, BlockPos currentPos) {
        if (direction == Direction.DOWN) {
            SoftFluidStack fluidStack = CommonCauldronCode.getFluidOrWater(newState, currentPos, level);
            boolean isFire = CommonCauldronCode.shouldBoil(neighborState, fluidStack, level, neighborPos);
            newState = (BlockState)newState.setValue((Property)ModCauldronBlock.BOILING, (Comparable)Boolean.valueOf(isFire));
        }
        return newState;
    }

    private static SoftFluidStack getFluidOrWater(BlockState newState, BlockPos pos, LevelAccessor level) {
        BlockEntity blockEntity;
        if (newState.getBlock() instanceof ModCauldronBlock && (blockEntity = level.getBlockEntity(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            return te.getSoftFluidTank().getFluid();
        }
        return SoftFluidStack.of((Holder)MLBuiltinSoftFluids.WATER.getHolder((HolderLookup.Provider)level.registryAccess()), (int)((Integer)newState.getValue((Property)LayeredCauldronBlock.LEVEL)));
    }

    public static boolean shouldBoil(BlockState belowState, SoftFluidStack fluid, LevelAccessor level, BlockPos pos) {
        if (!belowState.is(ModTags.HEAT_SOURCES) || fluid.is(ModTags.CANT_BOIL)) {
            return false;
        }
        if (belowState.hasProperty((Property)CampfireBlock.LIT)) {
            return (Boolean)belowState.getValue((Property)CampfireBlock.LIT);
        }
        Block block = belowState.getBlock();
        if (block instanceof ILightable) {
            ILightable il = (ILightable)block;
            return il.isLitUp(belowState, (BlockGetter)level, pos);
        }
        return true;
    }

    public static void onEntityFallOnContent(Level level, BlockState state, Entity entity, double height) {
        if (entity instanceof ItemEntity) {
            ItemEntity ie = (ItemEntity)entity;
            ie.setDefaultPickUpDelay();
        }
        if (!level.isClientSide) {
            CommonCauldronCode.playSplashEffects(entity, height);
        }
    }

    public static void playBubblingAnimation(Level level, BlockPos pos, double surface, RandomSource rand, int color, int light) {
        SimpleParticleType type = (SimpleParticleType)ModRegistry.BOILING_PARTICLE.get();
        int count = 2;
        CommonCauldronCode.addSurfaceParticles((ParticleOptions)type, level, pos, count, surface, rand, color, (float)pos.getY() + 0.3125f, light);
        if (level.random.nextInt(4) == 0) {
            level.playLocalSound((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.BUBBLE_COLUMN_UPWARDS_AMBIENT, SoundSource.BLOCKS, 0.4f + level.random.nextFloat() * 0.2f, 0.35f + level.random.nextFloat() * 0.2f, false);
        }
    }

    public static void addSurfaceParticles(ParticleOptions type, Level level, BlockPos pos, int count, double surface, RandomSource rand, float r, float g, float b) {
        for (int i = 0; i < count; ++i) {
            double x = (double)pos.getX() + 0.1875 + (double)rand.nextFloat() * 0.625;
            double y = (double)pos.getY() + surface;
            double z = (double)pos.getZ() + 0.1875 + (double)rand.nextFloat() * 0.625;
            level.addParticle(type, x, y, z, (double)r, (double)g, (double)b);
        }
    }

    public static void playSplashEffects(Entity entity, double waterHeight) {
        entity.gameEvent((Holder)GameEvent.SPLASH);
        Level level = entity.level();
        Entity feetEntity = entity.isVehicle() && entity.getControllingPassenger() != null ? entity.getControllingPassenger() : entity;
        float offset = feetEntity == entity ? 0.2f : 0.9f;
        Vec3 movement = feetEntity.getDeltaMovement();
        float speed = Math.min(1.0f, (float)Math.sqrt(movement.x * movement.x * 0.2 + movement.y * movement.y + movement.z * movement.z * 0.2) * offset);
        BlockPos pos = BlockPos.containing((Position)entity.position());
        Vec3 hitPos = new Vec3(entity.getX(), (double)pos.getY() + waterHeight, entity.getZ());
        RandomSource rand = level.random;
        if (speed < 0.25f) {
            level.playSound(null, hitPos.x(), hitPos.y(), hitPos.z(), entity.getSwimSplashSound(), entity.getSoundSource(), speed, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.4f);
        } else {
            level.playSound(null, hitPos.x(), hitPos.y(), hitPos.z(), entity.getSwimHighSpeedSplashSound(), entity.getSoundSource(), speed, 1.0f + (rand.nextFloat() - rand.nextFloat()) * 0.4f);
        }
        ClientBoundPlaySplashParticlesMessage particlePacket = new ClientBoundPlaySplashParticlesMessage(hitPos, speed, feetEntity.getBbWidth());
        NetworkHelper.sendToAllClientPlayersTrackingEntityAndSelf((Entity)entity, (Message)particlePacket);
    }

    private static void attemptInWorldCrafting(BlockState state, Level level, BlockPos pos, Entity entity, Supplier<Double> heightProvider) {
        if (!CommonConfigs.CAULDRON_HAND_CRAFTING.get().booleanValue()) {
            return;
        }
        if (!(entity instanceof ItemEntity)) {
            return;
        }
        ItemEntity ie = (ItemEntity)entity;
        if (ie.tickCount % 3 != 0) {
            ie.setPickUpDelay(ie.pickupDelay + 1);
        }
        List entities = level.getEntitiesOfClass(ItemEntity.class, new AABB((double)pos.getX() + 0.125, (double)((float)pos.getY() + 0.375f), (double)pos.getZ() + 0.125, (double)pos.getX() + 0.875, (double)pos.getY() + heightProvider.get(), (double)pos.getZ() + 0.875));
        ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
        for (ItemEntity e : entities) {
            ingredients.add(e.getItem());
        }
        SoftFluidStack cauldronFluid = CommonCauldronCode.getFluidOrWater(state, pos, (LevelAccessor)level);
        FluidAndItemCraftResult craftResult = CauldronRecipeUtils.craft(level, (Boolean)state.getValue((Property)ModCauldronBlock.BOILING), 3, cauldronFluid, ingredients);
        if (craftResult == null) {
            return;
        }
        SoftFluidStack resultFluid = craftResult.resultFluid();
        CommonCauldronCode.playCraftSound(pos, level, cauldronFluid, resultFluid);
        CauldronConversion.setCorrectCauldronStateAndTile(state, level, pos, resultFluid);
        level.gameEvent(entity, (Holder)GameEvent.BLOCK_CHANGE, pos);
        CommonCauldronCode.spawnResultItems(level, pos, List.of(craftResult.craftedItem()));
        for (ItemEntity e : entities) {
            if (!e.getItem().isEmpty()) continue;
            e.discard();
        }
    }

    private static void spawnResultItems(Level level, BlockPos pos, List<ItemStack> itemStacks) {
        if (itemStacks.isEmpty()) {
            return;
        }
        for (ItemStack item : itemStacks) {
            ItemEntity iteEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.25, (double)pos.getZ() + 0.5, item);
            iteEntity.setDefaultPickUpDelay();
            iteEntity.setDeltaMovement(level.random.nextGaussian() * 0.01, 0.375, level.random.nextGaussian() * 0.01);
            level.addFreshEntity((Entity)iteEntity);
        }
    }

    public static boolean attemptPlayerCrafting(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, int tankCapacity, SoftFluidStack currentFluid) {
        if (!CommonConfigs.CAULDRON_HAND_CRAFTING.get().booleanValue()) {
            return false;
        }
        ItemStack playerStack = player.getItemInHand(hand);
        FluidAndItemsCraftResult result = CauldronRecipeUtils.craftMultiple(level, (Boolean)state.getValue((Property)ModCauldronBlock.BOILING), tankCapacity, currentFluid, List.of(playerStack));
        if (result != null) {
            CommonCauldronCode.playCraftSound(pos, level, currentFluid, result.resultFluid());
            CauldronConversion.setCorrectCauldronStateAndTile(state, level, pos, result.resultFluid());
            CommonCauldronCode.onPlayerCrafted(level, pos, player, hand, playerStack, result.craftedItems());
            return true;
        }
        return false;
    }

    private static void onPlayerCrafted(Level level, BlockPos pos, Player player, InteractionHand hand, ItemStack playerItem, List<ItemStack> craftedItems) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        player.awardStat(Stats.ITEM_USED.get((Object)playerItem.getItem()));
        CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, playerItem);
        for (ItemStack crafted : craftedItems) {
            Utils.addItemOrDrop((Player)player, (ItemStack)crafted, (InvPlacer)InvPlacer.handOrExistingOrAny((InteractionHand)hand));
        }
    }

    private static void playCraftSound(BlockPos pos, Level level, SoftFluidStack oldStack, SoftFluidStack newStack) {
        if (oldStack.fluid() != newStack.fluid()) {
            level.playSound(null, pos, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 0.9f, 0.6f);
        } else {
            level.playSound(null, pos, SoundEvents.BUCKET_EMPTY, SoundSource.BLOCKS, 1.0f, 1.3f);
        }
    }
}

