/*
 * Decompiled with CFR 0.152.
 */
package net.wurstclient.zoom;

import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.util.Mth;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.util.Lazy;
import net.wurstclient.zoom.test.WiZoomTestClient;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="wi_zoom")
@EventBusSubscriber(modid="wi_zoom", bus=EventBusSubscriber.Bus.MOD)
public final class WiZoom {
    public static final String MODID = "wi_zoom";
    private static boolean initialized;
    public static final Minecraft MC;
    public static final Lazy<KeyMapping> zoomKey;
    private static final double defaultLevel = 3.0;
    private static Double currentLevel;
    private static Double defaultMouseSensitivity;

    public WiZoom(IEventBus modBus, ModContainer container) {
        if (initialized) {
            throw new RuntimeException("WiZoom constructor ran twice!");
        }
        ArtifactVersion version = container.getModInfo().getVersion();
        System.out.println("Starting WI Zoom v" + version.toString());
        if (System.getProperty("wi_zoom.e2eTest") != null) {
            WiZoomTestClient.start();
        }
    }

    @SubscribeEvent
    public static void registerKeyBindings(RegisterKeyMappingsEvent event) {
        event.register((KeyMapping)zoomKey.get());
    }

    public static double changeFovBasedOnZoom(double fov) {
        OptionInstance mouseSensitivitySetting = WiZoom.MC.options.sensitivity();
        if (currentLevel == null) {
            currentLevel = 3.0;
        }
        if (!((KeyMapping)zoomKey.get()).isDown()) {
            currentLevel = 3.0;
            if (defaultMouseSensitivity != null) {
                mouseSensitivitySetting.set((Object)defaultMouseSensitivity);
                defaultMouseSensitivity = null;
            }
            return fov;
        }
        if (defaultMouseSensitivity == null) {
            defaultMouseSensitivity = (Double)mouseSensitivitySetting.get();
        }
        mouseSensitivitySetting.set((Object)(defaultMouseSensitivity * (1.0 / currentLevel)));
        return fov / currentLevel;
    }

    public static void onMouseScroll(double amount) {
        if (!((KeyMapping)zoomKey.get()).isDown()) {
            return;
        }
        if (currentLevel == null) {
            currentLevel = 3.0;
        }
        if (amount > 0.0) {
            currentLevel = currentLevel * 1.1;
        } else if (amount < 0.0) {
            currentLevel = currentLevel * 0.9;
        }
        currentLevel = Mth.clamp((double)currentLevel, (double)1.0, (double)50.0);
    }

    static {
        MC = Minecraft.getInstance();
        zoomKey = Lazy.of(() -> new KeyMapping("key.wi_zoom.zoom", InputConstants.Type.KEYSYM, 86, "WI Zoom"));
    }
}

