/*
 * Decompiled with CFR 0.152.
 */
package ht.treechop.compat;

import harmonised.pmmo.api.APIUtils;
import harmonised.pmmo.api.enums.EventType;
import harmonised.pmmo.api.enums.ObjectType;
import ht.treechop.TreeChop;
import ht.treechop.api.ChopEvent;
import ht.treechop.common.block.ChoppedLogBlock;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;

@EventBusSubscriber(modid="treechop", bus=EventBusSubscriber.Bus.MOD)
public class ProjectMMO {
    private static boolean broke = false;
    private static final Function<BlockEntity, Map<String, Long>> TREE_XP = blockEntityIn -> {
        try {
            ChoppedLogBlock.MyEntity choppedLog;
            if (blockEntityIn instanceof ChoppedLogBlock.MyEntity && (choppedLog = (ChoppedLogBlock.MyEntity)((Object)blockEntityIn)).getLevel() != null) {
                ResourceLocation resource = Optional.of(BuiltInRegistries.BLOCK.getKey((Object)choppedLog.getOriginalState().getBlock())).orElse(BuiltInRegistries.BLOCK.getKey((Object)Blocks.OAK_LOG));
                return APIUtils.getXpAwardMap((ObjectType)ObjectType.BLOCK, (EventType)EventType.BLOCK_BREAK, (ResourceLocation)resource, (LogicalSide)(choppedLog.getLevel().isClientSide ? LogicalSide.CLIENT : LogicalSide.SERVER), null);
            }
        }
        catch (NoSuchMethodError e) {
            ProjectMMO.crank(e);
        }
        return new HashMap();
    };

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        if (ModList.get().isLoaded("pmmo")) {
            try {
                APIUtils.registerBlockXpGainTooltipData((ResourceLocation)TreeChop.resource("chopped_log"), (EventType)EventType.BLOCK_BREAK, TREE_XP);
                NeoForge.EVENT_BUS.addListener(ProjectMMO::awardXPOnChop);
                Class.forName("harmonised.pmmo.api.APIUtils");
                Class.forName("harmonised.pmmo.api.enums.EventType");
                Class.forName("harmonised.pmmo.api.enums.ObjectType");
            }
            catch (ClassNotFoundException | NoSuchMethodError e) {
                ProjectMMO.crank(e);
            }
        }
    }

    private static void crank(Throwable e) {
        if (!broke) {
            TreeChop.LOGGER.error("Something went wrong with Project MMO compatibility!");
            e.printStackTrace();
            broke = true;
        }
    }

    public static void awardXPOnChop(ChopEvent.FinishChopEvent event) {
        try {
            if (!event.getFelled()) {
                Map awardMap = APIUtils.getXpAwardMap((Level)event.getLevel(), (BlockPos)event.getChoppedBlockPos(), (EventType)EventType.BLOCK_BREAK, (Player)event.getPlayer());
                awardMap.forEach((skill, amount) -> APIUtils.addXp((String)skill, (Player)event.getPlayer(), (long)amount));
            }
        }
        catch (NoSuchMethodError e) {
            ProjectMMO.crank(e);
        }
    }
}

