/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.neoforge.registries.DeferredRegister;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.command.argument.ScaleEasingArgumentType;
import virtuoel.pehkui.command.argument.ScaleModifierArgumentType;
import virtuoel.pehkui.command.argument.ScaleOperationArgumentType;
import virtuoel.pehkui.command.argument.ScaleTypeArgumentType;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.server.command.ScaleCommand;

public class CommandUtils {
    private static final DeferredRegister<ArgumentTypeInfo<?, ?>> COMMAND_ARGUMENT_TYPES = DeferredRegister.create((ResourceKey)Registries.COMMAND_ARGUMENT_TYPE, (String)"pehkui");

    public static void registerArgumentTypes(ModLoadingContext ctx) {
        CommandUtils.registerArgumentTypes(CommandUtils::registerConstantArgumentType);
        COMMAND_ARGUMENT_TYPES.register(ctx.getActiveContainer().getEventBus());
    }

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        ScaleCommand.register(dispatcher);
        DebugCommand.register(dispatcher);
    }

    public static void registerArgumentTypes(ArgumentTypeConsumer consumer) {
        consumer.register(Pehkui.id("scale_type"), ScaleTypeArgumentType.class, ScaleTypeArgumentType::scaleType);
        consumer.register(Pehkui.id("scale_modifier"), ScaleModifierArgumentType.class, ScaleModifierArgumentType::scaleModifier);
        consumer.register(Pehkui.id("scale_operation"), ScaleOperationArgumentType.class, ScaleOperationArgumentType::operation);
        consumer.register(Pehkui.id("scale_easing"), ScaleEasingArgumentType.class, ScaleEasingArgumentType::scaleEasing);
    }

    public static void sendFeedback(CommandSourceStack source, Supplier<Component> text, boolean broadcastToOps) {
        source.sendSuccess(text, broadcastToOps);
    }

    public static boolean testFloatRange(MinMaxBounds.Doubles range, float value) {
        return range.matches((double)value);
    }

    public static <T extends ArgumentType<?>> void registerConstantArgumentType(ResourceLocation id, Class<T> argClass, Supplier<T> supplier) {
        COMMAND_ARGUMENT_TYPES.register(id.getPath(), () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass((Class)argClass, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree((Supplier)supplier)));
    }

    public static CompletableFuture<Suggestions> suggestIdentifiersIgnoringNamespace(String namespace, Iterable<ResourceLocation> candidates, SuggestionsBuilder builder) {
        CommandUtils.forEachMatchingIgnoringNamespace(namespace, candidates, builder.getRemaining().toLowerCase(Locale.ROOT), Function.identity(), id -> builder.suggest(String.valueOf(id)));
        return builder.buildFuture();
    }

    public static <T> void forEachMatchingIgnoringNamespace(String namespace, Iterable<T> candidates, String string, Function<T, ResourceLocation> idFunc, Consumer<T> action) {
        boolean hasColon = string.indexOf(58) > -1;
        for (T object : candidates) {
            ResourceLocation id = idFunc.apply(object);
            if (hasColon) {
                if (!CommandUtils.wordStartsWith(string, id.toString(), '_')) continue;
                action.accept(object);
                continue;
            }
            if (!CommandUtils.wordStartsWith(string, id.getNamespace(), '_') && (!id.getNamespace().equals(namespace) || !CommandUtils.wordStartsWith(string, id.getPath(), '_'))) continue;
            action.accept(object);
        }
    }

    public static boolean wordStartsWith(String string, String substring, char wordSeparator) {
        int i = 0;
        while (!substring.startsWith(string, i)) {
            if ((i = substring.indexOf(wordSeparator, i)) < 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @FunctionalInterface
    public static interface ArgumentTypeConsumer {
        public <T extends ArgumentType<?>> void register(ResourceLocation var1, Class<T> var2, Supplier<T> var3);
    }
}

