/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin.compat1204minus.compat117plus;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Dynamic;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={ContainerOpenersCounter.class}, priority=1010)
public class ViewerCountManagerMixin {
    @Shadow
    int openCount;
    @Unique
    float viewerSearchRange = 5.0f;

    @Inject(at={@At(value="HEAD")}, method={"incrementOpeners(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"})
    private void pehkui$openContainer(Player player, Level world, BlockPos pos, BlockState state, CallbackInfo info) {
        float nextRange;
        float scale;
        if (this.openCount < 0) {
            this.openCount = 0;
            this.viewerSearchRange = 5.0f;
        }
        if ((scale = ScaleUtils.getBlockReachScale((Entity)player)) != 1.0f && (nextRange = 5.0f * scale) > this.viewerSearchRange) {
            this.viewerSearchRange = nextRange;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"decrementOpeners(Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V"})
    private void pehkui$closeContainer(Player player, Level world, BlockPos pos, BlockState state, CallbackInfo info) {
        if (this.openCount <= 1) {
            this.openCount = 1;
            this.viewerSearchRange = 5.0f;
        }
    }

    @ModifyExpressionValue(method={"getInRangeViewerCount"}, at={@At(value="CONSTANT", args={"floatValue=5.0F"})})
    @Dynamic
    private float pehkui$getInRangeViewerCount$range(float value) {
        return this.viewerSearchRange;
    }
}

