/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element.button;

import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import mekanism.api.SupportsColorMap;
import mekanism.api.text.EnumColor;
import mekanism.api.text.TextComponentUtil;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.tooltip.TooltipUtils;
import mekanism.client.render.IFancyFontRenderer;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.base.IReactorLogic;
import mekanism.generators.common.base.IReactorLogicMode;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactorLogicButton<TYPE extends Enum<TYPE>>
extends MekanismButton {
    private static final ResourceLocation TEXTURE = MekanismGenerators.rl(MekanismUtils.ResourceType.GUI_BUTTON.getPrefix() + "reactor_logic.png");
    @NotNull
    private final IReactorLogic<TYPE> tile;
    private final Supplier<@Nullable TYPE> modeSupplier;
    private final Map<TYPE, Tooltip> typeTooltips;
    private final Consumer<TYPE> onPress;

    public ReactorLogicButton(IGuiWrapper gui, int x, int y, int index, @NotNull IReactorLogic<TYPE> tile, Class<TYPE> clazz, IntSupplier indexSupplier, Supplier<TYPE[]> modeList, Consumer<TYPE> onPress) {
        this(gui, x, y, tile, clazz, onPress, () -> {
            int i = indexSupplier.getAsInt() + index;
            Enum[] modes = (Enum[])modeList.get();
            return i >= 0 && i < modes.length ? modes[i] : null;
        });
    }

    private ReactorLogicButton(IGuiWrapper gui, int x, int y, @NotNull IReactorLogic<TYPE> tile, Class<TYPE> clazz, Consumer<TYPE> onPress, Supplier<@Nullable TYPE> modeSupplier) {
        super(gui, x, y, 128, 22, CommonComponents.EMPTY, (element, mouseX, mouseY) -> ((ReactorLogicButton)element).click());
        this.onPress = onPress;
        this.modeSupplier = modeSupplier;
        this.tile = tile;
        this.typeTooltips = new EnumMap<TYPE, Tooltip>(clazz);
    }

    private boolean click() {
        Enum mode = (Enum)this.modeSupplier.get();
        if (mode != null) {
            this.onPress.accept(mode);
        }
        return true;
    }

    public void drawBackground(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        Enum mode = (Enum)this.modeSupplier.get();
        if (mode != null) {
            MekanismRenderer.color((GuiGraphics)guiGraphics, (SupportsColorMap)((IReactorLogicMode)((Object)mode)).getColor());
            guiGraphics.blit(TEXTURE, this.getButtonX(), this.getButtonY(), 0.0f, mode == this.tile.getMode() ? 22.0f : 0.0f, this.getButtonWidth(), this.getButtonHeight(), 128, 44);
            MekanismRenderer.resetColor((GuiGraphics)guiGraphics);
        }
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Enum mode = (Enum)this.modeSupplier.get();
        if (mode != null) {
            this.gui().renderItem(guiGraphics, ((IReactorLogicMode)((Object)mode)).getRenderStack(), this.relativeX + 3, this.relativeY + 3);
            this.drawScrollingString(guiGraphics, (Component)TextComponentUtil.build((Object[])new Object[]{EnumColor.WHITE, mode}), 20, 2, IFancyFontRenderer.TextAlignment.LEFT, this.titleTextColor(), this.width - 20, 2, false);
            super.renderForeground(guiGraphics, mouseX, mouseY);
        }
    }

    public void updateTooltip(int mouseX, int mouseY) {
        Enum mode = (Enum)this.modeSupplier.get();
        if (mode == null) {
            this.clearTooltip();
        } else {
            this.setTooltip(this.typeTooltips.computeIfAbsent(mode, m -> TooltipUtils.create((Component)((IReactorLogicMode)((Object)m)).getDescription())));
        }
    }
}

