/*
 * Decompiled with CFR 0.152.
 */
package mekanism.generators.client.gui.element;

import mekanism.api.text.ILangEntry;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiTabElementType;
import mekanism.client.gui.element.tab.TabType;
import mekanism.client.render.lib.ColorAtlas;
import mekanism.common.MekanismLang;
import mekanism.common.network.PacketUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.network.to_server.PacketGeneratorsTileButtonPress;
import mekanism.generators.common.tile.turbine.TileEntityTurbineCasing;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;

public class GuiTurbineTab
extends GuiTabElementType<TileEntityTurbineCasing, TurbineTab> {
    public GuiTurbineTab(IGuiWrapper gui, TileEntityTurbineCasing tile, TurbineTab type) {
        super(gui, (BlockEntity)tile, (Enum)type);
    }

    public static enum TurbineTab implements TabType<TileEntityTurbineCasing>
    {
        MAIN("chemicals.png", (ILangEntry)MekanismLang.MAIN_TAB, PacketGeneratorsTileButtonPress.ClickedGeneratorsTileButton.TAB_MAIN, SpecialColors.TAB_MULTIBLOCK_MAIN),
        STAT("stats.png", GeneratorsLang.TURBINE_STATS, PacketGeneratorsTileButtonPress.ClickedGeneratorsTileButton.TAB_STATS, SpecialColors.TAB_MULTIBLOCK_STATS);

        private final PacketGeneratorsTileButtonPress.ClickedGeneratorsTileButton button;
        private final ColorAtlas.ColorRegistryObject colorRO;
        private final ILangEntry description;
        private final String path;

        private TurbineTab(String path, ILangEntry description, PacketGeneratorsTileButtonPress.ClickedGeneratorsTileButton button, ColorAtlas.ColorRegistryObject colorRO) {
            this.path = path;
            this.description = description;
            this.button = button;
            this.colorRO = colorRO;
        }

        public ResourceLocation getResource() {
            return MekanismUtils.getResource((MekanismUtils.ResourceType)MekanismUtils.ResourceType.GUI, (String)this.path);
        }

        public void onClick(TileEntityTurbineCasing tile) {
            PacketUtils.sendToServer((CustomPacketPayload)new PacketGeneratorsTileButtonPress(this.button, tile.getBlockPos()));
        }

        public Component getDescription() {
            return this.description.translate();
        }

        public ColorAtlas.ColorRegistryObject getTabColor() {
            return this.colorRO;
        }
    }
}

