/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.predicate;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Set;
import mekanism.api.gear.IModule;
import mekanism.api.gear.IModuleContainer;
import mekanism.api.gear.IModuleHelper;
import mekanism.api.gear.ModuleData;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class MaxedModuleContainerItemPredicate
implements ItemSubPredicate {
    public static final Codec<MaxedModuleContainerItemPredicate> CODEC = BuiltInRegistries.ITEM.holderByNameCodec().comapFlatMap(item -> {
        if (IModuleHelper.INSTANCE.isModuleContainer((Holder<Item>)item)) {
            return DataResult.success((Object)new MaxedModuleContainerItemPredicate((Holder<Item>)item));
        }
        return DataResult.error(() -> "Specified item is not a module container item.");
    }, pred -> pred.item).fieldOf("item").codec();
    public static final ItemSubPredicate.Type<MaxedModuleContainerItemPredicate> TYPE = new ItemSubPredicate.Type(CODEC);
    private final Set<ModuleData<?>> supportedModules;
    private final Holder<Item> item;

    public MaxedModuleContainerItemPredicate(Holder<Item> item) {
        this.item = item;
        this.supportedModules = IModuleHelper.INSTANCE.getSupported(this.item);
    }

    public boolean matches(@NotNull ItemStack stack) {
        IModuleContainer container;
        if (stack.is(this.item) && (container = IModuleHelper.INSTANCE.getModuleContainer(stack)) != null && container.moduleTypes().containsAll(this.supportedModules)) {
            for (IModule<?> module : container.modules()) {
                if (module.getInstalledCount() == module.getUntypedData().getMaxStackSize()) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

